/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin;

import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.GraphManager;
import org.apache.tinkerpop.gremlin.GraphProvider;
import org.apache.tinkerpop.gremlin.GraphProviderClass;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalEngine;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.javatuples.Pair;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGremlinSuite
extends Suite {
    private static final Logger logger = LoggerFactory.getLogger(AbstractGremlinSuite.class);
    private final boolean gremlinFlavorSuite;

    public AbstractGremlinSuite(Class<?> klass, RunnerBuilder builder, Class<?>[] testsToExecute, Class<?>[] testsToEnforce, boolean gremlinFlavorSuite, TraversalEngine.Type traversalEngineType) throws InitializationError {
        super(builder, klass, (Class[])AbstractGremlinSuite.enforce(testsToExecute, testsToEnforce));
        this.gremlinFlavorSuite = gremlinFlavorSuite;
        Pair<Class<? extends GraphProvider>, Class<? extends Graph>> pair = AbstractGremlinSuite.getGraphProviderClass(klass);
        Optional<GraphProvider.Descriptor> graphProviderDescriptor = this.getGraphProviderDescriptor(traversalEngineType, (Class)pair.getValue0());
        this.validateOptInToSuite((Class)pair.getValue1());
        AbstractGremlinSuite.validateOptInAndOutAnnotations((Class)pair.getValue0());
        AbstractGremlinSuite.validateOptInAndOutAnnotations((Class)pair.getValue1());
        this.registerOptOuts((Class)pair.getValue0(), graphProviderDescriptor, traversalEngineType);
        this.registerOptOuts((Class)pair.getValue1(), graphProviderDescriptor, traversalEngineType);
        try {
            GraphProvider graphProvider = (GraphProvider)((Class)pair.getValue0()).newInstance();
            GraphManager.setGraphProvider(graphProvider);
            GraphManager.setTraversalEngineType(traversalEngineType);
        }
        catch (Exception ex) {
            throw new InitializationError((Throwable)ex);
        }
    }

    private Optional<GraphProvider.Descriptor> getGraphProviderDescriptor(TraversalEngine.Type traversalEngineType, Class<? extends GraphProvider> klass) throws InitializationError {
        GraphProvider.Descriptor descriptorAnnotation = klass.getAnnotation(GraphProvider.Descriptor.class);
        if (traversalEngineType == TraversalEngine.Type.COMPUTER && null == descriptorAnnotation) {
            throw new InitializationError(String.format("For 'computer' tests, '%s' must have a GraphProvider.Descriptor annotation", klass.getName()));
        }
        return Optional.ofNullable(descriptorAnnotation);
    }

    private void validateOptInToSuite(Class<? extends Graph> klass) throws InitializationError {
        Graph.OptIn[] optIns = (Graph.OptIn[])klass.getAnnotationsByType(Graph.OptIn.class);
        if (!Arrays.stream(optIns).anyMatch(optIn -> optIn.value().equals(((Object)((Object)this)).getClass().getCanonicalName()))) {
            if (this.gremlinFlavorSuite) {
                logger.error(String.format("The %s will run for this Graph as it is testing a Gremlin flavor but the Graph does not publicly acknowledged it yet with the @OptIn annotation.", ((Object)((Object)this)).getClass().getSimpleName()));
            } else {
                throw new InitializationError(String.format("The %s will not run for this Graph until it is publicly acknowledged with the @OptIn annotation on the Graph instance itself", ((Object)((Object)this)).getClass().getSimpleName()));
            }
        }
    }

    private void registerOptOuts(Class<?> classWithOptOuts, Optional<GraphProvider.Descriptor> graphProviderDescriptor, TraversalEngine.Type traversalEngineType) throws InitializationError {
        List<Graph.OptOut> optOuts = AbstractGremlinSuite.getAllOptOuts(classWithOptOuts);
        if (!optOuts.isEmpty()) {
            if (!optOuts.stream().allMatch(ignore -> ignore.test() != null && ignore.reason() != null && !ignore.reason().isEmpty())) {
                throw new InitializationError("Check @IgnoreTest annotations - all must have a 'test' and 'reason' set");
            }
            try {
                Graph.OptOut[] oos = new Graph.OptOut[optOuts.size()];
                optOuts.toArray(oos);
                this.filter(new OptOutTestFilter(oos, graphProviderDescriptor, traversalEngineType));
            }
            catch (NoTestsRemainException ex) {
                throw new InitializationError((Throwable)ex);
            }
        }
    }

    private static List<Graph.OptOut> getAllOptOuts(Class<?> clazz) {
        if (clazz == Object.class || null == clazz) {
            return Collections.emptyList();
        }
        return Stream.concat(AbstractGremlinSuite.getAllOptOuts(clazz.getSuperclass()).stream(), Stream.of((Graph.OptOut[])clazz.getAnnotationsByType(Graph.OptOut.class))).distinct().collect(Collectors.toList());
    }

    private static Class<?>[] enforce(Class<?>[] unfilteredTestsToExecute, Class<?>[] unfilteredTestsToEnforce) {
        Class[] testsToExecute = AbstractGremlinSuite.filterSpecifiedTests(unfilteredTestsToExecute);
        Class<?>[] testsToEnforce = AbstractGremlinSuite.filterSpecifiedTests(unfilteredTestsToEnforce);
        if (null == testsToEnforce) {
            return testsToExecute;
        }
        List notSupplied = Stream.of(testsToEnforce).filter(t -> Stream.of(testsToExecute).noneMatch(t::isAssignableFrom)).collect(Collectors.toList());
        if (notSupplied.size() > 0) {
            logger.error(String.format("Review the testsToExecute given to the test suite as the following are missing: %s", notSupplied));
        }
        return testsToExecute;
    }

    private static Class<?>[] filterSpecifiedTests(Class<?>[] allTests) {
        Class<?>[] filteredTests;
        if (null == allTests) {
            return null;
        }
        String override = System.getenv().getOrDefault("GREMLIN_TESTS", "");
        if (override.equals("")) {
            filteredTests = allTests;
        } else {
            List<String> filters = Arrays.asList(override.split(","));
            List<Class> allowed = Stream.of(allTests).filter(c -> filters.contains(c.getName())).collect(Collectors.toList());
            filteredTests = allowed.toArray(new Class[allowed.size()]);
        }
        return filteredTests;
    }

    public static Pair<Class<? extends GraphProvider>, Class<? extends Graph>> getGraphProviderClass(Class<?> klass) throws InitializationError {
        GraphProviderClass annotation = klass.getAnnotation(GraphProviderClass.class);
        if (null == annotation) {
            throw new InitializationError(String.format("class '%s' must have a GraphProviderClass annotation", klass.getName()));
        }
        return Pair.with(annotation.provider(), annotation.graph());
    }

    static void validateOptInAndOutAnnotations(Class<?> klass) throws InitializationError {
        Graph.OptOut[] optOuts;
        for (Graph.OptOut optOut : optOuts = (Graph.OptOut[])klass.getAnnotationsByType(Graph.OptOut.class)) {
            Class<?> testClass;
            try {
                testClass = Class.forName(optOut.test());
            }
            catch (Exception ex) {
                throw new InitializationError(String.format("Invalid @OptOut on Graph instance.  Could not instantiate test class (it may have been renamed): %s", optOut.test()));
            }
            if (optOut.method().equals("*") || Arrays.stream(testClass.getMethods()).anyMatch(m -> m.getName().equals(optOut.method()))) continue;
            throw new InitializationError(String.format("Invalid @OptOut on Graph instance.  Could not match @OptOut test name %s on test class %s (it may have been renamed)", optOut.method(), optOut.test()));
        }
    }

    protected void runChild(Runner runner, RunNotifier notifier) {
        if (this.beforeTestExecution(runner.getDescription().getTestClass())) {
            super.runChild(runner, notifier);
        }
        this.afterTestExecution(runner.getDescription().getTestClass());
    }

    protected Statement withAfterClasses(final Statement statement) {
        Statement wrappedStatement = new Statement(){

            public void evaluate() throws Throwable {
                statement.evaluate();
                GraphProvider gp = GraphManager.getGraphProvider();
                if (gp instanceof AutoCloseable) {
                    ((AutoCloseable)((Object)gp)).close();
                }
            }
        };
        return super.withAfterClasses(wrappedStatement);
    }

    public boolean beforeTestExecution(Class<? extends AbstractGremlinTest> testClass) {
        return true;
    }

    public void afterTestExecution(Class<? extends AbstractGremlinTest> testClass) {
    }

    public static class OptOutTestFilter
    extends Filter {
        private final List<Description> individualSpecificTestsToIgnore;
        private final List<Description> testGroupToIgnore;
        private final List<Graph.OptOut> entireTestCaseToIgnore;
        private final Optional<GraphProvider.Descriptor> graphProviderDescriptor;
        private final TraversalEngine.Type traversalEngineType;

        public OptOutTestFilter(Graph.OptOut[] optOuts, Optional<GraphProvider.Descriptor> graphProviderDescriptor, TraversalEngine.Type traversalEngineType) {
            this.graphProviderDescriptor = graphProviderDescriptor;
            this.traversalEngineType = traversalEngineType;
            Map<Boolean, List<Graph.OptOut>> split = Arrays.stream(optOuts).filter(this::checkGraphProviderDescriptorForComputer).collect(Collectors.groupingBy(optOut -> optOut.method().equals("*")));
            List optOutsOfIndividualTests = split.getOrDefault(Boolean.FALSE, Collections.emptyList());
            this.individualSpecificTestsToIgnore = optOutsOfIndividualTests.stream().filter(ignoreTest -> !ignoreTest.method().equals("*")).filter(this.allowAbstractMethod(false)).map(ignoreTest -> Pair.with((Object)ignoreTest.test(), (Object)(ignoreTest.specific().isEmpty() ? ignoreTest.method() : String.format("%s[%s]", ignoreTest.method(), ignoreTest.specific())))).map(p -> Description.createTestDescription((String)p.getValue0().toString(), (String)p.getValue1().toString(), (Annotation[])new Annotation[0])).collect(Collectors.toList());
            this.testGroupToIgnore = optOutsOfIndividualTests.stream().filter(ignoreTest -> !ignoreTest.method().equals("*")).filter(this.allowAbstractMethod(true)).map(ignoreTest -> Pair.with((Object)ignoreTest.test(), (Object)(ignoreTest.specific().isEmpty() ? ignoreTest.method() : String.format("%s[%s]", ignoreTest.method(), ignoreTest.specific())))).map(p -> Description.createTestDescription((String)p.getValue0().toString(), (String)p.getValue1().toString(), (Annotation[])new Annotation[0])).collect(Collectors.toList());
            this.entireTestCaseToIgnore = split.getOrDefault(Boolean.TRUE, Collections.emptyList());
        }

        public boolean shouldRun(Description description) {
            boolean ignoreWholeTestCase;
            if (description.getTestClass() != null && (ignoreWholeTestCase = this.entireTestCaseToIgnore.stream().map(this::transformToClass).anyMatch(claxx -> claxx.isAssignableFrom(description.getTestClass())))) {
                return false;
            }
            if (description.isTest()) {
                return (this.testGroupToIgnore.isEmpty() || !this.testGroupToIgnore.stream().anyMatch(optOut -> optOut.getTestClass().isAssignableFrom(description.getTestClass()) && description.getMethodName().equals(optOut.getMethodName()))) && !this.individualSpecificTestsToIgnore.contains(description);
            }
            for (Description each : description.getChildren()) {
                if (!this.shouldRun(each)) continue;
                return true;
            }
            return false;
        }

        public String describe() {
            return String.format("Method %s", String.join((CharSequence)",", this.individualSpecificTestsToIgnore.stream().map(Description::getDisplayName).collect(Collectors.toList())));
        }

        private Predicate<Graph.OptOut> allowAbstractMethod(boolean allow) {
            return optOut -> {
                try {
                    Class<?> testClass = Class.forName(optOut.test());
                    if (allow) {
                        return Modifier.isAbstract(testClass.getModifiers());
                    }
                    return !Modifier.isAbstract(testClass.getModifiers());
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            };
        }

        private boolean checkGraphProviderDescriptorForComputer(Graph.OptOut optOut) {
            if (this.traversalEngineType == TraversalEngine.Type.STANDARD || optOut.computers().length == 0) {
                return true;
            }
            return Stream.of(optOut.computers()).map(c -> {
                try {
                    return Class.forName(c);
                }
                catch (ClassNotFoundException e) {
                    return Object.class;
                }
            }).filter(c -> !c.equals(Object.class)).anyMatch(c -> c == this.graphProviderDescriptor.get().computer());
        }

        private Class<?> transformToClass(Graph.OptOut optOut) {
            try {
                return Class.forName(optOut.test());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

