/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.gryo;

import java.io.IOException;
import java.util.Map;
import org.apache.tinkerpop.gremlin.structure.io.graphson.AbstractObjectDeserializer;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.InputShim;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.KryoShim;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.OutputShim;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.SerializerShim;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerationException;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerator;
import org.apache.tinkerpop.shaded.jackson.databind.SerializerProvider;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.StdScalarSerializer;

public final class ToyPoint {
    private final int x;
    private final int y;

    public ToyPoint(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int hashCode() {
        return this.x + this.y;
    }

    public boolean equals(Object other) {
        return other instanceof ToyPoint && ((ToyPoint)other).x == this.x && ((ToyPoint)other).y == this.y;
    }

    public String toString() {
        return "[" + this.x + "," + this.y + "]";
    }

    public static class ToyPointJacksonDeSerializer
    extends AbstractObjectDeserializer<ToyPoint> {
        public ToyPointJacksonDeSerializer() {
            super(ToyPoint.class);
        }

        public ToyPoint createObject(Map<String, Object> map) {
            return new ToyPoint((Integer)map.get("x"), (Integer)map.get("y"));
        }
    }

    public static class ToyPointJacksonSerializer
    extends StdScalarSerializer<ToyPoint> {
        public ToyPointJacksonSerializer() {
            super(ToyPoint.class);
        }

        public void serialize(ToyPoint toyPoint, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeObjectField("x", (Object)toyPoint.x);
            jsonGenerator.writeObjectField("y", (Object)toyPoint.y);
            jsonGenerator.writeEndObject();
        }
    }

    public static class ToyPointSerializer
    implements SerializerShim<ToyPoint> {
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, ToyPoint toyPoint) {
            output.writeInt(toyPoint.x);
            output.writeInt(toyPoint.y);
        }

        public <I extends InputShim> ToyPoint read(KryoShim<I, ?> kryo, I input, Class<ToyPoint> toyPointClass) {
            return new ToyPoint(input.readInt(), input.readInt());
        }
    }
}

