/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.tinkerpop.gremlin.ExceptionCoverage;
import org.apache.tinkerpop.gremlin.ExceptionCoverageSet;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.remote.EmbeddedRemoteConnection;
import org.apache.tinkerpop.gremlin.process.remote.RemoteConnection;
import org.apache.tinkerpop.gremlin.process.traversal.AnonymousTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.BulkSet;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.VerificationException;
import org.apache.tinkerpop.gremlin.process.traversal.util.DefaultTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.StringStartsWith;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@ExceptionCoverageSet(value={@ExceptionCoverage(exceptionClass=Traversal.Exceptions.class, methods={"traversalIsLocked"}), @ExceptionCoverage(exceptionClass=Graph.Exceptions.class, methods={"idArgsMustBeEitherIdOrElement"})})
public class CoreTraversalTest
extends AbstractGremlinProcessTest {
    @Test
    @LoadGraphWith
    public void shouldNeverPropagateANoBulkTraverser() {
        try {
            Assert.assertFalse((boolean)this.g.V(new Object[0]).dedup(new String[0]).sideEffect(t -> t.asAdmin().setBulk(0L)).hasNext());
            Assert.assertEquals((long)0L, (long)this.g.V(new Object[0]).dedup(new String[0]).sideEffect(t -> t.asAdmin().setBulk(0L)).toList().size());
            this.g.V(new Object[0]).dedup(new String[0]).sideEffect(t -> t.asAdmin().setBulk(0L)).sideEffect(t -> Assert.fail((String)"this should not have happened")).iterate();
        }
        catch (VerificationException verificationException) {
            // empty catch block
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldCloneTraversalForReuse() {
        DefaultTraversal t = (DefaultTraversal)this.g.V(new Object[0]).count();
        Assert.assertEquals((long)6L, (long)((Long)t.next()).intValue());
        MatcherAssert.assertThat((Object)t.hasNext(), (Matcher)Is.is((Object)false));
        DefaultTraversal t1 = t.clone();
        Assert.assertEquals((long)6L, (long)((Long)t1.next()).intValue());
        MatcherAssert.assertThat((Object)t1.hasNext(), (Matcher)Is.is((Object)false));
        DefaultTraversal t2 = t.clone();
        Assert.assertEquals((long)6L, (long)((Long)t2.next()).intValue());
        MatcherAssert.assertThat((Object)t2.hasNext(), (Matcher)Is.is((Object)false));
        DefaultTraversal t3 = t1.clone();
        Assert.assertEquals((long)6L, (long)((Long)t3.next()).intValue());
        MatcherAssert.assertThat((Object)t3.hasNext(), (Matcher)Is.is((Object)false));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldFilterOnIterate() {
        GraphTraversal traversal = this.g.V(new Object[0]).out(new String[0]).out(new String[0]).values(new String[]{"name"}).aggregate("x").iterate();
        Assert.assertFalse((boolean)traversal.hasNext());
        Assert.assertEquals((long)2L, (long)((BulkSet)traversal.asAdmin().getSideEffects().get("x")).size());
        Assert.assertTrue((boolean)((BulkSet)traversal.asAdmin().getSideEffects().get("x")).contains((Object)"ripple"));
        Assert.assertTrue((boolean)((BulkSet)traversal.asAdmin().getSideEffects().get("x")).contains((Object)"lop"));
        Assert.assertEquals((Object)"none", (Object)((Bytecode.Instruction)traversal.asAdmin().getBytecode().getStepInstructions().get(traversal.asAdmin().getBytecode().getStepInstructions().size() - 1)).getOperator());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldAllowIdsOfMixedTypes() {
        List vertices = this.g.V(new Object[0]).toList();
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{vertices.get(0), ((Vertex)vertices.get(1)).id()}).count().next()).intValue());
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{((Vertex)vertices.get(0)).id(), vertices.get(1)}).count().next()).intValue());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldHaveNextAndToCollectionWorkProperly() {
        GraphTraversal traversal = this.g.V(new Object[0]);
        Assert.assertTrue((boolean)(traversal.next() instanceof Vertex));
        Assert.assertEquals((long)4L, (long)traversal.next(4).size());
        Assert.assertTrue((boolean)traversal.hasNext());
        Assert.assertTrue((boolean)traversal.tryNext().isPresent());
        Assert.assertFalse((boolean)traversal.hasNext());
        Assert.assertFalse((boolean)traversal.tryNext().isPresent());
        Assert.assertFalse((boolean)traversal.hasNext());
        GraphTraversal intTraversal = __.inject((Object[])new Integer[]{7, 7, 2, 3, 6});
        Assert.assertTrue((boolean)intTraversal.hasNext());
        List list = intTraversal.toList();
        Assert.assertFalse((boolean)intTraversal.hasNext());
        Assert.assertEquals((long)5L, (long)list.size());
        Assert.assertEquals((long)7L, (long)((Integer)list.get(0)).intValue());
        Assert.assertEquals((long)7L, (long)((Integer)list.get(1)).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)list.get(2)).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)list.get(3)).intValue());
        Assert.assertEquals((long)6L, (long)((Integer)list.get(4)).intValue());
        Assert.assertFalse((boolean)intTraversal.hasNext());
        Assert.assertFalse((boolean)intTraversal.tryNext().isPresent());
        intTraversal = __.inject((Object[])new Integer[]{7, 7, 2, 3, 6});
        Assert.assertTrue((boolean)intTraversal.hasNext());
        Set set = intTraversal.toSet();
        Assert.assertFalse((boolean)intTraversal.hasNext());
        Assert.assertEquals((long)4L, (long)set.size());
        Assert.assertTrue((boolean)set.contains(7));
        Assert.assertTrue((boolean)set.contains(2));
        Assert.assertTrue((boolean)set.contains(3));
        Assert.assertTrue((boolean)set.contains(6));
        Assert.assertFalse((boolean)intTraversal.hasNext());
        Assert.assertFalse((boolean)intTraversal.tryNext().isPresent());
        intTraversal = __.inject((Object[])new Integer[]{7, 7, 2, 3, 6});
        Assert.assertTrue((boolean)intTraversal.hasNext());
        BulkSet bulkSet = intTraversal.toBulkSet();
        Assert.assertFalse((boolean)intTraversal.hasNext());
        Assert.assertEquals((long)4L, (long)bulkSet.uniqueSize());
        Assert.assertEquals((long)5L, (long)bulkSet.longSize());
        Assert.assertEquals((long)5L, (long)bulkSet.size());
        Assert.assertTrue((boolean)bulkSet.contains((Object)7));
        Assert.assertTrue((boolean)bulkSet.contains((Object)2));
        Assert.assertTrue((boolean)bulkSet.contains((Object)3));
        Assert.assertTrue((boolean)bulkSet.contains((Object)6));
        Assert.assertEquals((long)2L, (long)bulkSet.get((Object)7));
        Assert.assertFalse((boolean)intTraversal.hasNext());
        Assert.assertFalse((boolean)intTraversal.tryNext().isPresent());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldHavePropertyForEachRemainingBehaviorEvenWithStrategyRewrite() {
        GraphTraversal traversal = this.g.V(new Object[0]).out(new String[0]).groupCount();
        traversal.forEachRemaining(Map.class, map -> Assert.assertTrue((boolean)(map instanceof Map)));
    }

    @Test
    @Ignore
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldNotAlterTraversalAfterTraversalBecomesLocked() {
        GraphTraversal traversal = this.g.V(new Object[0]);
        Assert.assertTrue((boolean)traversal.hasNext());
        try {
            traversal.count().next();
            Assert.fail((String)("Should throw: " + Traversal.Exceptions.traversalIsLocked()));
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)Traversal.Exceptions.traversalIsLocked().getMessage(), (Object)e.getMessage());
        }
        catch (Exception e) {
            Assert.fail((String)("Should throw: " + Traversal.Exceptions.traversalIsLocked() + " not " + e + ":" + e.getMessage()));
        }
        traversal.iterate();
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions")
    public void shouldTraverseIfAutoTxEnabledAndOriginalTxIsClosed() {
        this.g.tx().onReadWrite((Consumer)Transaction.READ_WRITE_BEHAVIOR.AUTO);
        GraphTraversal t = this.g.V(new Object[0]).has("name", (Object)"marko");
        this.g.tx().rollback();
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)t));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions")
    public void shouldTraverseIfManualTxEnabledAndOriginalTxIsClosed() {
        this.g.tx().onReadWrite((Consumer)Transaction.READ_WRITE_BEHAVIOR.MANUAL);
        this.g.tx().open();
        GraphTraversal t = this.g.V(new Object[0]).has("name", (Object)"marko");
        this.g.tx().rollback();
        this.g.tx().open();
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)t));
        this.g.tx().rollback();
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldNotThrowFastNoSuchElementException() {
        try {
            this.g.V(new Object[0]).has("foo").next();
            Assert.fail((String)"Expected a user facing NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            Assert.assertEquals(NoSuchElementException.class, e.getClass());
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldThrowFastNoSuchElementExceptionInNestedTraversals() {
        GraphTraversal nestedTraversal = __.has((String)"name", (Object)"foo");
        GraphTraversal traversal = this.g.V(new Object[0]).has("name", (Object)"marko").branch((Traversal)nestedTraversal);
        GraphTraversal.Admin nestedTraversalAdmin = nestedTraversal.asAdmin();
        nestedTraversalAdmin.reset();
        nestedTraversalAdmin.addStart(nestedTraversalAdmin.getTraverserGenerator().generate(this.g.V(new Object[0]).has("name", (Object)"marko").next(), traversal.asAdmin().getStartStep(), 1L));
        try {
            nestedTraversal.next();
        }
        catch (NoSuchElementException e) {
            Assert.assertEquals(FastNoSuchElementException.class, e.getClass());
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldAllowEmbeddedRemoteConnectionUsage() {
        GraphTraversalSource simulatedRemoteG = (GraphTraversalSource)AnonymousTraversalSource.traversal().withRemote((RemoteConnection)new EmbeddedRemoteConnection(this.g));
        Assert.assertEquals((long)6L, (long)((Long)simulatedRemoteG.V(new Object[0]).count().next()).intValue());
        Assert.assertEquals((Object)"marko", (Object)simulatedRemoteG.V(new Object[0]).has("name", (Object)"marko").values(new String[]{"name"}).next());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldThrowNiceExceptionWhenMapKeyNotFoundInMathStep() {
        try {
            this.g.V(new Object[0]).hasLabel("person", new String[0]).project("age", new String[0]).by("age").as("x", new String[0]).math("x").by("aged").iterate();
            Assert.fail((String)"Traversal should no have succeeded since the 'aged' key does not exist");
        }
        catch (IllegalStateException ise) {
            MatcherAssert.assertThat((Object)ise.getMessage(), (Matcher)StringStartsWith.startsWith((String)"The variable x for math() step must resolve to a Number"));
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldThrowNiceExceptionWhenMapKeyIsNotResolvingToNumberInMathStep() {
        try {
            this.g.V(new Object[0]).hasLabel("person", new String[0]).project("age", new String[0]).by("age").as("x", new String[0]).math("x").by("name").iterate();
            Assert.fail((String)"Traversal should no have succeeded since the 'name' key does not resolve to Number");
        }
        catch (IllegalStateException ise) {
            MatcherAssert.assertThat((Object)ise.getMessage(), (Matcher)StringStartsWith.startsWith((String)"The variable x for math() step must resolve to a Number"));
        }
    }
}

