/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.FeatureRequirements;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.io.GraphMigrator;
import org.apache.tinkerpop.gremlin.structure.io.GraphReader;
import org.apache.tinkerpop.gremlin.structure.io.GraphWriter;
import org.apache.tinkerpop.gremlin.structure.io.Mapper;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONIo;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONVersion;
import org.apache.tinkerpop.gremlin.structure.io.graphson.TypeInfo;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoIo;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoVersion;
import org.apache.tinkerpop.gremlin.structure.io.util.CustomId;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.apache.tinkerpop.shaded.jackson.databind.JsonSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.module.SimpleModule;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IoCustomTest
extends AbstractGremlinTest {
    @Parameterized.Parameter(value=0)
    public String ioType;
    @Parameterized.Parameter(value=1)
    public boolean assertIdDirectly;
    @Parameterized.Parameter(value=2)
    public Function<Graph, GraphReader> readerMaker;
    @Parameterized.Parameter(value=3)
    public Function<Graph, GraphWriter> writerMaker;

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> data() {
        SimpleModule moduleV1d0 = new SimpleModule();
        moduleV1d0.addSerializer(CustomId.class, (JsonSerializer)new CustomId.CustomIdJacksonSerializerV1d0());
        CustomId.CustomIdTinkerPopJacksonModuleV2d0 moduleV2d0 = new CustomId.CustomIdTinkerPopJacksonModuleV2d0();
        CustomId.CustomIdTinkerPopJacksonModuleV3d0 modulev3d0 = new CustomId.CustomIdTinkerPopJacksonModuleV3d0();
        return Arrays.asList({"graphson-v1-embedded", true, g -> ((GraphSONIo)g.io(GraphSONIo.build((GraphSONVersion)GraphSONVersion.V1_0))).reader().mapper((Mapper)((GraphSONIo)g.io(GraphSONIo.build((GraphSONVersion)GraphSONVersion.V1_0))).mapper().addCustomModule(moduleV1d0).typeInfo(TypeInfo.PARTIAL_TYPES).create()).create(), g -> ((GraphSONIo)g.io(GraphSONIo.build((GraphSONVersion)GraphSONVersion.V1_0))).writer().mapper((Mapper)((GraphSONIo)g.io(GraphSONIo.build((GraphSONVersion)GraphSONVersion.V1_0))).mapper().addCustomModule(moduleV1d0).typeInfo(TypeInfo.PARTIAL_TYPES).create()).create()}, {"graphson-v2-embedded", true, arg_0 -> IoCustomTest.lambda$data$2((SimpleModule)moduleV2d0, arg_0), arg_0 -> IoCustomTest.lambda$data$3((SimpleModule)moduleV2d0, arg_0)}, {"graphson-v3", true, arg_0 -> IoCustomTest.lambda$data$4((SimpleModule)modulev3d0, arg_0), arg_0 -> IoCustomTest.lambda$data$5((SimpleModule)modulev3d0, arg_0)}, {"gryo-v1", true, g -> ((GryoIo)g.io(GryoIo.build((GryoVersion)GryoVersion.V1_0))).reader().mapper((Mapper)((GryoIo)g.io(GryoIo.build((GryoVersion)GryoVersion.V1_0))).mapper().version(GryoVersion.V1_0).addCustom(new Class[]{CustomId.class}).create()).create(), g -> ((GryoIo)g.io(GryoIo.build((GryoVersion)GryoVersion.V1_0))).writer().mapper((Mapper)((GryoIo)g.io(GryoIo.build((GryoVersion)GryoVersion.V1_0))).mapper().version(GryoVersion.V1_0).addCustom(new Class[]{CustomId.class}).create()).create()}, {"gryo-v3", true, g -> ((GryoIo)g.io(GryoIo.build((GryoVersion)GryoVersion.V3_0))).reader().mapper((Mapper)((GryoIo)g.io(GryoIo.build((GryoVersion)GryoVersion.V3_0))).mapper().version(GryoVersion.V3_0).addCustom(new Class[]{CustomId.class}).create()).create(), g -> ((GryoIo)g.io(GryoIo.build((GryoVersion)GryoVersion.V3_0))).writer().mapper((Mapper)((GryoIo)g.io(GryoIo.build((GryoVersion)GryoVersion.V3_0))).mapper().version(GryoVersion.V3_0).addCustom(new Class[]{CustomId.class}).create()).create()});
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="SerializableValues")})
    public void shouldSupportUUID() throws Exception {
        UUID id = UUID.randomUUID();
        Vertex v1 = this.graph.addVertex(new Object[]{T.label, "person"});
        Vertex v2 = this.graph.addVertex(new Object[]{T.label, "person"});
        Edge e = v1.addEdge("friend", v2, new Object[]{"uuid", id});
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GraphWriter writer = this.writerMaker.apply(this.graph);
            writer.writeEdge((OutputStream)os, e);
            AtomicBoolean called = new AtomicBoolean(false);
            GraphReader reader = this.readerMaker.apply(this.graph);
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readEdge((InputStream)bais, edge -> {
                    Edge detachedEdge = (Edge)edge;
                    Assert.assertEquals((Object)e.id(), (Object)(this.assertIdDirectly ? detachedEdge.id() : ((Edge)this.graph.edges(new Object[]{detachedEdge.id().toString()}).next()).id()));
                    Assert.assertEquals((Object)v1.id(), (Object)(this.assertIdDirectly ? detachedEdge.outVertex().id() : ((Vertex)this.graph.vertices(new Object[]{detachedEdge.outVertex().id().toString()}).next()).id()));
                    Assert.assertEquals((Object)v2.id(), (Object)(this.assertIdDirectly ? detachedEdge.inVertex().id() : ((Vertex)this.graph.vertices(new Object[]{detachedEdge.inVertex().id().toString()}).next()).id()));
                    Assert.assertEquals((Object)v1.label(), (Object)detachedEdge.outVertex().label());
                    Assert.assertEquals((Object)v2.label(), (Object)detachedEdge.inVertex().label());
                    Assert.assertEquals((Object)e.label(), (Object)detachedEdge.label());
                    Assert.assertEquals((long)e.keys().size(), (long)IteratorUtils.count((Iterator)detachedEdge.properties(new String[0])));
                    Assert.assertEquals((Object)id, (Object)detachedEdge.value("uuid"));
                    called.set(true);
                    return null;
                });
            }
            Assert.assertTrue((boolean)called.get());
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AnyIds")})
    public void shouldProperlySerializeCustomId() throws Exception {
        this.graph.addVertex(new Object[]{T.id, new CustomId("vertex", UUID.fromString("AF4B5965-B176-4552-B3C1-FBBE2F52C305"))});
        GraphWriter writer = this.writerMaker.apply(this.graph);
        GraphReader reader = this.readerMaker.apply(this.graph);
        Configuration configuration = this.graphProvider.newGraphConfiguration("readGraph", this.getClass(), this.name.getMethodName(), null);
        this.graphProvider.clear(configuration);
        Graph g1 = this.graphProvider.openTestGraph(configuration);
        GraphMigrator.migrateGraph((Graph)this.graph, (Graph)g1, (GraphReader)reader, (GraphWriter)writer);
        Vertex onlyVertex = (Vertex)g1.traversal().V(new Object[0]).next();
        CustomId id = (CustomId)onlyVertex.id();
        Assert.assertEquals((Object)"vertex", (Object)id.getCluster());
        Assert.assertEquals((Object)UUID.fromString("AF4B5965-B176-4552-B3C1-FBBE2F52C305"), (Object)id.getElementId());
        this.graphProvider.clear(g1, configuration);
    }

    private static /* synthetic */ GraphWriter lambda$data$5(SimpleModule modulev3d0, Graph g) {
        return ((GraphSONIo)g.io(GraphSONIo.build((GraphSONVersion)GraphSONVersion.V3_0))).writer().mapper((Mapper)((GraphSONIo)g.io(GraphSONIo.build((GraphSONVersion)GraphSONVersion.V3_0))).mapper().addCustomModule(modulev3d0).create()).create();
    }

    private static /* synthetic */ GraphReader lambda$data$4(SimpleModule modulev3d0, Graph g) {
        return ((GraphSONIo)g.io(GraphSONIo.build((GraphSONVersion)GraphSONVersion.V3_0))).reader().mapper((Mapper)((GraphSONIo)g.io(GraphSONIo.build((GraphSONVersion)GraphSONVersion.V3_0))).mapper().addCustomModule(modulev3d0).create()).create();
    }

    private static /* synthetic */ GraphWriter lambda$data$3(SimpleModule moduleV2d0, Graph g) {
        return ((GraphSONIo)g.io(GraphSONIo.build((GraphSONVersion)GraphSONVersion.V2_0))).writer().mapper((Mapper)((GraphSONIo)g.io(GraphSONIo.build((GraphSONVersion)GraphSONVersion.V2_0))).mapper().addCustomModule(moduleV2d0).typeInfo(TypeInfo.PARTIAL_TYPES).create()).create();
    }

    private static /* synthetic */ GraphReader lambda$data$2(SimpleModule moduleV2d0, Graph g) {
        return ((GraphSONIo)g.io(GraphSONIo.build((GraphSONVersion)GraphSONVersion.V2_0))).reader().mapper((Mapper)((GraphSONIo)g.io(GraphSONIo.build((GraphSONVersion)GraphSONVersion.V2_0))).mapper().addCustomModule(moduleV2d0).typeInfo(TypeInfo.PARTIAL_TYPES).create()).create();
    }
}

