/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.GraphManager;
import org.apache.tinkerpop.gremlin.process.IgnoreEngine;
import org.apache.tinkerpop.gremlin.process.remote.traversal.RemoteTraversalSideEffects;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalEngine;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSideEffects;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.MapHelper;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGremlinProcessTest
extends AbstractGremlinTest {
    private static final Logger logger = LoggerFactory.getLogger(AbstractGremlinProcessTest.class);

    protected boolean graphMeetsTestRequirements() {
        return !this.hasGraphComputerRequirement() || this.graph.features().graph().supportsComputer();
    }

    protected boolean hasGraphComputerRequirement() {
        return !GraphManager.getTraversalEngineType().equals((Object)TraversalEngine.Type.STANDARD);
    }

    @Before
    public void setupTest() {
        Assume.assumeTrue((boolean)this.graphMeetsTestRequirements());
        try {
            String testName = this.name.getMethodName();
            String methodName = testName.contains("[") ? testName.substring(0, testName.indexOf(91)) : testName;
            IgnoreEngine ignoreEngine = this.getClass().getMethod(methodName, new Class[0]).getAnnotation(IgnoreEngine.class);
            if (ignoreEngine != null) {
                Assume.assumeTrue((String)String.format("%s.%s is ignored for %s", this.getClass().getName(), testName, ignoreEngine.value()), (!ignoreEngine.value().equals((Object)GraphManager.getTraversalEngineType()) ? 1 : 0) != 0);
            }
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException(String.format("Could not find test method %s in test case %s", this.name.getMethodName(), this.getClass().getName()));
        }
    }

    public static void checkSideEffects(TraversalSideEffects sideEffects, Object ... keysClasses) {
        int counter = 0;
        for (int i = 0; i < keysClasses.length; i += 2) {
            ++counter;
            String key = (String)keysClasses[i];
            Class clazz = (Class)keysClasses[i + 1];
            MatcherAssert.assertThat((Object)sideEffects.keys().contains(key), (Matcher)Is.is((Object)true));
            MatcherAssert.assertThat((Object)sideEffects.exists(key), (Matcher)Is.is((Object)true));
            MatcherAssert.assertThat((Object)sideEffects.exists(UUID.randomUUID().toString()), (Matcher)Is.is((Object)false));
            if (sideEffects instanceof RemoteTraversalSideEffects) continue;
            Assert.assertEquals((Object)clazz, sideEffects.get((String)keysClasses[i]).getClass());
        }
        Assert.assertEquals((long)sideEffects.keys().size(), (long)counter);
        MatcherAssert.assertThat((Object)sideEffects.keys().contains(UUID.randomUUID().toString()), (Matcher)Is.is((Object)false));
        Assert.assertEquals((Object)StringFactory.traversalSideEffectsString((TraversalSideEffects)sideEffects), (Object)sideEffects.toString());
    }

    public static <T> void checkOrderedResults(List<T> expectedResults, Traversal<?, T> traversal) {
        List results = traversal.toList();
        Assert.assertFalse((boolean)traversal.hasNext());
        if (expectedResults.size() != results.size()) {
            logger.error("Expected results: " + expectedResults);
            logger.error("Actual results:   " + results);
            Assert.assertEquals((String)"Checking result size", (long)expectedResults.size(), (long)results.size());
        }
        for (int i = 0; i < expectedResults.size(); ++i) {
            Assert.assertEquals(expectedResults.get(i), results.get(i));
        }
    }

    public static <T> void checkResults(List<T> expectedResults, Traversal<?, T> traversal) {
        List results = traversal.toList();
        Assert.assertFalse((boolean)traversal.hasNext());
        if (expectedResults.size() != results.size()) {
            logger.error("Expected results: " + expectedResults);
            logger.error("Actual results:   " + results);
            Assert.assertEquals((String)"Checking result size", (long)expectedResults.size(), (long)results.size());
        }
        for (Object t2 : results) {
            if (t2 instanceof Map) {
                MatcherAssert.assertThat((String)("Checking map result existence: " + t2), (Object)expectedResults.stream().filter(e -> e instanceof Map).anyMatch(e -> AbstractGremlinProcessTest.internalCheckMap((Map)e, (Map)t2)), (Matcher)Is.is((Object)true));
                continue;
            }
            if (t2 instanceof List) {
                MatcherAssert.assertThat((String)("Checking list result existence: " + t2), (Object)expectedResults.stream().filter(e -> e instanceof List).anyMatch(e -> AbstractGremlinProcessTest.internalCheckList((List)e, (List)t2)), (Matcher)Is.is((Object)true));
                continue;
            }
            MatcherAssert.assertThat((String)("Checking result existence: " + t2), (Object)expectedResults.contains(t2), (Matcher)Is.is((Object)true));
        }
        HashMap<Object, Long> expectedResultsCount = new HashMap<Object, Long>();
        HashMap resultsCount = new HashMap();
        Assert.assertEquals((String)"Checking indexing is equivalent", (long)expectedResultsCount.size(), (long)resultsCount.size());
        expectedResults.forEach(t -> MapHelper.incr((Map)expectedResultsCount, (Object)t, (Long)1L));
        results.forEach(t -> MapHelper.incr((Map)resultsCount, (Object)t, (Long)1L));
        expectedResultsCount.forEach((k, v) -> Assert.assertEquals((String)"Checking result group counts", (Object)v, resultsCount.get(k)));
        MatcherAssert.assertThat((Object)traversal.hasNext(), (Matcher)Is.is((Object)false));
    }

    public static <T> void checkResults(Map<T, Long> expectedResults, Traversal<?, T> traversal) {
        ArrayList list = new ArrayList();
        expectedResults.forEach((k, v) -> {
            int i = 0;
            while ((long)i < v) {
                list.add(k);
                ++i;
            }
        });
        AbstractGremlinProcessTest.checkResults(list, traversal);
    }

    public static <A, B> void checkMap(Map<A, B> expectedMap, Map<A, B> actualMap) {
        List actualList = actualMap.entrySet().stream().sorted(Comparator.comparing(a -> a.getKey().toString())).collect(Collectors.toList());
        List expectedList = expectedMap.entrySet().stream().sorted(Comparator.comparing(a -> a.getKey().toString())).collect(Collectors.toList());
        Assert.assertEquals((long)expectedList.size(), (long)actualList.size());
        for (int i = 0; i < actualList.size(); ++i) {
            Assert.assertEquals(((Map.Entry)expectedList.get(i)).getKey(), ((Map.Entry)actualList.get(i)).getKey());
            Assert.assertEquals(((Map.Entry)expectedList.get(i)).getValue(), ((Map.Entry)actualList.get(i)).getValue());
        }
    }

    private static <A> boolean internalCheckList(List<A> expectedList, List<A> actualList) {
        if (expectedList.size() != actualList.size()) {
            return false;
        }
        for (int i = 0; i < actualList.size(); ++i) {
            if (actualList.get(i).equals(expectedList.get(i))) continue;
            return false;
        }
        return true;
    }

    private static <A, B> boolean internalCheckMap(Map<A, B> expectedMap, Map<A, B> actualMap) {
        List actualList = actualMap.entrySet().stream().sorted(Comparator.comparing(a -> a.getKey().toString())).collect(Collectors.toList());
        List expectedList = expectedMap.entrySet().stream().sorted(Comparator.comparing(a -> a.getKey().toString())).collect(Collectors.toList());
        if (expectedList.size() != actualList.size()) {
            return false;
        }
        for (int i = 0; i < actualList.size(); ++i) {
            if (!((Map.Entry)actualList.get(i)).getKey().equals(((Map.Entry)expectedList.get(i)).getKey())) {
                return false;
            }
            if (((Map.Entry)actualList.get(i)).getValue().equals(((Map.Entry)expectedList.get(i)).getValue())) continue;
            return false;
        }
        return true;
    }

    public <A, B> List<Map<A, B>> makeMapList(int size, Object ... keyValues) {
        ArrayList<Map<A, B>> mapList = new ArrayList<Map<A, B>>();
        for (int i = 0; i < keyValues.length; i += 2 * size) {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            for (int j = 0; j < 2 * size; j += 2) {
                map.put(keyValues[i + j], keyValues[i + j + 1]);
            }
            mapList.add(map);
        }
        return mapList;
    }
}

