/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.util;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.tinkerpop.gremlin.structure.io.graphson.AbstractObjectDeserializer;
import org.apache.tinkerpop.gremlin.structure.io.graphson.TinkerPopJacksonModule;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerationException;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerator;
import org.apache.tinkerpop.shaded.jackson.core.JsonParser;
import org.apache.tinkerpop.shaded.jackson.core.JsonProcessingException;
import org.apache.tinkerpop.shaded.jackson.databind.DeserializationContext;
import org.apache.tinkerpop.shaded.jackson.databind.JsonDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.JsonSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.SerializerProvider;
import org.apache.tinkerpop.shaded.jackson.databind.deser.std.StdDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.StdScalarSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.StdSerializer;

public class CustomId {
    private String cluster;
    private UUID elementId;

    private CustomId() {
    }

    public CustomId(String cluster, UUID elementId) {
        this.cluster = cluster;
        this.elementId = elementId;
    }

    public String getCluster() {
        return this.cluster;
    }

    public UUID getElementId() {
        return this.elementId;
    }

    public String toString() {
        return this.cluster + ":" + this.elementId;
    }

    public static class CustomIdTinkerPopJacksonModuleV3d0
    extends TinkerPopJacksonModule {
        private static final Map<Class, String> TYPE_DEFINITIONS = Collections.unmodifiableMap(new LinkedHashMap<Class, String>(){
            {
                this.put(CustomId.class, "id");
            }
        });

        public CustomIdTinkerPopJacksonModuleV3d0() {
            super("custom");
            this.addSerializer(CustomId.class, (JsonSerializer)new CustomIdJacksonSerializerV3d0());
            this.addDeserializer(CustomId.class, (JsonDeserializer)new CustomIdJacksonDeserializerV3d0());
        }

        public Map<Class, String> getTypeDefinitions() {
            return TYPE_DEFINITIONS;
        }

        public String getTypeNamespace() {
            return "simple";
        }
    }

    public static class CustomIdJacksonDeserializerV3d0
    extends StdDeserializer<CustomId> {
        public CustomIdJacksonDeserializerV3d0() {
            super(CustomId.class);
        }

        public CustomId deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            Map data = (Map)deserializationContext.readValue(jsonParser, Map.class);
            return new CustomId((String)data.get("cluster"), (UUID)data.get("elementId"));
        }

        public boolean isCachable() {
            return true;
        }
    }

    public static class CustomIdJacksonSerializerV3d0
    extends StdScalarSerializer<CustomId> {
        public CustomIdJacksonSerializerV3d0() {
            super(CustomId.class);
        }

        public void serialize(CustomId customId, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("cluster", customId.getCluster());
            m.put("elementId", customId.getElementId());
            jsonGenerator.writeObject(m);
        }
    }

    public static class CustomIdTinkerPopJacksonModuleV2d0
    extends TinkerPopJacksonModule {
        private static final Map<Class, String> TYPE_DEFINITIONS = Collections.unmodifiableMap(new LinkedHashMap<Class, String>(){
            {
                this.put(CustomId.class, "id");
            }
        });

        public CustomIdTinkerPopJacksonModuleV2d0() {
            super("custom");
            this.addSerializer(CustomId.class, (JsonSerializer)new CustomIdJacksonSerializerV2d0());
            this.addDeserializer(CustomId.class, (JsonDeserializer)new CustomIdJacksonDeserializerV2d0());
        }

        public Map<Class, String> getTypeDefinitions() {
            return TYPE_DEFINITIONS;
        }

        public String getTypeNamespace() {
            return "simple";
        }
    }

    public static class CustomIdJacksonDeserializerV2d0
    extends AbstractObjectDeserializer<CustomId> {
        public CustomIdJacksonDeserializerV2d0() {
            super(CustomId.class);
        }

        public CustomId createObject(Map data) {
            return new CustomId((String)data.get("cluster"), (UUID)data.get("elementId"));
        }
    }

    public static class CustomIdJacksonSerializerV2d0
    extends StdSerializer<CustomId> {
        public CustomIdJacksonSerializerV2d0() {
            super(CustomId.class);
        }

        public void serialize(CustomId customId, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
            jsonGenerator.writeString(customId.toString());
        }

        public void serializeWithType(CustomId customId, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonProcessingException {
            typeSerializer.writeTypePrefixForScalar((Object)customId, jsonGenerator);
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("cluster", customId.getCluster());
            m.put("elementId", customId.getElementId());
            jsonGenerator.writeObject(m);
            typeSerializer.writeTypeSuffixForScalar((Object)customId, jsonGenerator);
        }
    }

    public static class CustomIdJacksonSerializerV1d0
    extends StdSerializer<CustomId> {
        public CustomIdJacksonSerializerV1d0() {
            super(CustomId.class);
        }

        public void serialize(CustomId customId, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
            jsonGenerator.writeString(customId.toString());
        }

        public void serializeWithType(CustomId customId, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonProcessingException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("@class", CustomId.class.getName());
            jsonGenerator.writeStringField("cluster", customId.getCluster());
            jsonGenerator.writeObjectField("elementId", (Object)customId.getElementId());
            jsonGenerator.writeEndObject();
        }
    }
}

