/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.GremlinProcessRunner;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.process.traversal.SackFunctions;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GremlinProcessRunner.class)
public abstract class SackTest
extends AbstractGremlinProcessTest {
    public abstract Traversal<Vertex, String> get_g_withSackXhelloX_V_outE_sackXassignX_byXlabelX_inV_sack();

    public abstract Traversal<Vertex, Double> get_g_withSackX0X_V_outE_sackXsumX_byXweightX_inV_sack_sum();

    public abstract Traversal<Vertex, Double> get_g_withSackX0X_V_repeatXoutE_sackXsumX_byXweightX_inVX_timesX2X_sack();

    public abstract Traversal<Vertex, Map> get_g_withSackXmap__map_cloneX_V_out_out_sackXmap_a_nameX_sack();

    public abstract Traversal<Vertex, Double> get_g_withSackX1_sumX_VX1X_localXoutXknowsX_barrierXnormSackXX_inXknowsX_barrier_sack(Object var1);

    public abstract Traversal<Vertex, Integer> get_g_withBulkXfalseX_withSackX1_sumX_V_out_barrier_sack();

    public abstract Traversal<Vertex, Double> get_g_withBulkXfalseX_withSackX1_sumX_VX1X_localXoutEXknowsX_barrierXnormSackX_inVX_inXknowsX_barrier_sack(Object var1);

    public abstract Traversal<Vertex, BigDecimal> get_g_withSackXBigInteger_TEN_powX1000X_assignX_V_localXoutXknowsX_barrierXnormSackXX_inXknowsX_barrier_sack();

    public abstract Traversal<Vertex, Double> get_g_withSackX2X_V_sackXdivX_byXconstantX3_0XX_sack();

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_withSackXhelloX_V_outE_sackXassignX_byXlabelX_inV_sack() {
        Traversal<Vertex, String> traversal = this.get_g_withSackXhelloX_V_outE_sackXassignX_byXlabelX_inV_sack();
        SackTest.checkResults(Arrays.asList("knows", "knows", "created", "created", "created", "created"), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_withSackX0X_V_outE_sackXsumX_byXweightX_inV_sack_sum() {
        Traversal<Vertex, Double> traversal = this.get_g_withSackX0X_V_outE_sackXsumX_byXweightX_inV_sack_sum();
        this.printTraversalForm(traversal);
        Assert.assertEquals((double)3.5, (double)((Double)traversal.next()), (double)1.0E-5);
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_withSackX0X_V_repeatXoutE_sackXsumX_byXweightX_inVX_timesX2X_sack() {
        Traversal<Vertex, Double> traversal = this.get_g_withSackX0X_V_repeatXoutE_sackXsumX_byXweightX_inVX_timesX2X_sack();
        this.printTraversalForm(traversal);
        SackTest.checkResults(Arrays.asList(2.0, 1.4), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_withSackXmap__map_cloneX_V_out_out_sackXmap_a_nameX_sack() {
        Traversal<Vertex, Map> traversal = this.get_g_withSackXmap__map_cloneX_V_out_out_sackXmap_a_nameX_sack();
        this.printTraversalForm(traversal);
        int counter = 0;
        while (traversal.hasNext()) {
            Map map = (Map)traversal.next();
            Assert.assertEquals((long)1L, (long)map.size());
            Assert.assertTrue((boolean)map.containsKey("a"));
            Assert.assertTrue((map.get("a").equals("ripple") || map.get("a").equals("lop") ? 1 : 0) != 0);
            ++counter;
        }
        Assert.assertEquals((long)2L, (long)counter);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_withSackX1_sumX_VX1X_localXoutXknowsX_barrierXnormSackXX_inXknowsX_barrier_sack() {
        Traversal<Vertex, Double> traversal = this.get_g_withSackX1_sumX_VX1X_localXoutXknowsX_barrierXnormSackXX_inXknowsX_barrier_sack(this.convertToVertexId("marko"));
        this.printTraversalForm(traversal);
        SackTest.checkResults(Arrays.asList(1.0, 1.0), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_withBulkXfalseX_withSackX1_sumX_V_out_barrier_sack() {
        Traversal<Vertex, Integer> traversal = this.get_g_withBulkXfalseX_withSackX1_sumX_V_out_barrier_sack();
        this.printTraversalForm(traversal);
        SackTest.checkResults(Arrays.asList(1, 1, 1, 3), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_withBulkXfalseX_withSackX1_sumX_VX1X_localXoutEXknowsX_barrierXnormSackX_inVX_inXknowsX_barrier_sack() {
        Traversal<Vertex, Double> traversal = this.get_g_withBulkXfalseX_withSackX1_sumX_VX1X_localXoutEXknowsX_barrierXnormSackX_inVX_inXknowsX_barrier_sack(this.convertToVertexId("marko"));
        this.printTraversalForm(traversal);
        SackTest.checkResults(Collections.singletonList(1.0), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_withSackXBigInteger_TEN_powX1000X_assignX_V_localXoutXknowsX_barrierXnormSackXX_inXknowsX_barrier_sack() {
        Traversal<Vertex, BigDecimal> traversal = this.get_g_withSackXBigInteger_TEN_powX1000X_assignX_V_localXoutXknowsX_barrierXnormSackXX_inXknowsX_barrier_sack();
        this.printTraversalForm(traversal);
        BigDecimal half = BigDecimal.ONE.divide(BigDecimal.ONE.add(BigDecimal.ONE));
        Assert.assertTrue((boolean)traversal.hasNext());
        Assert.assertEquals((Object)half, (Object)traversal.next());
        Assert.assertTrue((boolean)traversal.hasNext());
        Assert.assertEquals((Object)half, (Object)traversal.next());
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_withSackX2X_V_sackXdivX_byXconstantX3_0XX_sack() {
        Traversal<Vertex, Double> traversal = this.get_g_withSackX2X_V_sackXdivX_byXconstantX3_0XX_sack();
        this.printTraversalForm(traversal);
        double expected = 0.6666666666666666;
        for (int i = 0; i < 6; ++i) {
            Assert.assertTrue((boolean)traversal.hasNext());
            Assert.assertEquals((double)0.6666666666666666, (double)((Number)traversal.next()).doubleValue(), (double)1.0E-4);
        }
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    public static class Traversals
    extends SackTest {
        @Override
        public Traversal<Vertex, String> get_g_withSackXhelloX_V_outE_sackXassignX_byXlabelX_inV_sack() {
            return this.g.withSack((Object)"hello").V(new Object[0]).outE(new String[0]).sack((BiFunction)Operator.assign).by(T.label).inV().sack();
        }

        @Override
        public Traversal<Vertex, Double> get_g_withSackX0X_V_outE_sackXsumX_byXweightX_inV_sack_sum() {
            return this.g.withSack((Object)0.0).V(new Object[0]).outE(new String[0]).sack((BiFunction)Operator.sum).by("weight").inV().sack().sum();
        }

        @Override
        public Traversal<Vertex, Double> get_g_withSackX0X_V_repeatXoutE_sackXsumX_byXweightX_inVX_timesX2X_sack() {
            return this.g.withSack((Object)0.0).V(new Object[0]).repeat((Traversal)__.outE((String[])new String[0]).sack((BiFunction)Operator.sum).by("weight").inV()).times(2).sack();
        }

        @Override
        public Traversal<Vertex, Map> get_g_withSackXmap__map_cloneX_V_out_out_sackXmap_a_nameX_sack() {
            return this.g.withSack(HashMap::new, m -> (HashMap)m.clone()).V(new Object[0]).out(new String[0]).out(new String[0]).sack((map, vertex) -> {
                map.put("a", vertex.value("name"));
                return map;
            }).sack();
        }

        @Override
        public Traversal<Vertex, Double> get_g_withSackX1_sumX_VX1X_localXoutXknowsX_barrierXnormSackXX_inXknowsX_barrier_sack(Object v1Id) {
            return this.g.withSack((Object)1.0, (BinaryOperator)Operator.sum).V(new Object[]{v1Id}).local((Traversal)__.out((String[])new String[]{"knows"}).barrier((Consumer)SackFunctions.Barrier.normSack)).in(new String[]{"knows"}).barrier().sack();
        }

        @Override
        public Traversal<Vertex, Integer> get_g_withBulkXfalseX_withSackX1_sumX_V_out_barrier_sack() {
            return this.g.withBulk(false).withSack((Object)1, (BinaryOperator)Operator.sum).V(new Object[0]).out(new String[0]).barrier().sack();
        }

        @Override
        public Traversal<Vertex, Double> get_g_withBulkXfalseX_withSackX1_sumX_VX1X_localXoutEXknowsX_barrierXnormSackX_inVX_inXknowsX_barrier_sack(Object v1Id) {
            return this.g.withBulk(false).withSack((Object)1.0, (BinaryOperator)Operator.sum).V(new Object[]{v1Id}).local((Traversal)__.outE((String[])new String[]{"knows"}).barrier((Consumer)SackFunctions.Barrier.normSack).inV()).in(new String[]{"knows"}).barrier().sack();
        }

        @Override
        public Traversal<Vertex, BigDecimal> get_g_withSackXBigInteger_TEN_powX1000X_assignX_V_localXoutXknowsX_barrierXnormSackXX_inXknowsX_barrier_sack() {
            return this.g.withSack((Object)BigInteger.TEN.pow(1000), (BinaryOperator)Operator.assign).V(new Object[0]).local((Traversal)__.out((String[])new String[]{"knows"}).barrier((Consumer)SackFunctions.Barrier.normSack)).in(new String[]{"knows"}).barrier().sack();
        }

        @Override
        public Traversal<Vertex, Double> get_g_withSackX2X_V_sackXdivX_byXconstantX3_0XX_sack() {
            return this.g.withSack((Object)2).V(new Object[0]).sack((BiFunction)Operator.div).by((Traversal)__.constant((Object)3.0)).sack();
        }
    }
}

