/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.jsr223;

import java.util.Collections;
import java.util.Map;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.tinkerpop.gremlin.jsr223.BindingsGremlinPlugin;
import org.apache.tinkerpop.gremlin.jsr223.DefaultGremlinScriptEngineManager;
import org.apache.tinkerpop.gremlin.jsr223.GremlinPlugin;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngine;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngineSuite;
import org.junit.Assert;
import org.junit.Test;

public class BindingsScriptEngineTest {
    @Test
    public void shouldIncludeGlobalBindings() throws ScriptException {
        DefaultGremlinScriptEngineManager manager = new DefaultGremlinScriptEngineManager();
        SimpleBindings b = new SimpleBindings();
        b.put("x", (Object)1);
        b.put("y", (Object)2);
        manager.addPlugin((GremlinPlugin)BindingsGremlinPlugin.build().bindings((Map)b).scope(200).appliesTo(Collections.singletonList(GremlinScriptEngineSuite.ENGINE_TO_TEST)).create());
        GremlinScriptEngine engine = manager.getEngineByName(GremlinScriptEngineSuite.ENGINE_TO_TEST);
        Assert.assertEquals((Object)1, (Object)engine.eval("x"));
        Assert.assertEquals((Object)2, (Object)engine.eval("y"));
    }

    @Test
    public void shouldIncludeEngineBindings() throws ScriptException {
        DefaultGremlinScriptEngineManager manager = new DefaultGremlinScriptEngineManager();
        SimpleBindings b = new SimpleBindings();
        b.put("x", (Object)1);
        b.put("y", (Object)2);
        manager.addPlugin((GremlinPlugin)BindingsGremlinPlugin.build().bindings((Map)b).scope(100).appliesTo(Collections.singletonList(GremlinScriptEngineSuite.ENGINE_TO_TEST)).create());
        GremlinScriptEngine engine = manager.getEngineByName(GremlinScriptEngineSuite.ENGINE_TO_TEST);
        Assert.assertEquals((Object)1, (Object)engine.eval("x"));
        Assert.assertEquals((Object)2, (Object)engine.eval("y"));
    }

    @Test
    public void shouldIncludeEngineBindingsToOverrideGlobalBindings() throws ScriptException {
        DefaultGremlinScriptEngineManager manager = new DefaultGremlinScriptEngineManager();
        SimpleBindings b1 = new SimpleBindings();
        b1.put("x", (Object)1);
        b1.put("y", (Object)2);
        manager.addPlugin((GremlinPlugin)BindingsGremlinPlugin.build().bindings((Map)b1).scope(200).appliesTo(Collections.singletonList(GremlinScriptEngineSuite.ENGINE_TO_TEST)).create());
        SimpleBindings b2 = new SimpleBindings();
        b2.put("x", (Object)100);
        b2.put("y", (Object)200);
        manager.addPlugin((GremlinPlugin)BindingsGremlinPlugin.build().bindings((Map)b2).scope(100).appliesTo(Collections.singletonList(GremlinScriptEngineSuite.ENGINE_TO_TEST)).create());
        GremlinScriptEngine engine = manager.getEngineByName(GremlinScriptEngineSuite.ENGINE_TO_TEST);
        Assert.assertEquals((Object)100, (Object)engine.eval("x"));
        Assert.assertEquals((Object)200, (Object)engine.eval("y"));
    }
}

