/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.FeatureRequirements;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.TestHelper;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.io.Io;
import org.apache.tinkerpop.gremlin.structure.io.IoCore;
import org.apache.tinkerpop.gremlin.structure.io.Mapper;
import org.apache.tinkerpop.gremlin.structure.io.graphml.GraphMLIo;
import org.apache.tinkerpop.gremlin.structure.io.graphml.GraphMLReader;
import org.apache.tinkerpop.gremlin.structure.io.graphml.GraphMLResourceAccess;
import org.apache.tinkerpop.gremlin.structure.io.graphml.GraphMLWriter;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONIo;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONMapper;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONReader;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONResourceAccess;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONWriter;
import org.apache.tinkerpop.gremlin.structure.io.graphson.LegacyGraphSONReader;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoIo;
import org.apache.tinkerpop.gremlin.structure.io.util.CustomId;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.apache.tinkerpop.shaded.jackson.databind.JsonNode;
import org.apache.tinkerpop.shaded.jackson.databind.JsonSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.ObjectMapper;
import org.apache.tinkerpop.shaded.jackson.databind.module.SimpleModule;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Enclosed.class)
public class IoTest {
    private static final Logger logger = LoggerFactory.getLogger(IoTest.class);

    public static void assertCrewGraph(Graph g1, boolean lossyForId) {
        Assert.assertEquals((Object)new Long(6L), (Object)g1.traversal().V(new Object[0]).count().next());
        Assert.assertEquals((Object)new Long(14L), (Object)g1.traversal().E(new Object[0]).count().next());
        Vertex v1 = (Vertex)g1.traversal().V(new Object[0]).has("name", (Object)"marko").next();
        Assert.assertEquals((Object)"person", (Object)v1.label());
        Assert.assertEquals((long)2L, (long)v1.keys().size());
        Assert.assertEquals((long)4L, (long)((int)IteratorUtils.count((Iterator)v1.properties(new String[]{"location"}))));
        v1.properties(new String[]{"location"}).forEachRemaining(vp -> {
            if (vp.value().equals("san diego")) {
                Assert.assertEquals((long)1997L, (long)((Integer)vp.value("startTime")).intValue());
                Assert.assertEquals((long)2001L, (long)((Integer)vp.value("endTime")).intValue());
                Assert.assertEquals((long)2L, (long)((int)IteratorUtils.count((Iterator)vp.properties(new String[0]))));
            } else if (vp.value().equals("santa cruz")) {
                Assert.assertEquals((long)2001L, (long)((Integer)vp.value("startTime")).intValue());
                Assert.assertEquals((long)2004L, (long)((Integer)vp.value("endTime")).intValue());
                Assert.assertEquals((long)2L, (long)((int)IteratorUtils.count((Iterator)vp.properties(new String[0]))));
            } else if (vp.value().equals("brussels")) {
                Assert.assertEquals((long)2004L, (long)((Integer)vp.value("startTime")).intValue());
                Assert.assertEquals((long)2005L, (long)((Integer)vp.value("endTime")).intValue());
                Assert.assertEquals((long)2L, (long)((int)IteratorUtils.count((Iterator)vp.properties(new String[0]))));
            } else if (vp.value().equals("santa fe")) {
                Assert.assertEquals((long)2005L, (long)((Integer)vp.value("startTime")).intValue());
                Assert.assertEquals((long)1L, (long)((int)IteratorUtils.count((Iterator)vp.properties(new String[0]))));
            } else {
                Assert.fail((String)"Found a value that should be there");
            }
        });
        IoTest.assertId(g1, lossyForId, (Element)v1, 1);
        List v1Edges = IteratorUtils.list((Iterator)v1.edges(Direction.BOTH, new String[0]));
        Assert.assertEquals((long)4L, (long)v1Edges.size());
        v1Edges.forEach(e -> {
            if (e.inVertex().value("name").equals("gremlin") && e.label().equals("develops")) {
                Assert.assertEquals((long)2009L, (long)((Integer)e.value("since")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 13);
            } else if (e.inVertex().value("name").equals("tinkergraph") && e.label().equals("develops")) {
                Assert.assertEquals((long)2010L, (long)((Integer)e.value("since")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 14);
            } else if (e.inVertex().value("name").equals("gremlin") && e.label().equals("uses")) {
                Assert.assertEquals((long)4L, (long)((Integer)e.value("skill")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 15);
            } else if (e.inVertex().value("name").equals("tinkergraph") && e.label().equals("uses")) {
                Assert.assertEquals((long)5L, (long)((Integer)e.value("skill")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 16);
            } else {
                Assert.fail((String)"Edge not expected");
            }
        });
        Vertex v7 = (Vertex)g1.traversal().V(new Object[0]).has("name", (Object)"stephen").next();
        Assert.assertEquals((Object)"person", (Object)v7.label());
        Assert.assertEquals((long)2L, (long)v7.keys().size());
        Assert.assertEquals((long)3L, (long)((int)IteratorUtils.count((Iterator)v7.properties(new String[]{"location"}))));
        v7.properties(new String[]{"location"}).forEachRemaining(vp -> {
            if (vp.value().equals("centreville")) {
                Assert.assertEquals((long)1990L, (long)((Integer)vp.value("startTime")).intValue());
                Assert.assertEquals((long)2000L, (long)((Integer)vp.value("endTime")).intValue());
                Assert.assertEquals((long)2L, (long)((int)IteratorUtils.count((Iterator)vp.properties(new String[0]))));
            } else if (vp.value().equals("dulles")) {
                Assert.assertEquals((long)2000L, (long)((Integer)vp.value("startTime")).intValue());
                Assert.assertEquals((long)2006L, (long)((Integer)vp.value("endTime")).intValue());
                Assert.assertEquals((long)2L, (long)((int)IteratorUtils.count((Iterator)vp.properties(new String[0]))));
            } else if (vp.value().equals("purcellville")) {
                Assert.assertEquals((long)2006L, (long)((Integer)vp.value("startTime")).intValue());
                Assert.assertEquals((long)1L, (long)((int)IteratorUtils.count((Iterator)vp.properties(new String[0]))));
            } else {
                Assert.fail((String)"Found a value that should be there");
            }
        });
        IoTest.assertId(g1, lossyForId, (Element)v7, 7);
        List v7Edges = IteratorUtils.list((Iterator)v7.edges(Direction.BOTH, new String[0]));
        Assert.assertEquals((long)4L, (long)v7Edges.size());
        v7Edges.forEach(e -> {
            if (e.inVertex().value("name").equals("gremlin") && e.label().equals("develops")) {
                Assert.assertEquals((long)2010L, (long)((Integer)e.value("since")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 17);
            } else if (e.inVertex().value("name").equals("tinkergraph") && e.label().equals("develops")) {
                Assert.assertEquals((long)2011L, (long)((Integer)e.value("since")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 18);
            } else if (e.inVertex().value("name").equals("gremlin") && e.label().equals("uses")) {
                Assert.assertEquals((long)5L, (long)((Integer)e.value("skill")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 19);
            } else if (e.inVertex().value("name").equals("tinkergraph") && e.label().equals("uses")) {
                Assert.assertEquals((long)4L, (long)((Integer)e.value("skill")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 20);
            } else {
                Assert.fail((String)"Edge not expected");
            }
        });
        Vertex v8 = (Vertex)g1.traversal().V(new Object[0]).has("name", (Object)"matthias").next();
        Assert.assertEquals((Object)"person", (Object)v8.label());
        Assert.assertEquals((long)2L, (long)v8.keys().size());
        Assert.assertEquals((long)4L, (long)((int)IteratorUtils.count((Iterator)v8.properties(new String[]{"location"}))));
        v8.properties(new String[]{"location"}).forEachRemaining(vp -> {
            if (vp.value().equals("bremen")) {
                Assert.assertEquals((long)2004L, (long)((Integer)vp.value("startTime")).intValue());
                Assert.assertEquals((long)2007L, (long)((Integer)vp.value("endTime")).intValue());
                Assert.assertEquals((long)2L, (long)((int)IteratorUtils.count((Iterator)vp.properties(new String[0]))));
            } else if (vp.value().equals("baltimore")) {
                Assert.assertEquals((long)2007L, (long)((Integer)vp.value("startTime")).intValue());
                Assert.assertEquals((long)2011L, (long)((Integer)vp.value("endTime")).intValue());
                Assert.assertEquals((long)2L, (long)((int)IteratorUtils.count((Iterator)vp.properties(new String[0]))));
            } else if (vp.value().equals("oakland")) {
                Assert.assertEquals((long)2011L, (long)((Integer)vp.value("startTime")).intValue());
                Assert.assertEquals((long)2014L, (long)((Integer)vp.value("endTime")).intValue());
                Assert.assertEquals((long)2L, (long)((int)IteratorUtils.count((Iterator)vp.properties(new String[0]))));
            } else if (vp.value().equals("seattle")) {
                Assert.assertEquals((long)2014L, (long)((Integer)vp.value("startTime")).intValue());
                Assert.assertEquals((long)1L, (long)((int)IteratorUtils.count((Iterator)vp.properties(new String[0]))));
            } else {
                Assert.fail((String)"Found a value that should be there");
            }
        });
        IoTest.assertId(g1, lossyForId, (Element)v8, 8);
        List v8Edges = IteratorUtils.list((Iterator)v8.edges(Direction.BOTH, new String[0]));
        Assert.assertEquals((long)3L, (long)v8Edges.size());
        v8Edges.forEach(e -> {
            if (e.inVertex().value("name").equals("gremlin") && e.label().equals("develops")) {
                Assert.assertEquals((long)2012L, (long)((Integer)e.value("since")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 21);
            } else if (e.inVertex().value("name").equals("gremlin") && e.label().equals("uses")) {
                Assert.assertEquals((long)3L, (long)((Integer)e.value("skill")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 22);
            } else if (e.inVertex().value("name").equals("tinkergraph") && e.label().equals("uses")) {
                Assert.assertEquals((long)3L, (long)((Integer)e.value("skill")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 23);
            } else {
                Assert.fail((String)"Edge not expected");
            }
        });
        Vertex v9 = (Vertex)g1.traversal().V(new Object[0]).has("name", (Object)"daniel").next();
        Assert.assertEquals((Object)"person", (Object)v9.label());
        Assert.assertEquals((long)2L, (long)v9.keys().size());
        Assert.assertEquals((long)3L, (long)((int)IteratorUtils.count((Iterator)v9.properties(new String[]{"location"}))));
        v9.properties(new String[]{"location"}).forEachRemaining(vp -> {
            if (vp.value().equals("spremberg")) {
                Assert.assertEquals((long)1982L, (long)((Integer)vp.value("startTime")).intValue());
                Assert.assertEquals((long)2005L, (long)((Integer)vp.value("endTime")).intValue());
                Assert.assertEquals((long)2L, (long)((int)IteratorUtils.count((Iterator)vp.properties(new String[0]))));
            } else if (vp.value().equals("kaiserslautern")) {
                Assert.assertEquals((long)2005L, (long)((Integer)vp.value("startTime")).intValue());
                Assert.assertEquals((long)2009L, (long)((Integer)vp.value("endTime")).intValue());
                Assert.assertEquals((long)2L, (long)((int)IteratorUtils.count((Iterator)vp.properties(new String[0]))));
            } else if (vp.value().equals("aachen")) {
                Assert.assertEquals((long)2009L, (long)((Integer)vp.value("startTime")).intValue());
                Assert.assertEquals((long)1L, (long)((int)IteratorUtils.count((Iterator)vp.properties(new String[0]))));
            } else {
                Assert.fail((String)"Found a value that should be there");
            }
        });
        IoTest.assertId(g1, lossyForId, (Element)v9, 9);
        List v9Edges = IteratorUtils.list((Iterator)v9.edges(Direction.BOTH, new String[0]));
        Assert.assertEquals((long)2L, (long)v9Edges.size());
        v9Edges.forEach(e -> {
            if (e.inVertex().value("name").equals("gremlin") && e.label().equals("uses")) {
                Assert.assertEquals((long)5L, (long)((Integer)e.value("skill")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 24);
            } else if (e.inVertex().value("name").equals("tinkergraph") && e.label().equals("uses")) {
                Assert.assertEquals((long)3L, (long)((Integer)e.value("skill")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 25);
            } else {
                Assert.fail((String)"Edge not expected");
            }
        });
        Vertex v10 = (Vertex)g1.traversal().V(new Object[0]).has("name", (Object)"gremlin").next();
        Assert.assertEquals((Object)"software", (Object)v10.label());
        Assert.assertEquals((long)1L, (long)v10.keys().size());
        IoTest.assertId(g1, lossyForId, (Element)v10, 10);
        List v10Edges = IteratorUtils.list((Iterator)v10.edges(Direction.BOTH, new String[0]));
        Assert.assertEquals((long)8L, (long)v10Edges.size());
        v10Edges.forEach(e -> {
            if (e.outVertex().value("name").equals("marko") && e.label().equals("develops")) {
                Assert.assertEquals((long)2009L, (long)((Integer)e.value("since")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 13);
            } else if (e.outVertex().value("name").equals("marko") && e.label().equals("uses")) {
                Assert.assertEquals((long)4L, (long)((Integer)e.value("skill")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 15);
            } else if (e.outVertex().value("name").equals("stephen") && e.label().equals("develops")) {
                Assert.assertEquals((long)2010L, (long)((Integer)e.value("since")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 17);
            } else if (e.outVertex().value("name").equals("stephen") && e.label().equals("uses")) {
                Assert.assertEquals((long)5L, (long)((Integer)e.value("skill")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 19);
            } else if (e.outVertex().value("name").equals("matthias") && e.label().equals("develops")) {
                Assert.assertEquals((long)2012L, (long)((Integer)e.value("since")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 21);
            } else if (e.outVertex().value("name").equals("matthias") && e.label().equals("uses")) {
                Assert.assertEquals((long)3L, (long)((Integer)e.value("skill")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 22);
            } else if (e.outVertex().value("name").equals("daniel") && e.label().equals("uses")) {
                Assert.assertEquals((long)5L, (long)((Integer)e.value("skill")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 24);
            } else if (e.inVertex().value("name").equals("tinkergraph") && e.label().equals("traverses")) {
                Assert.assertEquals((long)0L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 26);
            } else {
                Assert.fail((String)"Edge not expected");
            }
        });
        Vertex v11 = (Vertex)g1.traversal().V(new Object[0]).has("name", (Object)"tinkergraph").next();
        Assert.assertEquals((Object)"software", (Object)v11.label());
        Assert.assertEquals((long)1L, (long)v11.keys().size());
        IoTest.assertId(g1, lossyForId, (Element)v11, 11);
        List v11Edges = IteratorUtils.list((Iterator)v11.edges(Direction.BOTH, new String[0]));
        Assert.assertEquals((long)7L, (long)v11Edges.size());
        v11Edges.forEach(e -> {
            if (e.outVertex().value("name").equals("marko") && e.label().equals("develops")) {
                Assert.assertEquals((long)2010L, (long)((Integer)e.value("since")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 14);
            } else if (e.outVertex().value("name").equals("marko") && e.label().equals("uses")) {
                Assert.assertEquals((long)5L, (long)((Integer)e.value("skill")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 16);
            } else if (e.outVertex().value("name").equals("stephen") && e.label().equals("develops")) {
                Assert.assertEquals((long)2011L, (long)((Integer)e.value("since")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 18);
            } else if (e.outVertex().value("name").equals("stephen") && e.label().equals("uses")) {
                Assert.assertEquals((long)4L, (long)((Integer)e.value("skill")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 20);
            } else if (e.outVertex().value("name").equals("matthias") && e.label().equals("uses")) {
                Assert.assertEquals((long)3L, (long)((Integer)e.value("skill")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 23);
            } else if (e.outVertex().value("name").equals("daniel") && e.label().equals("uses")) {
                Assert.assertEquals((long)3L, (long)((Integer)e.value("skill")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 25);
            } else if (e.outVertex().value("name").equals("gremlin") && e.label().equals("traverses")) {
                Assert.assertEquals((long)0L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 26);
            } else {
                Assert.fail((String)"Edge not expected");
            }
        });
    }

    public static void assertClassicGraph(Graph g1, boolean assertDouble, boolean lossyForId) {
        IoTest.assertToyGraph(g1, assertDouble, lossyForId, false);
    }

    public static void assertNoEdgeGraph(Graph g1, boolean assertDouble, boolean lossyForId) {
        Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)g1.vertices(new Object[0])));
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)g1.edges(new Object[0])));
        Vertex v1 = (Vertex)g1.traversal().V(new Object[0]).has("name", (Object)"marko").next();
        Assert.assertEquals((long)29L, (long)((Integer)v1.value("age")).intValue());
        Assert.assertEquals((long)2L, (long)v1.keys().size());
        Assert.assertEquals((Object)"vertex", (Object)v1.label());
        IoTest.assertId(g1, lossyForId, (Element)v1, 1);
        List v1Edges = IteratorUtils.list((Iterator)v1.edges(Direction.BOTH, new String[0]));
        Assert.assertEquals((long)1L, (long)v1Edges.size());
        v1Edges.forEach(e -> {
            System.out.println("SERGE: e.inVertex().value(\"name\") : " + e.inVertex().value("name").equals("vadas"));
            if (e.inVertex().value("name").equals("vadas")) {
                Assert.assertEquals((Object)"edge", (Object)e.label());
                if (assertDouble) {
                    IoTest.assertWeightLoosely(0.5, e);
                } else {
                    IoTest.assertWeightLoosely(0.5f, e);
                }
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 7);
            } else {
                Assert.fail((String)"Edge not expected");
            }
        });
    }

    public static void assertModernGraph(Graph g1, boolean assertDouble, boolean lossyForId) {
        IoTest.assertToyGraph(g1, assertDouble, lossyForId, true);
    }

    private static void assertToyGraph(Graph g1, boolean assertDouble, boolean lossyForId, boolean assertSpecificLabel) {
        Assert.assertEquals((long)6L, (long)IteratorUtils.count((Iterator)g1.vertices(new Object[0])));
        Assert.assertEquals((long)6L, (long)IteratorUtils.count((Iterator)g1.edges(new Object[0])));
        Vertex v1 = (Vertex)g1.traversal().V(new Object[0]).has("name", (Object)"marko").next();
        Assert.assertEquals((long)29L, (long)((Integer)v1.value("age")).intValue());
        Assert.assertEquals((long)2L, (long)v1.keys().size());
        Assert.assertEquals((Object)(assertSpecificLabel ? "person" : "vertex"), (Object)v1.label());
        IoTest.assertId(g1, lossyForId, (Element)v1, 1);
        List v1Edges = IteratorUtils.list((Iterator)v1.edges(Direction.BOTH, new String[0]));
        Assert.assertEquals((long)3L, (long)v1Edges.size());
        v1Edges.forEach(e -> {
            if (e.inVertex().value("name").equals("vadas")) {
                Assert.assertEquals((Object)"knows", (Object)e.label());
                if (assertDouble) {
                    IoTest.assertWeightLoosely(0.5, e);
                } else {
                    IoTest.assertWeightLoosely(0.5f, e);
                }
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 7);
            } else if (e.inVertex().value("name").equals("josh")) {
                Assert.assertEquals((Object)"knows", (Object)e.label());
                if (assertDouble) {
                    IoTest.assertWeightLoosely(1.0, e);
                } else {
                    IoTest.assertWeightLoosely(1.0f, e);
                }
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 8);
            } else if (e.inVertex().value("name").equals("lop")) {
                Assert.assertEquals((Object)"created", (Object)e.label());
                if (assertDouble) {
                    IoTest.assertWeightLoosely(0.4, e);
                } else {
                    IoTest.assertWeightLoosely(0.4f, e);
                }
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 9);
            } else {
                Assert.fail((String)"Edge not expected");
            }
        });
        Vertex v2 = (Vertex)g1.traversal().V(new Object[0]).has("name", (Object)"vadas").next();
        Assert.assertEquals((long)27L, (long)((Integer)v2.value("age")).intValue());
        Assert.assertEquals((long)2L, (long)v2.keys().size());
        Assert.assertEquals((Object)(assertSpecificLabel ? "person" : "vertex"), (Object)v2.label());
        IoTest.assertId(g1, lossyForId, (Element)v2, 2);
        List v2Edges = IteratorUtils.list((Iterator)v2.edges(Direction.BOTH, new String[0]));
        Assert.assertEquals((long)1L, (long)v2Edges.size());
        v2Edges.forEach(e -> {
            if (e.outVertex().value("name").equals("marko")) {
                Assert.assertEquals((Object)"knows", (Object)e.label());
                if (assertDouble) {
                    IoTest.assertWeightLoosely(0.5, e);
                } else {
                    IoTest.assertWeightLoosely(0.5f, e);
                }
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 7);
            } else {
                Assert.fail((String)"Edge not expected");
            }
        });
        Vertex v3 = (Vertex)g1.traversal().V(new Object[0]).has("name", (Object)"lop").next();
        Assert.assertEquals((Object)"java", (Object)v3.value("lang"));
        Assert.assertEquals((long)2L, (long)v2.keys().size());
        Assert.assertEquals((Object)(assertSpecificLabel ? "software" : "vertex"), (Object)v3.label());
        IoTest.assertId(g1, lossyForId, (Element)v3, 3);
        List v3Edges = IteratorUtils.list((Iterator)v3.edges(Direction.BOTH, new String[0]));
        Assert.assertEquals((long)3L, (long)v3Edges.size());
        v3Edges.forEach(e -> {
            if (e.outVertex().value("name").equals("peter")) {
                Assert.assertEquals((Object)"created", (Object)e.label());
                if (assertDouble) {
                    IoTest.assertWeightLoosely(0.2, e);
                } else {
                    IoTest.assertWeightLoosely(0.2f, e);
                }
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 12);
            } else if (e.outVertex().value("name").equals("josh")) {
                Assert.assertEquals((Object)"created", (Object)e.label());
                if (assertDouble) {
                    IoTest.assertWeightLoosely(0.4, e);
                } else {
                    IoTest.assertWeightLoosely(0.4f, e);
                }
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 11);
            } else if (e.outVertex().value("name").equals("marko")) {
                Assert.assertEquals((Object)"created", (Object)e.label());
                if (assertDouble) {
                    IoTest.assertWeightLoosely(0.4, e);
                } else {
                    IoTest.assertWeightLoosely(0.4f, e);
                }
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 9);
            } else {
                Assert.fail((String)"Edge not expected");
            }
        });
        Vertex v4 = (Vertex)g1.traversal().V(new Object[0]).has("name", (Object)"josh").next();
        Assert.assertEquals((long)32L, (long)((Integer)v4.value("age")).intValue());
        Assert.assertEquals((long)2L, (long)v4.keys().size());
        Assert.assertEquals((Object)(assertSpecificLabel ? "person" : "vertex"), (Object)v4.label());
        IoTest.assertId(g1, lossyForId, (Element)v4, 4);
        List v4Edges = IteratorUtils.list((Iterator)v4.edges(Direction.BOTH, new String[0]));
        Assert.assertEquals((long)3L, (long)v4Edges.size());
        v4Edges.forEach(e -> {
            if (e.inVertex().value("name").equals("ripple")) {
                Assert.assertEquals((Object)"created", (Object)e.label());
                if (assertDouble) {
                    IoTest.assertWeightLoosely(1.0, e);
                } else {
                    IoTest.assertWeightLoosely(1.0f, e);
                }
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 10);
            } else if (e.inVertex().value("name").equals("lop")) {
                Assert.assertEquals((Object)"created", (Object)e.label());
                if (assertDouble) {
                    IoTest.assertWeightLoosely(0.4, e);
                } else {
                    IoTest.assertWeightLoosely(0.4f, e);
                }
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 11);
            } else if (e.outVertex().value("name").equals("marko")) {
                Assert.assertEquals((Object)"knows", (Object)e.label());
                if (assertDouble) {
                    IoTest.assertWeightLoosely(1.0, e);
                } else {
                    IoTest.assertWeightLoosely(1.0f, e);
                }
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 8);
            } else {
                Assert.fail((String)"Edge not expected");
            }
        });
        Vertex v5 = (Vertex)g1.traversal().V(new Object[0]).has("name", (Object)"ripple").next();
        Assert.assertEquals((Object)"java", (Object)v5.value("lang"));
        Assert.assertEquals((long)2L, (long)v5.keys().size());
        Assert.assertEquals((Object)(assertSpecificLabel ? "software" : "vertex"), (Object)v5.label());
        IoTest.assertId(g1, lossyForId, (Element)v5, 5);
        List v5Edges = IteratorUtils.list((Iterator)v5.edges(Direction.BOTH, new String[0]));
        Assert.assertEquals((long)1L, (long)v5Edges.size());
        v5Edges.forEach(e -> {
            if (e.outVertex().value("name").equals("josh")) {
                Assert.assertEquals((Object)"created", (Object)e.label());
                if (assertDouble) {
                    IoTest.assertWeightLoosely(1.0, e);
                } else {
                    IoTest.assertWeightLoosely(1.0f, e);
                }
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 10);
            } else {
                Assert.fail((String)"Edge not expected");
            }
        });
        Vertex v6 = (Vertex)g1.traversal().V(new Object[0]).has("name", (Object)"peter").next();
        Assert.assertEquals((long)35L, (long)((Integer)v6.value("age")).intValue());
        Assert.assertEquals((long)2L, (long)v6.keys().size());
        Assert.assertEquals((Object)(assertSpecificLabel ? "person" : "vertex"), (Object)v6.label());
        IoTest.assertId(g1, lossyForId, (Element)v6, 6);
        List v6Edges = IteratorUtils.list((Iterator)v6.edges(Direction.BOTH, new String[0]));
        Assert.assertEquals((long)1L, (long)v6Edges.size());
        v6Edges.forEach(e -> {
            if (e.inVertex().value("name").equals("lop")) {
                Assert.assertEquals((Object)"created", (Object)e.label());
                if (assertDouble) {
                    IoTest.assertWeightLoosely(0.2, e);
                } else {
                    IoTest.assertWeightLoosely(0.2f, e);
                }
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 12);
            } else {
                Assert.fail((String)"Edge not expected");
            }
        });
    }

    private static void assertWeightLoosely(double expected, Edge e) {
        try {
            Assert.assertEquals((double)expected, (double)((Double)e.value("weight")), (double)1.0E-4);
        }
        catch (Exception ex) {
            logger.warn("Attempting to assert weight as float for {} - if your graph is strongly typed from schema this is likely expected", (Object)e);
            Assert.assertEquals((float)new Double(expected).floatValue(), (float)((Float)e.value("weight")).floatValue(), (float)1.0E-4f);
        }
    }

    private static void assertWeightLoosely(float expected, Edge e) {
        try {
            Assert.assertEquals((float)expected, (float)((Float)e.value("weight")).floatValue(), (float)1.0E-4f);
        }
        catch (Exception ex) {
            logger.warn("Attempting to assert weight as double for {} - if your graph is strongly typed from schema this is likely expected", (Object)e);
            Assert.assertEquals((double)new Float(expected).doubleValue(), (double)((Double)e.value("weight")), (double)1.0E-4);
        }
    }

    private static void assertId(Graph g, boolean lossyForId, Element e, Object expected) {
        if (e instanceof Vertex && g.features().vertex().supportsUserSuppliedIds() && g.features().vertex().supportsNumericIds() || e instanceof Edge && g.features().edge().supportsUserSuppliedIds() && g.features().edge().supportsNumericIds() || e instanceof VertexProperty && g.features().vertex().properties().supportsUserSuppliedIds() && g.features().vertex().properties().supportsNumericIds()) {
            if (lossyForId) {
                Assert.assertEquals((Object)expected.toString(), (Object)e.id().toString());
            } else {
                Assert.assertEquals((Object)expected, (Object)e.id());
            }
        }
    }

    private static void validateXmlAgainstGraphMLXsd(File file) throws Exception {
        StreamSource xmlFile = new StreamSource(file);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(IoTest.class.getResource(TestHelper.convertPackageToResourcePath(GraphMLResourceAccess.class) + "graphml-1.1.xsd"));
        Validator validator = schema.newValidator();
        validator.validate(xmlFile);
    }

    private static void readGraphMLIntoGraph(Graph g, String file) throws IOException {
        GraphMLReader reader = GraphMLReader.build().create();
        try (InputStream stream = IoTest.class.getResourceAsStream(TestHelper.convertPackageToResourcePath(GraphMLResourceAccess.class) + file);){
            reader.readGraph(stream, g);
        }
    }

    private static String streamToString(InputStream in) throws IOException {
        StringWriter writer = new StringWriter();
        char[] buffer = new char[1024];
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));){
            int n;
            while ((n = reader.read(buffer)) != -1) {
                ((Writer)writer).write(buffer, 0, n);
            }
        }
        return ((Object)writer).toString();
    }

    public static final class GraphSONTest
    extends AbstractGremlinTest {
        private Io.Builder<GraphSONIo> graphson;

        @Before
        public void setupBeforeEachTest() {
            this.graphson = IoCore.graphson();
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="StringValues"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="FloatValues"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="NumericIds"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VariableFeatures.class, feature="Variables")})
        @LoadGraphWith(value=LoadGraphWith.GraphData.CLASSIC)
        public void shouldWriteNormalizedGraphSON() throws Exception {
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                GraphSONMapper mapper = ((GraphSONIo)this.graph.io(this.graphson)).mapper().normalize(true).create();
                GraphSONWriter w = ((GraphSONIo)this.graph.io(this.graphson)).writer().mapper((Mapper)mapper).create();
                w.writeGraph((OutputStream)bos, this.graph);
                String expected = IoTest.streamToString(IoTest.class.getResourceAsStream(TestHelper.convertPackageToResourcePath(GraphSONResourceAccess.class) + "tinkerpop-classic-normalized.json"));
                Assert.assertEquals((Object)expected.replace("\n", "").replace("\r", ""), (Object)bos.toString().replace("\n", "").replace("\r", ""));
            }
        }

        @Test
        @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
        public void shouldReadWriteModernWrappedInJsonObject() throws Exception {
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                GraphSONWriter writer = ((GraphSONIo)this.graph.io(IoCore.graphson())).writer().wrapAdjacencyList(true).create();
                writer.writeGraph((OutputStream)os, this.graph);
                Configuration configuration = this.graphProvider.newGraphConfiguration("readGraph", this.getClass(), this.name.getMethodName(), LoadGraphWith.GraphData.MODERN);
                this.graphProvider.clear(configuration);
                Graph g1 = this.graphProvider.openTestGraph(configuration);
                GraphSONReader reader = ((GraphSONIo)this.graph.io(IoCore.graphson())).reader().unwrapAdjacencyList(true).create();
                try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                    reader.readGraph((InputStream)bais, g1);
                }
                IoTest.assertModernGraph(g1, true, true);
                this.graphProvider.clear(g1, configuration);
            }
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AnyIds")})
        public void shouldProperlySerializeCustomIdWithGraphSON() throws Exception {
            UUID id = UUID.fromString("AF4B5965-B176-4552-B3C1-FBBE2F52C305");
            this.graph.addVertex(new Object[]{T.id, new CustomId("vertex", id)});
            SimpleModule module = new SimpleModule();
            module.addSerializer(CustomId.class, (JsonSerializer)new CustomId.CustomIdJacksonSerializerV1d0());
            GraphSONWriter writer = ((GraphSONIo)this.graph.io(this.graphson)).writer().mapper((Mapper)((GraphSONIo)this.graph.io(this.graphson)).mapper().addCustomModule(module).embedTypes(true).create()).create();
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                writer.writeGraph((OutputStream)baos, this.graph);
                JsonNode jsonGraph = new ObjectMapper().readTree(baos.toByteArray());
                JsonNode idValue = jsonGraph.get("id");
                Assert.assertTrue((boolean)idValue.has("cluster"));
                Assert.assertEquals((Object)"vertex", (Object)idValue.get("cluster").asText());
                Assert.assertTrue((boolean)idValue.has("elementId"));
                Assert.assertEquals((Object)"AF4B5965-B176-4552-B3C1-FBBE2F52C305".toLowerCase(), (Object)idValue.get("elementId").get(1).asText());
                Configuration configuration = this.graphProvider.newGraphConfiguration("g2", this.getClass(), this.name.getMethodName(), null);
                this.graphProvider.clear(configuration);
                Graph g2 = this.graphProvider.openTestGraph(configuration);
                try (ByteArrayInputStream is = new ByteArrayInputStream(baos.toByteArray());){
                    GraphSONReader reader = ((GraphSONIo)this.graph.io(this.graphson)).reader().mapper((Mapper)((GraphSONIo)this.graph.io(this.graphson)).mapper().embedTypes(true).addCustomModule(module).create()).create();
                    reader.readGraph((InputStream)is, g2);
                }
                Vertex v2 = (Vertex)g2.vertices(new Object[0]).next();
                CustomId customId = (CustomId)v2.id();
                Assert.assertEquals((Object)id, (Object)customId.getElementId());
                Assert.assertEquals((Object)"vertex", (Object)customId.getCluster());
                this.graphProvider.clear(g2, configuration);
            }
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="StringValues"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="FloatValues")})
        public void shouldReadLegacyGraphSON() throws IOException {
            LegacyGraphSONReader reader = LegacyGraphSONReader.build().create();
            try (InputStream stream = IoTest.class.getResourceAsStream(TestHelper.convertPackageToResourcePath(GraphSONResourceAccess.class) + "tinkerpop-classic-legacy.json");){
                reader.readGraph(stream, this.graph);
            }
            IoTest.assertClassicGraph(this.graph, false, true);
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="StringValues"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
        public void shouldReadWriteSelfLoopingEdges() throws Exception {
            Graph source = this.graph;
            Vertex v1 = source.addVertex(new Object[0]);
            Vertex v2 = source.addVertex(new Object[0]);
            v1.addEdge("CONTROL", v2, new Object[0]);
            v1.addEdge("SELFLOOP", v1, new Object[0]);
            Configuration targetConf = this.graphProvider.newGraphConfiguration("target", this.getClass(), this.name.getMethodName(), null);
            Graph target = this.graphProvider.openTestGraph(targetConf);
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                ((GraphSONIo)source.io(IoCore.graphson())).writer().create().writeGraph((OutputStream)os, source);
                try (ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());){
                    ((GraphSONIo)target.io(IoCore.graphson())).reader().create().readGraph((InputStream)is, target);
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            Assert.assertEquals((long)IteratorUtils.count((Iterator)source.vertices(new Object[0])), (long)IteratorUtils.count((Iterator)target.vertices(new Object[0])));
            Assert.assertEquals((long)IteratorUtils.count((Iterator)source.edges(new Object[0])), (long)IteratorUtils.count((Iterator)target.edges(new Object[0])));
        }
    }

    public static final class GryoTest
    extends AbstractGremlinTest {
        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="StringValues"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
        public void shouldReadWriteSelfLoopingEdges() {
            Graph source = this.graph;
            Vertex v1 = source.addVertex(new Object[0]);
            Vertex v2 = source.addVertex(new Object[0]);
            v1.addEdge("CONTROL", v2, new Object[0]);
            v1.addEdge("SELFLOOP", v1, new Object[0]);
            Configuration targetConf = this.graphProvider.newGraphConfiguration("target", this.getClass(), this.name.getMethodName(), null);
            Graph target = this.graphProvider.openTestGraph(targetConf);
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                ((GryoIo)source.io(IoCore.gryo())).writer().create().writeGraph((OutputStream)os, source);
                try (ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());){
                    ((GryoIo)target.io(IoCore.gryo())).reader().create().readGraph((InputStream)is, target);
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            Assert.assertEquals((long)IteratorUtils.count((Iterator)source.vertices(new Object[0])), (long)IteratorUtils.count((Iterator)target.vertices(new Object[0])));
            Assert.assertEquals((long)IteratorUtils.count((Iterator)source.edges(new Object[0])), (long)IteratorUtils.count((Iterator)target.edges(new Object[0])));
        }
    }

    public static class GraphMLTest
    extends AbstractGremlinTest {
        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="StringValues"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="FloatValues")})
        public void shouldReadGraphML() throws IOException {
            IoTest.readGraphMLIntoGraph(this.graph, "tinkerpop-classic.xml");
            IoTest.assertClassicGraph(this.graph, false, true);
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="StringValues"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="FloatValues")})
        public void shouldReadGraphMLWithNoEdgeLabels() throws IOException {
            IoTest.readGraphMLIntoGraph(this.graph, "tinkerpop-no-edge-labels.xml");
            IoTest.assertNoEdgeGraph(this.graph, false, true);
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="StringValues"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="FloatValues")})
        public void shouldReadGraphMLUnorderedElements() throws IOException {
            IoTest.readGraphMLIntoGraph(this.graph, "tinkerpop-classic-unordered.xml");
            IoTest.assertClassicGraph(this.graph, false, true);
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="StringValues"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="FloatValues"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="BooleanValues"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="LongValues"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="DoubleValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="FloatValues")})
        public void shouldReadGraphMLWithAllSupportedDataTypes() throws IOException {
            GraphMLReader reader = GraphMLReader.build().create();
            try (InputStream stream = IoTest.class.getResourceAsStream(TestHelper.convertPackageToResourcePath(GraphMLResourceAccess.class) + "graph-types.xml");){
                reader.readGraph(stream, this.graph);
            }
            Vertex v = (Vertex)this.graph.vertices(new Object[0]).next();
            Assert.assertEquals((double)123.45, (double)((Double)v.value("d")), (double)1.0E-6);
            Assert.assertEquals((Object)"some-string", (Object)v.value("s"));
            Assert.assertEquals((long)29L, (long)((Integer)v.value("i")).intValue());
            Assert.assertEquals((Object)true, (Object)v.value("b"));
            Assert.assertEquals((float)123.54f, (float)((Float)v.value("f")).floatValue(), (float)1.0E-6f);
            Assert.assertEquals((long)10000000L, (long)((Long)v.value("l")));
            Assert.assertEquals((Object)"junk", (Object)v.value("n"));
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="StringValues"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="FloatValues"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="BooleanValues"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="LongValues"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="DoubleValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="FloatValues")})
        public void shouldReadGraphMLWithoutStrictOption() throws IOException {
            GraphMLReader reader = GraphMLReader.build().strict(false).create();
            try (InputStream stream = IoTest.class.getResourceAsStream(TestHelper.convertPackageToResourcePath(GraphMLResourceAccess.class) + "graph-types-bad.xml");){
                reader.readGraph(stream, this.graph);
            }
            Vertex v = (Vertex)this.graph.vertices(new Object[0]).next();
            Assert.assertFalse((boolean)v.values(new String[]{"d"}).hasNext());
            Assert.assertEquals((Object)"some-string", (Object)v.value("s"));
            Assert.assertFalse((boolean)v.values(new String[]{"i"}).hasNext());
            Assert.assertEquals((Object)false, (Object)v.value("b"));
            Assert.assertFalse((boolean)v.values(new String[]{"f"}).hasNext());
            Assert.assertFalse((boolean)v.values(new String[]{"l"}).hasNext());
            Assert.assertEquals((Object)"junk", (Object)v.value("n"));
        }

        @Test(expected=NumberFormatException.class)
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="StringValues"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="FloatValues"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="BooleanValues"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="LongValues"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="DoubleValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="FloatValues")})
        public void shouldReadGraphMLWithStrictOption() throws IOException {
            GraphMLReader reader = GraphMLReader.build().strict(true).create();
            try (InputStream stream = IoTest.class.getResourceAsStream(TestHelper.convertPackageToResourcePath(GraphMLResourceAccess.class) + "graph-types-bad.xml");){
                reader.readGraph(stream, this.graph);
            }
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="StringValues"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="FloatValues"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="NumericIds")})
        @LoadGraphWith(value=LoadGraphWith.GraphData.CLASSIC)
        public void shouldWriteNormalizedGraphML() throws Exception {
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                GraphMLWriter w = GraphMLWriter.build().normalize(true).create();
                w.writeGraph((OutputStream)bos, this.graph);
                String expected = IoTest.streamToString(IoTest.class.getResourceAsStream(TestHelper.convertPackageToResourcePath(GraphMLResourceAccess.class) + "tinkerpop-classic-normalized.xml"));
                Assert.assertEquals((Object)expected.replace("\n", "").replace("\r", ""), (Object)bos.toString().replace("\n", "").replace("\r", ""));
            }
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="StringValues"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="StringIds")})
        public void shouldProperlyEncodeWithGraphML() throws Exception {
            Assume.assumeThat((Object)"GraphML web site is down so XSD cannot be retrieved", (Matcher)Is.is((Object)this.isGraphMLXSDPresent()));
            Vertex v = this.graph.addVertex(new Object[]{T.id, "1"});
            v.property(VertexProperty.Cardinality.single, "text", (Object)"\u00e9", new Object[0]);
            GraphMLWriter w = GraphMLWriter.build().create();
            File f = TestHelper.generateTempFile(this.getClass(), "test", ".txt");
            try (FileOutputStream out = new FileOutputStream(f);){
                w.writeGraph((OutputStream)out, this.graph);
            }
            IoTest.validateXmlAgainstGraphMLXsd(f);
            Configuration configuration = this.graphProvider.newGraphConfiguration("g2", this.getClass(), this.name.getMethodName(), null);
            this.graphProvider.clear(configuration);
            Graph g2 = this.graphProvider.openTestGraph(configuration);
            GraphMLReader r = GraphMLReader.build().create();
            try (FileInputStream in = new FileInputStream(f);){
                r.readGraph((InputStream)in, g2);
            }
            Vertex v2 = (Vertex)g2.vertices(new Object[]{"1"}).next();
            Assert.assertEquals((Object)"\u00e9", (Object)v2.property("text").value());
            this.graphProvider.clear(g2, configuration);
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="StringValues"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
        public void shouldReadWriteSelfLoopingEdges() throws Exception {
            Graph source = this.graph;
            Vertex v1 = source.addVertex(new Object[0]);
            Vertex v2 = source.addVertex(new Object[0]);
            v1.addEdge("CONTROL", v2, new Object[0]);
            v1.addEdge("SELFLOOP", v1, new Object[0]);
            Configuration targetConf = this.graphProvider.newGraphConfiguration("target", this.getClass(), this.name.getMethodName(), null);
            Graph target = this.graphProvider.openTestGraph(targetConf);
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                ((GraphMLIo)source.io(IoCore.graphml())).writer().create().writeGraph((OutputStream)os, source);
                try (ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());){
                    ((GraphMLIo)target.io(IoCore.graphml())).reader().create().readGraph((InputStream)is, target);
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            Assert.assertEquals((long)IteratorUtils.count((Iterator)source.vertices(new Object[0])), (long)IteratorUtils.count((Iterator)target.vertices(new Object[0])));
            Assert.assertEquals((long)IteratorUtils.count((Iterator)source.edges(new Object[0])), (long)IteratorUtils.count((Iterator)target.edges(new Object[0])));
        }

        private boolean isGraphMLXSDPresent() {
            try {
                new URL("http://graphml.graphdrawing.org/xmlns/1.1/graphml-structure.xsd").openConnection().connect();
                return true;
            }
            catch (Exception ex) {
                return false;
            }
        }
    }
}

