/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.GraphProvider;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalEngine;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.javatuples.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphManager {
    private static GraphProvider graphProvider;
    private static TraversalEngine.Type traversalEngineType;

    public static GraphProvider setGraphProvider(GraphProvider graphProvider) {
        GraphProvider old = GraphManager.graphProvider;
        GraphManager.graphProvider = graphProvider;
        return old;
    }

    public static GraphProvider getGraphProvider() {
        return new ManagedGraphProvider(graphProvider);
    }

    public static TraversalEngine.Type setTraversalEngineType(TraversalEngine.Type traversalEngine) {
        TraversalEngine.Type old = traversalEngineType;
        traversalEngineType = traversalEngine;
        return old;
    }

    public static TraversalEngine.Type getTraversalEngineType() {
        return traversalEngineType;
    }

    public static class ManagedGraphProvider
    implements GraphProvider {
        private static final Logger logger = LoggerFactory.getLogger(ManagedGraphProvider.class);
        private final GraphProvider innerGraphProvider;
        private final List<Pair<Graph, Configuration>> openGraphs = new ArrayList<Pair<Graph, Configuration>>();

        public ManagedGraphProvider(GraphProvider innerGraphProvider) {
            this.innerGraphProvider = innerGraphProvider;
        }

        public void tryClearGraphs() {
            for (Pair<Graph, Configuration> p : this.openGraphs) {
                try {
                    this.innerGraphProvider.clear((Graph)p.getValue0(), (Configuration)p.getValue1());
                }
                catch (Exception e) {
                    logger.warn(String.format("Automatic close of Graph instance [%s] and config [%s] generated failure.", p.getValue0() != null ? ((Graph)p.getValue0()).toString() : "null", p.getValue1() != null ? ((Configuration)p.getValue1()).toString() : "null"), (Throwable)e);
                }
            }
        }

        @Override
        public String getWorkingDirectory() {
            return this.innerGraphProvider.getWorkingDirectory();
        }

        @Override
        public GraphTraversalSource traversal(Graph graph) {
            return this.innerGraphProvider.traversal(graph);
        }

        @Override
        public GraphTraversalSource traversal(Graph graph, TraversalStrategy ... strategies) {
            return this.innerGraphProvider.traversal(graph, strategies);
        }

        @Override
        public Graph standardTestGraph(Class<?> test, String testMethodName, LoadGraphWith.GraphData loadGraphWith) {
            return this.openTestGraph(this.standardGraphConfiguration(test, testMethodName, loadGraphWith));
        }

        @Override
        public Graph openTestGraph(Configuration config) {
            Graph graph = this.innerGraphProvider.openTestGraph(config);
            this.openGraphs.add((Pair<Graph, Configuration>)Pair.with((Object)graph, (Object)config));
            return graph;
        }

        @Override
        public Configuration standardGraphConfiguration(Class<?> test, String testMethodName, LoadGraphWith.GraphData loadGraphWith) {
            return this.innerGraphProvider.standardGraphConfiguration(test, testMethodName, loadGraphWith);
        }

        @Override
        public void clear(Configuration configuration) throws Exception {
            this.innerGraphProvider.clear(configuration);
        }

        @Override
        public void clear(Graph graph, Configuration configuration) throws Exception {
            this.innerGraphProvider.clear(graph, configuration);
        }

        @Override
        public Object convertId(Object id, Class<? extends Element> c) {
            return this.innerGraphProvider.convertId(id, c);
        }

        @Override
        public String convertLabel(String label) {
            return this.innerGraphProvider.convertLabel(label);
        }

        @Override
        public Configuration newGraphConfiguration(String graphName, Class<?> test, String testMethodName, Map<String, Object> configurationOverrides, LoadGraphWith.GraphData loadGraphWith) {
            return this.innerGraphProvider.newGraphConfiguration(graphName, test, testMethodName, configurationOverrides, loadGraphWith);
        }

        @Override
        public Configuration newGraphConfiguration(String graphName, Class<?> test, String testMethodName, LoadGraphWith.GraphData loadGraphWith) {
            return this.innerGraphProvider.newGraphConfiguration(graphName, test, testMethodName, loadGraphWith);
        }

        @Override
        public void loadGraphData(Graph graph, LoadGraphWith loadGraphWith, Class testClass, String testName) {
            this.innerGraphProvider.loadGraphData(graph, loadGraphWith, testClass, testName);
        }

        @Override
        public Set<Class> getImplementations() {
            return this.innerGraphProvider.getImplementations();
        }
    }
}

