/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration;

import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.tinkerpop.gremlin.FeatureRequirementSet;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.ElementIdStrategy;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.junit.Assert;
import org.junit.Test;

public class ElementIdStrategyProcessTest
extends AbstractGremlinProcessTest {
    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldGenerateDefaultIdOnGraphAddVWithGeneratedDefaultId() throws Exception {
        ElementIdStrategy strategy = ElementIdStrategy.build().create();
        GraphTraversalSource sg = this.create(strategy);
        Vertex v = (Vertex)sg.addV(new Object[]{"name", "stephen"}).next();
        Assert.assertEquals((Object)"stephen", (Object)v.value("name"));
        GraphTraversal t1 = this.graph.traversal().V(new Object[]{v});
        t1.asAdmin().applyStrategies();
        System.out.println(t1);
        GraphTraversal t2 = sg.V(new Object[]{v});
        t2.asAdmin().applyStrategies();
        System.out.println(t2);
        Assert.assertNotNull((Object)UUID.fromString(sg.V(new Object[]{v}).id().next().toString()));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldGenerateDefaultIdOnGraphAddVWithGeneratedCustomId() throws Exception {
        ElementIdStrategy strategy = ElementIdStrategy.build().idMaker(() -> "xxx").create();
        GraphTraversalSource sg = this.create(strategy);
        Vertex v = (Vertex)sg.addV(new Object[]{"name", "stephen"}).next();
        Assert.assertEquals((Object)"stephen", (Object)v.value("name"));
        Assert.assertEquals((Object)"xxx", (Object)sg.V(new Object[]{v}).id().next());
        Assert.assertEquals((Object)"xxx", (Object)sg.V(new Object[]{"xxx"}).id().next());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldSetIdOnAddVWithIdPropertyKeySpecifiedAndNameSuppliedAsProperty() throws Exception {
        ElementIdStrategy strategy = ElementIdStrategy.build().idPropertyKey("name").create();
        GraphTraversalSource sg = this.create(strategy);
        Vertex v = (Vertex)sg.addV(new Object[]{"name", "stephen"}).next();
        Assert.assertEquals((Object)"stephen", (Object)v.value("name"));
        Assert.assertEquals((Object)"stephen", (Object)sg.V(new Object[]{v}).id().next());
        Assert.assertEquals((Object)"stephen", (Object)sg.V(new Object[]{"stephen"}).id().next());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldSetIdOnAddVWithIdPropertyKeySpecifiedAndIdSuppliedAsProperty() throws Exception {
        ElementIdStrategy strategy = ElementIdStrategy.build().idPropertyKey("name").create();
        GraphTraversalSource sg = this.create(strategy);
        Vertex v = (Vertex)sg.addV(new Object[]{T.id, "stephen"}).next();
        Assert.assertEquals((Object)"stephen", (Object)v.value("name"));
        Assert.assertEquals((Object)"stephen", (Object)sg.V(new Object[]{v}).id().next());
        Assert.assertEquals((Object)"stephen", (Object)sg.V(new Object[]{"stephen"}).id().next());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldGenerateDefaultIdOnGraphAddVWithSpecifiedId() throws Exception {
        ElementIdStrategy strategy = ElementIdStrategy.build().create();
        GraphTraversalSource sg = this.create(strategy);
        Vertex v = (Vertex)sg.addV(new Object[]{T.id, "STEPHEN", "name", "stephen"}).next();
        Assert.assertEquals((Object)"stephen", (Object)v.value("name"));
        Assert.assertEquals((Object)"STEPHEN", (Object)sg.V(new Object[]{v}).id().next());
        Assert.assertEquals((Object)"STEPHEN", (Object)sg.V(new Object[]{"STEPHEN"}).id().next());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldGenerateDefaultIdOnAddVWithGeneratedDefaultId() throws Exception {
        ElementIdStrategy strategy = ElementIdStrategy.build().create();
        GraphTraversalSource sg = this.create(strategy);
        sg.addV(new Object[0]).next();
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)sg.V(new Object[0])));
        Vertex v = (Vertex)sg.V(new Object[0]).addV(new Object[]{"name", "stephen"}).next();
        Assert.assertEquals((Object)"stephen", (Object)v.value("name"));
        Assert.assertNotNull((Object)UUID.fromString(sg.V(new Object[]{v}).id().next().toString()));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldGenerateDefaultIdOnAddVWithGeneratedCustomId() throws Exception {
        AtomicBoolean first = new AtomicBoolean(false);
        ElementIdStrategy strategy = ElementIdStrategy.build().idMaker(() -> {
            String key = first.get() ? "xxx" : "yyy";
            first.set(true);
            return key;
        }).create();
        GraphTraversalSource sg = this.create(strategy);
        sg.addV(new Object[0]).next();
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)sg.V(new Object[0])));
        Vertex v = (Vertex)sg.V(new Object[0]).addV(new Object[]{"name", "stephen"}).next();
        Assert.assertEquals((Object)"stephen", (Object)v.value("name"));
        Assert.assertEquals((Object)"xxx", (Object)sg.V(new Object[]{v}).id().next());
        Assert.assertEquals((Object)"xxx", (Object)sg.V(new Object[]{"xxx"}).id().next());
        Assert.assertEquals((Object)"yyy", (Object)sg.V(new Object[]{"yyy"}).id().next());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldGenerateDefaultIdOnAddVWithSpecifiedId() throws Exception {
        ElementIdStrategy strategy = ElementIdStrategy.build().create();
        GraphTraversalSource sg = this.create(strategy);
        sg.addV(new Object[0]).next();
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)sg.V(new Object[0])));
        Vertex v = (Vertex)sg.V(new Object[0]).addV(new Object[]{T.id, "STEPHEN", "name", "stephen"}).next();
        Assert.assertEquals((Object)"stephen", (Object)v.value("name"));
        Assert.assertEquals((Object)"STEPHEN", (Object)sg.V(new Object[]{v}).id().next());
        Assert.assertEquals((Object)"STEPHEN", (Object)sg.V(new Object[]{"STEPHEN"}).id().next());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldGenerateDefaultIdOnAddEWithSpecifiedId() throws Exception {
        ElementIdStrategy strategy = ElementIdStrategy.build().create();
        GraphTraversalSource sg = this.create(strategy);
        Vertex v = (Vertex)sg.addV(new Object[0]).next();
        Edge e = (Edge)sg.withSideEffect("v", () -> v).V(new Object[]{v}).addE(Direction.OUT, "self", "v", new Object[]{"test", "value", T.id, "some-id"}).next();
        Assert.assertEquals((Object)"value", (Object)e.value("test"));
        Assert.assertEquals((Object)"some-id", (Object)sg.E(new Object[]{e}).id().next());
        Assert.assertEquals((Object)"some-id", (Object)sg.E(new Object[]{"some-id"}).id().next());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldGenerateDefaultIdOnAddEWithGeneratedId() throws Exception {
        ElementIdStrategy strategy = ElementIdStrategy.build().create();
        GraphTraversalSource sg = this.create(strategy);
        Vertex v = (Vertex)sg.addV(new Object[0]).next();
        Edge e = (Edge)sg.withSideEffect("v", () -> v).V(new Object[]{v}).addE(Direction.OUT, "self", "v", new Object[]{"test", "value"}).next();
        Assert.assertEquals((Object)"value", (Object)e.value("test"));
        Assert.assertNotNull((Object)UUID.fromString(sg.E(new Object[]{e}).id().next().toString()));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldSetIdOnAddEWithIdPropertyKeySpecifiedAndNameSuppliedAsProperty() throws Exception {
        ElementIdStrategy strategy = ElementIdStrategy.build().idPropertyKey("name").create();
        GraphTraversalSource sg = this.create(strategy);
        Vertex v = (Vertex)sg.addV(new Object[0]).next();
        Edge e = (Edge)sg.withSideEffect("v", () -> v).V(new Object[]{v}).addE(Direction.OUT, "self", "v", new Object[]{"test", "value", T.id, "some-id"}).next();
        Assert.assertEquals((Object)"value", (Object)e.value("test"));
        Assert.assertEquals((Object)"some-id", (Object)e.value("name"));
        Assert.assertEquals((Object)"some-id", (Object)sg.E(new Object[]{e}).id().next());
        Assert.assertEquals((Object)"some-id", (Object)sg.E(new Object[]{"some-id"}).id().next());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldSetIdOnAddEWithNamePropertyKeySpecifiedAndNameSuppliedAsProperty() throws Exception {
        ElementIdStrategy strategy = ElementIdStrategy.build().idPropertyKey("name").create();
        GraphTraversalSource sg = this.create(strategy);
        Vertex v = (Vertex)sg.addV(new Object[0]).next();
        Edge e = (Edge)sg.withSideEffect("v", () -> v).V(new Object[]{v}).addE(Direction.OUT, "self", "v", new Object[]{"test", "value", "name", "some-id"}).next();
        Assert.assertEquals((Object)"value", (Object)e.value("test"));
        Assert.assertEquals((Object)"some-id", (Object)e.value("name"));
        Assert.assertEquals((Object)"some-id", (Object)sg.E(new Object[]{e}).id().next());
        Assert.assertEquals((Object)"some-id", (Object)sg.E(new Object[]{"some-id"}).id().next());
    }

    private GraphTraversalSource create(ElementIdStrategy strategy) {
        return this.graphProvider.traversal(this.graph, new TraversalStrategy[]{strategy});
    }
}

