/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.tinkerpop.gremlin.ExceptionCoverage;
import org.apache.tinkerpop.gremlin.ExceptionCoverageSet;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.computer.KeyValue;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.MessageScope;
import org.apache.tinkerpop.gremlin.process.computer.Messenger;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.util.StaticMapReduce;
import org.apache.tinkerpop.gremlin.process.computer.util.StaticVertexProgram;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.junit.Assert;
import org.junit.Test;

@ExceptionCoverageSet(value={@ExceptionCoverage(exceptionClass=GraphComputer.Exceptions.class, methods={"providedKeyIsNotAMemoryComputeKey", "computerHasNoVertexProgramNorMapReducers", "computerHasAlreadyBeenSubmittedAVertexProgram", "providedKeyIsNotAnElementComputeKey", "incidentAndAdjacentElementsCanNotBeAccessedInMapReduce", "adjacentVertexLabelsCanNotBeRead", "adjacentVertexPropertiesCanNotBeReadOrUpdated", "adjacentVertexEdgesAndVerticesCanNotBeReadOrUpdated", "resultGraphPersistCombinationNotSupported", "vertexPropertiesCanNotBeUpdatedInMapReduce"}), @ExceptionCoverage(exceptionClass=Graph.Exceptions.class, methods={"graphDoesNotSupportProvidedGraphComputer"})})
public class GraphComputerTest
extends AbstractGremlinProcessTest {
    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldHaveStandardStringRepresentation() {
        GraphComputer computer = this.graph.compute((Class)this.graphComputerClass.get());
        Assert.assertEquals((Object)StringFactory.graphComputerString((GraphComputer)computer), (Object)computer.toString());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldNotAllowWithNoVertexProgramNorMapReducers() throws Exception {
        try {
            this.graph.compute((Class)this.graphComputerClass.get()).submit().get();
            Assert.fail((String)"Should throw an IllegalStateException when there is no vertex program nor map reducers");
        }
        catch (Exception ex) {
            GraphComputerTest.validateException(GraphComputer.Exceptions.computerHasNoVertexProgramNorMapReducers(), ex);
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldNotAllowBadGraphComputers() {
        try {
            this.graph.compute(BadGraphComputer.class);
            Assert.fail((String)"Providing a bad graph computer class should fail");
        }
        catch (Exception ex) {
            GraphComputerTest.validateException(Graph.Exceptions.graphDoesNotSupportProvidedGraphComputer(BadGraphComputer.class), ex);
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldHaveImmutableComputeResultMemory() throws Exception {
        ComputerResult results = (ComputerResult)this.graph.compute((Class)this.graphComputerClass.get()).program((VertexProgram)new VertexProgramB()).submit().get();
        try {
            results.memory().set("set", (Object)"test");
        }
        catch (Exception ex) {
            GraphComputerTest.validateException(Memory.Exceptions.memoryIsCurrentlyImmutable(), ex);
        }
        try {
            results.memory().incr("incr", 1L);
        }
        catch (Exception ex) {
            GraphComputerTest.validateException(Memory.Exceptions.memoryIsCurrentlyImmutable(), ex);
        }
        try {
            results.memory().and("and", true);
        }
        catch (Exception ex) {
            GraphComputerTest.validateException(Memory.Exceptions.memoryIsCurrentlyImmutable(), ex);
        }
        try {
            results.memory().or("or", false);
        }
        catch (Exception ex) {
            GraphComputerTest.validateException(Memory.Exceptions.memoryIsCurrentlyImmutable(), ex);
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldNotAllowNullMemoryKeys() throws Exception {
        try {
            this.graph.compute((Class)this.graphComputerClass.get()).program((VertexProgram)new VertexProgramC()).submit().get();
            Assert.fail((String)"Providing null memory key should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldNotAllowEmptyMemoryKeys() throws Exception {
        try {
            this.graph.compute((Class)this.graphComputerClass.get()).program((VertexProgram)new VertexProgramD()).submit().get();
            Assert.fail((String)"Providing empty memory key should fail");
        }
        catch (Exception ex) {
            GraphComputerTest.validateException(Memory.Exceptions.memoryKeyCanNotBeEmpty(), ex);
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldNotAllowSettingUndeclaredMemoryKeys() throws Exception {
        this.graph.compute((Class)this.graphComputerClass.get()).program((VertexProgram)new VertexProgramE()).submit().get();
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldNotAllowTheSameComputerToExecutedTwice() throws Exception {
        GraphComputer computer = this.graph.compute((Class)this.graphComputerClass.get()).program((VertexProgram)new VertexProgramA());
        computer.submit().get();
        try {
            computer.submit();
            Assert.fail((String)"Using the same graph computer to compute again should not be possible");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Exception e) {
            Assert.fail((String)"Should yield an illegal state exception for graph computer being executed twice");
        }
        try {
            computer.submit();
            Assert.fail((String)"Using the same graph computer to compute again should not be possible");
        }
        catch (IllegalStateException e) {
        }
        catch (Exception e) {
            Assert.fail((String)"Should yield an illegal state exception for graph computer being executed twice");
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldHaveConsistentMemoryVertexPropertiesAndExceptions() throws Exception {
        ComputerResult results = (ComputerResult)this.graph.compute((Class)this.graphComputerClass.get()).program((VertexProgram)new VertexProgramF()).submit().get();
        Assert.assertEquals((long)1L, (long)results.memory().getIteration());
        Assert.assertEquals((long)2L, (long)results.memory().asMap().size());
        Assert.assertEquals((long)2L, (long)results.memory().keys().size());
        Assert.assertTrue((boolean)results.memory().keys().contains("a"));
        Assert.assertTrue((boolean)results.memory().keys().contains("b"));
        Assert.assertTrue((results.memory().getRuntime() >= 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)12L, (Object)results.memory().get("a"));
        Assert.assertEquals((Object)28L, (Object)results.memory().get("b"));
        try {
            results.memory().get("BAD");
            Assert.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)Memory.Exceptions.memoryDoesNotExist((String)"BAD").getMessage(), (Object)e.getMessage());
        }
        Assert.assertEquals((Object)0L, (Object)results.graph().traversal().V(new Object[0]).count().next());
        results.graph().traversal().V(new Object[0]).forEachRemaining(v -> {
            Assert.assertTrue((boolean)v.property("nameLengthCounter").isPresent());
            Assert.assertEquals((Object)(((String)v.value("name")).length() * 2), (Object)((Integer)v.value("nameLengthCounter")));
        });
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldAndOrIncrCorrectlyThroughSubStages() throws Exception {
        ComputerResult results = (ComputerResult)this.graph.compute((Class)this.graphComputerClass.get()).program((VertexProgram)new VertexProgramG()).submit().get();
        Assert.assertEquals((long)2L, (long)results.memory().getIteration());
        Assert.assertEquals((long)6L, (long)results.memory().asMap().size());
        Assert.assertEquals((long)6L, (long)results.memory().keys().size());
        Assert.assertTrue((boolean)results.memory().keys().contains("a"));
        Assert.assertTrue((boolean)results.memory().keys().contains("b"));
        Assert.assertTrue((boolean)results.memory().keys().contains("c"));
        Assert.assertTrue((boolean)results.memory().keys().contains("d"));
        Assert.assertTrue((boolean)results.memory().keys().contains("e"));
        Assert.assertTrue((boolean)results.memory().keys().contains("f"));
        Assert.assertEquals((Object)18L, (Object)results.memory().get("a"));
        Assert.assertEquals((Object)0L, (Object)results.memory().get("b"));
        Assert.assertFalse((boolean)((Boolean)results.memory().get("c")));
        Assert.assertTrue((boolean)((Boolean)results.memory().get("d")));
        Assert.assertTrue((boolean)((Boolean)results.memory().get("e")));
        Assert.assertEquals((long)3L, (long)((Integer)results.memory().get("f")).intValue());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldAllowMapReduceWithNoVertexProgram() throws Exception {
        ComputerResult results = (ComputerResult)this.graph.compute((Class)this.graphComputerClass.get()).mapReduce((MapReduce)new MapReduceA()).submit().get();
        Assert.assertEquals((long)123L, (long)((Integer)results.memory().get("ageSum")).intValue());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldSupportMultipleMapReduceJobs() throws Exception {
        ComputerResult results = (ComputerResult)this.graph.compute((Class)this.graphComputerClass.get()).program((VertexProgram)new VertexProgramH()).mapReduce((MapReduce)new MapReduceH1()).mapReduce((MapReduce)new MapReduceH2()).submit().get();
        Assert.assertEquals((long)60L, (long)((Integer)results.memory().get("a")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)results.memory().get("b")).intValue());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldSortReduceOutput() throws Exception {
        ComputerResult results = (ComputerResult)this.graph.compute((Class)this.graphComputerClass.get()).mapReduce((MapReduce)new MapReduceB()).submit().get();
        List ids = (List)results.memory().get("ids");
        Assert.assertEquals((long)6L, (long)ids.size());
        for (int i = 1; i < ids.size(); ++i) {
            Assert.assertTrue(((Long)ids.get(i) < (Long)ids.get(i - 1) ? 1 : 0) != 0);
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldOnlyAllowReadingVertexPropertiesInMapReduce() throws Exception {
        this.graph.compute((Class)this.graphComputerClass.get()).mapReduce((MapReduce)new MapReduceC()).submit().get();
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldOnlyAllowIDAccessOfAdjacentVertices() throws Exception {
        this.graph.compute((Class)this.graphComputerClass.get()).program((VertexProgram)new VertexProgramI()).submit().get();
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldStartAndEndWorkersForVertexProgramAndMapReduce() throws Exception {
        VertexProgramJ.TIME_KEEPER.set(-1L);
        MapReduceI.TIME_KEEPER.set(-1L);
        MapReduceI.WORKER_START.clear();
        MapReduceI.WORKER_END.clear();
        Assert.assertEquals((long)3L, (long)((Integer)((ComputerResult)this.graph.compute((Class)this.graphComputerClass.get()).program((VertexProgram)new VertexProgramJ()).mapReduce((MapReduce)new MapReduceI()).submit().get()).memory().get("a")).intValue());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)VertexProgramJ.TIME_KEEPER.get());
        if (MapReduceI.WORKER_START.size() == 2) {
            Assert.assertEquals((long)2L, (long)MapReduceI.WORKER_START.size());
            Assert.assertTrue((MapReduceI.WORKER_START.contains(MapReduce.Stage.MAP) && MapReduceI.WORKER_START.contains(MapReduce.Stage.REDUCE) ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((long)3L, (long)MapReduceI.WORKER_START.size());
            Assert.assertTrue((MapReduceI.WORKER_START.contains(MapReduce.Stage.MAP) && MapReduceI.WORKER_START.contains(MapReduce.Stage.COMBINE) && MapReduceI.WORKER_START.contains(MapReduce.Stage.REDUCE) ? 1 : 0) != 0);
        }
        if (MapReduceI.WORKER_END.size() == 2) {
            Assert.assertEquals((long)2L, (long)MapReduceI.WORKER_END.size());
            Assert.assertTrue((MapReduceI.WORKER_END.contains(MapReduce.Stage.MAP) && MapReduceI.WORKER_END.contains(MapReduce.Stage.REDUCE) ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((long)3L, (long)MapReduceI.WORKER_END.size());
            Assert.assertTrue((MapReduceI.WORKER_END.contains(MapReduce.Stage.MAP) && MapReduceI.WORKER_END.contains(MapReduce.Stage.COMBINE) && MapReduceI.WORKER_END.contains(MapReduce.Stage.REDUCE) ? 1 : 0) != 0);
        }
    }

    private static void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Test
    @LoadGraphWith
    public void shouldSupportPersistResultGraphPairsStatedInFeatures() throws Exception {
        for (GraphComputer.ResultGraph resultGraph : GraphComputer.ResultGraph.values()) {
            for (GraphComputer.Persist persist : GraphComputer.Persist.values()) {
                GraphComputer computer = this.graph.compute((Class)this.graphComputerClass.get());
                if (computer.features().supportsResultGraphPersistCombination(resultGraph, persist)) {
                    computer.program((VertexProgram)new VertexProgramK()).result(resultGraph).persist(persist).submit().get();
                    continue;
                }
                try {
                    computer.program((VertexProgram)new VertexProgramK()).result(resultGraph).persist(persist).submit().get();
                    Assert.fail((String)("The GraphComputer " + computer + " states that it does support the following resultGraph/persist pair: " + resultGraph + ":" + persist));
                }
                catch (IllegalArgumentException e) {
                    Assert.assertEquals((Object)GraphComputer.Exceptions.resultGraphPersistCombinationNotSupported((GraphComputer.ResultGraph)resultGraph, (GraphComputer.Persist)persist).getMessage(), (Object)e.getMessage());
                }
            }
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldProcessResultGraphNewWithPersistNothing() throws Exception {
        GraphComputer computer = this.graph.compute((Class)this.graphComputerClass.get());
        if (computer.features().supportsResultGraphPersistCombination(GraphComputer.ResultGraph.NEW, GraphComputer.Persist.NOTHING)) {
            ComputerResult result = (ComputerResult)computer.program((VertexProgram)new VertexProgramK()).result(GraphComputer.ResultGraph.NEW).persist(GraphComputer.Persist.NOTHING).submit().get();
            Assert.assertEquals((Object)0L, (Object)result.graph().traversal().V(new Object[0]).count().next());
            Assert.assertEquals((Object)0L, (Object)result.graph().traversal().E(new Object[0]).count().next());
            Assert.assertEquals((Object)0L, (Object)result.graph().traversal().V(new Object[0]).values(new String[0]).count().next());
            Assert.assertEquals((Object)0L, (Object)result.graph().traversal().E(new Object[0]).values(new String[0]).count().next());
            Assert.assertEquals((Object)0.0, (Object)result.graph().traversal().V(new Object[0]).values(new String[]{"money"}).sum().next());
            Assert.assertEquals((Object)6L, (Object)this.graph.traversal().V(new Object[0]).count().next());
            Assert.assertEquals((Object)6L, (Object)this.graph.traversal().E(new Object[0]).count().next());
            Assert.assertEquals((Object)12L, (Object)this.graph.traversal().V(new Object[0]).values(new String[0]).count().next());
            Assert.assertEquals((Object)6L, (Object)this.graph.traversal().E(new Object[0]).values(new String[0]).count().next());
            Assert.assertEquals((Object)0.0, (Object)this.graph.traversal().V(new Object[0]).values(new String[]{"money"}).sum().next());
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldProcessResultGraphNewWithPersistVertexProperties() throws Exception {
        GraphComputer computer = this.graph.compute((Class)this.graphComputerClass.get());
        if (computer.features().supportsResultGraphPersistCombination(GraphComputer.ResultGraph.NEW, GraphComputer.Persist.VERTEX_PROPERTIES)) {
            ComputerResult result = (ComputerResult)computer.program((VertexProgram)new VertexProgramK()).result(GraphComputer.ResultGraph.NEW).persist(GraphComputer.Persist.VERTEX_PROPERTIES).submit().get();
            Assert.assertEquals((Object)6L, (Object)result.graph().traversal().V(new Object[0]).count().next());
            Assert.assertEquals((Object)0L, (Object)result.graph().traversal().E(new Object[0]).count().next());
            Assert.assertEquals((Object)18L, (Object)result.graph().traversal().V(new Object[0]).values(new String[0]).count().next());
            Assert.assertEquals((Object)0L, (Object)result.graph().traversal().E(new Object[0]).values(new String[0]).count().next());
            Assert.assertEquals((Object)28.0, (Object)result.graph().traversal().V(new Object[0]).values(new String[]{"money"}).sum().next());
            Assert.assertEquals((Object)6L, (Object)this.graph.traversal().V(new Object[0]).count().next());
            Assert.assertEquals((Object)6L, (Object)this.graph.traversal().E(new Object[0]).count().next());
            Assert.assertEquals((Object)12L, (Object)this.graph.traversal().V(new Object[0]).values(new String[0]).count().next());
            Assert.assertEquals((Object)6L, (Object)this.graph.traversal().E(new Object[0]).values(new String[0]).count().next());
            Assert.assertEquals((Object)0.0, (Object)this.graph.traversal().V(new Object[0]).values(new String[]{"money"}).sum().next());
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldProcessResultGraphNewWithPersistEdges() throws Exception {
        GraphComputer computer = this.graph.compute((Class)this.graphComputerClass.get());
        if (computer.features().supportsResultGraphPersistCombination(GraphComputer.ResultGraph.NEW, GraphComputer.Persist.EDGES)) {
            ComputerResult result = (ComputerResult)computer.program((VertexProgram)new VertexProgramK()).result(GraphComputer.ResultGraph.NEW).persist(GraphComputer.Persist.EDGES).submit().get();
            Assert.assertEquals((Object)6L, (Object)result.graph().traversal().V(new Object[0]).count().next());
            Assert.assertEquals((Object)6L, (Object)result.graph().traversal().E(new Object[0]).count().next());
            Assert.assertEquals((Object)18L, (Object)result.graph().traversal().V(new Object[0]).values(new String[0]).count().next());
            Assert.assertEquals((Object)6L, (Object)result.graph().traversal().E(new Object[0]).values(new String[0]).count().next());
            Assert.assertEquals((Object)28.0, (Object)result.graph().traversal().V(new Object[0]).values(new String[]{"money"}).sum().next());
            Assert.assertEquals((Object)6L, (Object)this.graph.traversal().V(new Object[0]).count().next());
            Assert.assertEquals((Object)6L, (Object)this.graph.traversal().E(new Object[0]).count().next());
            Assert.assertEquals((Object)12L, (Object)this.graph.traversal().V(new Object[0]).values(new String[0]).count().next());
            Assert.assertEquals((Object)6L, (Object)this.graph.traversal().E(new Object[0]).values(new String[0]).count().next());
            Assert.assertEquals((Object)0.0, (Object)this.graph.traversal().V(new Object[0]).values(new String[]{"money"}).sum().next());
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldProcessResultGraphOriginalWithPersistNothing() throws Exception {
        GraphComputer computer = this.graph.compute((Class)this.graphComputerClass.get());
        if (computer.features().supportsResultGraphPersistCombination(GraphComputer.ResultGraph.ORIGINAL, GraphComputer.Persist.NOTHING)) {
            ComputerResult result = (ComputerResult)computer.program((VertexProgram)new VertexProgramK()).result(GraphComputer.ResultGraph.ORIGINAL).persist(GraphComputer.Persist.NOTHING).submit().get();
            Assert.assertEquals((Object)6L, (Object)result.graph().traversal().V(new Object[0]).count().next());
            Assert.assertEquals((Object)6L, (Object)result.graph().traversal().E(new Object[0]).count().next());
            Assert.assertEquals((Object)12L, (Object)result.graph().traversal().V(new Object[0]).values(new String[0]).count().next());
            Assert.assertEquals((Object)6L, (Object)result.graph().traversal().E(new Object[0]).values(new String[0]).count().next());
            Assert.assertEquals((Object)0.0, (Object)result.graph().traversal().V(new Object[0]).values(new String[]{"money"}).sum().next());
            Assert.assertEquals((Object)6L, (Object)this.graph.traversal().V(new Object[0]).count().next());
            Assert.assertEquals((Object)6L, (Object)this.graph.traversal().E(new Object[0]).count().next());
            Assert.assertEquals((Object)12L, (Object)this.graph.traversal().V(new Object[0]).values(new String[0]).count().next());
            Assert.assertEquals((Object)6L, (Object)this.graph.traversal().E(new Object[0]).values(new String[0]).count().next());
            Assert.assertEquals((Object)0.0, (Object)this.graph.traversal().V(new Object[0]).values(new String[]{"money"}).sum().next());
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldProcessResultGraphOriginalWithPersistVertexProperties() throws Exception {
        GraphComputer computer = this.graph.compute((Class)this.graphComputerClass.get());
        if (computer.features().supportsResultGraphPersistCombination(GraphComputer.ResultGraph.ORIGINAL, GraphComputer.Persist.VERTEX_PROPERTIES)) {
            ComputerResult result = (ComputerResult)computer.program((VertexProgram)new VertexProgramK()).result(GraphComputer.ResultGraph.ORIGINAL).persist(GraphComputer.Persist.VERTEX_PROPERTIES).submit().get();
            Assert.assertEquals((Object)6L, (Object)result.graph().traversal().V(new Object[0]).count().next());
            Assert.assertEquals((Object)6L, (Object)result.graph().traversal().E(new Object[0]).count().next());
            Assert.assertEquals((Object)18L, (Object)result.graph().traversal().V(new Object[0]).values(new String[0]).count().next());
            Assert.assertEquals((Object)6L, (Object)result.graph().traversal().E(new Object[0]).values(new String[0]).count().next());
            Assert.assertEquals((Object)28.0, (Object)result.graph().traversal().V(new Object[0]).values(new String[]{"money"}).sum().next());
            Assert.assertEquals((Object)6L, (Object)this.graph.traversal().V(new Object[0]).count().next());
            Assert.assertEquals((Object)6L, (Object)this.graph.traversal().E(new Object[0]).count().next());
            Assert.assertEquals((Object)18L, (Object)this.graph.traversal().V(new Object[0]).values(new String[0]).count().next());
            Assert.assertEquals((Object)6L, (Object)this.graph.traversal().E(new Object[0]).values(new String[0]).count().next());
            Assert.assertEquals((Object)28.0, (Object)this.graph.traversal().V(new Object[0]).values(new String[]{"money"}).sum().next());
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldProcessResultGraphOriginalWithPersistEdges() throws Exception {
        GraphComputer computer = this.graph.compute((Class)this.graphComputerClass.get());
        if (computer.features().supportsResultGraphPersistCombination(GraphComputer.ResultGraph.ORIGINAL, GraphComputer.Persist.EDGES)) {
            ComputerResult result = (ComputerResult)computer.program((VertexProgram)new VertexProgramK()).result(GraphComputer.ResultGraph.ORIGINAL).persist(GraphComputer.Persist.EDGES).submit().get();
            Assert.assertEquals((Object)6L, (Object)result.graph().traversal().V(new Object[0]).count().next());
            Assert.assertEquals((Object)6L, (Object)result.graph().traversal().E(new Object[0]).count().next());
            Assert.assertEquals((Object)18L, (Object)result.graph().traversal().V(new Object[0]).values(new String[0]).count().next());
            Assert.assertEquals((Object)6L, (Object)result.graph().traversal().E(new Object[0]).values(new String[0]).count().next());
            Assert.assertEquals((Object)28.0, (Object)result.graph().traversal().V(new Object[0]).values(new String[]{"money"}).sum().next());
            Assert.assertEquals((Object)6L, (Object)this.graph.traversal().V(new Object[0]).count().next());
            Assert.assertEquals((Object)6L, (Object)this.graph.traversal().E(new Object[0]).count().next());
            Assert.assertEquals((Object)18L, (Object)this.graph.traversal().V(new Object[0]).values(new String[0]).count().next());
            Assert.assertEquals((Object)6L, (Object)this.graph.traversal().E(new Object[0]).values(new String[0]).count().next());
            Assert.assertEquals((Object)28.0, (Object)this.graph.traversal().V(new Object[0]).values(new String[]{"money"}).sum().next());
        }
    }

    public static class VertexProgramK
    extends StaticVertexProgram {
        public void setup(Memory memory) {
        }

        public void execute(Vertex vertex, Messenger messenger, Memory memory) {
            vertex.property("money", (Object)((String)vertex.value("name")).length());
        }

        public boolean terminate(Memory memory) {
            return true;
        }

        public Set<String> getElementComputeKeys() {
            return Collections.singleton("money");
        }

        public Set<MessageScope> getMessageScopes(Memory memory) {
            return Collections.emptySet();
        }

        public GraphComputer.ResultGraph getPreferredResultGraph() {
            return GraphComputer.ResultGraph.NEW;
        }

        public GraphComputer.Persist getPreferredPersist() {
            return GraphComputer.Persist.EDGES;
        }
    }

    private static class MapReduceI
    extends StaticMapReduce<MapReduce.NullObject, Integer, MapReduce.NullObject, Integer, Integer> {
        private static final AtomicLong TIME_KEEPER = new AtomicLong(-1L);
        private static final Set<MapReduce.Stage> WORKER_START = new ConcurrentSkipListSet<MapReduce.Stage>();
        private static final Set<MapReduce.Stage> WORKER_END = new ConcurrentSkipListSet<MapReduce.Stage>();

        private MapReduceI() {
        }

        public boolean doStage(MapReduce.Stage stage) {
            return true;
        }

        public void workerStart(MapReduce.Stage stage) {
            long time = System.nanoTime();
            if (!stage.equals((Object)MapReduce.Stage.MAP)) {
                Assert.assertNotEquals((long)-1L, (long)TIME_KEEPER.get());
            }
            Assert.assertTrue((TIME_KEEPER.getAndSet(time) <= time ? 1 : 0) != 0);
            WORKER_START.add(stage);
            if (!stage.equals((Object)MapReduce.Stage.MAP)) {
                Assert.assertFalse((boolean)WORKER_END.isEmpty());
            }
        }

        public void map(Vertex vertex, MapReduce.MapEmitter<MapReduce.NullObject, Integer> emitter) {
            emitter.emit((Object)1);
            GraphComputerTest.sleep(10L);
            Assert.assertNotEquals((long)-1L, (long)TIME_KEEPER.get());
            long time = System.nanoTime();
            Assert.assertTrue((TIME_KEEPER.getAndSet(time) <= time ? 1 : 0) != 0);
            Assert.assertEquals((long)1L, (long)WORKER_START.size());
            Assert.assertTrue((boolean)WORKER_START.contains(MapReduce.Stage.MAP));
        }

        public void combine(MapReduce.NullObject key, Iterator<Integer> values, MapReduce.ReduceEmitter<MapReduce.NullObject, Integer> emitter) {
            emitter.emit((Object)2);
            GraphComputerTest.sleep(10L);
            Assert.assertNotEquals((long)-1L, (long)TIME_KEEPER.get());
            long time = System.nanoTime();
            Assert.assertTrue((TIME_KEEPER.getAndSet(time) <= time ? 1 : 0) != 0);
            Assert.assertEquals((long)2L, (long)WORKER_START.size());
            Assert.assertTrue((WORKER_START.contains(MapReduce.Stage.MAP) && WORKER_START.contains(MapReduce.Stage.COMBINE) ? 1 : 0) != 0);
            Assert.assertFalse((boolean)WORKER_END.isEmpty());
        }

        public void reduce(MapReduce.NullObject key, Iterator<Integer> values, MapReduce.ReduceEmitter<MapReduce.NullObject, Integer> emitter) {
            emitter.emit((Object)3);
            GraphComputerTest.sleep(10L);
            Assert.assertNotEquals((long)-1L, (long)TIME_KEEPER.get());
            long time = System.nanoTime();
            Assert.assertTrue((TIME_KEEPER.getAndSet(time) <= time ? 1 : 0) != 0);
            if (WORKER_START.size() == 2) {
                Assert.assertEquals((long)2L, (long)WORKER_START.size());
                Assert.assertTrue((WORKER_START.contains(MapReduce.Stage.MAP) && WORKER_START.contains(MapReduce.Stage.REDUCE) ? 1 : 0) != 0);
            } else {
                Assert.assertEquals((long)3L, (long)WORKER_START.size());
                Assert.assertTrue((WORKER_START.contains(MapReduce.Stage.MAP) && WORKER_START.contains(MapReduce.Stage.COMBINE) && WORKER_START.contains(MapReduce.Stage.REDUCE) ? 1 : 0) != 0);
            }
            Assert.assertFalse((boolean)WORKER_END.isEmpty());
        }

        public void workerEnd(MapReduce.Stage stage) {
            Assert.assertNotEquals((long)-1L, (long)TIME_KEEPER.get());
            long time = System.nanoTime();
            Assert.assertTrue((TIME_KEEPER.get() <= time ? 1 : 0) != 0);
            Assert.assertFalse((boolean)WORKER_START.isEmpty());
            if (!stage.equals((Object)MapReduce.Stage.MAP)) {
                Assert.assertFalse((boolean)WORKER_END.isEmpty());
            }
            WORKER_END.add(stage);
        }

        public Integer generateFinalResult(Iterator<KeyValue<MapReduce.NullObject, Integer>> keyValues) {
            Assert.assertEquals((long)3L, (long)((Integer)keyValues.next().getValue()).intValue());
            return 3;
        }

        public String getMemoryKey() {
            return "a";
        }
    }

    public static class VertexProgramJ
    extends StaticVertexProgram {
        private static final AtomicLong TIME_KEEPER = new AtomicLong(-1L);

        public void setup(Memory memory) {
            memory.set("test", (Object)memory.getIteration());
        }

        public void workerIterationStart(Memory memory) {
            Assert.assertEquals((long)memory.getIteration(), (long)((Integer)memory.get("test")).intValue());
            long time = System.nanoTime();
            if (!memory.isInitialIteration()) {
                Assert.assertNotEquals((long)-1L, (long)TIME_KEEPER.get());
            }
            Assert.assertTrue((TIME_KEEPER.getAndSet(time) <= time ? 1 : 0) != 0);
            try {
                memory.set("test", (Object)memory.getIteration());
                Assert.fail((String)"Should throw an immutable memory exception");
            }
            catch (IllegalStateException e) {
                Assert.assertEquals((Object)Memory.Exceptions.memoryIsCurrentlyImmutable().getMessage(), (Object)e.getMessage());
            }
        }

        public void execute(Vertex vertex, Messenger messenger, Memory memory) {
            Assert.assertEquals((long)memory.getIteration(), (long)((Integer)memory.get("test")).intValue());
            memory.set("test", (Object)(memory.getIteration() + 1));
            GraphComputerTest.sleep(10L);
            Assert.assertNotEquals((long)-1L, (long)TIME_KEEPER.get());
            Assert.assertTrue((TIME_KEEPER.get() <= System.nanoTime() ? 1 : 0) != 0);
        }

        public boolean terminate(Memory memory) {
            return memory.getIteration() > 3;
        }

        public void workerIterationEnd(Memory memory) {
            Assert.assertEquals((long)memory.getIteration(), (long)((Integer)memory.get("test")).intValue());
            Assert.assertNotEquals((long)-1L, (long)TIME_KEEPER.get());
            Assert.assertTrue((TIME_KEEPER.getAndSet(Long.MIN_VALUE) <= System.nanoTime() ? 1 : 0) != 0);
            try {
                memory.set("test", (Object)memory.getIteration());
                Assert.fail((String)"Should throw an immutable memory exception");
            }
            catch (IllegalStateException e) {
                Assert.assertEquals((Object)Memory.Exceptions.memoryIsCurrentlyImmutable().getMessage(), (Object)e.getMessage());
            }
        }

        public Set<String> getMemoryComputeKeys() {
            return new HashSet<String>(Arrays.asList("test"));
        }

        public Set<MessageScope> getMessageScopes(Memory memory) {
            return Collections.emptySet();
        }

        public GraphComputer.ResultGraph getPreferredResultGraph() {
            return GraphComputer.ResultGraph.NEW;
        }

        public GraphComputer.Persist getPreferredPersist() {
            return GraphComputer.Persist.NOTHING;
        }
    }

    public static class VertexProgramI
    extends StaticVertexProgram<MapReduce.NullObject> {
        public void setup(Memory memory) {
        }

        public void execute(Vertex vertex, Messenger messenger, Memory memory) {
            vertex.vertices(Direction.OUT, new String[0]).forEachRemaining(Element::id);
            vertex.vertices(Direction.IN, new String[0]).forEachRemaining(Element::id);
            vertex.vertices(Direction.BOTH, new String[0]).forEachRemaining(Element::id);
            if (vertex.vertices(Direction.OUT, new String[0]).hasNext()) {
                try {
                    vertex.vertices(Direction.OUT, new String[0]).forEachRemaining(Element::label);
                    Assert.fail((String)"Adjacent vertex labels should not be accessible in VertexProgram.execute()");
                }
                catch (UnsupportedOperationException e) {
                    Assert.assertEquals((Object)GraphComputer.Exceptions.adjacentVertexLabelsCanNotBeRead().getMessage(), (Object)e.getMessage());
                }
            }
            if (vertex.vertices(Direction.IN, new String[0]).hasNext()) {
                try {
                    vertex.vertices(Direction.IN, new String[0]).forEachRemaining(Element::label);
                    Assert.fail((String)"Adjacent vertex labels should not be accessible in VertexProgram.execute()");
                }
                catch (UnsupportedOperationException e) {
                    Assert.assertEquals((Object)GraphComputer.Exceptions.adjacentVertexLabelsCanNotBeRead().getMessage(), (Object)e.getMessage());
                }
            }
            if (vertex.vertices(Direction.BOTH, new String[0]).hasNext()) {
                try {
                    vertex.vertices(Direction.BOTH, new String[0]).forEachRemaining(Element::label);
                    Assert.fail((String)"Adjacent vertex labels should not be accessible in VertexProgram.execute()");
                }
                catch (UnsupportedOperationException e) {
                    Assert.assertEquals((Object)GraphComputer.Exceptions.adjacentVertexLabelsCanNotBeRead().getMessage(), (Object)e.getMessage());
                }
            }
            if (vertex.vertices(Direction.OUT, new String[0]).hasNext()) {
                try {
                    vertex.vertices(Direction.OUT, new String[0]).forEachRemaining(v -> v.property("name"));
                    Assert.fail((String)"Adjacent vertex properties should not be accessible in VertexProgram.execute()");
                }
                catch (UnsupportedOperationException e) {
                    Assert.assertEquals((Object)GraphComputer.Exceptions.adjacentVertexPropertiesCanNotBeReadOrUpdated().getMessage(), (Object)e.getMessage());
                }
            }
            if (vertex.vertices(Direction.IN, new String[0]).hasNext()) {
                try {
                    vertex.vertices(Direction.IN, new String[0]).forEachRemaining(v -> v.property("name"));
                    Assert.fail((String)"Adjacent vertex properties should not be accessible in VertexProgram.execute()");
                }
                catch (UnsupportedOperationException e) {
                    Assert.assertEquals((Object)GraphComputer.Exceptions.adjacentVertexPropertiesCanNotBeReadOrUpdated().getMessage(), (Object)e.getMessage());
                }
            }
            if (vertex.vertices(Direction.BOTH, new String[0]).hasNext()) {
                try {
                    vertex.vertices(Direction.BOTH, new String[0]).forEachRemaining(v -> v.property("name"));
                    Assert.fail((String)"Adjacent vertex properties should not be accessible in VertexProgram.execute()");
                }
                catch (UnsupportedOperationException e) {
                    Assert.assertEquals((Object)GraphComputer.Exceptions.adjacentVertexPropertiesCanNotBeReadOrUpdated().getMessage(), (Object)e.getMessage());
                }
            }
            if (vertex.vertices(Direction.BOTH, new String[0]).hasNext()) {
                try {
                    vertex.vertices(Direction.BOTH, new String[0]).forEachRemaining(v -> v.edges(Direction.BOTH, new String[0]));
                    Assert.fail((String)"Adjacent vertex edges should not be accessible in VertexProgram.execute()");
                }
                catch (UnsupportedOperationException e) {
                    Assert.assertEquals((Object)GraphComputer.Exceptions.adjacentVertexEdgesAndVerticesCanNotBeReadOrUpdated().getMessage(), (Object)e.getMessage());
                }
            }
            if (vertex.vertices(Direction.BOTH, new String[0]).hasNext()) {
                try {
                    vertex.vertices(Direction.BOTH, new String[0]).forEachRemaining(v -> v.vertices(Direction.BOTH, new String[0]));
                    Assert.fail((String)"Adjacent vertex vertices should not be accessible in VertexProgram.execute()");
                }
                catch (UnsupportedOperationException e) {
                    Assert.assertEquals((Object)GraphComputer.Exceptions.adjacentVertexEdgesAndVerticesCanNotBeReadOrUpdated().getMessage(), (Object)e.getMessage());
                }
            }
        }

        public boolean terminate(Memory memory) {
            return memory.getIteration() > 1;
        }

        public Set<MessageScope> getMessageScopes(Memory memory) {
            return Collections.emptySet();
        }

        public GraphComputer.ResultGraph getPreferredResultGraph() {
            return GraphComputer.ResultGraph.NEW;
        }

        public GraphComputer.Persist getPreferredPersist() {
            return GraphComputer.Persist.NOTHING;
        }
    }

    public static class MapReduceC
    extends StaticMapReduce<MapReduce.NullObject, MapReduce.NullObject, MapReduce.NullObject, MapReduce.NullObject, MapReduce.NullObject> {
        public boolean doStage(MapReduce.Stage stage) {
            return stage.equals((Object)MapReduce.Stage.MAP);
        }

        public void map(Vertex vertex, MapReduce.MapEmitter<MapReduce.NullObject, MapReduce.NullObject> emitter) {
            try {
                vertex.edges(Direction.OUT, new String[0]);
                Assert.fail((String)"Edges should not be accessible in MapReduce.map()");
            }
            catch (UnsupportedOperationException e) {
                Assert.assertEquals((Object)GraphComputer.Exceptions.incidentAndAdjacentElementsCanNotBeAccessedInMapReduce().getMessage(), (Object)e.getMessage());
            }
            try {
                vertex.edges(Direction.IN, new String[0]);
                Assert.fail((String)"Edges should not be accessible in MapReduce.map()");
            }
            catch (UnsupportedOperationException e) {
                Assert.assertEquals((Object)GraphComputer.Exceptions.incidentAndAdjacentElementsCanNotBeAccessedInMapReduce().getMessage(), (Object)e.getMessage());
            }
            try {
                vertex.edges(Direction.BOTH, new String[0]);
                Assert.fail((String)"Edges should not be accessible in MapReduce.map()");
            }
            catch (UnsupportedOperationException e) {
                Assert.assertEquals((Object)GraphComputer.Exceptions.incidentAndAdjacentElementsCanNotBeAccessedInMapReduce().getMessage(), (Object)e.getMessage());
            }
            try {
                vertex.property("name", (Object)"bob");
                Assert.fail((String)"Vertex properties should be immutable in MapReduce.map()");
            }
            catch (UnsupportedOperationException e) {
                Assert.assertEquals((Object)GraphComputer.Exceptions.vertexPropertiesCanNotBeUpdatedInMapReduce().getMessage(), (Object)e.getMessage());
            }
            try {
                vertex.property("name").property("test", (Object)1);
                Assert.fail((String)"Vertex properties should be immutable in MapReduce.map()");
            }
            catch (UnsupportedOperationException e) {
                Assert.assertEquals((Object)GraphComputer.Exceptions.vertexPropertiesCanNotBeUpdatedInMapReduce().getMessage(), (Object)e.getMessage());
            }
        }

        public String getMemoryKey() {
            return MapReduce.NullObject.instance().toString();
        }

        public MapReduce.NullObject generateFinalResult(Iterator<KeyValue<MapReduce.NullObject, MapReduce.NullObject>> keyValues) {
            return MapReduce.NullObject.instance();
        }
    }

    public static class MapReduceB
    extends StaticMapReduce<Long, Long, Long, Long, List<Long>> {
        public boolean doStage(MapReduce.Stage stage) {
            return stage.equals((Object)MapReduce.Stage.REDUCE) || stage.equals((Object)MapReduce.Stage.MAP);
        }

        public void map(Vertex vertex, MapReduce.MapEmitter<Long, Long> emitter) {
            emitter.emit((Object)Long.valueOf(vertex.id().toString()), (Object)Long.valueOf(vertex.id().toString()));
        }

        public void reduce(Long key, Iterator<Long> values, MapReduce.ReduceEmitter<Long, Long> emitter) {
            values.forEachRemaining(id -> emitter.emit(id, id));
        }

        public Optional<Comparator<Long>> getReduceKeySort() {
            return Optional.of(Comparator.reverseOrder());
        }

        public String getMemoryKey() {
            return "ids";
        }

        public List<Long> generateFinalResult(Iterator<KeyValue<Long, Long>> keyValues) {
            ArrayList<Long> list = new ArrayList<Long>();
            keyValues.forEachRemaining(id -> list.add((Long)id.getKey()));
            return list;
        }
    }

    private static class MapReduceH2
    extends StaticMapReduce<Integer, Integer, Integer, Integer, Integer> {
        private MapReduceH2() {
        }

        public boolean doStage(MapReduce.Stage stage) {
            return true;
        }

        public void map(Vertex vertex, MapReduce.MapEmitter<Integer, Integer> emitter) {
            vertex.property("age").ifPresent(age -> emitter.emit(age, age));
        }

        public void combine(Integer key, Iterator<Integer> values, MapReduce.ReduceEmitter<Integer, Integer> emitter) {
            values.forEachRemaining(i -> emitter.emit(i, (Object)1));
        }

        public void reduce(Integer key, Iterator<Integer> values, MapReduce.ReduceEmitter<Integer, Integer> emitter) {
            values.forEachRemaining(i -> emitter.emit(i, (Object)1));
        }

        public Integer generateFinalResult(Iterator<KeyValue<Integer, Integer>> keyValues) {
            return (Integer)keyValues.next().getValue();
        }

        public String getMemoryKey() {
            return "b";
        }
    }

    private static class MapReduceH1
    extends StaticMapReduce<MapReduce.NullObject, Integer, MapReduce.NullObject, Integer, Integer> {
        private MapReduceH1() {
        }

        public boolean doStage(MapReduce.Stage stage) {
            return stage.equals((Object)MapReduce.Stage.MAP) || stage.equals((Object)MapReduce.Stage.REDUCE);
        }

        public void map(Vertex vertex, MapReduce.MapEmitter<MapReduce.NullObject, Integer> emitter) {
            vertex.property("counter").ifPresent(arg_0 -> emitter.emit(arg_0));
        }

        public void reduce(MapReduce.NullObject key, Iterator<Integer> values, MapReduce.ReduceEmitter<MapReduce.NullObject, Integer> emitter) {
            int sum = 0;
            while (values.hasNext()) {
                sum += values.next().intValue();
            }
            emitter.emit((Object)sum);
        }

        public Integer generateFinalResult(Iterator<KeyValue<MapReduce.NullObject, Integer>> keyValues) {
            return (Integer)keyValues.next().getValue();
        }

        public String getMemoryKey() {
            return "a";
        }
    }

    public static class VertexProgramH
    extends StaticVertexProgram {
        public void setup(Memory memory) {
        }

        public void execute(Vertex vertex, Messenger messenger, Memory memory) {
            vertex.property(VertexProperty.Cardinality.single, "counter", (Object)(memory.isInitialIteration() ? 1 : (Integer)vertex.value("counter") + 1), new Object[0]);
        }

        public boolean terminate(Memory memory) {
            return memory.getIteration() > 8;
        }

        public Set<String> getElementComputeKeys() {
            return new HashSet<String>(Arrays.asList("counter"));
        }

        public Set<String> getMemoryComputeKeys() {
            return Collections.emptySet();
        }

        public Set<MessageScope> getMessageScopes(Memory memory) {
            return Collections.emptySet();
        }

        public GraphComputer.ResultGraph getPreferredResultGraph() {
            return GraphComputer.ResultGraph.NEW;
        }

        public GraphComputer.Persist getPreferredPersist() {
            return GraphComputer.Persist.NOTHING;
        }
    }

    private static class MapReduceA
    extends StaticMapReduce<MapReduce.NullObject, Integer, MapReduce.NullObject, Integer, Integer> {
        private MapReduceA() {
        }

        public boolean doStage(MapReduce.Stage stage) {
            return stage.equals((Object)MapReduce.Stage.MAP) || stage.equals((Object)MapReduce.Stage.REDUCE);
        }

        public void map(Vertex vertex, MapReduce.MapEmitter<MapReduce.NullObject, Integer> emitter) {
            vertex.property("age").ifPresent(arg_0 -> emitter.emit(arg_0));
        }

        public void reduce(MapReduce.NullObject key, Iterator<Integer> values, MapReduce.ReduceEmitter<MapReduce.NullObject, Integer> emitter) {
            int sum = 0;
            while (values.hasNext()) {
                sum += values.next().intValue();
            }
            emitter.emit((Object)sum);
        }

        public Integer generateFinalResult(Iterator<KeyValue<MapReduce.NullObject, Integer>> keyValues) {
            return (Integer)keyValues.next().getValue();
        }

        public String getMemoryKey() {
            return "ageSum";
        }
    }

    public static class VertexProgramG
    extends StaticVertexProgram {
        public void setup(Memory memory) {
            memory.set("a", (Object)0L);
            memory.set("b", (Object)0L);
            memory.set("c", (Object)true);
            memory.set("d", (Object)false);
            memory.set("e", (Object)true);
            memory.set("f", (Object)memory.getIteration());
        }

        public void execute(Vertex vertex, Messenger messenger, Memory memory) {
            Assert.assertEquals((Object)(6 * memory.getIteration()), (Object)memory.get("a"));
            Assert.assertEquals((Object)0L, (Object)memory.get("b"));
            if (memory.isInitialIteration()) {
                Assert.assertTrue((boolean)((Boolean)memory.get("c")));
                Assert.assertFalse((boolean)((Boolean)memory.get("d")));
            } else {
                Assert.assertFalse((boolean)((Boolean)memory.get("c")));
                Assert.assertTrue((boolean)((Boolean)memory.get("d")));
            }
            Assert.assertTrue((boolean)((Boolean)memory.get("e")));
            Assert.assertEquals((long)memory.getIteration(), (long)((Integer)memory.get("f")).intValue());
            memory.incr("a", 1L);
            memory.incr("b", 1L);
            memory.and("c", false);
            memory.or("d", true);
            memory.and("e", false);
            memory.set("f", (Object)(memory.getIteration() + 1));
            Assert.assertEquals((Object)(6 * memory.getIteration()), (Object)memory.get("a"));
            Assert.assertEquals((Object)0L, (Object)memory.get("b"));
            if (memory.isInitialIteration()) {
                Assert.assertTrue((boolean)((Boolean)memory.get("c")));
                Assert.assertFalse((boolean)((Boolean)memory.get("d")));
            } else {
                Assert.assertFalse((boolean)((Boolean)memory.get("c")));
                Assert.assertTrue((boolean)((Boolean)memory.get("d")));
            }
            Assert.assertTrue((boolean)((Boolean)memory.get("e")));
            Assert.assertEquals((long)memory.getIteration(), (long)((Integer)memory.get("f")).intValue());
        }

        public boolean terminate(Memory memory) {
            Assert.assertEquals((Object)(6 * (memory.getIteration() + 1)), (Object)memory.get("a"));
            Assert.assertEquals((Object)6L, (Object)memory.get("b"));
            Assert.assertFalse((boolean)((Boolean)memory.get("c")));
            Assert.assertTrue((boolean)((Boolean)memory.get("d")));
            Assert.assertFalse((boolean)((Boolean)memory.get("e")));
            Assert.assertEquals((long)(memory.getIteration() + 1), (long)((Integer)memory.get("f")).intValue());
            memory.set("b", (Object)0L);
            memory.set("e", (Object)true);
            return memory.getIteration() > 1;
        }

        public Set<String> getElementComputeKeys() {
            return Collections.emptySet();
        }

        public Set<String> getMemoryComputeKeys() {
            return new HashSet<String>(Arrays.asList("a", "b", "c", "d", "e", "f"));
        }

        public Set<MessageScope> getMessageScopes(Memory memory) {
            return Collections.emptySet();
        }

        public GraphComputer.ResultGraph getPreferredResultGraph() {
            return GraphComputer.ResultGraph.NEW;
        }

        public GraphComputer.Persist getPreferredPersist() {
            return GraphComputer.Persist.NOTHING;
        }
    }

    public static class VertexProgramF
    extends StaticVertexProgram<Object> {
        public void setup(Memory memory) {
        }

        public void execute(Vertex vertex, Messenger<Object> messenger, Memory memory) {
            try {
                vertex.property(VertexProperty.Cardinality.single, "blah", (Object)"blah", new Object[0]);
                Assert.fail((String)"Should throw an IllegalArgumentException");
            }
            catch (IllegalArgumentException e) {
                Assert.assertEquals((Object)GraphComputer.Exceptions.providedKeyIsNotAnElementComputeKey((String)"blah").getMessage(), (Object)e.getMessage());
            }
            catch (Exception e) {
                Assert.fail((String)("Should throw an IllegalArgumentException: " + e));
            }
            memory.incr("a", 1L);
            if (memory.isInitialIteration()) {
                vertex.property(VertexProperty.Cardinality.single, "nameLengthCounter", (Object)((String)vertex.value("name")).length(), new Object[0]);
                memory.incr("b", (long)((String)vertex.value("name")).length());
            } else {
                vertex.property(VertexProperty.Cardinality.single, "nameLengthCounter", (Object)(((String)vertex.value("name")).length() + (Integer)vertex.value("nameLengthCounter")), new Object[0]);
            }
        }

        public boolean terminate(Memory memory) {
            return memory.getIteration() == 1;
        }

        public Set<String> getElementComputeKeys() {
            return new HashSet<String>(Arrays.asList("nameLengthCounter"));
        }

        public Set<String> getMemoryComputeKeys() {
            return new HashSet<String>(Arrays.asList("a", "b"));
        }

        public Set<MessageScope> getMessageScopes(Memory memory) {
            return Collections.emptySet();
        }

        public GraphComputer.ResultGraph getPreferredResultGraph() {
            return GraphComputer.ResultGraph.NEW;
        }

        public GraphComputer.Persist getPreferredPersist() {
            return GraphComputer.Persist.NOTHING;
        }
    }

    public static class VertexProgramA
    extends StaticVertexProgram {
        public void setup(Memory memory) {
        }

        public void execute(Vertex vertex, Messenger messenger, Memory memory) {
        }

        public boolean terminate(Memory memory) {
            return true;
        }

        public Set<MessageScope> getMessageScopes(Memory memory) {
            return Collections.emptySet();
        }

        public GraphComputer.ResultGraph getPreferredResultGraph() {
            return GraphComputer.ResultGraph.ORIGINAL;
        }

        public GraphComputer.Persist getPreferredPersist() {
            return GraphComputer.Persist.NOTHING;
        }
    }

    public static class VertexProgramE
    extends StaticVertexProgram {
        public void setup(Memory memory) {
            try {
                memory.set("a", (Object)true);
                Assert.fail((String)"Setting a memory key that wasn't declared should fail");
            }
            catch (IllegalArgumentException e) {
                Assert.assertEquals((Object)GraphComputer.Exceptions.providedKeyIsNotAMemoryComputeKey((String)"a").getMessage(), (Object)e.getMessage());
            }
        }

        public void execute(Vertex vertex, Messenger messenger, Memory memory) {
        }

        public boolean terminate(Memory memory) {
            return true;
        }

        public Set<MessageScope> getMessageScopes(Memory memory) {
            return Collections.emptySet();
        }

        public GraphComputer.ResultGraph getPreferredResultGraph() {
            return GraphComputer.ResultGraph.ORIGINAL;
        }

        public GraphComputer.Persist getPreferredPersist() {
            return GraphComputer.Persist.NOTHING;
        }
    }

    public static class VertexProgramD
    extends StaticVertexProgram {
        public void setup(Memory memory) {
        }

        public void execute(Vertex vertex, Messenger messenger, Memory memory) {
        }

        public boolean terminate(Memory memory) {
            return true;
        }

        public Set<String> getMemoryComputeKeys() {
            return new HashSet<String>(Arrays.asList(""));
        }

        public Set<MessageScope> getMessageScopes(Memory memory) {
            return Collections.emptySet();
        }

        public GraphComputer.ResultGraph getPreferredResultGraph() {
            return GraphComputer.ResultGraph.ORIGINAL;
        }

        public GraphComputer.Persist getPreferredPersist() {
            return GraphComputer.Persist.NOTHING;
        }
    }

    public static class VertexProgramC
    extends StaticVertexProgram {
        public void setup(Memory memory) {
        }

        public void execute(Vertex vertex, Messenger messenger, Memory memory) {
        }

        public boolean terminate(Memory memory) {
            return true;
        }

        public Set<String> getMemoryComputeKeys() {
            return new HashSet<String>(Arrays.asList(null));
        }

        public Set<MessageScope> getMessageScopes(Memory memory) {
            return Collections.emptySet();
        }

        public GraphComputer.ResultGraph getPreferredResultGraph() {
            return GraphComputer.ResultGraph.ORIGINAL;
        }

        public GraphComputer.Persist getPreferredPersist() {
            return GraphComputer.Persist.NOTHING;
        }
    }

    public static class VertexProgramB
    extends StaticVertexProgram {
        public void setup(Memory memory) {
            Assert.assertEquals((long)0L, (long)memory.getIteration());
            Assert.assertTrue((boolean)memory.isInitialIteration());
        }

        public void execute(Vertex vertex, Messenger messenger, Memory memory) {
            Assert.assertEquals((long)0L, (long)memory.getIteration());
            Assert.assertTrue((boolean)memory.isInitialIteration());
        }

        public boolean terminate(Memory memory) {
            Assert.assertEquals((long)0L, (long)memory.getIteration());
            Assert.assertTrue((boolean)memory.isInitialIteration());
            return true;
        }

        public Set<String> getMemoryComputeKeys() {
            return new HashSet<String>(Arrays.asList("set", "incr", "and", "or"));
        }

        public Set<MessageScope> getMessageScopes(Memory memory) {
            return Collections.emptySet();
        }

        public GraphComputer.ResultGraph getPreferredResultGraph() {
            return GraphComputer.ResultGraph.ORIGINAL;
        }

        public GraphComputer.Persist getPreferredPersist() {
            return GraphComputer.Persist.NOTHING;
        }
    }

    public static class BadGraphComputer
    implements GraphComputer {
        public GraphComputer result(GraphComputer.ResultGraph resultGraph) {
            return null;
        }

        public GraphComputer persist(GraphComputer.Persist persist) {
            return null;
        }

        public GraphComputer program(VertexProgram vertexProgram) {
            return null;
        }

        public GraphComputer mapReduce(MapReduce mapReduce) {
            return null;
        }

        public Future<ComputerResult> submit() {
            return null;
        }
    }
}

