/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.GraphManager;
import org.apache.tinkerpop.gremlin.process.IgnoreEngine;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalEngine;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.MapHelper;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;

public abstract class AbstractGremlinProcessTest
extends AbstractGremlinTest {
    protected boolean graphMeetsTestRequirements() {
        return !this.hasGraphComputerRequirement() || this.graph.features().graph().supportsComputer();
    }

    protected boolean hasGraphComputerRequirement() {
        return !GraphManager.getTraversalEngineType().equals((Object)TraversalEngine.Type.STANDARD);
    }

    @Before
    public void setupTest() {
        Assume.assumeTrue((boolean)this.graphMeetsTestRequirements());
        try {
            IgnoreEngine ignoreEngine = this.getClass().getMethod(this.name.getMethodName(), new Class[0]).getAnnotation(IgnoreEngine.class);
            if (ignoreEngine != null) {
                Assume.assumeTrue((String)String.format("This test is ignored for %s", ignoreEngine.value()), (!ignoreEngine.value().equals((Object)GraphManager.getTraversalEngineType()) ? 1 : 0) != 0);
            }
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException(String.format("Could not find test method %s in test case %s", this.name.getMethodName(), this.getClass().getName()));
        }
    }

    public static <T> void checkResults(List<T> expectedResults, Traversal<?, T> traversal) {
        List results = traversal.toList();
        Assert.assertFalse((boolean)traversal.hasNext());
        if (expectedResults.size() != results.size()) {
            System.err.println("Expected results: " + expectedResults);
            System.err.println("Actual results:   " + results);
            Assert.assertEquals((String)"Checking result size", (long)expectedResults.size(), (long)results.size());
        }
        for (Object t2 : results) {
            if (t2 instanceof Map) {
                Assert.assertTrue((String)("Checking map result existence: " + t2), (boolean)expectedResults.stream().filter(e -> e instanceof Map).filter(e -> AbstractGremlinProcessTest.checkMap((Map)e, (Map)t2)).findAny().isPresent());
                continue;
            }
            Assert.assertTrue((String)("Checking result existence: " + t2), (boolean)expectedResults.contains(t2));
        }
        HashMap<Object, Long> expectedResultsCount = new HashMap<Object, Long>();
        HashMap resultsCount = new HashMap();
        Assert.assertEquals((String)"Checking indexing is equivalent", (long)expectedResultsCount.size(), (long)resultsCount.size());
        expectedResults.forEach(t -> MapHelper.incr((Map)expectedResultsCount, (Object)t, (Long)1L));
        results.forEach(t -> MapHelper.incr((Map)resultsCount, (Object)t, (Long)1L));
        expectedResultsCount.forEach((k, v) -> Assert.assertEquals((String)"Checking result group counts", (Object)v, resultsCount.get(k)));
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    public static <T> void checkResults(Map<T, Long> expectedResults, Traversal<?, T> traversal) {
        ArrayList list = new ArrayList();
        expectedResults.forEach((k, v) -> {
            int i = 0;
            while ((long)i < v) {
                list.add(k);
                ++i;
            }
        });
        AbstractGremlinProcessTest.checkResults(list, traversal);
    }

    public static <A, B> boolean checkMap(Map<A, B> expectedMap, Map<A, B> actualMap) {
        List actualList = actualMap.entrySet().stream().sorted((a, b) -> a.getKey().toString().compareTo(b.getKey().toString())).collect(Collectors.toList());
        List expectedList = expectedMap.entrySet().stream().sorted((a, b) -> a.getKey().toString().compareTo(b.getKey().toString())).collect(Collectors.toList());
        if (expectedList.size() > actualList.size()) {
            return false;
        }
        if (actualList.size() > expectedList.size()) {
            return false;
        }
        for (int i = 0; i < actualList.size(); ++i) {
            if (!((Map.Entry)actualList.get(i)).getKey().equals(((Map.Entry)expectedList.get(i)).getKey())) {
                return false;
            }
            if (((Map.Entry)actualList.get(i)).getValue().equals(((Map.Entry)expectedList.get(i)).getValue())) continue;
            return false;
        }
        return true;
    }

    public <A, B> List<Map<A, B>> makeMapList(int size, Object ... keyValues) {
        ArrayList<Map<A, B>> mapList = new ArrayList<Map<A, B>>();
        for (int i = 0; i < keyValues.length; i += 2 * size) {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            for (int j = 0; j < 2 * size; j += 2) {
                map.put(keyValues[i + j], keyValues[i + j + 1]);
            }
            mapList.add(map);
        }
        return mapList;
    }
}

