/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.FeatureRequirements;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.TestHelper;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.io.GraphMigrator;
import org.apache.tinkerpop.gremlin.structure.io.GraphReader;
import org.apache.tinkerpop.gremlin.structure.io.GraphWriter;
import org.apache.tinkerpop.gremlin.structure.io.Io;
import org.apache.tinkerpop.gremlin.structure.io.IoCore;
import org.apache.tinkerpop.gremlin.structure.io.graphml.GraphMLIo;
import org.apache.tinkerpop.gremlin.structure.io.graphml.GraphMLReader;
import org.apache.tinkerpop.gremlin.structure.io.graphml.GraphMLResourceAccess;
import org.apache.tinkerpop.gremlin.structure.io.graphml.GraphMLWriter;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONIo;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONMapper;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONReader;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONResourceAccess;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONWriter;
import org.apache.tinkerpop.gremlin.structure.io.graphson.LegacyGraphSONReader;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoIo;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoMapper;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoReader;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoWriter;
import org.apache.tinkerpop.gremlin.structure.io.gryo.VertexByteArrayInputStream;
import org.apache.tinkerpop.gremlin.structure.util.Attachable;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedEdge;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedFactory;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertex;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class IoTest
extends AbstractGremlinTest {
    private Io.Builder<GraphMLIo> graphml;
    private Io.Builder<GraphSONIo> graphson;
    private Io.Builder<GryoIo> gryo;

    @Before
    public void setupBeforeEachTest() {
        this.graphml = IoCore.graphml();
        this.graphson = IoCore.graphson();
        this.gryo = IoCore.gryo();
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="StringValues"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="FloatValues")})
    public void shouldReadGraphML() throws IOException {
        IoTest.readGraphMLIntoGraph(this.graph, "tinkerpop-classic.xml");
        IoTest.assertClassicGraph(this.graph, false, true);
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="StringValues"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="FloatValues")})
    public void shouldReadGraphMLUnorderedElements() throws IOException {
        IoTest.readGraphMLIntoGraph(this.graph, "tinkerpop-classic-unordered.xml");
        IoTest.assertClassicGraph(this.graph, false, true);
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="StringValues"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="FloatValues"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="BooleanValues"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="LongValues"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="DoubleValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="FloatValues")})
    public void shouldReadGraphMLAnAllSupportedDataTypes() throws IOException {
        GraphMLReader reader = GraphMLReader.build().create();
        try (InputStream stream = IoTest.class.getResourceAsStream(TestHelper.convertPackageToResourcePath(GraphMLResourceAccess.class) + "graph-types.xml");){
            reader.readGraph(stream, this.graph);
        }
        Vertex v = (Vertex)this.graph.vertices(new Object[0]).next();
        Assert.assertEquals((double)123.45, (double)((Double)v.value("d")), (double)1.0E-6);
        Assert.assertEquals((Object)"some-string", (Object)v.value("s"));
        Assert.assertEquals((long)29L, (long)((Integer)v.value("i")).intValue());
        Assert.assertEquals((Object)true, (Object)v.value("b"));
        Assert.assertEquals((float)123.54f, (float)((Float)v.value("f")).floatValue(), (float)1.0E-6f);
        Assert.assertEquals((long)10000000L, (long)((Long)v.value("l")));
        Assert.assertEquals((Object)"junk", (Object)v.value("n"));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.CLASSIC)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
    public void shouldReadWriteClassicToGraphMLToFileWithHelpers() throws Exception {
        File f = TestHelper.generateTempFile(this.getClass(), this.name.getMethodName(), ".xml");
        try {
            ((GraphMLIo)this.graph.io(this.graphml)).writeGraph(f.getAbsolutePath());
            Configuration configuration = this.graphProvider.newGraphConfiguration("readGraph", this.getClass(), this.name.getMethodName(), LoadGraphWith.GraphData.CLASSIC);
            Graph g1 = this.graphProvider.openTestGraph(configuration);
            ((GraphMLIo)g1.io(this.graphml)).readGraph(f.getAbsolutePath());
            IoTest.assertClassicGraph(this.graph, false, true);
            this.graphProvider.clear(g1, configuration);
        }
        catch (Exception ex) {
            f.delete();
            throw ex;
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="StringValues"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="FloatValues"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="NumericIds")})
    @LoadGraphWith(value=LoadGraphWith.GraphData.CLASSIC)
    public void shouldWriteNormalizedGraphML() throws Exception {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            GraphMLWriter w = GraphMLWriter.build().normalize(true).create();
            w.writeGraph((OutputStream)bos, this.graph);
            String expected = this.streamToString(IoTest.class.getResourceAsStream(TestHelper.convertPackageToResourcePath(GraphMLResourceAccess.class) + "tinkerpop-classic-normalized.xml"));
            Assert.assertEquals((Object)expected.replace("\n", "").replace("\r", ""), (Object)bos.toString().replace("\n", "").replace("\r", ""));
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="StringValues"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="FloatValues"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="NumericIds"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VariableFeatures.class, feature="Variables")})
    @LoadGraphWith(value=LoadGraphWith.GraphData.CLASSIC)
    public void shouldWriteNormalizedGraphSON() throws Exception {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            GraphSONMapper mapper = ((GraphSONIo)this.graph.io(this.graphson)).mapper().normalize(true).create();
            GraphSONWriter w = ((GraphSONIo)this.graph.io(this.graphson)).writer().mapper(mapper).create();
            w.writeGraph((OutputStream)bos, this.graph);
            String expected = this.streamToString(IoTest.class.getResourceAsStream(TestHelper.convertPackageToResourcePath(GraphSONResourceAccess.class) + "tinkerpop-classic-normalized.json"));
            Assert.assertEquals((Object)expected.replace("\n", "").replace("\r", ""), (Object)bos.toString().replace("\n", "").replace("\r", ""));
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="StringValues"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="StringIds")})
    public void shouldProperlyEncodeWithGraphML() throws Exception {
        Vertex v = this.graph.addVertex(new Object[]{T.id, "1"});
        v.property(VertexProperty.Cardinality.single, "text", (Object)"\u00e9", new Object[0]);
        GraphMLWriter w = GraphMLWriter.build().create();
        File f = TestHelper.generateTempFile(this.getClass(), "test", ".txt");
        try (FileOutputStream out = new FileOutputStream(f);){
            w.writeGraph((OutputStream)out, this.graph);
        }
        this.validateXmlAgainstGraphMLXsd(f);
        Configuration configuration = this.graphProvider.newGraphConfiguration("g2", this.getClass(), this.name.getMethodName(), null);
        this.graphProvider.clear(configuration);
        Graph g2 = this.graphProvider.openTestGraph(configuration);
        GraphMLReader r = GraphMLReader.build().create();
        try (FileInputStream in = new FileInputStream(f);){
            r.readGraph((InputStream)in, g2);
        }
        Vertex v2 = (Vertex)g2.vertices(new Object[]{"1"}).next();
        Assert.assertEquals((Object)"\u00e9", (Object)v2.property("text").value());
        this.graphProvider.clear(g2, configuration);
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AnyIds")})
    public void shouldProperlySerializeCustomIdWithGraphSON() throws Exception {
        UUID id = UUID.fromString("AF4B5965-B176-4552-B3C1-FBBE2F52C305");
        this.graph.addVertex(new Object[]{T.id, new CustomId("vertex", id)});
        SimpleModule module = new SimpleModule();
        module.addSerializer(CustomId.class, (JsonSerializer)new CustomId.CustomIdJacksonSerializer());
        GraphSONWriter writer = ((GraphSONIo)this.graph.io(this.graphson)).writer().mapper(((GraphSONIo)this.graph.io(this.graphson)).mapper().addCustomModule(module).embedTypes(true).create()).create();
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            writer.writeGraph((OutputStream)baos, this.graph);
            JsonNode jsonGraph = new ObjectMapper().readTree(baos.toByteArray());
            JsonNode idValue = jsonGraph.get("id");
            Assert.assertTrue((boolean)idValue.has("cluster"));
            Assert.assertEquals((Object)"vertex", (Object)idValue.get("cluster").asText());
            Assert.assertTrue((boolean)idValue.has("elementId"));
            Assert.assertEquals((Object)"AF4B5965-B176-4552-B3C1-FBBE2F52C305".toLowerCase(), (Object)idValue.get("elementId").get(1).asText());
            Configuration configuration = this.graphProvider.newGraphConfiguration("g2", this.getClass(), this.name.getMethodName(), null);
            this.graphProvider.clear(configuration);
            Graph g2 = this.graphProvider.openTestGraph(configuration);
            try (ByteArrayInputStream is = new ByteArrayInputStream(baos.toByteArray());){
                GraphSONReader reader = ((GraphSONIo)this.graph.io(this.graphson)).reader().mapper(((GraphSONIo)this.graph.io(this.graphson)).mapper().embedTypes(true).addCustomModule(module).create()).create();
                reader.readGraph((InputStream)is, g2);
            }
            Vertex v2 = (Vertex)g2.vertices(new Object[0]).next();
            CustomId customId = (CustomId)v2.id();
            Assert.assertEquals((Object)id, (Object)customId.getElementId());
            Assert.assertEquals((Object)"vertex", (Object)customId.getCluster());
            this.graphProvider.clear(g2, configuration);
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AnyIds")})
    public void shouldProperlySerializeCustomIdWithGryo() throws Exception {
        this.graph.addVertex(new Object[]{T.id, new CustomId("vertex", UUID.fromString("AF4B5965-B176-4552-B3C1-FBBE2F52C305"))});
        GryoMapper gryo = GryoMapper.build().addCustom(new Class[]{CustomId.class}).create();
        GryoWriter writer = GryoWriter.build().mapper(gryo).create();
        GryoReader reader = GryoReader.build().mapper(gryo).create();
        Configuration configuration = this.graphProvider.newGraphConfiguration("readGraph", this.getClass(), this.name.getMethodName(), null);
        this.graphProvider.clear(configuration);
        Graph g1 = this.graphProvider.openTestGraph(configuration);
        GraphMigrator.migrateGraph((Graph)this.graph, (Graph)g1, (GraphReader)reader, (GraphWriter)writer);
        Vertex onlyVertex = (Vertex)g1.traversal().V(new Object[0]).next();
        CustomId id = (CustomId)onlyVertex.id();
        Assert.assertEquals((Object)"vertex", (Object)id.getCluster());
        Assert.assertEquals((Object)UUID.fromString("AF4B5965-B176-4552-B3C1-FBBE2F52C305"), (Object)id.getElementId());
        this.graphProvider.clear(g1, configuration);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.CLASSIC)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
    public void shouldMigrateGraphWithFloat() throws Exception {
        Configuration configuration = this.graphProvider.newGraphConfiguration("readGraph", this.getClass(), this.name.getMethodName(), null);
        this.graphProvider.clear(configuration);
        Graph g1 = this.graphProvider.openTestGraph(configuration);
        GryoReader reader = ((GryoIo)this.graph.io(this.gryo)).reader().create();
        GryoWriter writer = ((GryoIo)this.graph.io(this.gryo)).writer().create();
        GraphMigrator.migrateGraph((Graph)this.graph, (Graph)g1, (GraphReader)reader, (GraphWriter)writer);
        IoTest.assertClassicGraph(g1, false, false);
        this.graphProvider.clear(g1, configuration);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
    public void shouldMigrateGraph() throws Exception {
        Configuration configuration = this.graphProvider.newGraphConfiguration("readGraph", this.getClass(), this.name.getMethodName(), LoadGraphWith.GraphData.MODERN);
        this.graphProvider.clear(configuration);
        Graph g1 = this.graphProvider.openTestGraph(configuration);
        GryoReader reader = ((GryoIo)this.graph.io(this.gryo)).reader().create();
        GryoWriter writer = ((GryoIo)this.graph.io(this.gryo)).writer().create();
        GraphMigrator.migrateGraph((Graph)this.graph, (Graph)g1, (GraphReader)reader, (GraphWriter)writer);
        IoTest.assertModernGraph(g1, true, false);
        this.graphProvider.clear(g1, configuration);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
    public void shouldReadWriteModernToGryo() throws Exception {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GryoWriter writer = ((GryoIo)this.graph.io(this.gryo)).writer().create();
            writer.writeGraph((OutputStream)os, this.graph);
            Configuration configuration = this.graphProvider.newGraphConfiguration("readGraph", this.getClass(), this.name.getMethodName(), LoadGraphWith.GraphData.MODERN);
            this.graphProvider.clear(configuration);
            Graph g1 = this.graphProvider.openTestGraph(configuration);
            GryoReader reader = ((GryoIo)this.graph.io(this.gryo)).reader().create();
            byte[] x = os.toByteArray();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(x);){
                reader.readGraph((InputStream)bais, g1);
            }
            IoTest.assertModernGraph(g1, true, false);
            this.graphProvider.clear(g1, configuration);
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
    public void shouldReadWriteModernToGryoToFileWithHelpers() throws Exception {
        File f = TestHelper.generateTempFile(this.getClass(), this.name.getMethodName(), ".kryo");
        try {
            ((GryoIo)this.graph.io(this.gryo)).writeGraph(f.getAbsolutePath());
            Configuration configuration = this.graphProvider.newGraphConfiguration("readGraph", this.getClass(), this.name.getMethodName(), LoadGraphWith.GraphData.MODERN);
            Graph g1 = this.graphProvider.openTestGraph(configuration);
            ((GryoIo)g1.io(this.gryo)).readGraph(f.getAbsolutePath());
            IoTest.assertModernGraph(g1, true, false);
            this.graphProvider.clear(g1, configuration);
        }
        catch (Exception ex) {
            f.delete();
            throw ex;
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.CREW)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
    public void shouldReadWriteCrewToGryo() throws Exception {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GryoWriter writer = ((GryoIo)this.graph.io(this.gryo)).writer().create();
            writer.writeGraph((OutputStream)os, this.graph);
            Configuration configuration = this.graphProvider.newGraphConfiguration("readGraph", this.getClass(), this.name.getMethodName(), LoadGraphWith.GraphData.CREW);
            this.graphProvider.clear(configuration);
            Graph g1 = this.graphProvider.openTestGraph(configuration);
            GryoReader reader = GryoReader.build().mapper(((GryoIo)this.graph.io(this.gryo)).mapper().create()).create();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readGraph((InputStream)bais, g1);
            }
            IoTest.assertCrewGraph(g1, false);
            this.graphProvider.clear(g1, configuration);
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.CLASSIC)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
    public void shouldReadWriteClassicToGryo() throws Exception {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GryoWriter writer = ((GryoIo)this.graph.io(this.gryo)).writer().create();
            writer.writeGraph((OutputStream)os, this.graph);
            Configuration configuration = this.graphProvider.newGraphConfiguration("readGraph", this.getClass(), this.name.getMethodName(), LoadGraphWith.GraphData.CLASSIC);
            this.graphProvider.clear(configuration);
            Graph g1 = this.graphProvider.openTestGraph(configuration);
            GryoReader reader = ((GryoIo)this.graph.io(this.gryo)).reader().create();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readGraph((InputStream)bais, g1);
            }
            IoTest.assertClassicGraph(g1, false, false);
            this.graphProvider.clear(g1, configuration);
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.CLASSIC)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
    public void shouldReadWriteClassicToGraphSON() throws Exception {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GraphSONWriter writer = ((GraphSONIo)this.graph.io(this.graphson)).writer().create();
            writer.writeGraph((OutputStream)os, this.graph);
            Configuration configuration = this.graphProvider.newGraphConfiguration("readGraph", this.getClass(), this.name.getMethodName(), LoadGraphWith.GraphData.CLASSIC);
            this.graphProvider.clear(configuration);
            Graph g1 = this.graphProvider.openTestGraph(configuration);
            GraphSONReader reader = ((GraphSONIo)this.graph.io(this.graphson)).reader().create();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readGraph((InputStream)bais, g1);
            }
            IoTest.assertClassicGraph(g1, true, false);
            this.graphProvider.clear(g1, configuration);
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
    public void shouldReadWriteModernToGraphSON() throws Exception {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GraphSONWriter writer = ((GraphSONIo)this.graph.io(this.graphson)).writer().create();
            writer.writeGraph((OutputStream)os, this.graph);
            Configuration configuration = this.graphProvider.newGraphConfiguration("readGraph", this.getClass(), this.name.getMethodName(), LoadGraphWith.GraphData.MODERN);
            this.graphProvider.clear(configuration);
            Graph g1 = this.graphProvider.openTestGraph(configuration);
            GraphSONReader reader = ((GraphSONIo)this.graph.io(this.graphson)).reader().create();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readGraph((InputStream)bais, g1);
            }
            IoTest.assertModernGraph(g1, true, false);
            this.graphProvider.clear(g1, configuration);
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
    public void shouldReadWriteModernToGraphSONWithHelpers() throws Exception {
        File f = TestHelper.generateTempFile(this.getClass(), this.name.getMethodName(), ".json");
        try {
            ((GraphSONIo)this.graph.io(this.graphson)).writeGraph(f.getAbsolutePath());
            Configuration configuration = this.graphProvider.newGraphConfiguration("readGraph", this.getClass(), this.name.getMethodName(), LoadGraphWith.GraphData.MODERN);
            this.graphProvider.clear(configuration);
            Graph g1 = this.graphProvider.openTestGraph(configuration);
            ((GraphSONIo)g1.io(this.graphson)).readGraph(f.getAbsolutePath());
            IoTest.assertModernGraph(g1, true, false);
            this.graphProvider.clear(g1, configuration);
        }
        catch (Exception ex) {
            f.delete();
            throw ex;
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.CREW)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
    public void shouldReadWriteCrewToGraphSON() throws Exception {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GraphSONWriter writer = ((GraphSONIo)this.graph.io(this.graphson)).writer().create();
            writer.writeGraph((OutputStream)os, this.graph);
            Configuration configuration = this.graphProvider.newGraphConfiguration("readGraph", this.getClass(), this.name.getMethodName(), LoadGraphWith.GraphData.CREW);
            this.graphProvider.clear(configuration);
            Graph g1 = this.graphProvider.openTestGraph(configuration);
            GraphSONReader reader = ((GraphSONIo)this.graph.io(this.graphson)).reader().create();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readGraph((InputStream)bais, g1);
            }
            IoTest.assertCrewGraph(g1, true);
            this.graphProvider.clear(g1, configuration);
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="FloatValues")})
    public void shouldReadWriteEdgeToGryoUsingFloatProperty() throws Exception {
        Vertex v1 = this.graph.addVertex(new Object[]{T.label, "person"});
        Vertex v2 = this.graph.addVertex(new Object[]{T.label, "person"});
        Edge e = v1.addEdge("friend", v2, new Object[]{"weight", Float.valueOf(0.5f), "acl", "rw"});
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GryoWriter writer = ((GryoIo)this.graph.io(this.gryo)).writer().create();
            writer.writeEdge((OutputStream)os, e);
            AtomicBoolean called = new AtomicBoolean(false);
            GryoReader reader = ((GryoIo)this.graph.io(this.gryo)).reader().create();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readEdge((InputStream)bais, edge2 -> {
                    Edge detachedEdge = (Edge)edge2;
                    Assert.assertEquals((Object)e.id(), (Object)detachedEdge.id());
                    Assert.assertEquals((Object)v1.id(), (Object)detachedEdge.outVertex().id());
                    Assert.assertEquals((Object)v2.id(), (Object)detachedEdge.inVertex().id());
                    Assert.assertEquals((Object)v1.label(), (Object)detachedEdge.outVertex().label());
                    Assert.assertEquals((Object)v2.label(), (Object)detachedEdge.inVertex().label());
                    Assert.assertEquals((Object)e.label(), (Object)detachedEdge.label());
                    Assert.assertEquals((Object)Float.valueOf(0.5f), (Object)((Property)detachedEdge.properties(new String[]{"weight"}).next()).value());
                    Assert.assertEquals((Object)"rw", (Object)((Property)detachedEdge.properties(new String[]{"acl"}).next()).value());
                    called.set(true);
                    return null;
                });
            }
            Assert.assertTrue((boolean)called.get());
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")})
    public void shouldReadWriteEdgeToGryo() throws Exception {
        Vertex v1 = this.graph.addVertex(new Object[]{T.label, "person"});
        Vertex v2 = this.graph.addVertex(new Object[]{T.label, "person"});
        Edge e = v1.addEdge("friend", v2, new Object[]{"weight", 0.5, "acl", "rw"});
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GryoWriter writer = ((GryoIo)this.graph.io(this.gryo)).writer().create();
            writer.writeEdge((OutputStream)os, e);
            AtomicBoolean called = new AtomicBoolean(false);
            GryoReader reader = ((GryoIo)this.graph.io(this.gryo)).reader().create();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readEdge((InputStream)bais, edge2 -> {
                    Edge detachedEdge = (Edge)edge2;
                    Assert.assertEquals((Object)e.id(), (Object)detachedEdge.id());
                    Assert.assertEquals((Object)v1.id(), (Object)detachedEdge.outVertex().id());
                    Assert.assertEquals((Object)v2.id(), (Object)detachedEdge.inVertex().id());
                    Assert.assertEquals((Object)v1.label(), (Object)detachedEdge.outVertex().label());
                    Assert.assertEquals((Object)v2.label(), (Object)detachedEdge.inVertex().label());
                    Assert.assertEquals((Object)e.label(), (Object)detachedEdge.label());
                    Assert.assertEquals((Object)0.5, (Object)((Property)e.properties(new String[]{"weight"}).next()).value());
                    Assert.assertEquals((Object)"rw", (Object)((Property)e.properties(new String[]{"acl"}).next()).value());
                    called.set(true);
                    return null;
                });
            }
            Assert.assertTrue((boolean)called.get());
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")})
    public void shouldReadWriteDetachedEdgeAsReferenceToGryo() throws Exception {
        Vertex v1 = this.graph.addVertex(new Object[]{T.label, "person"});
        Vertex v2 = this.graph.addVertex(new Object[]{T.label, "person"});
        DetachedEdge e = DetachedFactory.detach((Edge)v1.addEdge("friend", v2, new Object[]{"weight", 0.5, "acl", "rw"}), (boolean)false);
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GryoWriter writer = ((GryoIo)this.graph.io(this.gryo)).writer().create();
            writer.writeEdge((OutputStream)os, (Edge)e);
            AtomicBoolean called = new AtomicBoolean(false);
            GryoReader reader = ((GryoIo)this.graph.io(this.gryo)).reader().create();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readEdge((InputStream)bais, arg_0 -> IoTest.lambda$shouldReadWriteDetachedEdgeAsReferenceToGryo$66((Edge)e, v1, v2, called, arg_0));
            }
            Assert.assertTrue((boolean)called.get());
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")})
    public void shouldReadWriteDetachedEdgeToGryo() throws Exception {
        Vertex v1 = this.graph.addVertex(new Object[]{T.label, "person"});
        Vertex v2 = this.graph.addVertex(new Object[]{T.label, "person"});
        DetachedEdge e = DetachedFactory.detach((Edge)v1.addEdge("friend", v2, new Object[]{"weight", 0.5, "acl", "rw"}), (boolean)true);
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GryoWriter writer = ((GryoIo)this.graph.io(this.gryo)).writer().create();
            writer.writeEdge((OutputStream)os, (Edge)e);
            AtomicBoolean called = new AtomicBoolean(false);
            GryoReader reader = ((GryoIo)this.graph.io(this.gryo)).reader().create();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readEdge((InputStream)bais, arg_0 -> IoTest.lambda$shouldReadWriteDetachedEdgeToGryo$67((Edge)e, v1, v2, called, arg_0));
            }
            Assert.assertTrue((boolean)called.get());
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="FloatValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")})
    public void shouldReadWriteEdgeToGraphSON() throws Exception {
        Vertex v1 = this.graph.addVertex(new Object[]{T.label, "person"});
        Vertex v2 = this.graph.addVertex(new Object[]{T.label, "person"});
        Edge e = v1.addEdge("friend", v2, new Object[]{"weight", Float.valueOf(0.5f), "acl", "rw"});
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GraphSONWriter writer = ((GraphSONIo)this.graph.io(this.graphson)).writer().create();
            writer.writeEdge((OutputStream)os, e);
            AtomicBoolean called = new AtomicBoolean(false);
            GraphSONReader reader = ((GraphSONIo)this.graph.io(this.graphson)).reader().create();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readEdge((InputStream)bais, edge2 -> {
                    Edge detachedEdge = (Edge)edge2;
                    Assert.assertEquals((Object)e.id(), (Object)((Edge)this.graph.edges(new Object[]{detachedEdge.id().toString()}).next()).id());
                    Assert.assertEquals((Object)v1.id(), (Object)((Vertex)this.graph.vertices(new Object[]{detachedEdge.outVertex().id().toString()}).next()).id());
                    Assert.assertEquals((Object)v2.id(), (Object)((Vertex)this.graph.vertices(new Object[]{detachedEdge.inVertex().id().toString()}).next()).id());
                    Assert.assertEquals((Object)v1.label(), (Object)detachedEdge.outVertex().label());
                    Assert.assertEquals((Object)v2.label(), (Object)detachedEdge.inVertex().label());
                    Assert.assertEquals((Object)e.label(), (Object)detachedEdge.label());
                    Assert.assertEquals((Object)0.5, (Object)((Property)detachedEdge.properties(new String[]{"weight"}).next()).value());
                    Assert.assertEquals((Object)"rw", (Object)((Property)detachedEdge.properties(new String[]{"acl"}).next()).value());
                    called.set(true);
                    return null;
                });
            }
            Assert.assertTrue((boolean)called.get());
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="FloatValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")})
    public void shouldReadWriteDetachedEdgeAsReferenceToGraphSON() throws Exception {
        Vertex v1 = this.graph.addVertex(new Object[]{T.label, "person"});
        Vertex v2 = this.graph.addVertex(new Object[]{T.label, "person"});
        DetachedEdge e = DetachedFactory.detach((Edge)v1.addEdge("friend", v2, new Object[]{"weight", Float.valueOf(0.5f), "acl", "rw"}), (boolean)false);
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GraphSONWriter writer = ((GraphSONIo)this.graph.io(this.graphson)).writer().create();
            writer.writeEdge((OutputStream)os, (Edge)e);
            AtomicBoolean called = new AtomicBoolean(false);
            GraphSONReader reader = ((GraphSONIo)this.graph.io(this.graphson)).reader().create();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readEdge((InputStream)bais, arg_0 -> this.lambda$shouldReadWriteDetachedEdgeAsReferenceToGraphSON$69((Edge)e, v1, v2, called, arg_0));
            }
            Assert.assertTrue((boolean)called.get());
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="FloatValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")})
    public void shouldReadWriteDetachedEdgeToGraphSON() throws Exception {
        Vertex v1 = this.graph.addVertex(new Object[]{T.label, "person"});
        Vertex v2 = this.graph.addVertex(new Object[]{T.label, "person"});
        DetachedEdge e = DetachedFactory.detach((Edge)v1.addEdge("friend", v2, new Object[]{"weight", Float.valueOf(0.5f), "acl", "rw"}), (boolean)true);
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GraphSONWriter writer = ((GraphSONIo)this.graph.io(this.graphson)).writer().create();
            writer.writeEdge((OutputStream)os, (Edge)e);
            AtomicBoolean called = new AtomicBoolean(false);
            GraphSONReader reader = ((GraphSONIo)this.graph.io(this.graphson)).reader().create();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readEdge((InputStream)bais, arg_0 -> this.lambda$shouldReadWriteDetachedEdgeToGraphSON$70((Edge)e, v1, v2, called, arg_0));
            }
            Assert.assertTrue((boolean)called.get());
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="FloatValues"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="NumericIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds")})
    public void shouldReadWriteEdgeToGraphSONNonLossy() throws Exception {
        Vertex v1 = this.graph.addVertex(new Object[]{T.id, 1L, T.label, "person"});
        Vertex v2 = this.graph.addVertex(new Object[]{T.id, 2L, T.label, "person"});
        Edge e = v1.addEdge("friend", v2, new Object[]{"weight", Float.valueOf(0.5f), "acl", "rw"});
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GraphSONWriter writer = ((GraphSONIo)this.graph.io(this.graphson)).writer().mapper(((GraphSONIo)this.graph.io(this.graphson)).mapper().embedTypes(true).create()).create();
            writer.writeEdge((OutputStream)os, e);
            AtomicBoolean called = new AtomicBoolean(false);
            GraphSONReader reader = ((GraphSONIo)this.graph.io(this.graphson)).reader().mapper(((GraphSONIo)this.graph.io(this.graphson)).mapper().embedTypes(true).create()).create();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readEdge((InputStream)bais, edge2 -> {
                    Edge detachedEdge = (Edge)edge2;
                    Assert.assertEquals((Object)e.id(), (Object)detachedEdge.id());
                    Assert.assertEquals((Object)v1.id(), (Object)detachedEdge.outVertex().id());
                    Assert.assertEquals((Object)v2.id(), (Object)detachedEdge.inVertex().id());
                    Assert.assertEquals((Object)v1.label(), (Object)detachedEdge.outVertex().label());
                    Assert.assertEquals((Object)v2.label(), (Object)detachedEdge.inVertex().label());
                    Assert.assertEquals((Object)e.label(), (Object)detachedEdge.label());
                    Assert.assertEquals((Object)Float.valueOf(0.5f), (Object)((Property)detachedEdge.properties(new String[]{"weight"}).next()).value());
                    Assert.assertEquals((Object)"rw", (Object)((Property)detachedEdge.properties(new String[]{"acl"}).next()).value());
                    called.set(true);
                    return null;
                });
            }
            Assert.assertTrue((boolean)called.get());
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="SerializableValues")})
    public void shouldSupportUUIDInGraphSON() throws Exception {
        UUID id = UUID.randomUUID();
        Vertex v1 = this.graph.addVertex(new Object[]{T.label, "person"});
        Vertex v2 = this.graph.addVertex(new Object[]{T.label, "person"});
        Edge e = v1.addEdge("friend", v2, new Object[]{"uuid", id});
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GraphSONWriter writer = ((GraphSONIo)this.graph.io(this.graphson)).writer().mapper(((GraphSONIo)this.graph.io(this.graphson)).mapper().embedTypes(true).create()).create();
            writer.writeEdge((OutputStream)os, e);
            AtomicBoolean called = new AtomicBoolean(false);
            GraphSONReader reader = ((GraphSONIo)this.graph.io(this.graphson)).reader().mapper(((GraphSONIo)this.graph.io(this.graphson)).mapper().embedTypes(true).create()).create();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readEdge((InputStream)bais, edge2 -> {
                    Edge detachedEdge = (Edge)edge2;
                    Assert.assertEquals((Object)e.id(), (Object)((Edge)this.graph.edges(new Object[]{detachedEdge.id()}).next()).id());
                    Assert.assertEquals((Object)v1.id(), (Object)((Vertex)this.graph.vertices(new Object[]{detachedEdge.outVertex().id()}).next()).id());
                    Assert.assertEquals((Object)v2.id(), (Object)((Vertex)this.graph.vertices(new Object[]{detachedEdge.inVertex().id()}).next()).id());
                    Assert.assertEquals((Object)v1.label(), (Object)detachedEdge.outVertex().label());
                    Assert.assertEquals((Object)v2.label(), (Object)detachedEdge.inVertex().label());
                    Assert.assertEquals((Object)e.label(), (Object)detachedEdge.label());
                    Assert.assertEquals((long)e.keys().size(), (long)IteratorUtils.count((Iterator)detachedEdge.properties(new String[0])));
                    Assert.assertEquals((Object)id, (Object)detachedEdge.value("uuid"));
                    called.set(true);
                    return null;
                });
            }
            Assert.assertTrue((boolean)called.get());
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="SerializableValues")})
    public void shouldSupportUUIDInGryo() throws Exception {
        UUID id = UUID.randomUUID();
        Vertex v1 = this.graph.addVertex(new Object[]{T.label, "person"});
        Vertex v2 = this.graph.addVertex(new Object[]{T.label, "person"});
        Edge e = v1.addEdge("friend", v2, new Object[]{"uuid", id});
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GryoWriter writer = ((GryoIo)this.graph.io(this.gryo)).writer().create();
            writer.writeEdge((OutputStream)os, e);
            AtomicBoolean called = new AtomicBoolean(false);
            GryoReader reader = ((GryoIo)this.graph.io(this.gryo)).reader().create();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readEdge((InputStream)bais, edge2 -> {
                    Edge detachedEdge = (Edge)edge2;
                    Assert.assertEquals((Object)e.id(), (Object)detachedEdge.id());
                    Assert.assertEquals((Object)v1.id(), (Object)detachedEdge.outVertex().id());
                    Assert.assertEquals((Object)v2.id(), (Object)detachedEdge.inVertex().id());
                    Assert.assertEquals((Object)v1.label(), (Object)detachedEdge.outVertex().label());
                    Assert.assertEquals((Object)v2.label(), (Object)detachedEdge.inVertex().label());
                    Assert.assertEquals((Object)e.label(), (Object)detachedEdge.label());
                    Assert.assertEquals((long)e.keys().size(), (long)IteratorUtils.count((Iterator)detachedEdge.properties(new String[0])));
                    Assert.assertEquals((Object)id, (Object)detachedEdge.value("uuid"));
                    called.set(true);
                    return null;
                });
            }
            Assert.assertTrue((boolean)called.get());
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="StringValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="FloatValues")})
    public void shouldReadWriteVertexNoEdgesToGryoUsingFloatProperty() throws Exception {
        Vertex v1 = this.graph.addVertex(new Object[]{"name", "marko", "acl", "rw"});
        Vertex v2 = this.graph.addVertex(new Object[0]);
        v1.addEdge("friends", v2, new Object[]{"weight", Float.valueOf(0.5f)});
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GryoWriter writer = ((GryoIo)this.graph.io(this.gryo)).writer().create();
            writer.writeVertex((OutputStream)os, v1);
            AtomicBoolean called = new AtomicBoolean(false);
            GryoReader reader = ((GryoIo)this.graph.io(this.gryo)).reader().create();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readVertex((InputStream)bais, attachable -> {
                    Vertex detachedVertex = (Vertex)attachable.get();
                    Assert.assertEquals((Object)v1.id(), (Object)detachedVertex.id());
                    Assert.assertEquals((Object)v1.label(), (Object)detachedVertex.label());
                    Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)detachedVertex.properties(new String[0])));
                    Assert.assertEquals((Object)v1.value("name"), (Object)detachedVertex.value("name").toString());
                    Assert.assertEquals((Object)v1.value("acl"), (Object)detachedVertex.value("acl").toString());
                    called.set(true);
                    return (Vertex)Mockito.mock(Vertex.class);
                });
            }
            Assert.assertTrue((boolean)called.get());
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="StringValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")})
    public void shouldReadWriteVertexNoEdgesToGryo() throws Exception {
        Vertex v1 = this.graph.addVertex(new Object[]{"name", "marko", "acl", "rw"});
        Vertex v2 = this.graph.addVertex(new Object[0]);
        v1.addEdge("friends", v2, new Object[]{"weight", 0.5});
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GryoWriter writer = ((GryoIo)this.graph.io(this.gryo)).writer().create();
            writer.writeVertex((OutputStream)os, v1);
            AtomicBoolean called = new AtomicBoolean(false);
            GryoReader reader = ((GryoIo)this.graph.io(this.gryo)).reader().create();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readVertex((InputStream)bais, attachable -> {
                    Vertex detachedVertex = (Vertex)attachable.get();
                    Assert.assertEquals((Object)v1.id(), (Object)detachedVertex.id());
                    Assert.assertEquals((Object)v1.label(), (Object)detachedVertex.label());
                    Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)detachedVertex.properties(new String[0])));
                    Assert.assertEquals((Object)v1.value("name"), (Object)detachedVertex.value("name").toString());
                    Assert.assertEquals((Object)v1.value("acl"), (Object)detachedVertex.value("acl").toString());
                    called.set(true);
                    return (Vertex)Mockito.mock(Vertex.class);
                });
            }
            Assert.assertTrue((boolean)called.get());
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="StringValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")})
    public void shouldReadWriteDetachedVertexNoEdgesToGryo() throws Exception {
        Vertex v1 = this.graph.addVertex(new Object[]{"name", "marko", "acl", "rw"});
        Vertex v2 = this.graph.addVertex(new Object[0]);
        v1.addEdge("friends", v2, new Object[]{"weight", 0.5});
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GryoWriter writer = ((GryoIo)this.graph.io(this.gryo)).writer().create();
            DetachedVertex dv = DetachedFactory.detach((Vertex)v1, (boolean)true);
            writer.writeVertex((OutputStream)os, (Vertex)dv);
            AtomicBoolean called = new AtomicBoolean(false);
            GryoReader reader = ((GryoIo)this.graph.io(this.gryo)).reader().create();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readVertex((InputStream)bais, attachable -> {
                    Vertex detachedVertex = (Vertex)attachable.get();
                    Assert.assertEquals((Object)v1.id(), (Object)detachedVertex.id());
                    Assert.assertEquals((Object)v1.label(), (Object)detachedVertex.label());
                    Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)detachedVertex.properties(new String[0])));
                    Assert.assertEquals((Object)"marko", (Object)((VertexProperty)detachedVertex.properties(new String[]{"name"}).next()).value());
                    Assert.assertEquals((Object)"rw", (Object)((VertexProperty)detachedVertex.properties(new String[]{"acl"}).next()).value());
                    called.set(true);
                    return (Vertex)Mockito.mock(Vertex.class);
                });
            }
            Assert.assertTrue((boolean)called.get());
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="StringValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")})
    public void shouldReadWriteDetachedVertexAsReferenceNoEdgesToGryo() throws Exception {
        Vertex v1 = this.graph.addVertex(new Object[]{"name", "marko", "acl", "rw"});
        Vertex v2 = this.graph.addVertex(new Object[0]);
        v1.addEdge("friends", v2, new Object[]{"weight", 0.5});
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GryoWriter writer = ((GryoIo)this.graph.io(this.gryo)).writer().create();
            DetachedVertex dv = DetachedFactory.detach((Vertex)v1, (boolean)false);
            writer.writeVertex((OutputStream)os, (Vertex)dv);
            AtomicBoolean called = new AtomicBoolean(false);
            GryoReader reader = ((GryoIo)this.graph.io(this.gryo)).reader().create();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readVertex((InputStream)bais, attachable -> {
                    Vertex detachedVertex = (Vertex)attachable.get();
                    Assert.assertEquals((Object)v1.id(), (Object)detachedVertex.id());
                    Assert.assertEquals((Object)v1.label(), (Object)detachedVertex.label());
                    Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)detachedVertex.properties(new String[0])));
                    called.set(true);
                    return (Vertex)Mockito.mock(Vertex.class);
                });
            }
            Assert.assertTrue((boolean)called.get());
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="StringValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MultiProperties"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties")})
    public void shouldReadWriteVertexMultiPropsNoEdgesToGryo() throws Exception {
        Vertex v1 = this.graph.addVertex(new Object[]{"name", "marko", "name", "mark", "acl", "rw"});
        v1.property(VertexProperty.Cardinality.single, "propsSquared", (Object)123, new Object[]{"x", "a", "y", "b"});
        Vertex v2 = this.graph.addVertex(new Object[0]);
        v1.addEdge("friends", v2, new Object[]{"weight", 0.5});
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GryoWriter writer = ((GryoIo)this.graph.io(this.gryo)).writer().create();
            writer.writeVertex((OutputStream)os, v1);
            AtomicBoolean called = new AtomicBoolean(false);
            GryoReader reader = ((GryoIo)this.graph.io(this.gryo)).reader().create();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readVertex((InputStream)bais, attachable -> {
                    Vertex detachedVertex = (Vertex)attachable.get();
                    Assert.assertEquals((Object)v1.id(), (Object)detachedVertex.id());
                    Assert.assertEquals((Object)v1.label(), (Object)detachedVertex.label());
                    Assert.assertEquals((long)4L, (long)IteratorUtils.count((Iterator)detachedVertex.properties(new String[0])));
                    Assert.assertEquals((Object)"a", (Object)detachedVertex.property("propsSquared").value("x"));
                    Assert.assertEquals((Object)"b", (Object)detachedVertex.property("propsSquared").value("y"));
                    Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)detachedVertex.properties(new String[]{"name"})));
                    Assert.assertTrue((boolean)IteratorUtils.stream((Iterator)detachedVertex.properties(new String[]{"name"})).allMatch(p -> p.key().equals("name") && (p.value().equals("marko") || p.value().equals("mark"))));
                    Assert.assertEquals((Object)v1.value("acl"), (Object)detachedVertex.value("acl").toString());
                    called.set(true);
                    return (Vertex)Mockito.mock(Vertex.class);
                });
            }
            Assert.assertTrue((boolean)called.get());
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="StringValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="FloatValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")})
    public void shouldReadWriteVertexNoEdgesToGraphSON() throws Exception {
        Vertex v1 = this.graph.addVertex(new Object[]{"name", "marko", "acl", "rw"});
        Vertex v2 = this.graph.addVertex(new Object[0]);
        v1.addEdge("friends", v2, new Object[]{"weight", Float.valueOf(0.5f)});
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GraphSONWriter writer = ((GraphSONIo)this.graph.io(this.graphson)).writer().create();
            writer.writeVertex((OutputStream)os, v1);
            AtomicBoolean called = new AtomicBoolean(false);
            GraphSONReader reader = ((GraphSONIo)this.graph.io(this.graphson)).reader().create();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readVertex((InputStream)bais, attachable -> {
                    Vertex detachedVertex = (Vertex)attachable.get();
                    Assert.assertEquals((Object)v1.id(), (Object)((Vertex)this.graph.vertices(new Object[]{detachedVertex.id().toString()}).next()).id());
                    Assert.assertEquals((Object)v1.label(), (Object)detachedVertex.label());
                    Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)detachedVertex.properties(new String[0])));
                    Assert.assertEquals((Object)"marko", (Object)((VertexProperty)detachedVertex.properties(new String[]{"name"}).next()).value());
                    Assert.assertEquals((Object)"rw", (Object)((VertexProperty)detachedVertex.properties(new String[]{"acl"}).next()).value());
                    called.set(true);
                    return detachedVertex;
                });
            }
            Assert.assertTrue((boolean)called.get());
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="StringValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="FloatValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")})
    public void shouldReadWriteDetachedVertexNoEdgesToGraphSON() throws Exception {
        Vertex v1 = this.graph.addVertex(new Object[]{"name", "marko", "acl", "rw"});
        Vertex v2 = this.graph.addVertex(new Object[0]);
        v1.addEdge("friends", v2, new Object[]{"weight", Float.valueOf(0.5f)});
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GraphSONWriter writer = ((GraphSONIo)this.graph.io(this.graphson)).writer().create();
            DetachedVertex dv = DetachedFactory.detach((Vertex)v1, (boolean)true);
            writer.writeVertex((OutputStream)os, (Vertex)dv);
            AtomicBoolean called = new AtomicBoolean(false);
            GraphSONReader reader = ((GraphSONIo)this.graph.io(this.graphson)).reader().create();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readVertex((InputStream)bais, attachable -> {
                    Vertex detachedVertex = (Vertex)attachable.get();
                    Assert.assertEquals((Object)v1.id(), (Object)((Vertex)this.graph.vertices(new Object[]{detachedVertex.id().toString()}).next()).id());
                    Assert.assertEquals((Object)v1.label(), (Object)detachedVertex.label());
                    Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)detachedVertex.properties(new String[0])));
                    Assert.assertEquals((Object)"marko", (Object)((VertexProperty)detachedVertex.properties(new String[]{"name"}).next()).value());
                    Assert.assertEquals((Object)"rw", (Object)((VertexProperty)detachedVertex.properties(new String[]{"acl"}).next()).value());
                    called.set(true);
                    return detachedVertex;
                });
            }
            Assert.assertTrue((boolean)called.get());
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="StringValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="FloatValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")})
    public void shouldReadWriteDetachedVertexAsReferenceNoEdgesToGraphSON() throws Exception {
        Vertex v1 = this.graph.addVertex(new Object[]{"name", "marko", "acl", "rw"});
        Vertex v2 = this.graph.addVertex(new Object[0]);
        v1.addEdge("friends", v2, new Object[]{"weight", Float.valueOf(0.5f)});
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GraphSONWriter writer = ((GraphSONIo)this.graph.io(this.graphson)).writer().create();
            DetachedVertex dv = DetachedFactory.detach((Vertex)v1, (boolean)false);
            writer.writeVertex((OutputStream)os, (Vertex)dv);
            AtomicBoolean called = new AtomicBoolean(false);
            GraphSONReader reader = ((GraphSONIo)this.graph.io(this.graphson)).reader().create();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readVertex((InputStream)bais, attachable -> {
                    Vertex detachedVertex = (Vertex)attachable.get();
                    Assert.assertEquals((Object)v1.id(), (Object)((Vertex)this.graph.vertices(new Object[]{detachedVertex.id().toString()}).next()).id());
                    Assert.assertEquals((Object)v1.label(), (Object)detachedVertex.label());
                    Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)detachedVertex.properties(new String[0])));
                    called.set(true);
                    return detachedVertex;
                });
            }
            Assert.assertTrue((boolean)called.get());
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="StringValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MultiProperties"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties")})
    public void shouldReadWriteVertexMultiPropsNoEdgesToGraphSON() throws Exception {
        Vertex v1 = this.graph.addVertex(new Object[]{"name", "marko", "name", "mark", "acl", "rw"});
        v1.property(VertexProperty.Cardinality.single, "propsSquared", (Object)123, new Object[]{"x", "a", "y", "b"});
        Vertex v2 = this.graph.addVertex(new Object[0]);
        v1.addEdge("friends", v2, new Object[]{"weight", 0.5});
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GraphSONWriter writer = ((GraphSONIo)this.graph.io(this.graphson)).writer().create();
            writer.writeVertex((OutputStream)os, v1);
            AtomicBoolean called = new AtomicBoolean(false);
            GraphSONReader reader = ((GraphSONIo)this.graph.io(this.graphson)).reader().create();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readVertex((InputStream)bais, attachable -> {
                    Vertex detachedVertex = (Vertex)attachable.get();
                    Assert.assertEquals((Object)v1.id(), (Object)((Vertex)this.graph.vertices(new Object[]{detachedVertex.id().toString()}).next()).id());
                    Assert.assertEquals((Object)v1.label(), (Object)detachedVertex.label());
                    Assert.assertEquals((long)4L, (long)IteratorUtils.count((Iterator)detachedVertex.properties(new String[0])));
                    Assert.assertEquals((Object)"a", (Object)detachedVertex.property("propsSquared").value("x"));
                    Assert.assertEquals((Object)"b", (Object)detachedVertex.property("propsSquared").value("y"));
                    Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)detachedVertex.properties(new String[]{"name"})));
                    Assert.assertTrue((boolean)IteratorUtils.stream((Iterator)detachedVertex.properties(new String[]{"name"})).allMatch(p -> p.key().equals("name") && (p.value().equals("marko") || p.value().equals("mark"))));
                    Assert.assertEquals((Object)v1.value("acl"), (Object)detachedVertex.value("acl").toString());
                    called.set(true);
                    return (Vertex)Mockito.mock(Vertex.class);
                });
            }
            Assert.assertTrue((boolean)called.get());
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.CLASSIC)
    public void shouldReadWriteVerticesNoEdgesToGryoManual() throws Exception {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GryoWriter writer = ((GryoIo)this.graph.io(this.gryo)).writer().create();
            writer.writeVertices((OutputStream)os, (Iterator)this.g.V(new Object[0]).has("age", P.gt((Object)30)));
            AtomicInteger called = new AtomicInteger(0);
            GryoReader reader = ((GryoIo)this.graph.io(this.gryo)).reader().create();
            try (VertexByteArrayInputStream vbais = new VertexByteArrayInputStream((InputStream)new ByteArrayInputStream(os.toByteArray()));){
                byte[] y = vbais.readVertexBytes().toByteArray();
                reader.readVertex((InputStream)new ByteArrayInputStream(y), attachable -> {
                    Vertex detachedVertex = (Vertex)attachable.get();
                    called.incrementAndGet();
                    return detachedVertex;
                });
                byte[] z = vbais.readVertexBytes().toByteArray();
                reader.readVertex((InputStream)new ByteArrayInputStream(z), attachable -> {
                    Vertex detachedVertex = (Vertex)attachable.get();
                    called.incrementAndGet();
                    return detachedVertex;
                });
            }
            Assert.assertEquals((long)2L, (long)called.get());
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldReadWriteVerticesNoEdgesToGryo() throws Exception {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GryoWriter writer = ((GryoIo)this.graph.io(this.gryo)).writer().create();
            writer.writeVertices((OutputStream)os, (Iterator)this.g.V(new Object[0]).has("age", P.gt((Object)30)));
            AtomicInteger called = new AtomicInteger(0);
            GryoReader reader = ((GryoIo)this.graph.io(this.gryo)).reader().create();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                Iterator itty = reader.readVertices((InputStream)bais, attachable -> {
                    Vertex detachedVertex = (Vertex)attachable.get();
                    called.incrementAndGet();
                    return detachedVertex;
                }, null, null);
                Assert.assertNotNull(itty.next());
                Assert.assertNotNull(itty.next());
                Assert.assertFalse((boolean)itty.hasNext());
            }
            Assert.assertEquals((long)2L, (long)called.get());
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldReadWriteVerticesNoEdgesToGraphSON() throws Exception {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GraphSONWriter writer = ((GraphSONIo)this.graph.io(this.graphson)).writer().create();
            writer.writeVertices((OutputStream)os, (Iterator)this.g.V(new Object[0]).has("age", P.gt((Object)30)));
            AtomicInteger called = new AtomicInteger(0);
            GraphSONReader reader = ((GraphSONIo)this.graph.io(this.graphson)).reader().create();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                Iterator itty = reader.readVertices((InputStream)bais, attachable -> {
                    Vertex detachedVertex = (Vertex)attachable.get();
                    called.incrementAndGet();
                    return detachedVertex;
                }, null, null);
                Assert.assertNotNull(itty.next());
                Assert.assertNotNull(itty.next());
                Assert.assertFalse((boolean)itty.hasNext());
            }
            Assert.assertEquals((long)2L, (long)called.get());
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.CLASSIC)
    public void shouldReadWriteVerticesNoEdgesToGraphSONManual() throws Exception {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GraphSONWriter writer = ((GraphSONIo)this.graph.io(this.graphson)).writer().create();
            writer.writeVertices((OutputStream)os, (Iterator)this.g.V(new Object[0]).has("age", P.gt((Object)30)));
            AtomicInteger called = new AtomicInteger(0);
            GraphSONReader reader = ((GraphSONIo)this.graph.io(this.graphson)).reader().create();
            BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(os.toByteArray())));
            String line = br.readLine();
            reader.readVertex((InputStream)new ByteArrayInputStream(line.getBytes()), attachable -> {
                called.incrementAndGet();
                return (Vertex)Mockito.mock(Vertex.class);
            });
            line = br.readLine();
            reader.readVertex((InputStream)new ByteArrayInputStream(line.getBytes()), detachedVertex -> {
                called.incrementAndGet();
                return (Vertex)Mockito.mock(Vertex.class);
            });
            Assert.assertEquals((long)2L, (long)called.get());
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="StringValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")})
    public void shouldReadWriteVertexWithOUTEdgesToGryo() throws Exception {
        Vertex v1 = this.graph.addVertex(new Object[]{"name", "marko", T.label, "person"});
        Vertex v2 = this.graph.addVertex(new Object[]{T.label, "person"});
        Edge e = v1.addEdge("friends", v2, new Object[]{"weight", 0.5});
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GryoWriter writer = ((GryoIo)this.graph.io(this.gryo)).writer().create();
            writer.writeVertex((OutputStream)os, v1, Direction.OUT);
            AtomicBoolean calledVertex = new AtomicBoolean(false);
            AtomicBoolean calledEdge = new AtomicBoolean(false);
            GryoReader reader = ((GryoIo)this.graph.io(this.gryo)).reader().create();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readVertex((InputStream)bais, attachable -> {
                    Vertex detachedVertex = (Vertex)attachable.get();
                    TestHelper.validateVertexEquality(v1, detachedVertex, true);
                    calledVertex.set(true);
                    return detachedVertex;
                }, attachable -> {
                    Edge detachedEdge = (Edge)attachable.get();
                    TestHelper.validateEdgeEquality(e, detachedEdge);
                    calledEdge.set(true);
                    return detachedEdge;
                }, Direction.OUT);
            }
            Assert.assertTrue((boolean)calledVertex.get());
            Assert.assertTrue((boolean)calledEdge.get());
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="StringValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="FloatValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")})
    public void shouldReadWriteVertexWithOUTEdgesToGraphSON() throws Exception {
        Vertex v1 = this.graph.addVertex(new Object[]{"name", "marko", T.label, "person"});
        Vertex v2 = this.graph.addVertex(new Object[]{T.label, "person"});
        Edge e = v1.addEdge("friends", v2, new Object[]{"weight", Float.valueOf(0.5f)});
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GraphSONWriter writer = ((GraphSONIo)this.graph.io(this.graphson)).writer().create();
            writer.writeVertex((OutputStream)os, v1, Direction.OUT);
            AtomicBoolean calledVertex = new AtomicBoolean(false);
            AtomicBoolean calledEdge = new AtomicBoolean(false);
            GraphSONReader reader = ((GraphSONIo)this.graph.io(this.graphson)).reader().create();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readVertex((InputStream)bais, attachable -> {
                    Vertex detachedVertex = (Vertex)attachable.get();
                    Assert.assertEquals((Object)v1.id(), (Object)((Vertex)this.graph.vertices(new Object[]{detachedVertex.id().toString()}).next()).id());
                    Assert.assertEquals((Object)v1.label(), (Object)detachedVertex.label());
                    Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)detachedVertex.properties(new String[0])));
                    Assert.assertEquals((Object)"marko", (Object)detachedVertex.value("name"));
                    calledVertex.set(true);
                    return null;
                }, attachable -> {
                    Edge detachedEdge = (Edge)attachable.get();
                    Assert.assertEquals((Object)e.id(), (Object)((Edge)this.graph.edges(new Object[]{detachedEdge.id().toString()}).next()).id());
                    Assert.assertEquals((Object)v1.id(), (Object)((Vertex)this.graph.vertices(new Object[]{detachedEdge.outVertex().id().toString()}).next()).id());
                    Assert.assertEquals((Object)v2.id(), (Object)((Vertex)this.graph.vertices(new Object[]{detachedEdge.inVertex().id().toString()}).next()).id());
                    Assert.assertEquals((Object)v1.label(), (Object)detachedEdge.outVertex().label());
                    Assert.assertEquals((Object)e.label(), (Object)detachedEdge.label());
                    Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)detachedEdge.properties(new String[0])));
                    Assert.assertEquals((double)0.5, (double)((Double)detachedEdge.value("weight")), (double)1.0E-6);
                    calledEdge.set(true);
                    return null;
                }, Direction.OUT);
            }
            Assert.assertTrue((boolean)calledVertex.get());
            Assert.assertTrue((boolean)calledEdge.get());
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="StringValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")})
    public void shouldReadWriteVertexWithINEdgesToGryo() throws Exception {
        Vertex v1 = this.graph.addVertex(new Object[]{"name", "marko", T.label, "person"});
        Vertex v2 = this.graph.addVertex(new Object[]{T.label, "person"});
        Edge e = v2.addEdge("friends", v1, new Object[]{"weight", 0.5});
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GryoWriter writer = ((GryoIo)this.graph.io(this.gryo)).writer().create();
            writer.writeVertex((OutputStream)os, v1, Direction.IN);
            AtomicBoolean calledVertex = new AtomicBoolean(false);
            AtomicBoolean calledEdge = new AtomicBoolean(false);
            GryoReader reader = ((GryoIo)this.graph.io(this.gryo)).reader().create();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readVertex((InputStream)bais, attachable -> {
                    Vertex detachedVertex = (Vertex)attachable.get();
                    TestHelper.validateVertexEquality(v1, detachedVertex, true);
                    calledVertex.set(true);
                    return detachedVertex;
                }, attachable -> {
                    Edge detachedEdge = (Edge)attachable.get();
                    TestHelper.validateEdgeEquality(e, detachedEdge);
                    calledEdge.set(true);
                    return detachedEdge;
                }, Direction.IN);
            }
            Assert.assertTrue((boolean)calledVertex.get());
            Assert.assertTrue((boolean)calledEdge.get());
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="StringValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="FloatValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")})
    public void shouldReadWriteVertexWithINEdgesToGraphSON() throws Exception {
        Vertex v1 = this.graph.addVertex(new Object[]{"name", "marko", T.label, "person"});
        Vertex v2 = this.graph.addVertex(new Object[]{T.label, "person"});
        Edge e = v2.addEdge("friends", v1, new Object[]{"weight", Float.valueOf(0.5f)});
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GraphSONWriter writer = ((GraphSONIo)this.graph.io(this.graphson)).writer().create();
            writer.writeVertex((OutputStream)os, v1, Direction.IN);
            os.close();
            AtomicBoolean calledVertex = new AtomicBoolean(false);
            AtomicBoolean calledEdge = new AtomicBoolean(false);
            GraphSONReader reader = ((GraphSONIo)this.graph.io(this.graphson)).reader().create();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readVertex((InputStream)bais, attachable -> {
                    Vertex detachedVertex = (Vertex)attachable.get();
                    Assert.assertEquals((Object)v1.id(), (Object)((Vertex)this.graph.vertices(new Object[]{detachedVertex.id().toString()}).next()).id());
                    Assert.assertEquals((Object)v1.label(), (Object)detachedVertex.label());
                    Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)detachedVertex.properties(new String[0])));
                    Assert.assertEquals((Object)"marko", (Object)detachedVertex.value("name"));
                    calledVertex.set(true);
                    return null;
                }, attachable -> {
                    Edge detachedEdge = (Edge)attachable.get();
                    Assert.assertEquals((Object)e.id(), (Object)((Edge)this.graph.edges(new Object[]{detachedEdge.id().toString()}).next()).id());
                    Assert.assertEquals((Object)v1.id(), (Object)((Vertex)this.graph.vertices(new Object[]{detachedEdge.inVertex().id().toString()}).next()).id());
                    Assert.assertEquals((Object)v2.id(), (Object)((Vertex)this.graph.vertices(new Object[]{detachedEdge.outVertex().id().toString()}).next()).id());
                    Assert.assertEquals((Object)v2.label(), (Object)detachedEdge.inVertex().label());
                    Assert.assertEquals((Object)e.label(), (Object)detachedEdge.label());
                    Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)detachedEdge.properties(new String[0])));
                    Assert.assertEquals((double)0.5, (double)((Double)detachedEdge.value("weight")), (double)1.0E-6);
                    calledEdge.set(true);
                    return null;
                }, Direction.IN);
            }
            Assert.assertTrue((boolean)calledVertex.get());
            Assert.assertTrue((boolean)calledEdge.get());
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="StringValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")})
    public void shouldReadWriteVertexWithBOTHEdgesToGryo() throws Exception {
        Vertex v1 = this.graph.addVertex(new Object[]{"name", "marko", T.label, "person"});
        Vertex v2 = this.graph.addVertex(new Object[]{T.label, "person"});
        Edge e1 = v2.addEdge("friends", v1, new Object[]{"weight", 0.5});
        Edge e2 = v1.addEdge("friends", v2, new Object[]{"weight", 1.0});
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GryoWriter writer = ((GryoIo)this.graph.io(this.gryo)).writer().create();
            writer.writeVertex((OutputStream)os, v1, Direction.BOTH);
            AtomicBoolean calledVertex = new AtomicBoolean(false);
            AtomicBoolean calledEdge1 = new AtomicBoolean(false);
            AtomicBoolean calledEdge2 = new AtomicBoolean(false);
            GryoReader reader = ((GryoIo)this.graph.io(this.gryo)).reader().create();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readVertex((InputStream)bais, attachable -> {
                    Vertex detachedVertex = (Vertex)attachable.get();
                    TestHelper.validateVertexEquality(v1, detachedVertex, true);
                    calledVertex.set(true);
                    return detachedVertex;
                }, attachable -> {
                    Edge detachedEdge = (Edge)attachable.get();
                    if (detachedEdge.id().equals(e1.id())) {
                        TestHelper.validateEdgeEquality(e1, detachedEdge);
                        calledEdge1.set(true);
                    } else if (detachedEdge.id().equals(e2.id())) {
                        TestHelper.validateEdgeEquality(e2, detachedEdge);
                        calledEdge2.set(true);
                    } else {
                        Assert.fail((String)"An edge id generated that does not exist");
                    }
                    return null;
                }, Direction.BOTH);
            }
            Assert.assertTrue((boolean)calledVertex.get());
            Assert.assertTrue((boolean)calledEdge1.get());
            Assert.assertTrue((boolean)calledEdge2.get());
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="StringValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="FloatValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")})
    public void shouldReadWriteVertexWithBOTHEdgesToGraphSON() throws Exception {
        Vertex v1 = this.graph.addVertex(new Object[]{"name", "marko", T.label, "person"});
        Vertex v2 = this.graph.addVertex(new Object[]{T.label, "person"});
        Edge e1 = v2.addEdge("friends", v1, new Object[]{"weight", Float.valueOf(0.5f)});
        Edge e2 = v1.addEdge("friends", v2, new Object[]{"weight", Float.valueOf(1.0f)});
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GraphSONWriter writer = ((GraphSONIo)this.graph.io(this.graphson)).writer().create();
            writer.writeVertex((OutputStream)os, v1, Direction.BOTH);
            AtomicBoolean vertexCalled = new AtomicBoolean(false);
            AtomicBoolean edge1Called = new AtomicBoolean(false);
            AtomicBoolean edge2Called = new AtomicBoolean(false);
            GraphSONReader reader = ((GraphSONIo)this.graph.io(this.graphson)).reader().create();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readVertex((InputStream)bais, attachable -> {
                    Vertex detachedVertex = (Vertex)attachable.get();
                    Assert.assertEquals((Object)v1.id(), (Object)((Vertex)this.graph.vertices(new Object[]{detachedVertex.id().toString()}).next()).id());
                    Assert.assertEquals((Object)v1.label(), (Object)detachedVertex.label());
                    Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)detachedVertex.properties(new String[0])));
                    Assert.assertEquals((Object)"marko", (Object)detachedVertex.value("name"));
                    vertexCalled.set(true);
                    return null;
                }, attachable -> {
                    Edge detachedEdge = (Edge)attachable.get();
                    if (((Edge)this.graph.edges(new Object[]{detachedEdge.id().toString()}).next()).id().equals(e1.id())) {
                        Assert.assertEquals((Object)e1.id(), (Object)((Edge)this.graph.edges(new Object[]{detachedEdge.id().toString()}).next()).id());
                        Assert.assertEquals((Object)v1.id(), (Object)((Vertex)this.graph.vertices(new Object[]{detachedEdge.inVertex().id().toString()}).next()).id());
                        Assert.assertEquals((Object)v2.id(), (Object)((Vertex)this.graph.vertices(new Object[]{detachedEdge.outVertex().id().toString()}).next()).id());
                        Assert.assertEquals((Object)v2.label(), (Object)detachedEdge.inVertex().label());
                        Assert.assertEquals((Object)e1.label(), (Object)detachedEdge.label());
                        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)detachedEdge.properties(new String[0])));
                        Assert.assertEquals((double)0.5, (double)((Double)detachedEdge.value("weight")), (double)1.0E-6);
                        edge1Called.set(true);
                    } else if (((Edge)this.graph.edges(new Object[]{detachedEdge.id().toString()}).next()).id().equals(e2.id())) {
                        Assert.assertEquals((Object)e2.id(), (Object)((Edge)this.graph.edges(new Object[]{detachedEdge.id().toString()}).next()).id());
                        Assert.assertEquals((Object)v2.id(), (Object)((Vertex)this.graph.vertices(new Object[]{detachedEdge.inVertex().id().toString()}).next()).id());
                        Assert.assertEquals((Object)v1.id(), (Object)((Vertex)this.graph.vertices(new Object[]{detachedEdge.outVertex().id().toString()}).next()).id());
                        Assert.assertEquals((Object)v1.label(), (Object)detachedEdge.outVertex().label());
                        Assert.assertEquals((Object)e2.label(), (Object)detachedEdge.label());
                        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)detachedEdge.properties(new String[0])));
                        Assert.assertEquals((double)1.0, (double)((Double)detachedEdge.value("weight")), (double)1.0E-6);
                        edge2Called.set(true);
                    } else {
                        Assert.fail((String)"An edge id generated that does not exist");
                    }
                    return null;
                }, Direction.BOTH);
            }
            Assert.assertTrue((boolean)vertexCalled.get());
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="StringValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="FloatValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")})
    public void shouldReadWriteVertexWithBOTHEdgesToGraphSONWithTypes() throws Exception {
        Vertex v1 = this.graph.addVertex(new Object[]{"name", "marko", T.label, "person"});
        Vertex v2 = this.graph.addVertex(new Object[]{T.label, "person"});
        Edge e1 = v2.addEdge("friends", v1, new Object[]{"weight", Float.valueOf(0.5f)});
        Edge e2 = v1.addEdge("friends", v2, new Object[]{"weight", Float.valueOf(1.0f)});
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GraphSONWriter writer = ((GraphSONIo)this.graph.io(this.graphson)).writer().mapper(((GraphSONIo)this.graph.io(this.graphson)).mapper().embedTypes(true).create()).create();
            writer.writeVertex((OutputStream)os, v1, Direction.BOTH);
            AtomicBoolean vertexCalled = new AtomicBoolean(false);
            AtomicBoolean edge1Called = new AtomicBoolean(false);
            AtomicBoolean edge2Called = new AtomicBoolean(false);
            GraphSONReader reader = ((GraphSONIo)this.graph.io(this.graphson)).reader().mapper(((GraphSONIo)this.graph.io(this.graphson)).mapper().embedTypes(true).create()).create();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readVertex((InputStream)bais, attachable -> {
                    Vertex detachedVertex = (Vertex)attachable.get();
                    Assert.assertEquals((Object)v1.id(), (Object)((Vertex)this.graph.vertices(new Object[]{detachedVertex.id()}).next()).id());
                    Assert.assertEquals((Object)v1.label(), (Object)detachedVertex.label());
                    Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)detachedVertex.properties(new String[0])));
                    Assert.assertEquals((Object)v1.value("name"), (Object)detachedVertex.value("name").toString());
                    vertexCalled.set(true);
                    return null;
                }, attachable -> {
                    Edge detachedEdge = (Edge)attachable.get();
                    if (((Edge)this.graph.edges(new Object[]{detachedEdge.id()}).next()).id().equals(e1.id())) {
                        Assert.assertEquals((Object)v2.id(), (Object)((Vertex)this.graph.vertices(new Object[]{detachedEdge.outVertex().id()}).next()).id());
                        Assert.assertEquals((Object)v1.id(), (Object)((Vertex)this.graph.vertices(new Object[]{detachedEdge.inVertex().id()}).next()).id());
                        Assert.assertEquals((Object)v2.label(), (Object)detachedEdge.inVertex().label());
                        Assert.assertEquals((Object)e1.label(), (Object)detachedEdge.label());
                        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)detachedEdge.properties(new String[0])));
                        Assert.assertEquals((float)0.5f, (float)((Float)detachedEdge.value("weight")).floatValue(), (float)1.0E-5f);
                        edge1Called.set(true);
                    } else if (((Edge)this.graph.edges(new Object[]{detachedEdge.id()}).next()).id().equals(e2.id())) {
                        Assert.assertEquals((Object)v1.id(), (Object)((Vertex)this.graph.vertices(new Object[]{detachedEdge.outVertex().id()}).next()).id());
                        Assert.assertEquals((Object)v2.id(), (Object)((Vertex)this.graph.vertices(new Object[]{detachedEdge.inVertex().id()}).next()).id());
                        Assert.assertEquals((Object)v1.label(), (Object)detachedEdge.outVertex().label());
                        Assert.assertEquals((Object)e1.label(), (Object)detachedEdge.label());
                        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)detachedEdge.properties(new String[0])));
                        Assert.assertEquals((float)1.0f, (float)((Float)detachedEdge.value("weight")).floatValue(), (float)1.0E-5f);
                        edge2Called.set(true);
                    } else {
                        Assert.fail((String)"An edge id generated that does not exist");
                    }
                    return null;
                }, Direction.BOTH);
            }
            Assert.assertTrue((boolean)vertexCalled.get());
            Assert.assertTrue((boolean)edge1Called.get());
            Assert.assertTrue((boolean)edge2Called.get());
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="StringValues"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="FloatValues")})
    public void shouldReadLegacyGraphSON() throws IOException {
        LegacyGraphSONReader reader = LegacyGraphSONReader.build().create();
        try (InputStream stream = IoTest.class.getResourceAsStream(TestHelper.convertPackageToResourcePath(GraphSONResourceAccess.class) + "tinkerpop-classic-legacy.json");){
            reader.readGraph(stream, this.graph);
        }
        IoTest.assertClassicGraph(this.graph, false, true);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldReadWritePropertyGraphSON() throws Exception {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GraphSONWriter writer = ((GraphSONIo)this.graph.io(this.graphson)).writer().create();
            Property p = ((Edge)this.g.E(new Object[]{this.convertToEdgeId("marko", "knows", "vadas")}).next()).property("weight");
            writer.writeProperty((OutputStream)os, p);
            AtomicBoolean called = new AtomicBoolean(false);
            GraphSONReader reader = ((GraphSONIo)this.graph.io(this.graphson)).reader().create();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readProperty((InputStream)bais, propertyAttachable -> {
                    Assert.assertEquals((Object)p.value(), (Object)((Property)propertyAttachable.get()).value());
                    Assert.assertEquals((Object)p.key(), (Object)((Property)propertyAttachable.get()).key());
                    called.set(true);
                    return (Property)propertyAttachable.get();
                });
            }
            Assert.assertTrue((boolean)called.get());
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldReadWriteVertexPropertyNoMetaPropertiesGraphSON() throws Exception {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GraphSONWriter writer = ((GraphSONIo)this.graph.io(this.graphson)).writer().create();
            VertexProperty p = ((Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next()).property("name");
            writer.writeVertexProperty((OutputStream)os, p);
            AtomicBoolean called = new AtomicBoolean(false);
            GraphSONReader reader = ((GraphSONIo)this.graph.io(this.graphson)).reader().create();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readVertexProperty((InputStream)bais, propertyAttachable -> {
                    Assert.assertEquals((Object)p.value(), (Object)((VertexProperty)propertyAttachable.get()).value());
                    Assert.assertEquals((Object)p.key(), (Object)((VertexProperty)propertyAttachable.get()).key());
                    Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)((VertexProperty)propertyAttachable.get()).properties(new String[0])));
                    called.set(true);
                    return (VertexProperty)propertyAttachable.get();
                });
            }
            Assert.assertTrue((boolean)called.get());
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.CREW)
    public void shouldReadWriteVertexPropertyWithMetaPropertiesGraphSON() throws Exception {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GraphSONWriter writer = ((GraphSONIo)this.graph.io(this.graphson)).writer().create();
            VertexProperty p = (VertexProperty)((Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next()).properties(new String[]{"location"}).next();
            writer.writeVertexProperty((OutputStream)os, p);
            AtomicBoolean called = new AtomicBoolean(false);
            GraphSONReader reader = ((GraphSONIo)this.graph.io(this.graphson)).reader().create();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readVertexProperty((InputStream)bais, propertyAttachable -> {
                    Assert.assertEquals((Object)p.value(), (Object)((VertexProperty)propertyAttachable.get()).value());
                    Assert.assertEquals((Object)p.key(), (Object)((VertexProperty)propertyAttachable.get()).key());
                    Assert.assertEquals((long)IteratorUtils.count((Iterator)p.properties(new String[0])), (long)IteratorUtils.count((Iterator)((VertexProperty)propertyAttachable.get()).properties(new String[0])));
                    Assert.assertEquals((Object)p.property("startTime").value(), (Object)((Property)((VertexProperty)propertyAttachable.get()).properties(new String[]{"startTime"}).next()).value());
                    Assert.assertEquals((Object)p.property("endTime").value(), (Object)((Property)((VertexProperty)propertyAttachable.get()).properties(new String[]{"endTime"}).next()).value());
                    called.set(true);
                    return (VertexProperty)propertyAttachable.get();
                });
            }
            Assert.assertTrue((boolean)called.get());
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldReadWritePropertyGryo() throws Exception {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GryoWriter writer = ((GryoIo)this.graph.io(this.gryo)).writer().create();
            Property p = ((Edge)this.g.E(new Object[]{this.convertToEdgeId("marko", "knows", "vadas")}).next()).property("weight");
            writer.writeProperty((OutputStream)os, p);
            AtomicBoolean called = new AtomicBoolean(false);
            GryoReader reader = ((GryoIo)this.graph.io(this.gryo)).reader().create();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readProperty((InputStream)bais, propertyAttachable -> {
                    Assert.assertEquals((Object)p.value(), (Object)((Property)propertyAttachable.get()).value());
                    Assert.assertEquals((Object)p.key(), (Object)((Property)propertyAttachable.get()).key());
                    called.set(true);
                    return (Property)propertyAttachable.get();
                });
            }
            Assert.assertTrue((boolean)called.get());
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldReadWriteVertexPropertyNoMetaPropertiesGryo() throws Exception {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GryoWriter writer = ((GryoIo)this.graph.io(this.gryo)).writer().create();
            VertexProperty p = ((Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next()).property("name");
            writer.writeVertexProperty((OutputStream)os, p);
            AtomicBoolean called = new AtomicBoolean(false);
            GryoReader reader = ((GryoIo)this.graph.io(this.gryo)).reader().create();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readVertexProperty((InputStream)bais, propertyAttachable -> {
                    Assert.assertEquals((Object)p.value(), (Object)((VertexProperty)propertyAttachable.get()).value());
                    Assert.assertEquals((Object)p.key(), (Object)((VertexProperty)propertyAttachable.get()).key());
                    Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)((VertexProperty)propertyAttachable.get()).properties(new String[0])));
                    called.set(true);
                    return (VertexProperty)propertyAttachable.get();
                });
            }
            Assert.assertTrue((boolean)called.get());
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.CREW)
    public void shouldReadWriteVertexPropertyWithMetaPropertiesGryo() throws Exception {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GryoWriter writer = ((GryoIo)this.graph.io(this.gryo)).writer().create();
            VertexProperty p = (VertexProperty)((Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next()).properties(new String[]{"location"}).next();
            writer.writeVertexProperty((OutputStream)os, p);
            AtomicBoolean called = new AtomicBoolean(false);
            GryoReader reader = ((GryoIo)this.graph.io(this.gryo)).reader().create();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readVertexProperty((InputStream)bais, propertyAttachable -> {
                    Assert.assertEquals((Object)p.value(), (Object)((VertexProperty)propertyAttachable.get()).value());
                    Assert.assertEquals((Object)p.key(), (Object)((VertexProperty)propertyAttachable.get()).key());
                    Assert.assertEquals((long)IteratorUtils.count((Iterator)p.properties(new String[0])), (long)IteratorUtils.count((Iterator)((VertexProperty)propertyAttachable.get()).properties(new String[0])));
                    Assert.assertEquals((Object)p.property("startTime").value(), (Object)((Property)((VertexProperty)propertyAttachable.get()).properties(new String[]{"startTime"}).next()).value());
                    Assert.assertEquals((Object)p.property("endTime").value(), (Object)((Property)((VertexProperty)propertyAttachable.get()).properties(new String[]{"endTime"}).next()).value());
                    called.set(true);
                    return (VertexProperty)propertyAttachable.get();
                });
            }
            Assert.assertTrue((boolean)called.get());
        }
    }

    public static void assertCrewGraph(Graph g1, boolean lossyForId) {
        Assert.assertEquals((Object)new Long(6L), (Object)g1.traversal().V(new Object[0]).count().next());
        Assert.assertEquals((Object)new Long(14L), (Object)g1.traversal().E(new Object[0]).count().next());
        Vertex v1 = (Vertex)g1.traversal().V(new Object[0]).has("name", (Object)"marko").next();
        Assert.assertEquals((Object)"person", (Object)v1.label());
        Assert.assertEquals((long)2L, (long)v1.keys().size());
        Assert.assertEquals((long)4L, (long)((int)IteratorUtils.count((Iterator)v1.properties(new String[]{"location"}))));
        v1.properties(new String[]{"location"}).forEachRemaining(vp -> {
            if (vp.value().equals("san diego")) {
                Assert.assertEquals((long)1997L, (long)((Integer)vp.value("startTime")).intValue());
                Assert.assertEquals((long)2001L, (long)((Integer)vp.value("endTime")).intValue());
                Assert.assertEquals((long)2L, (long)((int)IteratorUtils.count((Iterator)vp.properties(new String[0]))));
            } else if (vp.value().equals("santa cruz")) {
                Assert.assertEquals((long)2001L, (long)((Integer)vp.value("startTime")).intValue());
                Assert.assertEquals((long)2004L, (long)((Integer)vp.value("endTime")).intValue());
                Assert.assertEquals((long)2L, (long)((int)IteratorUtils.count((Iterator)vp.properties(new String[0]))));
            } else if (vp.value().equals("brussels")) {
                Assert.assertEquals((long)2004L, (long)((Integer)vp.value("startTime")).intValue());
                Assert.assertEquals((long)2005L, (long)((Integer)vp.value("endTime")).intValue());
                Assert.assertEquals((long)2L, (long)((int)IteratorUtils.count((Iterator)vp.properties(new String[0]))));
            } else if (vp.value().equals("santa fe")) {
                Assert.assertEquals((long)2005L, (long)((Integer)vp.value("startTime")).intValue());
                Assert.assertEquals((long)1L, (long)((int)IteratorUtils.count((Iterator)vp.properties(new String[0]))));
            } else {
                Assert.fail((String)"Found a value that should be there");
            }
        });
        IoTest.assertId(g1, lossyForId, (Element)v1, 1);
        List v1Edges = IteratorUtils.list((Iterator)v1.edges(Direction.BOTH, new String[0]));
        Assert.assertEquals((long)4L, (long)v1Edges.size());
        v1Edges.forEach(e -> {
            if (e.inVertex().value("name").equals("gremlin") && e.label().equals("develops")) {
                Assert.assertEquals((long)2009L, (long)((Integer)e.value("since")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 13);
            } else if (e.inVertex().value("name").equals("tinkergraph") && e.label().equals("develops")) {
                Assert.assertEquals((long)2010L, (long)((Integer)e.value("since")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 14);
            } else if (e.inVertex().value("name").equals("gremlin") && e.label().equals("uses")) {
                Assert.assertEquals((long)4L, (long)((Integer)e.value("skill")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 15);
            } else if (e.inVertex().value("name").equals("tinkergraph") && e.label().equals("uses")) {
                Assert.assertEquals((long)5L, (long)((Integer)e.value("skill")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 16);
            } else {
                Assert.fail((String)"Edge not expected");
            }
        });
        Vertex v7 = (Vertex)g1.traversal().V(new Object[0]).has("name", (Object)"stephen").next();
        Assert.assertEquals((Object)"person", (Object)v7.label());
        Assert.assertEquals((long)2L, (long)v7.keys().size());
        Assert.assertEquals((long)3L, (long)((int)IteratorUtils.count((Iterator)v7.properties(new String[]{"location"}))));
        v7.properties(new String[]{"location"}).forEachRemaining(vp -> {
            if (vp.value().equals("centreville")) {
                Assert.assertEquals((long)1990L, (long)((Integer)vp.value("startTime")).intValue());
                Assert.assertEquals((long)2000L, (long)((Integer)vp.value("endTime")).intValue());
                Assert.assertEquals((long)2L, (long)((int)IteratorUtils.count((Iterator)vp.properties(new String[0]))));
            } else if (vp.value().equals("dulles")) {
                Assert.assertEquals((long)2000L, (long)((Integer)vp.value("startTime")).intValue());
                Assert.assertEquals((long)2006L, (long)((Integer)vp.value("endTime")).intValue());
                Assert.assertEquals((long)2L, (long)((int)IteratorUtils.count((Iterator)vp.properties(new String[0]))));
            } else if (vp.value().equals("purcellville")) {
                Assert.assertEquals((long)2006L, (long)((Integer)vp.value("startTime")).intValue());
                Assert.assertEquals((long)1L, (long)((int)IteratorUtils.count((Iterator)vp.properties(new String[0]))));
            } else {
                Assert.fail((String)"Found a value that should be there");
            }
        });
        IoTest.assertId(g1, lossyForId, (Element)v7, 7);
        List v7Edges = IteratorUtils.list((Iterator)v7.edges(Direction.BOTH, new String[0]));
        Assert.assertEquals((long)4L, (long)v7Edges.size());
        v7Edges.forEach(e -> {
            if (e.inVertex().value("name").equals("gremlin") && e.label().equals("develops")) {
                Assert.assertEquals((long)2010L, (long)((Integer)e.value("since")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 17);
            } else if (e.inVertex().value("name").equals("tinkergraph") && e.label().equals("develops")) {
                Assert.assertEquals((long)2011L, (long)((Integer)e.value("since")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 18);
            } else if (e.inVertex().value("name").equals("gremlin") && e.label().equals("uses")) {
                Assert.assertEquals((long)5L, (long)((Integer)e.value("skill")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 19);
            } else if (e.inVertex().value("name").equals("tinkergraph") && e.label().equals("uses")) {
                Assert.assertEquals((long)4L, (long)((Integer)e.value("skill")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 20);
            } else {
                Assert.fail((String)"Edge not expected");
            }
        });
        Vertex v8 = (Vertex)g1.traversal().V(new Object[0]).has("name", (Object)"matthias").next();
        Assert.assertEquals((Object)"person", (Object)v8.label());
        Assert.assertEquals((long)2L, (long)v8.keys().size());
        Assert.assertEquals((long)4L, (long)((int)IteratorUtils.count((Iterator)v8.properties(new String[]{"location"}))));
        v8.properties(new String[]{"location"}).forEachRemaining(vp -> {
            if (vp.value().equals("bremen")) {
                Assert.assertEquals((long)2004L, (long)((Integer)vp.value("startTime")).intValue());
                Assert.assertEquals((long)2007L, (long)((Integer)vp.value("endTime")).intValue());
                Assert.assertEquals((long)2L, (long)((int)IteratorUtils.count((Iterator)vp.properties(new String[0]))));
            } else if (vp.value().equals("baltimore")) {
                Assert.assertEquals((long)2007L, (long)((Integer)vp.value("startTime")).intValue());
                Assert.assertEquals((long)2011L, (long)((Integer)vp.value("endTime")).intValue());
                Assert.assertEquals((long)2L, (long)((int)IteratorUtils.count((Iterator)vp.properties(new String[0]))));
            } else if (vp.value().equals("oakland")) {
                Assert.assertEquals((long)2011L, (long)((Integer)vp.value("startTime")).intValue());
                Assert.assertEquals((long)2014L, (long)((Integer)vp.value("endTime")).intValue());
                Assert.assertEquals((long)2L, (long)((int)IteratorUtils.count((Iterator)vp.properties(new String[0]))));
            } else if (vp.value().equals("seattle")) {
                Assert.assertEquals((long)2014L, (long)((Integer)vp.value("startTime")).intValue());
                Assert.assertEquals((long)1L, (long)((int)IteratorUtils.count((Iterator)vp.properties(new String[0]))));
            } else {
                Assert.fail((String)"Found a value that should be there");
            }
        });
        IoTest.assertId(g1, lossyForId, (Element)v8, 8);
        List v8Edges = IteratorUtils.list((Iterator)v8.edges(Direction.BOTH, new String[0]));
        Assert.assertEquals((long)3L, (long)v8Edges.size());
        v8Edges.forEach(e -> {
            if (e.inVertex().value("name").equals("gremlin") && e.label().equals("develops")) {
                Assert.assertEquals((long)2012L, (long)((Integer)e.value("since")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 21);
            } else if (e.inVertex().value("name").equals("gremlin") && e.label().equals("uses")) {
                Assert.assertEquals((long)3L, (long)((Integer)e.value("skill")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 22);
            } else if (e.inVertex().value("name").equals("tinkergraph") && e.label().equals("uses")) {
                Assert.assertEquals((long)3L, (long)((Integer)e.value("skill")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 23);
            } else {
                Assert.fail((String)"Edge not expected");
            }
        });
        Vertex v9 = (Vertex)g1.traversal().V(new Object[0]).has("name", (Object)"daniel").next();
        Assert.assertEquals((Object)"person", (Object)v9.label());
        Assert.assertEquals((long)2L, (long)v9.keys().size());
        Assert.assertEquals((long)3L, (long)((int)IteratorUtils.count((Iterator)v9.properties(new String[]{"location"}))));
        v9.properties(new String[]{"location"}).forEachRemaining(vp -> {
            if (vp.value().equals("spremberg")) {
                Assert.assertEquals((long)1982L, (long)((Integer)vp.value("startTime")).intValue());
                Assert.assertEquals((long)2005L, (long)((Integer)vp.value("endTime")).intValue());
                Assert.assertEquals((long)2L, (long)((int)IteratorUtils.count((Iterator)vp.properties(new String[0]))));
            } else if (vp.value().equals("kaiserslautern")) {
                Assert.assertEquals((long)2005L, (long)((Integer)vp.value("startTime")).intValue());
                Assert.assertEquals((long)2009L, (long)((Integer)vp.value("endTime")).intValue());
                Assert.assertEquals((long)2L, (long)((int)IteratorUtils.count((Iterator)vp.properties(new String[0]))));
            } else if (vp.value().equals("aachen")) {
                Assert.assertEquals((long)2009L, (long)((Integer)vp.value("startTime")).intValue());
                Assert.assertEquals((long)1L, (long)((int)IteratorUtils.count((Iterator)vp.properties(new String[0]))));
            } else {
                Assert.fail((String)"Found a value that should be there");
            }
        });
        IoTest.assertId(g1, lossyForId, (Element)v9, 9);
        List v9Edges = IteratorUtils.list((Iterator)v9.edges(Direction.BOTH, new String[0]));
        Assert.assertEquals((long)2L, (long)v9Edges.size());
        v9Edges.forEach(e -> {
            if (e.inVertex().value("name").equals("gremlin") && e.label().equals("uses")) {
                Assert.assertEquals((long)5L, (long)((Integer)e.value("skill")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 24);
            } else if (e.inVertex().value("name").equals("tinkergraph") && e.label().equals("uses")) {
                Assert.assertEquals((long)3L, (long)((Integer)e.value("skill")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 25);
            } else {
                Assert.fail((String)"Edge not expected");
            }
        });
        Vertex v10 = (Vertex)g1.traversal().V(new Object[0]).has("name", (Object)"gremlin").next();
        Assert.assertEquals((Object)"software", (Object)v10.label());
        Assert.assertEquals((long)1L, (long)v10.keys().size());
        IoTest.assertId(g1, lossyForId, (Element)v10, 10);
        List v10Edges = IteratorUtils.list((Iterator)v10.edges(Direction.BOTH, new String[0]));
        Assert.assertEquals((long)8L, (long)v10Edges.size());
        v10Edges.forEach(e -> {
            if (e.outVertex().value("name").equals("marko") && e.label().equals("develops")) {
                Assert.assertEquals((long)2009L, (long)((Integer)e.value("since")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 13);
            } else if (e.outVertex().value("name").equals("marko") && e.label().equals("uses")) {
                Assert.assertEquals((long)4L, (long)((Integer)e.value("skill")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 15);
            } else if (e.outVertex().value("name").equals("stephen") && e.label().equals("develops")) {
                Assert.assertEquals((long)2010L, (long)((Integer)e.value("since")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 17);
            } else if (e.outVertex().value("name").equals("stephen") && e.label().equals("uses")) {
                Assert.assertEquals((long)5L, (long)((Integer)e.value("skill")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 19);
            } else if (e.outVertex().value("name").equals("matthias") && e.label().equals("develops")) {
                Assert.assertEquals((long)2012L, (long)((Integer)e.value("since")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 21);
            } else if (e.outVertex().value("name").equals("matthias") && e.label().equals("uses")) {
                Assert.assertEquals((long)3L, (long)((Integer)e.value("skill")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 22);
            } else if (e.outVertex().value("name").equals("daniel") && e.label().equals("uses")) {
                Assert.assertEquals((long)5L, (long)((Integer)e.value("skill")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 24);
            } else if (e.inVertex().value("name").equals("tinkergraph") && e.label().equals("traverses")) {
                Assert.assertEquals((long)0L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 26);
            } else {
                Assert.fail((String)"Edge not expected");
            }
        });
        Vertex v11 = (Vertex)g1.traversal().V(new Object[0]).has("name", (Object)"tinkergraph").next();
        Assert.assertEquals((Object)"software", (Object)v11.label());
        Assert.assertEquals((long)1L, (long)v11.keys().size());
        IoTest.assertId(g1, lossyForId, (Element)v11, 11);
        List v11Edges = IteratorUtils.list((Iterator)v11.edges(Direction.BOTH, new String[0]));
        Assert.assertEquals((long)7L, (long)v11Edges.size());
        v11Edges.forEach(e -> {
            if (e.outVertex().value("name").equals("marko") && e.label().equals("develops")) {
                Assert.assertEquals((long)2010L, (long)((Integer)e.value("since")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 14);
            } else if (e.outVertex().value("name").equals("marko") && e.label().equals("uses")) {
                Assert.assertEquals((long)5L, (long)((Integer)e.value("skill")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 16);
            } else if (e.outVertex().value("name").equals("stephen") && e.label().equals("develops")) {
                Assert.assertEquals((long)2011L, (long)((Integer)e.value("since")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 18);
            } else if (e.outVertex().value("name").equals("stephen") && e.label().equals("uses")) {
                Assert.assertEquals((long)4L, (long)((Integer)e.value("skill")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 20);
            } else if (e.outVertex().value("name").equals("matthias") && e.label().equals("uses")) {
                Assert.assertEquals((long)3L, (long)((Integer)e.value("skill")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 23);
            } else if (e.outVertex().value("name").equals("daniel") && e.label().equals("uses")) {
                Assert.assertEquals((long)3L, (long)((Integer)e.value("skill")).intValue());
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 25);
            } else if (e.outVertex().value("name").equals("gremlin") && e.label().equals("traverses")) {
                Assert.assertEquals((long)0L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 26);
            } else {
                Assert.fail((String)"Edge not expected");
            }
        });
    }

    public static void assertClassicGraph(Graph g1, boolean assertDouble, boolean lossyForId) {
        IoTest.assertToyGraph(g1, assertDouble, lossyForId, false);
    }

    public static void assertModernGraph(Graph g1, boolean assertDouble, boolean lossyForId) {
        IoTest.assertToyGraph(g1, assertDouble, lossyForId, true);
    }

    private static void assertToyGraph(Graph g1, boolean assertDouble, boolean lossyForId, boolean assertSpecificLabel) {
        Assert.assertEquals((long)6L, (long)IteratorUtils.count((Iterator)g1.vertices(new Object[0])));
        Assert.assertEquals((long)6L, (long)IteratorUtils.count((Iterator)g1.edges(new Object[0])));
        Vertex v1 = (Vertex)g1.traversal().V(new Object[0]).has("name", (Object)"marko").next();
        Assert.assertEquals((long)29L, (long)((Integer)v1.value("age")).intValue());
        Assert.assertEquals((long)2L, (long)v1.keys().size());
        Assert.assertEquals((Object)(assertSpecificLabel ? "person" : "vertex"), (Object)v1.label());
        IoTest.assertId(g1, lossyForId, (Element)v1, 1);
        List v1Edges = IteratorUtils.list((Iterator)v1.edges(Direction.BOTH, new String[0]));
        Assert.assertEquals((long)3L, (long)v1Edges.size());
        v1Edges.forEach(e -> {
            if (e.inVertex().value("name").equals("vadas")) {
                Assert.assertEquals((Object)"knows", (Object)e.label());
                if (assertDouble) {
                    Assert.assertEquals((double)0.5, (double)((Double)e.value("weight")), (double)1.0E-4);
                } else {
                    Assert.assertEquals((float)0.5f, (float)((Float)e.value("weight")).floatValue(), (float)1.0E-4f);
                }
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 7);
            } else if (e.inVertex().value("name").equals("josh")) {
                Assert.assertEquals((Object)"knows", (Object)e.label());
                if (assertDouble) {
                    Assert.assertEquals((double)1.0, (double)((Double)e.value("weight")), (double)1.0E-4);
                } else {
                    Assert.assertEquals((float)1.0f, (float)((Float)e.value("weight")).floatValue(), (float)1.0E-4f);
                }
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 8);
            } else if (e.inVertex().value("name").equals("lop")) {
                Assert.assertEquals((Object)"created", (Object)e.label());
                if (assertDouble) {
                    Assert.assertEquals((double)0.4, (double)((Double)e.value("weight")), (double)1.0E-4);
                } else {
                    Assert.assertEquals((float)0.4f, (float)((Float)e.value("weight")).floatValue(), (float)1.0E-4f);
                }
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 9);
            } else {
                Assert.fail((String)"Edge not expected");
            }
        });
        Vertex v2 = (Vertex)g1.traversal().V(new Object[0]).has("name", (Object)"vadas").next();
        Assert.assertEquals((long)27L, (long)((Integer)v2.value("age")).intValue());
        Assert.assertEquals((long)2L, (long)v2.keys().size());
        Assert.assertEquals((Object)(assertSpecificLabel ? "person" : "vertex"), (Object)v2.label());
        IoTest.assertId(g1, lossyForId, (Element)v2, 2);
        List v2Edges = IteratorUtils.list((Iterator)v2.edges(Direction.BOTH, new String[0]));
        Assert.assertEquals((long)1L, (long)v2Edges.size());
        v2Edges.forEach(e -> {
            if (e.outVertex().value("name").equals("marko")) {
                Assert.assertEquals((Object)"knows", (Object)e.label());
                if (assertDouble) {
                    Assert.assertEquals((double)0.5, (double)((Double)e.value("weight")), (double)1.0E-4);
                } else {
                    Assert.assertEquals((float)0.5f, (float)((Float)e.value("weight")).floatValue(), (float)1.0E-4f);
                }
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 7);
            } else {
                Assert.fail((String)"Edge not expected");
            }
        });
        Vertex v3 = (Vertex)g1.traversal().V(new Object[0]).has("name", (Object)"lop").next();
        Assert.assertEquals((Object)"java", (Object)v3.value("lang"));
        Assert.assertEquals((long)2L, (long)v2.keys().size());
        Assert.assertEquals((Object)(assertSpecificLabel ? "software" : "vertex"), (Object)v3.label());
        IoTest.assertId(g1, lossyForId, (Element)v3, 3);
        List v3Edges = IteratorUtils.list((Iterator)v3.edges(Direction.BOTH, new String[0]));
        Assert.assertEquals((long)3L, (long)v3Edges.size());
        v3Edges.forEach(e -> {
            if (e.outVertex().value("name").equals("peter")) {
                Assert.assertEquals((Object)"created", (Object)e.label());
                if (assertDouble) {
                    Assert.assertEquals((double)0.2, (double)((Double)e.value("weight")), (double)1.0E-4);
                } else {
                    Assert.assertEquals((float)0.2f, (float)((Float)e.value("weight")).floatValue(), (float)1.0E-4f);
                }
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 12);
            } else if (e.outVertex().value("name").equals("josh")) {
                Assert.assertEquals((Object)"created", (Object)e.label());
                if (assertDouble) {
                    Assert.assertEquals((double)0.4, (double)((Double)e.value("weight")), (double)1.0E-4);
                } else {
                    Assert.assertEquals((float)0.4f, (float)((Float)e.value("weight")).floatValue(), (float)1.0E-4f);
                }
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 11);
            } else if (e.outVertex().value("name").equals("marko")) {
                Assert.assertEquals((Object)"created", (Object)e.label());
                if (assertDouble) {
                    Assert.assertEquals((double)0.4, (double)((Double)e.value("weight")), (double)1.0E-4);
                } else {
                    Assert.assertEquals((float)0.4f, (float)((Float)e.value("weight")).floatValue(), (float)1.0E-4f);
                }
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 9);
            } else {
                Assert.fail((String)"Edge not expected");
            }
        });
        Vertex v4 = (Vertex)g1.traversal().V(new Object[0]).has("name", (Object)"josh").next();
        Assert.assertEquals((long)32L, (long)((Integer)v4.value("age")).intValue());
        Assert.assertEquals((long)2L, (long)v4.keys().size());
        Assert.assertEquals((Object)(assertSpecificLabel ? "person" : "vertex"), (Object)v4.label());
        IoTest.assertId(g1, lossyForId, (Element)v4, 4);
        List v4Edges = IteratorUtils.list((Iterator)v4.edges(Direction.BOTH, new String[0]));
        Assert.assertEquals((long)3L, (long)v4Edges.size());
        v4Edges.forEach(e -> {
            if (e.inVertex().value("name").equals("ripple")) {
                Assert.assertEquals((Object)"created", (Object)e.label());
                if (assertDouble) {
                    Assert.assertEquals((double)1.0, (double)((Double)e.value("weight")), (double)1.0E-4);
                } else {
                    Assert.assertEquals((float)1.0f, (float)((Float)e.value("weight")).floatValue(), (float)1.0E-4f);
                }
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 10);
            } else if (e.inVertex().value("name").equals("lop")) {
                Assert.assertEquals((Object)"created", (Object)e.label());
                if (assertDouble) {
                    Assert.assertEquals((double)0.4, (double)((Double)e.value("weight")), (double)1.0E-4);
                } else {
                    Assert.assertEquals((float)0.4f, (float)((Float)e.value("weight")).floatValue(), (float)1.0E-4f);
                }
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 11);
            } else if (e.outVertex().value("name").equals("marko")) {
                Assert.assertEquals((Object)"knows", (Object)e.label());
                if (assertDouble) {
                    Assert.assertEquals((double)1.0, (double)((Double)e.value("weight")), (double)1.0E-4);
                } else {
                    Assert.assertEquals((float)1.0f, (float)((Float)e.value("weight")).floatValue(), (float)1.0E-4f);
                }
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 8);
            } else {
                Assert.fail((String)"Edge not expected");
            }
        });
        Vertex v5 = (Vertex)g1.traversal().V(new Object[0]).has("name", (Object)"ripple").next();
        Assert.assertEquals((Object)"java", (Object)v5.value("lang"));
        Assert.assertEquals((long)2L, (long)v5.keys().size());
        Assert.assertEquals((Object)(assertSpecificLabel ? "software" : "vertex"), (Object)v5.label());
        IoTest.assertId(g1, lossyForId, (Element)v5, 5);
        List v5Edges = IteratorUtils.list((Iterator)v5.edges(Direction.BOTH, new String[0]));
        Assert.assertEquals((long)1L, (long)v5Edges.size());
        v5Edges.forEach(e -> {
            if (e.outVertex().value("name").equals("josh")) {
                Assert.assertEquals((Object)"created", (Object)e.label());
                if (assertDouble) {
                    Assert.assertEquals((double)1.0, (double)((Double)e.value("weight")), (double)1.0E-4);
                } else {
                    Assert.assertEquals((float)1.0f, (float)((Float)e.value("weight")).floatValue(), (float)1.0E-4f);
                }
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 10);
            } else {
                Assert.fail((String)"Edge not expected");
            }
        });
        Vertex v6 = (Vertex)g1.traversal().V(new Object[0]).has("name", (Object)"peter").next();
        Assert.assertEquals((long)35L, (long)((Integer)v6.value("age")).intValue());
        Assert.assertEquals((long)2L, (long)v6.keys().size());
        Assert.assertEquals((Object)(assertSpecificLabel ? "person" : "vertex"), (Object)v6.label());
        IoTest.assertId(g1, lossyForId, (Element)v6, 6);
        List v6Edges = IteratorUtils.list((Iterator)v6.edges(Direction.BOTH, new String[0]));
        Assert.assertEquals((long)1L, (long)v6Edges.size());
        v6Edges.forEach(e -> {
            if (e.inVertex().value("name").equals("lop")) {
                Assert.assertEquals((Object)"created", (Object)e.label());
                if (assertDouble) {
                    Assert.assertEquals((double)0.2, (double)((Double)e.value("weight")), (double)1.0E-4);
                } else {
                    Assert.assertEquals((float)0.2f, (float)((Float)e.value("weight")).floatValue(), (float)1.0E-4f);
                }
                Assert.assertEquals((long)1L, (long)e.keys().size());
                IoTest.assertId(g1, lossyForId, (Element)e, 12);
            } else {
                Assert.fail((String)"Edge not expected");
            }
        });
    }

    private static void assertId(Graph g, boolean lossyForId, Element e, Object expected) {
        if (g.features().edge().supportsUserSuppliedIds()) {
            if (lossyForId) {
                Assert.assertEquals((Object)expected.toString(), (Object)e.id().toString());
            } else {
                Assert.assertEquals((Object)expected, (Object)e.id());
            }
        }
    }

    private void validateXmlAgainstGraphMLXsd(File file) throws Exception {
        StreamSource xmlFile = new StreamSource(file);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(IoTest.class.getResource(TestHelper.convertPackageToResourcePath(GraphMLResourceAccess.class) + "graphml-1.1.xsd"));
        Validator validator = schema.newValidator();
        validator.validate(xmlFile);
    }

    private static void readGraphMLIntoGraph(Graph g, String file) throws IOException {
        GraphMLReader reader = GraphMLReader.build().create();
        try (InputStream stream = IoTest.class.getResourceAsStream(TestHelper.convertPackageToResourcePath(GraphMLResourceAccess.class) + file);){
            reader.readGraph(stream, g);
        }
    }

    private String streamToString(InputStream in) throws IOException {
        StringWriter writer = new StringWriter();
        char[] buffer = new char[1024];
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));){
            int n;
            while ((n = reader.read(buffer)) != -1) {
                ((Writer)writer).write(buffer, 0, n);
            }
        }
        return ((Object)writer).toString();
    }

    private /* synthetic */ Edge lambda$shouldReadWriteDetachedEdgeToGraphSON$70(Edge edge, Vertex vertex, Vertex vertex2, AtomicBoolean atomicBoolean, Attachable edge2) {
        Edge detachedEdge = (Edge)edge2;
        Assert.assertEquals((Object)edge.id(), (Object)((Edge)this.graph.edges(new Object[]{detachedEdge.id().toString()}).next()).id());
        Assert.assertEquals((Object)vertex.id(), (Object)((Vertex)this.graph.vertices(new Object[]{detachedEdge.outVertex().id().toString()}).next()).id());
        Assert.assertEquals((Object)vertex2.id(), (Object)((Vertex)this.graph.vertices(new Object[]{detachedEdge.inVertex().id().toString()}).next()).id());
        Assert.assertEquals((Object)vertex.label(), (Object)detachedEdge.outVertex().label());
        Assert.assertEquals((Object)vertex2.label(), (Object)detachedEdge.inVertex().label());
        Assert.assertEquals((Object)edge.label(), (Object)detachedEdge.label());
        Assert.assertEquals((Object)0.5, (Object)((Property)detachedEdge.properties(new String[]{"weight"}).next()).value());
        Assert.assertEquals((Object)"rw", (Object)((Property)detachedEdge.properties(new String[]{"acl"}).next()).value());
        atomicBoolean.set(true);
        return null;
    }

    private /* synthetic */ Edge lambda$shouldReadWriteDetachedEdgeAsReferenceToGraphSON$69(Edge edge, Vertex vertex, Vertex vertex2, AtomicBoolean atomicBoolean, Attachable edge2) {
        Edge detachedEdge = (Edge)edge2;
        Assert.assertEquals((Object)edge.id(), (Object)((Edge)this.graph.edges(new Object[]{detachedEdge.id().toString()}).next()).id());
        Assert.assertEquals((Object)vertex.id(), (Object)((Vertex)this.graph.vertices(new Object[]{detachedEdge.outVertex().id().toString()}).next()).id());
        Assert.assertEquals((Object)vertex2.id(), (Object)((Vertex)this.graph.vertices(new Object[]{detachedEdge.inVertex().id().toString()}).next()).id());
        Assert.assertEquals((Object)vertex.label(), (Object)detachedEdge.outVertex().label());
        Assert.assertEquals((Object)vertex2.label(), (Object)detachedEdge.inVertex().label());
        Assert.assertEquals((Object)edge.label(), (Object)detachedEdge.label());
        Assert.assertEquals((long)edge.keys().size(), (long)IteratorUtils.count((Iterator)detachedEdge.properties(new String[0])));
        atomicBoolean.set(true);
        return null;
    }

    private static /* synthetic */ Edge lambda$shouldReadWriteDetachedEdgeToGryo$67(Edge edge, Vertex vertex, Vertex vertex2, AtomicBoolean atomicBoolean, Attachable edge2) {
        Edge detachedEdge = (Edge)edge2;
        Assert.assertEquals((Object)edge.id(), (Object)detachedEdge.id());
        Assert.assertEquals((Object)vertex.id(), (Object)detachedEdge.outVertex().id());
        Assert.assertEquals((Object)vertex2.id(), (Object)detachedEdge.inVertex().id());
        Assert.assertEquals((Object)vertex.label(), (Object)detachedEdge.outVertex().label());
        Assert.assertEquals((Object)vertex2.label(), (Object)detachedEdge.inVertex().label());
        Assert.assertEquals((Object)edge.label(), (Object)detachedEdge.label());
        Assert.assertEquals((Object)0.5, (Object)((Property)detachedEdge.properties(new String[]{"weight"}).next()).value());
        Assert.assertEquals((Object)"rw", (Object)((Property)detachedEdge.properties(new String[]{"acl"}).next()).value());
        atomicBoolean.set(true);
        return null;
    }

    private static /* synthetic */ Edge lambda$shouldReadWriteDetachedEdgeAsReferenceToGryo$66(Edge edge, Vertex vertex, Vertex vertex2, AtomicBoolean atomicBoolean, Attachable edge2) {
        Edge detachedEdge = (Edge)edge2;
        Assert.assertEquals((Object)edge.id(), (Object)detachedEdge.id());
        Assert.assertEquals((Object)vertex.id(), (Object)detachedEdge.outVertex().id());
        Assert.assertEquals((Object)vertex2.id(), (Object)detachedEdge.inVertex().id());
        Assert.assertEquals((Object)vertex.label(), (Object)detachedEdge.outVertex().label());
        Assert.assertEquals((Object)vertex2.label(), (Object)detachedEdge.inVertex().label());
        Assert.assertEquals((Object)edge.label(), (Object)detachedEdge.label());
        Assert.assertEquals((long)edge.keys().size(), (long)IteratorUtils.count((Iterator)detachedEdge.properties(new String[0])));
        atomicBoolean.set(true);
        return null;
    }

    public static class CustomId {
        private String cluster;
        private UUID elementId;

        private CustomId() {
        }

        public CustomId(String cluster, UUID elementId) {
            this.cluster = cluster;
            this.elementId = elementId;
        }

        public String getCluster() {
            return this.cluster;
        }

        public UUID getElementId() {
            return this.elementId;
        }

        public String toString() {
            return this.cluster + ":" + this.elementId;
        }

        static class CustomIdJacksonSerializer
        extends StdSerializer<CustomId> {
            public CustomIdJacksonSerializer() {
                super(CustomId.class);
            }

            public void serialize(CustomId customId, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
                jsonGenerator.writeString(customId.toString());
            }

            public void serializeWithType(CustomId customId, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonProcessingException {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeStringField("@class", CustomId.class.getName());
                jsonGenerator.writeStringField("cluster", customId.getCluster());
                jsonGenerator.writeObjectField("elementId", (Object)customId.getElementId());
                jsonGenerator.writeEndObject();
            }
        }
    }
}

