/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.util.GraphFactory;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.junit.Assert;
import org.junit.Test;

public class GraphConstructionTest
extends AbstractGremlinTest {
    @Test
    public void shouldOpenGraphThroughGraphFactoryViaApacheConfig() throws Exception {
        Graph expectedGraph = this.graph;
        Configuration c = this.graphProvider.newGraphConfiguration("temp1", this.getClass(), this.name.getMethodName(), null);
        Graph createdGraph = GraphFactory.open((Configuration)c);
        Assert.assertNotNull((Object)createdGraph);
        Assert.assertEquals(expectedGraph.getClass(), createdGraph.getClass());
        this.graphProvider.clear(createdGraph, c);
    }

    @Test
    public void shouldConstructAnEmptyGraph() {
        GraphConstructionTest.assertVertexEdgeCounts(0, 0).accept(this.graph);
    }

    @Test
    public void shouldMaintainOriginalConfigurationObjectGivenToFactory() {
        Configuration originalConfig = this.graphProvider.newGraphConfiguration("temp2", this.getClass(), this.name.getMethodName(), null);
        Graph createdGraph = GraphFactory.open((Configuration)originalConfig);
        Configuration configInGraph = createdGraph.configuration();
        AtomicInteger keyCount = new AtomicInteger(0);
        originalConfig.getKeys().forEachRemaining(k -> {
            Assert.assertTrue((boolean)configInGraph.containsKey(k));
            keyCount.incrementAndGet();
        });
        Assert.assertTrue((keyCount.get() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)keyCount.get(), (long)IteratorUtils.count((Iterator)configInGraph.getKeys()));
    }
}

