/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.GremlinProcessRunner;
import org.apache.tinkerpop.gremlin.process.IgnoreEngine;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalEngine;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.step.Profiling;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.FlatMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.ProfileStep;
import org.apache.tinkerpop.gremlin.process.traversal.util.Metrics;
import org.apache.tinkerpop.gremlin.process.traversal.util.MutableMetrics;
import org.apache.tinkerpop.gremlin.process.traversal.util.StandardTraversalMetrics;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalMetrics;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GremlinProcessRunner.class)
public abstract class ProfileTest
extends AbstractGremlinProcessTest {
    public abstract Traversal<Vertex, StandardTraversalMetrics> get_g_V_out_out_profile();

    public abstract Traversal<Vertex, StandardTraversalMetrics> get_g_V_repeat_both_profile();

    public abstract Traversal<Vertex, StandardTraversalMetrics> get_g_V_sideEffectXThread_sleepX10XX_sideEffectXThread_sleepX5XX_profile();

    public abstract Traversal<Vertex, StandardTraversalMetrics> get_g_V_whereXinXcreatedX_count_isX1XX_valuesXnameX_profile();

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_out_out_profile_simple() {
        Traversal<Vertex, StandardTraversalMetrics> traversal = this.get_g_V_out_out_profile();
        this.printTraversalForm(traversal);
        traversal.iterate();
        TraversalMetrics traversalMetrics = (TraversalMetrics)traversal.asAdmin().getSideEffects().get(TraversalMetrics.METRICS_KEY).get();
        traversalMetrics.toString();
        List steps = traversal.asAdmin().getSteps();
        for (int ii = 1; ii < steps.size(); ii += 2) {
            Assert.assertEquals((String)"Every other Step should be a ProfileStep.", ProfileStep.class, ((Step)steps.get(ii)).getClass());
        }
        Metrics metrics = traversalMetrics.getMetrics(traversalMetrics.getMetrics().size() - 1);
        Assert.assertEquals((long)2L, (long)metrics.getCount("elementCount"));
        Assert.assertNotEquals((long)0L, (long)metrics.getCount("traverserCount"));
        Assert.assertTrue((String)"Percent duration should be positive.", ((Double)metrics.getAnnotation("percentDur") > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Times should be positive.", (metrics.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        double totalPercentDuration = 0.0;
        for (Metrics m : traversalMetrics.getMetrics()) {
            totalPercentDuration += ((Double)m.getAnnotation("percentDur")).doubleValue();
        }
        Assert.assertEquals((double)100.0, (double)totalPercentDuration, (double)1.0E-6);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_out_out_profile_modern() {
        Traversal<Vertex, StandardTraversalMetrics> traversal = this.get_g_V_out_out_profile();
        this.printTraversalForm(traversal);
        traversal.iterate();
        TraversalMetrics traversalMetrics = (TraversalMetrics)traversal.asAdmin().getSideEffects().get(TraversalMetrics.METRICS_KEY).get();
        traversalMetrics.toString();
        Metrics metrics = traversalMetrics.getMetrics(0);
        Assert.assertEquals((long)6L, (long)metrics.getCount("traverserCount"));
        Assert.assertEquals((long)6L, (long)metrics.getCount("elementCount"));
        Assert.assertTrue((String)"Percent duration should be positive.", ((Double)metrics.getAnnotation("percentDur") > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Times should be positive.", (metrics.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        metrics = traversalMetrics.getMetrics(1);
        Assert.assertEquals((long)6L, (long)metrics.getCount("elementCount"));
        Assert.assertNotEquals((long)0L, (long)metrics.getCount("traverserCount"));
        Assert.assertTrue((String)"Percent duration should be positive.", ((Double)metrics.getAnnotation("percentDur") > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Times should be positive.", (metrics.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        metrics = traversalMetrics.getMetrics(2);
        Assert.assertEquals((long)2L, (long)metrics.getCount("elementCount"));
        Assert.assertNotEquals((long)0L, (long)metrics.getCount("traverserCount"));
        Assert.assertTrue((String)"Percent duration should be positive.", ((Double)metrics.getAnnotation("percentDur") > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Times should be positive.", (metrics.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        double totalPercentDuration = 0.0;
        for (Metrics m : traversalMetrics.getMetrics()) {
            totalPercentDuration += ((Double)m.getAnnotation("percentDur")).doubleValue();
        }
        Assert.assertEquals((double)100.0, (double)totalPercentDuration, (double)1.0E-6);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.GRATEFUL)
    public void g_V_out_out_profile_grateful() {
        Traversal<Vertex, StandardTraversalMetrics> traversal = this.get_g_V_out_out_profile();
        this.printTraversalForm(traversal);
        traversal.iterate();
        TraversalMetrics traversalMetrics = (TraversalMetrics)traversal.asAdmin().getSideEffects().get(TraversalMetrics.METRICS_KEY).get();
        traversalMetrics.toString();
        Metrics metrics = traversalMetrics.getMetrics(0);
        Assert.assertEquals((long)808L, (long)metrics.getCount("traverserCount"));
        Assert.assertEquals((long)808L, (long)metrics.getCount("elementCount"));
        Assert.assertTrue((String)"Percent duration should be positive.", ((Double)metrics.getAnnotation("percentDur") > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Times should be positive.", (metrics.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        metrics = traversalMetrics.getMetrics(1);
        Assert.assertEquals((long)8049L, (long)metrics.getCount("elementCount"));
        Assert.assertNotEquals((long)0L, (long)metrics.getCount("traverserCount"));
        Assert.assertTrue((String)"Percent duration should be positive.", ((Double)metrics.getAnnotation("percentDur") > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Times should be positive.", (metrics.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        metrics = traversalMetrics.getMetrics(2);
        Assert.assertEquals((long)327370L, (long)metrics.getCount("elementCount"));
        Assert.assertNotEquals((long)0L, (long)metrics.getCount("traverserCount"));
        Assert.assertTrue((String)"Percent duration should be positive.", ((Double)metrics.getAnnotation("percentDur") > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Times should be positive.", (metrics.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        double totalPercentDuration = 0.0;
        for (Metrics m : traversalMetrics.getMetrics()) {
            totalPercentDuration += ((Double)m.getAnnotation("percentDur")).doubleValue();
        }
        Assert.assertEquals((double)100.0, (double)totalPercentDuration, (double)1.0E-6);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @IgnoreEngine(value=TraversalEngine.Type.COMPUTER)
    public void g_V_sideEffectXThread_sleepX10XX_sideEffectXThread_sleepX5XX_profile() {
        Traversal<Vertex, StandardTraversalMetrics> traversal = this.get_g_V_sideEffectXThread_sleepX10XX_sideEffectXThread_sleepX5XX_profile();
        this.printTraversalForm(traversal);
        traversal.iterate();
        Assert.assertEquals((String)"There should be 6 steps in this traversal (counting injected profile steps).", (long)6L, (long)traversal.asAdmin().getSteps().size());
        TraversalMetrics traversalMetrics = (TraversalMetrics)traversal.asAdmin().getSideEffects().get(TraversalMetrics.METRICS_KEY).get();
        traversalMetrics.toString();
        Metrics metrics = traversalMetrics.getMetrics(1);
        Assert.assertTrue((String)("Duration should be at least the length of the sleep (59ms): " + metrics.getDuration(TimeUnit.MILLISECONDS)), (metrics.getDuration(TimeUnit.MILLISECONDS) >= 59L ? 1 : 0) != 0);
        Assert.assertTrue((String)("Check that duration is within tolerant range: " + metrics.getDuration(TimeUnit.MILLISECONDS)), (metrics.getDuration(TimeUnit.MILLISECONDS) < 100L ? 1 : 0) != 0);
        metrics = traversalMetrics.getMetrics(2);
        Assert.assertTrue((String)("Duration should be at least the length of the sleep (29ms): " + metrics.getDuration(TimeUnit.MILLISECONDS)), (metrics.getDuration(TimeUnit.MILLISECONDS) >= 29L ? 1 : 0) != 0);
        Assert.assertTrue((String)("Check that duration is within tolerant range: " + metrics.getDuration(TimeUnit.MILLISECONDS)), (metrics.getDuration(TimeUnit.MILLISECONDS) < 100L ? 1 : 0) != 0);
        double totalPercentDuration = 0.0;
        for (Metrics m : traversalMetrics.getMetrics()) {
            totalPercentDuration += ((Double)m.getAnnotation("percentDur")).doubleValue();
        }
        Assert.assertEquals((double)100.0, (double)totalPercentDuration, (double)1.0E-6);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @IgnoreEngine(value=TraversalEngine.Type.COMPUTER)
    public void g_V_repeat_both_modern_profile() {
        Traversal<Vertex, StandardTraversalMetrics> traversal = this.get_g_V_repeat_both_profile();
        this.printTraversalForm(traversal);
        traversal.iterate();
        TraversalMetrics traversalMetrics = (TraversalMetrics)traversal.asAdmin().getSideEffects().get(TraversalMetrics.METRICS_KEY).get();
        traversalMetrics.toString();
        Metrics metrics = traversalMetrics.getMetrics(0);
        Assert.assertEquals((long)6L, (long)metrics.getCount("traverserCount"));
        Assert.assertEquals((long)6L, (long)metrics.getCount("elementCount"));
        Assert.assertTrue((String)"Percent duration should be positive.", ((Double)metrics.getAnnotation("percentDur") > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Times should be positive.", (metrics.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        metrics = traversalMetrics.getMetrics(1);
        Assert.assertEquals((long)72L, (long)metrics.getCount("elementCount"));
        Assert.assertNotEquals((long)0L, (long)metrics.getCount("traverserCount"));
        Assert.assertTrue((String)"Count should be greater than traversers.", (metrics.getCount("elementCount") > metrics.getCount("traverserCount") ? 1 : 0) != 0);
        Assert.assertTrue((String)"Percent duration should be positive.", ((Double)metrics.getAnnotation("percentDur") > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Times should be positive.", (metrics.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        Metrics vertexStepNestedInRepeat = (Metrics)metrics.getNested().toArray()[0];
        Assert.assertEquals((long)114L, (long)vertexStepNestedInRepeat.getCount("elementCount"));
        Assert.assertNotEquals((long)0L, (long)vertexStepNestedInRepeat.getCount("traverserCount"));
        Assert.assertTrue((String)"Count should be greater than traversers.", (vertexStepNestedInRepeat.getCount("elementCount") > vertexStepNestedInRepeat.getCount("traverserCount") ? 1 : 0) != 0);
        Assert.assertTrue((String)"Times should be positive.", (vertexStepNestedInRepeat.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        Metrics repeatEndStepNestedInRepeat = (Metrics)metrics.getNested().toArray()[1];
        Assert.assertEquals((long)72L, (long)repeatEndStepNestedInRepeat.getCount("elementCount"));
        Assert.assertNotEquals((long)0L, (long)repeatEndStepNestedInRepeat.getCount("traverserCount"));
        Assert.assertTrue((String)"Count should be greater than traversers.", (repeatEndStepNestedInRepeat.getCount("elementCount") > repeatEndStepNestedInRepeat.getCount("traverserCount") ? 1 : 0) != 0);
        Assert.assertTrue((String)"Times should be positive.", (repeatEndStepNestedInRepeat.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        double totalPercentDuration = 0.0;
        for (Metrics m : traversalMetrics.getMetrics()) {
            totalPercentDuration += ((Double)m.getAnnotation("percentDur")).doubleValue();
        }
        Assert.assertEquals((double)100.0, (double)totalPercentDuration, (double)1.0E-6);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXinXcreatedX_count_isX1XX_valuesXnameX_profile() {
        Traversal<Vertex, StandardTraversalMetrics> traversal = this.get_g_V_whereXinXcreatedX_count_isX1XX_valuesXnameX_profile();
        this.printTraversalForm(traversal);
        traversal.iterate();
        TraversalMetrics traversalMetrics = (TraversalMetrics)traversal.asAdmin().getSideEffects().get(TraversalMetrics.METRICS_KEY).get();
        traversalMetrics.toString();
        Assert.assertEquals((String)"There should be 3 top-level metrics.", (long)3L, (long)traversalMetrics.getMetrics().size());
        Metrics metrics = traversalMetrics.getMetrics(0);
        Assert.assertEquals((long)6L, (long)metrics.getCount("traverserCount"));
        Assert.assertEquals((long)6L, (long)metrics.getCount("elementCount"));
        metrics = traversalMetrics.getMetrics(1);
        Assert.assertEquals((long)1L, (long)metrics.getCount("traverserCount"));
        Assert.assertEquals((long)1L, (long)metrics.getCount("elementCount"));
        Assert.assertEquals((String)"Metrics 1 should have 3 nested metrics.", (long)3L, (long)metrics.getNested().size());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void testProfileStrategyCallback() {
        Traversal<Vertex, StandardTraversalMetrics> t = this.get_g_V_out_out_profile();
        MockStep mockStep = new MockStep(t.asAdmin());
        t.asAdmin().addStep(3, (Step)mockStep);
        t.iterate();
        Assert.assertTrue((boolean)MockStep.callbackCalled);
    }

    public static class Traversals
    extends ProfileTest {
        @Override
        public Traversal<Vertex, StandardTraversalMetrics> get_g_V_out_out_profile() {
            return this.g.V(new Object[0]).out(new String[0]).out(new String[0]).profile();
        }

        @Override
        public Traversal<Vertex, StandardTraversalMetrics> get_g_V_repeat_both_profile() {
            return this.g.V(new Object[0]).repeat((Traversal)__.both((String[])new String[0])).times(3).profile();
        }

        @Override
        public Traversal<Vertex, StandardTraversalMetrics> get_g_V_sideEffectXThread_sleepX10XX_sideEffectXThread_sleepX5XX_profile() {
            return this.g.V(new Object[0]).sideEffect(v -> {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }).sideEffect(v -> {
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }).profile();
        }

        @Override
        public Traversal<Vertex, StandardTraversalMetrics> get_g_V_whereXinXcreatedX_count_isX1XX_valuesXnameX_profile() {
            return this.g.V(new Object[0]).where((Traversal)__.in((String[])new String[]{"created"}).count().is((Object)1L)).values(new String[]{"name"}).profile();
        }
    }

    public static class MockStep
    extends FlatMapStep<Vertex, Vertex>
    implements Profiling {
        public static boolean callbackCalled = false;

        public MockStep(Traversal.Admin traversal) {
            super(traversal);
        }

        protected Iterator<Vertex> flatMap(Traverser.Admin<Vertex> traverser) {
            ArrayList<Object> l = new ArrayList<Object>();
            l.add(traverser.get());
            return l.iterator();
        }

        public void setMetrics(MutableMetrics parentMetrics) {
            if (parentMetrics != null) {
                callbackCalled = true;
            }
        }
    }
}

