/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.filter;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.GremlinProcessRunner;
import org.apache.tinkerpop.gremlin.process.traversal.Scope;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GremlinProcessRunner.class)
public abstract class DedupTest
extends AbstractGremlinProcessTest {
    public abstract Traversal<Vertex, String> get_g_V_both_dedup_name();

    public abstract Traversal<Vertex, String> get_g_V_both_hasXlabel_softwareX_dedup_byXlangX_name();

    public abstract Traversal<Vertex, String> get_g_V_both_name_orderXa_bX_dedup();

    public abstract Traversal<Vertex, String> get_g_V_both_both_name_dedup();

    public abstract Traversal<Vertex, Vertex> get_g_V_both_both_dedup();

    public abstract Traversal<Vertex, Vertex> get_g_V_both_both_dedup_byXlabelX();

    public abstract Traversal<Vertex, Map<String, Set<Double>>> get_g_V_group_byXlabelX_byXbothE_valuesXweightX_foldX_byXdedupXlocalXX();

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_both_dedup_name() {
        Traversal<Vertex, String> traversal = this.get_g_V_both_dedup_name();
        this.printTraversalForm(traversal);
        List names = traversal.toList();
        Assert.assertEquals((long)6L, (long)names.size());
        Assert.assertTrue((boolean)names.contains("marko"));
        Assert.assertTrue((boolean)names.contains("vadas"));
        Assert.assertTrue((boolean)names.contains("lop"));
        Assert.assertTrue((boolean)names.contains("josh"));
        Assert.assertTrue((boolean)names.contains("ripple"));
        Assert.assertTrue((boolean)names.contains("peter"));
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_both_hasXlabel_softwareX_dedup_byXlangX_name() {
        Traversal<Vertex, String> traversal = this.get_g_V_both_hasXlabel_softwareX_dedup_byXlangX_name();
        this.printTraversalForm(traversal);
        List names = traversal.toList();
        Assert.assertEquals((long)1L, (long)names.size());
        Assert.assertTrue((names.contains("lop") || names.contains("ripple") ? 1 : 0) != 0);
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_both_name_orderXa_bX_dedup() {
        Traversal<Vertex, String> traversal = this.get_g_V_both_name_orderXa_bX_dedup();
        this.printTraversalForm(traversal);
        List names = traversal.toList();
        Assert.assertEquals((long)6L, (long)names.size());
        Assert.assertEquals((Object)"josh", names.get(0));
        Assert.assertEquals((Object)"lop", names.get(1));
        Assert.assertEquals((Object)"marko", names.get(2));
        Assert.assertEquals((Object)"peter", names.get(3));
        Assert.assertEquals((Object)"ripple", names.get(4));
        Assert.assertEquals((Object)"vadas", names.get(5));
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_both_both_name_dedup() {
        Traversal<Vertex, String> traversal = this.get_g_V_both_both_name_dedup();
        this.printTraversalForm(traversal);
        DedupTest.checkResults(Arrays.asList("marko", "vadas", "josh", "peter", "lop", "ripple"), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_both_both_dedup() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_both_both_dedup();
        this.printTraversalForm(traversal);
        DedupTest.checkResults(Arrays.asList(this.convertToVertex(this.graph, "marko"), this.convertToVertex(this.graph, "vadas"), this.convertToVertex(this.graph, "josh"), this.convertToVertex(this.graph, "peter"), this.convertToVertex(this.graph, "lop"), this.convertToVertex(this.graph, "ripple")), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_both_both_dedup_byXlabelX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_both_both_dedup_byXlabelX();
        this.printTraversalForm(traversal);
        List vertices = traversal.toList();
        Assert.assertEquals((long)2L, (long)vertices.size());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_group_byXlabelX_byXbothE_valuesXweightX_foldX_byXdedupXlocalXX() {
        Traversal<Vertex, Map<String, Set<Double>>> traversal = this.get_g_V_group_byXlabelX_byXbothE_valuesXweightX_foldX_byXdedupXlocalXX();
        this.printTraversalForm(traversal);
        Assert.assertTrue((boolean)traversal.hasNext());
        Map map = (Map)traversal.next();
        Assert.assertFalse((boolean)traversal.hasNext());
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((long)3L, (long)((Set)map.get("software")).size());
        Assert.assertEquals((long)4L, (long)((Set)map.get("person")).size());
        Assert.assertEquals(new HashSet<Double>(Arrays.asList(0.2, 0.4, 1.0)), map.get("software"));
        Assert.assertEquals(new HashSet<Double>(Arrays.asList(0.2, 0.4, 0.5, 1.0)), map.get("person"));
    }

    public static class Traversals
    extends DedupTest {
        @Override
        public Traversal<Vertex, String> get_g_V_both_dedup_name() {
            return this.g.V(new Object[0]).both(new String[0]).dedup().values(new String[]{"name"});
        }

        @Override
        public Traversal<Vertex, String> get_g_V_both_hasXlabel_softwareX_dedup_byXlangX_name() {
            return this.g.V(new Object[0]).both(new String[0]).has(T.label, (Object)"software").dedup().by("lang").values(new String[]{"name"});
        }

        @Override
        public Traversal<Vertex, String> get_g_V_both_name_orderXa_bX_dedup() {
            return this.g.V(new Object[0]).both(new String[0]).properties(new String[]{"name"}).order().by((a, b) -> ((String)a.value()).compareTo((String)b.value())).dedup().value();
        }

        @Override
        public Traversal<Vertex, String> get_g_V_both_both_name_dedup() {
            return this.g.V(new Object[0]).both(new String[0]).both(new String[0]).values(new String[]{"name"}).dedup();
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_both_both_dedup() {
            return this.g.V(new Object[0]).both(new String[0]).both(new String[0]).dedup();
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_both_both_dedup_byXlabelX() {
            return this.g.V(new Object[0]).both(new String[0]).both(new String[0]).dedup().by(T.label);
        }

        @Override
        public Traversal<Vertex, Map<String, Set<Double>>> get_g_V_group_byXlabelX_byXbothE_valuesXweightX_foldX_byXdedupXlocalXX() {
            return this.g.V(new Object[0]).group().by(T.label).by((Traversal)__.bothE((String[])new String[0]).values(new String[]{"weight"}).fold()).by((Traversal)__.dedup((Scope)Scope.local));
        }
    }
}

