/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.ExceptionCoverage;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.FeatureRequirementSet;
import org.apache.tinkerpop.gremlin.FeatureRequirements;
import org.apache.tinkerpop.gremlin.GraphManager;
import org.apache.tinkerpop.gremlin.GraphProvider;
import org.apache.tinkerpop.gremlin.process.traversal.T;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.IoTest;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.util.StreamFactory;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

@ExceptionCoverage(exceptionClass=Graph.Exceptions.class, methods={"vertexWithIdAlreadyExists", "elementNotFound"})
public class GraphTest
extends AbstractGremlinTest {
    @Test
    public void shouldImplementAndExposeFeatures() {
        Graph.Features features = this.graph.features();
        Assert.assertNotNull((Object)features);
        AtomicInteger counter = new AtomicInteger(0);
        List<Method> methods = Arrays.asList(features.getClass().getMethods()).stream().filter(m -> Graph.Features.FeatureSet.class.isAssignableFrom(m.getReturnType())).collect(Collectors.toList());
        methods.forEach(m -> {
            try {
                Assert.assertNotNull((Object)m.invoke((Object)features, new Object[0]));
                counter.incrementAndGet();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Assert.fail((String)"Exception while dynamically checking compliance on Feature implementation");
            }
        });
        Assert.assertTrue((methods.size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)methods.size(), (long)counter.get());
    }

    @Test
    public void shouldHaveExceptionConsistencyWhenFindVertexByIdThatIsNonExistentViaIterator() {
        try {
            this.graph.vertices(new Object[]{10000L}).next();
            Assert.fail((String)"Call to g.V(10000l) should throw an exception");
        }
        catch (Exception ex) {
            Assert.assertThat((Object)ex, (Matcher)CoreMatchers.instanceOf(Graph.Exceptions.elementNotFound(Vertex.class, (Object)10000L).getClass()));
        }
    }

    @Test
    public void shouldHaveExceptionConsistencyWhenFindEdgeByIdThatIsNonExistentViaIterator() {
        try {
            this.graph.edges(new Object[]{10000L}).next();
            Assert.fail((String)"Call to g.E(10000l) should throw an exception");
        }
        catch (Exception ex) {
            Assert.assertThat((Object)ex, (Matcher)CoreMatchers.instanceOf(Graph.Exceptions.elementNotFound(Edge.class, (Object)10000L).getClass()));
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds")})
    public void shouldHaveExceptionConsistencyWhenAssigningSameIdOnVertex() {
        Object o = GraphManager.getGraphProvider().convertId("1");
        this.graph.addVertex(new Object[]{T.id, o});
        try {
            this.graph.addVertex(new Object[]{T.id, o});
            Assert.fail((String)"Assigning the same ID to an Element should throw an exception");
        }
        catch (Exception ex) {
            Assert.assertThat((Object)ex, (Matcher)CoreMatchers.instanceOf(Graph.Exceptions.vertexWithIdAlreadyExists((Object)0).getClass()));
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="NumericIds")})
    public void shouldAddVertexWithUserSuppliedNumericId() {
        this.graph.addVertex(new Object[]{T.id, 1000L});
        this.tryCommit(this.graph, graph -> {
            Vertex v = (Vertex)graph.vertices(new Object[]{1000L}).next();
            Assert.assertEquals((Object)1000L, (Object)v.id());
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="StringIds")})
    public void shouldAddVertexWithUserSuppliedStringId() {
        this.graph.addVertex(new Object[]{T.id, "1000"});
        this.tryCommit(this.graph, graph -> {
            Vertex v = (Vertex)graph.vertices(new Object[]{"1000"}).next();
            Assert.assertEquals((Object)"1000", (Object)v.id());
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UuidIds")})
    public void shouldAddVertexWithUserSuppliedUuidId() {
        UUID uuid = UUID.randomUUID();
        this.graph.addVertex(new Object[]{T.id, uuid});
        this.tryCommit(this.graph, graph -> {
            Vertex v = (Vertex)graph.vertices(new Object[]{uuid}).next();
            Assert.assertEquals((Object)uuid, (Object)v.id());
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AnyIds")})
    public void shouldAddVertexWithUserSuppliedAnyId() {
        UUID uuid = UUID.randomUUID();
        this.graph.addVertex(new Object[]{T.id, uuid});
        this.tryCommit(this.graph, graph -> {
            Vertex v = (Vertex)graph.vertices(new Object[]{uuid}).next();
            Assert.assertEquals((Object)uuid, (Object)v.id());
        });
        this.graph.addVertex(new Object[]{T.id, uuid.toString()});
        this.tryCommit(this.graph, graph -> {
            Vertex v = (Vertex)graph.vertices(new Object[]{uuid.toString()}).next();
            Assert.assertEquals((Object)uuid.toString(), (Object)v.id());
        });
        IoTest.CustomId customId = new IoTest.CustomId("test", uuid);
        this.graph.addVertex(new Object[]{T.id, customId});
        this.tryCommit(this.graph, graph -> {
            Vertex v = (Vertex)graph.vertices(new Object[]{customId}).next();
            Assert.assertEquals((Object)customId, (Object)v.id());
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MultiProperties", supported=false)})
    public void shouldOverwriteEarlierKeyValuesWithLaterKeyValuesOnAddVertexIfNoMultiProperty() {
        Vertex v = this.graph.addVertex(new Object[]{"test", "A", "test", "B", "test", "C"});
        this.tryCommit(this.graph, graph -> {
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)v.properties(new String[]{"test"})));
            Assert.assertTrue((boolean)StreamFactory.stream((Iterator)v.values(new String[]{"test"})).anyMatch(t -> t.equals("C")));
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MultiProperties")})
    public void shouldOverwriteEarlierKeyValuesWithLaterKeyValuesOnAddVertexIfMultiProperty() {
        Vertex v = this.graph.addVertex(new Object[]{"test", "A", "test", "B", "test", "C"});
        this.tryCommit(this.graph, graph -> {
            Assert.assertEquals((long)3L, (long)IteratorUtils.count((Iterator)v.properties(new String[]{"test"})));
            Assert.assertTrue((boolean)StreamFactory.stream((Iterator)v.values(new String[]{"test"})).anyMatch(t -> t.equals("A")));
            Assert.assertTrue((boolean)StreamFactory.stream((Iterator)v.values(new String[]{"test"})).anyMatch(t -> t.equals("B")));
            Assert.assertTrue((boolean)StreamFactory.stream((Iterator)v.values(new String[]{"test"})).anyMatch(t -> t.equals("C")));
        });
    }

    @Test
    public void shouldHaveStandardStringRepresentation() throws Exception {
        Assert.assertTrue((boolean)this.graph.toString().matches(".*\\[.*\\]"));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="RemoveEdges")})
    public void shouldRemoveEdges() {
        int vertexCount = 100;
        int edgeCount = 200;
        ArrayList vertices = new ArrayList();
        ArrayList edges = new ArrayList();
        Random random = new Random();
        IntStream.range(0, 100).forEach(i -> vertices.add(this.graph.addVertex(new Object[0])));
        this.tryCommit(this.graph, GraphTest.assertVertexEdgeCounts(100, 0));
        IntStream.range(0, 200).forEach(i -> {
            boolean created = false;
            while (!created) {
                Vertex b;
                Vertex a = (Vertex)vertices.get(random.nextInt(vertices.size()));
                if (a == (b = (Vertex)vertices.get(random.nextInt(vertices.size())))) continue;
                edges.add(a.addEdge(GraphManager.getGraphProvider().convertLabel("a" + UUID.randomUUID()), b, new Object[0]));
                created = true;
            }
        });
        this.tryCommit(this.graph, GraphTest.assertVertexEdgeCounts(100, 200));
        int counter = 0;
        for (Edge e : edges) {
            e.remove();
            int currentCounter = ++counter;
            this.tryCommit(this.graph, GraphTest.assertVertexEdgeCounts(100, 200 - currentCounter));
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="RemoveVertices")})
    public void shouldRemoveVertices() {
        int vertexCount = 500;
        ArrayList vertices = new ArrayList();
        ArrayList<Edge> edges = new ArrayList<Edge>();
        IntStream.range(0, 500).forEach(i -> vertices.add(this.graph.addVertex(new Object[0])));
        this.tryCommit(this.graph, GraphTest.assertVertexEdgeCounts(500, 0));
        for (int i2 = 0; i2 < 500; i2 += 2) {
            Vertex a = (Vertex)vertices.get(i2);
            Vertex b = (Vertex)vertices.get(i2 + 1);
            edges.add(a.addEdge(GraphManager.getGraphProvider().convertLabel("a" + UUID.randomUUID()), b, new Object[0]));
        }
        this.tryCommit(this.graph, GraphTest.assertVertexEdgeCounts(500, 250));
        int counter = 0;
        for (Vertex v : vertices) {
            v.remove();
            if ((++counter + 1) % 2 != 0) continue;
            int currentCounter = counter;
            this.tryCommit(this.graph, GraphTest.assertVertexEdgeCounts(500 - currentCounter, edges.size() - (currentCounter + 1) / 2));
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="RemoveVertices")})
    public void shouldRemoveVerticesWithoutConcurrentModificationException() {
        for (int i = 0; i < 100; ++i) {
            this.graph.addVertex(new Object[0]);
        }
        Iterator vertexIterator = this.graph.vertices(new Object[0]);
        Assert.assertTrue((boolean)vertexIterator.hasNext());
        while (vertexIterator.hasNext()) {
            ((Vertex)vertexIterator.next()).remove();
        }
        Assert.assertFalse((boolean)vertexIterator.hasNext());
        this.tryCommit(this.graph, graph -> Assert.assertFalse((boolean)graph.vertices(new Object[0]).hasNext()));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="RemoveEdges")})
    public void shouldRemoveEdgesWithoutConcurrentModificationException() {
        for (int i = 0; i < 50; ++i) {
            this.graph.addVertex(new Object[0]).addEdge("link", this.graph.addVertex(new Object[0]), new Object[0]);
        }
        Iterator edgeIterator = this.graph.edges(new Object[0]);
        Assert.assertTrue((boolean)edgeIterator.hasNext());
        while (edgeIterator.hasNext()) {
            ((Edge)edgeIterator.next()).remove();
        }
        Assert.assertFalse((boolean)edgeIterator.hasNext());
        this.tryCommit(this.graph, g -> Assert.assertFalse((boolean)g.edges(new Object[0]).hasNext()));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
    public void shouldEvaluateConnectivityPatterns() {
        Vertex d;
        Vertex c;
        Vertex b;
        Vertex a;
        GraphProvider graphProvider = GraphManager.getGraphProvider();
        if (this.graph.features().vertex().supportsUserSuppliedIds()) {
            a = this.graph.addVertex(new Object[]{T.id, graphProvider.convertId("1")});
            b = this.graph.addVertex(new Object[]{T.id, graphProvider.convertId("2")});
            c = this.graph.addVertex(new Object[]{T.id, graphProvider.convertId("3")});
            d = this.graph.addVertex(new Object[]{T.id, graphProvider.convertId("4")});
        } else {
            a = this.graph.addVertex(new Object[0]);
            b = this.graph.addVertex(new Object[0]);
            c = this.graph.addVertex(new Object[0]);
            d = this.graph.addVertex(new Object[0]);
        }
        this.tryCommit(this.graph, GraphTest.assertVertexEdgeCounts(4, 0));
        Edge e = a.addEdge(graphProvider.convertLabel("knows"), b, new Object[0]);
        Edge f = b.addEdge(graphProvider.convertLabel("knows"), c, new Object[0]);
        Edge g = c.addEdge(graphProvider.convertLabel("knows"), d, new Object[0]);
        Edge h = d.addEdge(graphProvider.convertLabel("knows"), a, new Object[0]);
        this.tryCommit(this.graph, GraphTest.assertVertexEdgeCounts(4, 4));
        this.graph.vertices(new Object[0]).forEachRemaining(v -> {
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)v.edges(Direction.OUT, new String[0])));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)v.edges(Direction.IN, new String[0])));
        });
        this.graph.edges(new Object[0]).forEachRemaining(x -> Assert.assertEquals((Object)graphProvider.convertLabel("knows"), (Object)x.label()));
        if (this.graph.features().vertex().supportsUserSuppliedIds()) {
            Vertex va = (Vertex)this.graph.vertices(new Object[]{graphProvider.convertId("1")}).next();
            Vertex vb = (Vertex)this.graph.vertices(new Object[]{graphProvider.convertId("2")}).next();
            Vertex vc = (Vertex)this.graph.vertices(new Object[]{graphProvider.convertId("3")}).next();
            Vertex vd = (Vertex)this.graph.vertices(new Object[]{graphProvider.convertId("4")}).next();
            Assert.assertEquals((Object)a, (Object)va);
            Assert.assertEquals((Object)b, (Object)vb);
            Assert.assertEquals((Object)c, (Object)vc);
            Assert.assertEquals((Object)d, (Object)vd);
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)va.edges(Direction.IN, new String[0])));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)va.edges(Direction.OUT, new String[0])));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)vb.edges(Direction.IN, new String[0])));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)vb.edges(Direction.OUT, new String[0])));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)vc.edges(Direction.IN, new String[0])));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)vc.edges(Direction.OUT, new String[0])));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)vd.edges(Direction.IN, new String[0])));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)vd.edges(Direction.OUT, new String[0])));
            Edge i = a.addEdge(graphProvider.convertLabel("hates"), b, new Object[0]);
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)va.edges(Direction.IN, new String[0])));
            Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)va.edges(Direction.OUT, new String[0])));
            Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)vb.edges(Direction.IN, new String[0])));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)vb.edges(Direction.OUT, new String[0])));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)vc.edges(Direction.IN, new String[0])));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)vc.edges(Direction.OUT, new String[0])));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)vd.edges(Direction.IN, new String[0])));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)vd.edges(Direction.OUT, new String[0])));
            for (Edge x2 : IteratorUtils.list((Iterator)a.edges(Direction.OUT, new String[0]))) {
                Assert.assertTrue((x2.label().equals(graphProvider.convertId("knows")) || x2.label().equals(graphProvider.convertId("hates")) ? 1 : 0) != 0);
            }
            Assert.assertEquals((Object)graphProvider.convertId("hates"), (Object)i.label());
            Assert.assertEquals((Object)graphProvider.convertId("2"), (Object)i.inVertex().id().toString());
            Assert.assertEquals((Object)graphProvider.convertId("1"), (Object)i.outVertex().id().toString());
        }
        HashSet<Object> vertexIds = new HashSet<Object>();
        vertexIds.add(a.id());
        vertexIds.add(a.id());
        vertexIds.add(b.id());
        vertexIds.add(b.id());
        vertexIds.add(c.id());
        vertexIds.add(d.id());
        vertexIds.add(d.id());
        vertexIds.add(d.id());
        Assert.assertEquals((long)4L, (long)vertexIds.size());
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
    public void shouldTraverseInOutFromVertexWithSingleEdgeLabelFilter() {
        GraphProvider graphProvider = GraphManager.getGraphProvider();
        Vertex a = this.graph.addVertex(new Object[0]);
        Vertex b = this.graph.addVertex(new Object[0]);
        Vertex c = this.graph.addVertex(new Object[0]);
        String labelFriend = graphProvider.convertLabel("friend");
        String labelHate = graphProvider.convertLabel("hate");
        Edge aFriendB = a.addEdge(labelFriend, b, new Object[0]);
        Edge aFriendC = a.addEdge(labelFriend, c, new Object[0]);
        Edge aHateC = a.addEdge(labelHate, c, new Object[0]);
        Edge cHateA = c.addEdge(labelHate, a, new Object[0]);
        Edge cHateB = c.addEdge(labelHate, b, new Object[0]);
        List results = IteratorUtils.list((Iterator)a.edges(Direction.OUT, new String[0]));
        Assert.assertEquals((long)3L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(aFriendB));
        Assert.assertTrue((boolean)results.contains(aFriendC));
        Assert.assertTrue((boolean)results.contains(aHateC));
        results = IteratorUtils.list((Iterator)a.edges(Direction.OUT, new String[]{labelFriend}));
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(aFriendB));
        Assert.assertTrue((boolean)results.contains(aFriendC));
        results = IteratorUtils.list((Iterator)a.edges(Direction.OUT, new String[]{labelHate}));
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(aHateC));
        results = IteratorUtils.list((Iterator)a.edges(Direction.IN, new String[]{labelHate}));
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(cHateA));
        results = IteratorUtils.list((Iterator)a.edges(Direction.IN, new String[]{labelFriend}));
        Assert.assertEquals((long)0L, (long)results.size());
        results = IteratorUtils.list((Iterator)b.edges(Direction.IN, new String[]{labelHate}));
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(cHateB));
        results = IteratorUtils.list((Iterator)b.edges(Direction.IN, new String[]{labelFriend}));
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(aFriendB));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
    public void shouldTraverseInOutFromVertexWithMultipleEdgeLabelFilter() {
        GraphProvider graphProvider = GraphManager.getGraphProvider();
        Vertex a = this.graph.addVertex(new Object[0]);
        Vertex b = this.graph.addVertex(new Object[0]);
        Vertex c = this.graph.addVertex(new Object[0]);
        String labelFriend = graphProvider.convertLabel("friend");
        String labelHate = graphProvider.convertLabel("hate");
        Edge aFriendB = a.addEdge(labelFriend, b, new Object[0]);
        Edge aFriendC = a.addEdge(labelFriend, c, new Object[0]);
        Edge aHateC = a.addEdge(labelHate, c, new Object[0]);
        Edge cHateA = c.addEdge(labelHate, a, new Object[0]);
        Edge cHateB = c.addEdge(labelHate, b, new Object[0]);
        List results = IteratorUtils.list((Iterator)a.edges(Direction.OUT, new String[]{labelFriend, labelHate}));
        Assert.assertEquals((long)3L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(aFriendB));
        Assert.assertTrue((boolean)results.contains(aFriendC));
        Assert.assertTrue((boolean)results.contains(aHateC));
        results = IteratorUtils.list((Iterator)a.edges(Direction.IN, new String[]{labelFriend, labelHate}));
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(cHateA));
        results = IteratorUtils.list((Iterator)b.edges(Direction.IN, new String[]{labelFriend, labelHate}));
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(aFriendB));
        Assert.assertTrue((boolean)results.contains(cHateB));
        results = IteratorUtils.list((Iterator)b.edges(Direction.IN, new String[]{graphProvider.convertLabel("blah1"), graphProvider.convertLabel("blah2")}));
        Assert.assertEquals((long)0L, (long)results.size());
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
    public void shouldTestTreeConnectivity() {
        GraphProvider graphProvider = GraphManager.getGraphProvider();
        int branchSize = 11;
        Vertex start = this.graph.addVertex(new Object[0]);
        for (int i = 0; i < branchSize; ++i) {
            Vertex a = this.graph.addVertex(new Object[0]);
            start.addEdge(graphProvider.convertLabel("test1"), a, new Object[0]);
            for (int j = 0; j < branchSize; ++j) {
                Vertex b = this.graph.addVertex(new Object[0]);
                a.addEdge(graphProvider.convertLabel("test2"), b, new Object[0]);
                for (int k = 0; k < branchSize; ++k) {
                    Vertex c = this.graph.addVertex(new Object[0]);
                    b.addEdge(graphProvider.convertLabel("test3"), c, new Object[0]);
                }
            }
        }
        Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)start.edges(Direction.IN, new String[0])));
        Assert.assertEquals((long)branchSize, (long)IteratorUtils.count((Iterator)start.edges(Direction.OUT, new String[0])));
        for (Vertex a : IteratorUtils.list((Iterator)start.edges(Direction.OUT, new String[0]))) {
            Assert.assertEquals((Object)graphProvider.convertId("test1"), (Object)a.label());
            Assert.assertEquals((long)branchSize, (long)IteratorUtils.count((Iterator)a.inVertex().vertices(Direction.OUT, new String[0])));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)a.inVertex().vertices(Direction.IN, new String[0])));
            for (Vertex b : IteratorUtils.list((Iterator)a.inVertex().edges(Direction.OUT, new String[0]))) {
                Assert.assertEquals((Object)graphProvider.convertId("test2"), (Object)b.label());
                Assert.assertEquals((long)branchSize, (long)IteratorUtils.count((Iterator)b.inVertex().vertices(Direction.OUT, new String[0])));
                Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)b.inVertex().vertices(Direction.IN, new String[0])));
                for (Vertex c : IteratorUtils.list((Iterator)b.inVertex().edges(Direction.OUT, new String[0]))) {
                    Assert.assertEquals((Object)graphProvider.convertId("test3"), (Object)c.label());
                    Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)c.inVertex().vertices(Direction.OUT, new String[0])));
                    Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)c.inVertex().vertices(Direction.IN, new String[0])));
                }
            }
        }
        int totalVertices = 0;
        for (int i = 0; i < 4; ++i) {
            totalVertices += (int)Math.pow(branchSize, i);
        }
        this.tryCommit(this.graph, GraphTest.assertVertexEdgeCounts(totalVertices, totalVertices - 1));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Persistence")
    public void shouldPersistDataOnClose() throws Exception {
        GraphProvider graphProvider = GraphManager.getGraphProvider();
        Vertex v = this.graph.addVertex(new Object[0]);
        Vertex u = this.graph.addVertex(new Object[0]);
        if (this.graph.features().edge().properties().supportsStringValues()) {
            v.property("name", (Object)"marko");
            u.property("name", (Object)"pavel");
        }
        Edge e = v.addEdge(graphProvider.convertLabel("collaborator"), u, new Object[0]);
        if (this.graph.features().edge().properties().supportsStringValues()) {
            e.property("location", (Object)"internet");
        }
        this.tryCommit(this.graph, GraphTest.assertVertexEdgeCounts(2, 1));
        this.graph.close();
        Graph reopenedGraph = graphProvider.standardTestGraph(this.getClass(), this.name.getMethodName());
        GraphTest.assertVertexEdgeCounts(2, 1).accept(reopenedGraph);
        if (this.graph.features().vertex().properties().supportsStringValues()) {
            reopenedGraph.vertices(new Object[0]).forEachRemaining(vertex -> Assert.assertTrue((vertex.property("name").value().equals("marko") || vertex.property("name").value().equals("pavel") ? 1 : 0) != 0));
        }
        reopenedGraph.edges(new Object[0]).forEachRemaining(edge -> {
            Assert.assertEquals((Object)graphProvider.convertId("collaborator"), (Object)edge.label());
            if (this.graph.features().edge().properties().supportsStringValues()) {
                Assert.assertEquals((Object)"internet", (Object)edge.property("location").value());
            }
        });
        graphProvider.clear(reopenedGraph, graphProvider.standardGraphConfiguration(this.getClass(), this.name.getMethodName()));
    }
}

