/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.FeatureRequirementSet;
import org.apache.tinkerpop.gremlin.FeatureRequirements;
import org.apache.tinkerpop.gremlin.GraphManager;
import org.apache.tinkerpop.gremlin.process.traversal.T;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.batch.BatchGraph;
import org.apache.tinkerpop.gremlin.structure.util.batch.Exists;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.junit.Assert;
import org.junit.Test;

public class BatchTest
extends AbstractGremlinTest {
    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds")})
    public void shouldLoadVerticesIncrementallyWithSuppliedIdentifier() {
        BatchGraph batchGraph = BatchGraph.build((Graph)this.graph).incrementalLoading(true).bufferSize(1L).create();
        Object id1 = GraphManager.getGraphProvider().convertId("1");
        Object id2 = GraphManager.getGraphProvider().convertId("2");
        batchGraph.addVertex(new Object[]{T.id, id1, "name", "marko", "age", 29});
        Vertex v1 = batchGraph.addVertex(new Object[]{T.id, id2, "name", "stephen", "age", 37});
        Vertex v2 = batchGraph.addVertex(new Object[]{T.id, id1, "name", "marko", "age", 34});
        v1.addEdge("knows", v2, new Object[]{"weight", 1.0});
        this.tryCommit((Graph)batchGraph);
        Vertex vStephen = (Vertex)this.g.V(new Object[0]).has("name", (Object)"stephen").next();
        Assert.assertEquals((Object)37, (Object)vStephen.property("age").value());
        Assert.assertEquals((Object)new Long(1L), (Object)this.g.V(new Object[]{vStephen}).outE(new String[]{"knows"}).has("weight", (Object)1.0).inV().has("name", (Object)"marko").count().next());
        Vertex vMarko = (Vertex)this.g.V(new Object[0]).has("name", (Object)"marko").next();
        Assert.assertEquals((Object)29, (Object)vMarko.property("age").value());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")})
    public void shouldLoadVerticesIncrementallyWithNamedIdentifier() {
        BatchGraph batchGraph = BatchGraph.build((Graph)this.graph).incrementalLoading(true).vertexIdKey("name").bufferSize(1L).create();
        batchGraph.addVertex(new Object[]{T.id, "marko", "age", 29});
        Vertex v1 = batchGraph.addVertex(new Object[]{T.id, "stephen", "age", 37});
        Vertex v2 = batchGraph.addVertex(new Object[]{T.id, "marko", "age", 34});
        v1.addEdge("knows", v2, new Object[]{"weight", 1.0});
        this.tryCommit((Graph)batchGraph);
        Vertex vStephen = (Vertex)this.g.V(new Object[0]).has("name", (Object)"stephen").next();
        Assert.assertEquals((Object)37, (Object)vStephen.property("age").value());
        Assert.assertEquals((Object)new Long(1L), (Object)this.g.V(new Object[]{vStephen}).outE(new String[]{"knows"}).has("weight", (Object)1.0).inV().has("name", (Object)"marko").count().next());
        Vertex vMarko = (Vertex)this.g.V(new Object[0]).has("name", (Object)"marko").next();
        Assert.assertEquals((Object)29, (Object)vMarko.property("age").value());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds")})
    public void shouldLoadVerticesIncrementallyWithSuppliedIdentifierThrowOnExistingVertex() {
        BatchGraph batchGraph = BatchGraph.build((Graph)this.graph).incrementalLoading(true, (BiConsumer)Exists.THROW, (BiConsumer)Exists.IGNORE).bufferSize(1L).create();
        Object id1 = GraphManager.getGraphProvider().convertId("1");
        batchGraph.addVertex(new Object[]{T.id, id1, "name", "marko", "age", 29});
        try {
            batchGraph.addVertex(new Object[]{T.id, id1, "name", "marko", "age", 34});
            Assert.fail((String)"Should have thrown an error because the vertex already exists");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof IllegalStateException));
        }
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues")
    public void shouldLoadVerticesIncrementallyWithNamedIdentifierThrowOnExistingVertex() {
        BatchGraph batchGraph = BatchGraph.build((Graph)this.graph).incrementalLoading(true, (BiConsumer)Exists.THROW, (BiConsumer)Exists.IGNORE).vertexIdKey("name").bufferSize(1L).create();
        batchGraph.addVertex(new Object[]{T.id, "marko", "age", 29});
        try {
            batchGraph.addVertex(new Object[]{T.id, "marko", "age", 34});
            Assert.fail((String)"Should have thrown an error because the vertex already exists");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof IllegalStateException));
        }
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds")})
    public void shouldLoadVerticesIncrementallyWithSuppliedIdentifierOverwriteSingleExistingVertex() {
        BatchGraph batchGraph = BatchGraph.build((Graph)this.graph).incrementalLoading(true, (BiConsumer)Exists.OVERWRITE_SINGLE, (BiConsumer)Exists.IGNORE).bufferSize(1L).create();
        Object id1 = GraphManager.getGraphProvider().convertId("1");
        Object id2 = GraphManager.getGraphProvider().convertId("2");
        batchGraph.addVertex(new Object[]{T.id, id1, "name", "marko", "age", 29});
        Vertex v1 = batchGraph.addVertex(new Object[]{T.id, id2, "name", "stephen", "age", 37});
        Vertex v2 = batchGraph.addVertex(new Object[]{T.id, id1, "name", "marko", "age", 34});
        v1.addEdge("knows", v2, new Object[]{"weight", 1.0});
        this.tryCommit((Graph)batchGraph);
        Vertex vStephen = (Vertex)this.g.V(new Object[0]).has("name", (Object)"stephen").next();
        Assert.assertEquals((Object)37, (Object)vStephen.property("age").value());
        Assert.assertEquals((Object)new Long(1L), (Object)this.g.V(new Object[]{vStephen}).outE(new String[]{"knows"}).has("weight", (Object)1.0).inV().has("name", (Object)"marko").count().next());
        Vertex vMarko = (Vertex)this.g.V(new Object[0]).has("name", (Object)"marko").next();
        Assert.assertEquals((Object)34, (Object)vMarko.property("age").value());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")})
    public void shouldLoadVerticesIncrementallyWithNamedIdentifierOverwriteSingleExistingVertex() {
        BatchGraph batchGraph = BatchGraph.build((Graph)this.graph).incrementalLoading(true, (BiConsumer)Exists.OVERWRITE_SINGLE, (BiConsumer)Exists.IGNORE).vertexIdKey("name").bufferSize(1L).create();
        batchGraph.addVertex(new Object[]{T.id, "marko", "age", 29});
        Vertex v1 = batchGraph.addVertex(new Object[]{T.id, "stephen", "age", 37});
        Vertex v2 = batchGraph.addVertex(new Object[]{T.id, "marko", "age", 34});
        v1.addEdge("knows", v2, new Object[]{"weight", 1.0});
        this.tryCommit((Graph)batchGraph);
        Vertex vStephen = (Vertex)this.g.V(new Object[0]).has("name", (Object)"stephen").next();
        Assert.assertEquals((Object)37, (Object)vStephen.property("age").value());
        Assert.assertEquals((Object)new Long(1L), (Object)this.g.V(new Object[]{vStephen}).outE(new String[]{"knows"}).has("weight", (Object)1.0).inV().has("name", (Object)"marko").count().next());
        Vertex vMarko = (Vertex)this.g.V(new Object[0]).has("name", (Object)"marko").next();
        Assert.assertEquals((Object)34, (Object)vMarko.property("age").value());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds")})
    public void shouldLoadVerticesIncrementallyWithSuppliedIdentifierOverwriteExistingVertex() {
        BatchGraph batchGraph = BatchGraph.build((Graph)this.graph).incrementalLoading(true, (BiConsumer)Exists.OVERWRITE, (BiConsumer)Exists.IGNORE).bufferSize(1L).create();
        Object id1 = GraphManager.getGraphProvider().convertId("1");
        Object id2 = GraphManager.getGraphProvider().convertId("2");
        batchGraph.addVertex(new Object[]{T.id, id1, "name", "marko", "age", 29});
        Vertex v1 = batchGraph.addVertex(new Object[]{T.id, id2, "name", "stephen", "age", 37});
        Vertex v2 = batchGraph.addVertex(new Object[]{T.id, id1, "name", "marko", "age", 34});
        v1.addEdge("knows", v2, new Object[]{"weight", 1.0});
        this.tryCommit((Graph)batchGraph);
        Vertex vStephen = (Vertex)this.g.V(new Object[0]).has("name", (Object)"stephen").next();
        Assert.assertEquals((Object)37, (Object)vStephen.property("age").value());
        Assert.assertEquals((Object)new Long(1L), (Object)this.g.V(new Object[]{vStephen}).outE(new String[]{"knows"}).has("weight", (Object)1.0).inV().has("name", (Object)"marko").count().next());
        Vertex vMarko = (Vertex)this.g.V(new Object[0]).has("name", (Object)"marko").next();
        Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)vMarko.properties(new String[]{"age"})));
        Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)vMarko.properties(new String[]{"name"})));
        Assert.assertTrue((boolean)((List)((Map)this.g.V(new Object[]{vMarko}).valueMap(new String[0]).next()).get("age")).contains(29));
        Assert.assertTrue((boolean)((List)((Map)this.g.V(new Object[]{vMarko}).valueMap(new String[0]).next()).get("age")).contains(34));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MultiProperties")})
    public void shouldLoadVerticesIncrementallyWithNamedIdentifierAddMultiPropertyExistingVertex() {
        BatchGraph batchGraph = BatchGraph.build((Graph)this.graph).incrementalLoading(true, (BiConsumer)Exists.OVERWRITE, (BiConsumer)Exists.IGNORE).vertexIdKey("name").bufferSize(1L).create();
        batchGraph.addVertex(new Object[]{T.id, "marko", "age", 29});
        Vertex v1 = batchGraph.addVertex(new Object[]{T.id, "stephen", "age", 37});
        Vertex v2 = batchGraph.addVertex(new Object[]{T.id, "marko", "age", 34});
        v1.addEdge("knows", v2, new Object[]{"weight", 1.0});
        this.tryCommit((Graph)batchGraph);
        Vertex vStephen = (Vertex)this.g.V(new Object[0]).has("name", (Object)"stephen").next();
        Assert.assertEquals((Object)37, (Object)vStephen.property("age").value());
        Assert.assertEquals((Object)new Long(1L), (Object)this.g.V(new Object[]{vStephen}).outE(new String[]{"knows"}).has("weight", (Object)1.0).inV().has("name", (Object)"marko").count().next());
        Vertex vMarko = (Vertex)this.g.V(new Object[0]).has("name", (Object)"marko").next();
        Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)vMarko.properties(new String[]{"age"})));
        Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)vMarko.properties(new String[]{"name"})));
        Assert.assertTrue((boolean)((List)((Map)this.g.V(new Object[]{vMarko}).valueMap(new String[0]).next()).get("age")).contains(29));
        Assert.assertTrue((boolean)((List)((Map)this.g.V(new Object[]{vMarko}).valueMap(new String[0]).next()).get("age")).contains(34));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="UserSuppliedIds")})
    public void shouldLoadEdgesIncrementallyWithSuppliedIdentifier() {
        BatchGraph batchGraph = BatchGraph.build((Graph)this.graph).incrementalLoading(true).vertexIdKey("name").bufferSize(1L).create();
        Vertex v2 = batchGraph.addVertex(new Object[]{T.id, "marko", "age", 29});
        Vertex v1 = batchGraph.addVertex(new Object[]{T.id, "stephen", "age", 37});
        Object id1 = GraphManager.getGraphProvider().convertId("1");
        v1.addEdge("knows", v2, new Object[]{"weight", 1.0, T.id, id1});
        v1.addEdge("knows", v2, new Object[]{"weight", 0.5, T.id, id1});
        this.tryCommit((Graph)batchGraph);
        Vertex vStephen = (Vertex)this.g.V(new Object[0]).has("name", (Object)"stephen").next();
        Assert.assertEquals((Object)37, (Object)vStephen.property("age").value());
        Assert.assertEquals((Object)new Long(1L), (Object)this.g.V(new Object[]{vStephen}).outE(new String[]{"knows"}).has("weight", (Object)1.0).inV().has("name", (Object)"marko").count().next());
        Assert.assertEquals((Object)new Long(0L), (Object)this.g.V(new Object[]{vStephen}).outE(new String[]{"knows"}).has("weight", (Object)0.5).inV().has("name", (Object)"marko").count().next());
        Vertex vMarko = (Vertex)this.g.V(new Object[0]).has("name", (Object)"marko").next();
        Assert.assertEquals((Object)29, (Object)vMarko.property("age").value());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")})
    public void shouldLoadEdgesIncrementallyWithNamedIdentifier() {
        BatchGraph batchGraph = BatchGraph.build((Graph)this.graph).incrementalLoading(true).vertexIdKey("name").edgeIdKey("uid").bufferSize(1L).create();
        Vertex v2 = batchGraph.addVertex(new Object[]{T.id, "marko", "age", 29});
        Vertex v1 = batchGraph.addVertex(new Object[]{T.id, "stephen", "age", 37});
        v1.addEdge("knows", v2, new Object[]{"weight", 1.0, T.id, "abcde"});
        v1.addEdge("knows", v2, new Object[]{"weight", 0.5, T.id, "abcde"});
        this.tryCommit((Graph)batchGraph);
        Vertex vStephen = (Vertex)this.g.V(new Object[0]).has("name", (Object)"stephen").next();
        Assert.assertEquals((Object)37, (Object)vStephen.property("age").value());
        Assert.assertEquals((Object)new Long(1L), (Object)this.g.V(new Object[]{vStephen}).outE(new String[]{"knows"}).has("uid", (Object)"abcde").has("weight", (Object)1.0).inV().has("name", (Object)"marko").count().next());
        Assert.assertEquals((Object)new Long(0L), (Object)this.g.V(new Object[]{vStephen}).outE(new String[]{"knows"}).has("weight", (Object)0.5).inV().has("name", (Object)"marko").count().next());
        Vertex vMarko = (Vertex)this.g.V(new Object[0]).has("name", (Object)"marko").next();
        Assert.assertEquals((Object)29, (Object)vMarko.property("age").value());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="UserSuppliedIds")})
    public void shouldLoadEdgesIncrementallyWithSuppliedIdentifierOverwriteSingleExistingEdge() {
        BatchGraph batchGraph = BatchGraph.build((Graph)this.graph).incrementalLoading(true, (BiConsumer)Exists.IGNORE, (BiConsumer)Exists.OVERWRITE_SINGLE).vertexIdKey("name").bufferSize(1L).create();
        Vertex v2 = batchGraph.addVertex(new Object[]{T.id, "marko", "age", 29});
        Vertex v1 = batchGraph.addVertex(new Object[]{T.id, "stephen", "age", 37});
        Object id1 = GraphManager.getGraphProvider().convertId("1");
        v1.addEdge("knows", v2, new Object[]{"weight", 1.0, T.id, id1});
        v1.addEdge("knows", v2, new Object[]{"weight", 0.5, T.id, id1});
        this.tryCommit((Graph)batchGraph);
        Vertex vStephen = (Vertex)this.g.V(new Object[0]).has("name", (Object)"stephen").next();
        Assert.assertEquals((Object)37, (Object)vStephen.property("age").value());
        Assert.assertEquals((Object)new Long(0L), (Object)this.g.V(new Object[]{vStephen}).outE(new String[]{"knows"}).has("weight", (Object)1.0).inV().has("name", (Object)"marko").count().next());
        Assert.assertEquals((Object)new Long(1L), (Object)this.g.V(new Object[]{vStephen}).outE(new String[]{"knows"}).has("weight", (Object)0.5).inV().has("name", (Object)"marko").count().next());
        Vertex vMarko = (Vertex)this.g.V(new Object[0]).has("name", (Object)"marko").next();
        Assert.assertEquals((Object)29, (Object)vMarko.property("age").value());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")})
    public void shouldLoadEdgesIncrementallyWithNamedIdentifierOverwriteSingleExistingEdge() {
        BatchGraph batchGraph = BatchGraph.build((Graph)this.graph).incrementalLoading(true, (BiConsumer)Exists.IGNORE, (BiConsumer)Exists.OVERWRITE_SINGLE).vertexIdKey("name").edgeIdKey("uid").bufferSize(1L).create();
        Vertex v2 = batchGraph.addVertex(new Object[]{T.id, "marko", "age", 29});
        Vertex v1 = batchGraph.addVertex(new Object[]{T.id, "stephen", "age", 37});
        v1.addEdge("knows", v2, new Object[]{"weight", 1.0, T.id, "abcde"});
        v1.addEdge("knows", v2, new Object[]{"weight", 0.5, T.id, "abcde"});
        this.tryCommit((Graph)batchGraph);
        Vertex vStephen = (Vertex)this.g.V(new Object[0]).has("name", (Object)"stephen").next();
        Assert.assertEquals((Object)37, (Object)vStephen.property("age").value());
        Assert.assertEquals((Object)new Long(0L), (Object)this.g.V(new Object[]{vStephen}).outE(new String[]{"knows"}).has("uid", (Object)"abcde").has("weight", (Object)1.0).inV().has("name", (Object)"marko").count().next());
        Assert.assertEquals((Object)new Long(1L), (Object)this.g.V(new Object[]{vStephen}).outE(new String[]{"knows"}).has("weight", (Object)0.5).inV().has("name", (Object)"marko").count().next());
        Vertex vMarko = (Vertex)this.g.V(new Object[0]).has("name", (Object)"marko").next();
        Assert.assertEquals((Object)29, (Object)vMarko.property("age").value());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="UserSuppliedIds")})
    public void shouldLoadEdgesIncrementallyWithSuppliedIdentifierOverwriteExistingEdge() {
        BatchGraph batchGraph = BatchGraph.build((Graph)this.graph).incrementalLoading(true, (BiConsumer)Exists.IGNORE, (BiConsumer)Exists.OVERWRITE).vertexIdKey("name").bufferSize(1L).create();
        Vertex v2 = batchGraph.addVertex(new Object[]{T.id, "marko", "age", 29});
        Vertex v1 = batchGraph.addVertex(new Object[]{T.id, "stephen", "age", 37});
        Object id1 = GraphManager.getGraphProvider().convertId("1");
        v1.addEdge("knows", v2, new Object[]{"weight", 1.0, T.id, id1});
        v1.addEdge("knows", v2, new Object[]{"weight", 0.5, T.id, id1});
        this.tryCommit((Graph)batchGraph);
        Vertex vStephen = (Vertex)this.g.V(new Object[0]).has("name", (Object)"stephen").next();
        Assert.assertEquals((Object)37, (Object)vStephen.property("age").value());
        Assert.assertEquals((Object)new Long(0L), (Object)this.g.V(new Object[]{vStephen}).outE(new String[]{"knows"}).has("weight", (Object)1.0).inV().has("name", (Object)"marko").count().next());
        Assert.assertEquals((Object)new Long(1L), (Object)this.g.V(new Object[]{vStephen}).outE(new String[]{"knows"}).has("weight", (Object)0.5).inV().has("name", (Object)"marko").count().next());
        Vertex vMarko = (Vertex)this.g.V(new Object[0]).has("name", (Object)"marko").next();
        Assert.assertEquals((Object)29, (Object)vMarko.property("age").value());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")})
    public void shouldLoadEdgesIncrementallyWithNamedIdentifierOverwriteExistingEdge() {
        BatchGraph batchGraph = BatchGraph.build((Graph)this.graph).incrementalLoading(true, (BiConsumer)Exists.IGNORE, (BiConsumer)Exists.OVERWRITE).vertexIdKey("name").edgeIdKey("uid").bufferSize(1L).create();
        Vertex v2 = batchGraph.addVertex(new Object[]{T.id, "marko", "age", 29});
        Vertex v1 = batchGraph.addVertex(new Object[]{T.id, "stephen", "age", 37});
        v1.addEdge("knows", v2, new Object[]{"weight", 1.0, T.id, "abcde"});
        v1.addEdge("knows", v2, new Object[]{"weight", 0.5, T.id, "abcde"});
        this.tryCommit((Graph)batchGraph);
        Vertex vStephen = (Vertex)this.g.V(new Object[0]).has("name", (Object)"stephen").next();
        Assert.assertEquals((Object)37, (Object)vStephen.property("age").value());
        Assert.assertEquals((Object)new Long(0L), (Object)this.g.V(new Object[]{vStephen}).outE(new String[]{"knows"}).has("uid", (Object)"abcde").has("weight", (Object)1.0).inV().has("name", (Object)"marko").count().next());
        Assert.assertEquals((Object)new Long(1L), (Object)this.g.V(new Object[]{vStephen}).outE(new String[]{"knows"}).has("weight", (Object)0.5).inV().has("name", (Object)"marko").count().next());
        Vertex vMarko = (Vertex)this.g.V(new Object[0]).has("name", (Object)"marko").next();
        Assert.assertEquals((Object)29, (Object)vMarko.property("age").value());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="UserSuppliedIds")})
    public void shouldLoadEdgesIncrementallyWithSuppliedIdentifierThrowOnExistingEdge() {
        BatchGraph batchGraph = BatchGraph.build((Graph)this.graph).incrementalLoading(true, (BiConsumer)Exists.IGNORE, (BiConsumer)Exists.THROW).vertexIdKey("name").bufferSize(1L).create();
        Vertex v2 = batchGraph.addVertex(new Object[]{T.id, "marko", "age", 29});
        Vertex v1 = batchGraph.addVertex(new Object[]{T.id, "stephen", "age", 37});
        Object id1 = GraphManager.getGraphProvider().convertId("1");
        v1.addEdge("knows", v2, new Object[]{"weight", 1.0, T.id, id1});
        try {
            v1.addEdge("knows", v2, new Object[]{"weight", 0.5, T.id, id1});
            Assert.fail((String)"Should have thrown an error because the vertex already exists");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof IllegalStateException));
        }
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")})
    public void shouldLoadEdgesIncrementallyWithNamedIdentifierThrowOnExistingEdge() {
        BatchGraph batchGraph = BatchGraph.build((Graph)this.graph).incrementalLoading(true, (BiConsumer)Exists.IGNORE, (BiConsumer)Exists.THROW).vertexIdKey("name").edgeIdKey("uid").bufferSize(1L).create();
        Vertex v2 = batchGraph.addVertex(new Object[]{T.id, "marko", "age", 29});
        Vertex v1 = batchGraph.addVertex(new Object[]{T.id, "stephen", "age", 37});
        v1.addEdge("knows", v2, new Object[]{"weight", 1.0, T.id, "abcde"});
        try {
            v1.addEdge("knows", v2, new Object[]{"weight", 0.5, T.id, "abcde"});
            Assert.fail((String)"Should have thrown an error because the vertex already exists");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof IllegalStateException));
        }
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")})
    public void shouldLoadEdgesIncrementallyNoIdSpecified() {
        BatchGraph batchGraph = BatchGraph.build((Graph)this.graph).incrementalLoading(true).vertexIdKey("name").bufferSize(1L).create();
        Vertex v2 = batchGraph.addVertex(new Object[]{T.id, "marko", "age", 29});
        Vertex v1 = batchGraph.addVertex(new Object[]{T.id, "stephen", "age", 37});
        v1.addEdge("knows", v2, new Object[]{"weight", 1.0});
        v1.addEdge("knows", v2, new Object[]{"weight", 0.5});
        this.tryCommit((Graph)batchGraph);
        Vertex vStephen = (Vertex)this.g.V(new Object[0]).has("name", (Object)"stephen").next();
        Assert.assertEquals((Object)37, (Object)vStephen.property("age").value());
        Assert.assertEquals((Object)new Long(1L), (Object)this.g.V(new Object[]{vStephen}).outE(new String[]{"knows"}).has("weight", (Object)1.0).inV().has("name", (Object)"marko").count().next());
        Assert.assertEquals((Object)new Long(1L), (Object)this.g.V(new Object[]{vStephen}).outE(new String[]{"knows"}).has("weight", (Object)0.5).inV().has("name", (Object)"marko").count().next());
        Vertex vMarko = (Vertex)this.g.V(new Object[0]).has("name", (Object)"marko").next();
        Assert.assertEquals((Object)29, (Object)vMarko.property("age").value());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")})
    public void shouldLoadEdgesIncrementallyWithNamedIdentifierAndNoIdSpecified() {
        BatchGraph batchGraph = BatchGraph.build((Graph)this.graph).incrementalLoading(true).vertexIdKey("name").edgeIdKey("uid").bufferSize(1L).create();
        Vertex v2 = batchGraph.addVertex(new Object[]{T.id, "marko", "age", 29});
        Vertex v1 = batchGraph.addVertex(new Object[]{T.id, "stephen", "age", 37});
        v1.addEdge("knows", v2, new Object[]{"weight", 1.0});
        v1.addEdge("knows", v2, new Object[]{"weight", 0.5});
        this.tryCommit((Graph)batchGraph);
        Vertex vStephen = (Vertex)this.g.V(new Object[0]).has("name", (Object)"stephen").next();
        Assert.assertEquals((Object)37, (Object)vStephen.property("age").value());
        Assert.assertEquals((Object)new Long(1L), (Object)this.g.V(new Object[]{vStephen}).outE(new String[]{"knows"}).has("weight", (Object)1.0).inV().has("name", (Object)"marko").count().next());
        Assert.assertEquals((Object)new Long(1L), (Object)this.g.V(new Object[]{vStephen}).outE(new String[]{"knows"}).has("weight", (Object)0.5).inV().has("name", (Object)"marko").count().next());
        Vertex vMarko = (Vertex)this.g.V(new Object[0]).has("name", (Object)"marko").next();
        Assert.assertEquals((Object)29, (Object)vMarko.property("age").value());
    }
}

