/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.verification;

import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.UseEngine;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalEngine;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.junit.Assert;
import org.junit.Test;

public abstract class TraversalVerificationStrategyTest
extends AbstractGremlinProcessTest {

    @UseEngine(value=TraversalEngine.Type.COMPUTER)
    public static class ComputerTraversals
    extends TraversalVerificationStrategyTest {
        @Test
        @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
        public void shouldNotAllowNestedGlobalTraversalToHaveBarriers() {
            try {
                GraphTraversal t = this.g.V(new Object[0]).values(new String[]{"age"}).union(new Traversal[]{__.max(), __.min(), __.sum()}).iterate();
                Assert.fail((String)("Nested global traversals should not be allowed to contain barriers (COMPUTER): " + t));
            }
            catch (IllegalStateException e) {
                Assert.assertTrue((boolean)true);
            }
        }

        @Test
        @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
        public void shouldNotAllowMidTraversalBarriersOnComputer() {
            GraphTraversal t;
            try {
                t = this.g.V(new Object[0]).count().sum().iterate();
                Assert.fail((String)("Mid-traversal barrier steps are not allowed (COMPUTER): " + t));
            }
            catch (IllegalStateException e) {
                Assert.assertTrue((boolean)true);
            }
            try {
                t = this.g.V(new Object[0]).count().sum().map(x -> (Double)x.get() * 19.0).iterate();
                Assert.fail((String)("Mid-traversal barrier steps are not allowed (COMPUTER): " + t));
            }
            catch (IllegalStateException e) {
                Assert.assertTrue((boolean)true);
            }
        }

        @Test
        @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
        public void shouldNotAllowLocalTraversalsToLeaveTheStarGraphOnComputer() {
            GraphTraversal t;
            try {
                t = this.g.V(new Object[0]).local((Traversal)__.out((String[])new String[0]).out(new String[0])).iterate();
                Assert.fail((String)("Local traversals should not be allowed to leave the star-graph (COMPUTER): " + t));
            }
            catch (IllegalStateException e) {
                Assert.assertTrue((boolean)true);
            }
            try {
                t = this.g.V(new Object[0]).local((Traversal)__.out((String[])new String[0]).values(new String[]{"name"})).iterate();
                Assert.fail((String)("Local traversals should not be allowed to leave the star-graph (COMPUTER): " + t));
            }
            catch (IllegalStateException e) {
                Assert.assertTrue((boolean)true);
            }
            try {
                this.g.V(new Object[0]).local((Traversal)__.outE((String[])new String[0]).values(new String[]{"weight"})).iterate();
                this.g.V(new Object[0]).local((Traversal)__.out((String[])new String[0]).id()).iterate();
                this.g.V(new Object[0]).local((Traversal)__.outE((String[])new String[0]).inV()).iterate();
            }
            catch (IllegalStateException e) {
                Assert.fail((String)("Local traversals on the star-graph are OK on COMPUTER: " + e.getMessage()));
            }
        }
    }

    @UseEngine(value=TraversalEngine.Type.STANDARD)
    public static class StandardTraversals
    extends TraversalVerificationStrategyTest {
        @Test
        @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
        public void shouldAllowNestedGlobalTraversalToHaveBarriers() {
            try {
                this.g.V(new Object[0]).values(new String[]{"age"}).union(new Traversal[]{__.max(), __.min(), __.sum()}).iterate();
            }
            catch (IllegalStateException e) {
                Assert.fail((String)("Nested global traversals can have barrier steps on STANDARD:" + e.getMessage()));
            }
        }

        @Test
        @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
        public void shouldAllowMidTraversalBarriersOnComputer() {
            try {
                this.g.V(new Object[0]).count().sum().iterate();
            }
            catch (IllegalStateException e) {
                Assert.fail((String)("Mid-traversal barrier steps are OK on STANDARD: " + e.getMessage()));
            }
        }

        @Test
        @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
        public void shouldAllowLocalTraversalsToLeaveTheStarGraphOnComputer() {
            try {
                this.g.V(new Object[0]).local((Traversal)__.out((String[])new String[0]).out(new String[0])).iterate();
            }
            catch (IllegalStateException e) {
                Assert.fail((String)("Local traversals leaving the star-graph are OK on STANDARD: " + e.getMessage()));
            }
        }
    }
}

