/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.UseEngine;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalEngine;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.junit.Assert;
import org.junit.Test;

public abstract class SideEffectTest
extends AbstractGremlinTest {
    public abstract Traversal<Vertex, String> get_g_VX1X_sideEffectXstore_aX_name(Object var1);

    public abstract Traversal<Vertex, String> get_g_VX1X_out_sideEffectXincr_cX_name(Object var1);

    public abstract Traversal<Vertex, String> get_g_VX1X_out_sideEffectXX_name(Object var1);

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_sideEffectXstore_aX_name() {
        Traversal<Vertex, String> traversal = this.get_g_VX1X_sideEffectXstore_aX_name(this.convertToVertexId("marko"));
        this.printTraversalForm(traversal);
        Assert.assertEquals((Object)traversal.next(), (Object)"marko");
        Assert.assertFalse((boolean)traversal.hasNext());
        Assert.assertEquals((Object)this.convertToVertexId("marko"), (Object)((Vertex)((List)traversal.asAdmin().getSideEffects().get("a")).get(0)).id());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_out_sideEffectXincr_cX_name() {
        Traversal<Vertex, String> traversal = this.get_g_VX1X_out_sideEffectXincr_cX_name(this.convertToVertexId("marko"));
        this.printTraversalForm(traversal);
        this.assert_g_v1_out_sideEffectXincr_cX_valueXnameX((Iterator<String>)traversal);
        Assert.assertEquals((Object)new Integer(3), ((List)traversal.asAdmin().getSideEffects().get("c")).get(0));
    }

    private void assert_g_v1_out_sideEffectXincr_cX_valueXnameX(Iterator<String> traversal) {
        ArrayList<String> names = new ArrayList<String>();
        while (traversal.hasNext()) {
            names.add(traversal.next());
        }
        Assert.assertEquals((long)3L, (long)names.size());
        Assert.assertTrue((boolean)names.contains("josh"));
        Assert.assertTrue((boolean)names.contains("lop"));
        Assert.assertTrue((boolean)names.contains("vadas"));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_out_sideEffectXX_name() {
        Traversal<Vertex, String> traversal = this.get_g_VX1X_out_sideEffectXX_name(this.convertToVertexId("marko"));
        this.printTraversalForm(traversal);
        this.assert_g_v1_out_sideEffectXincr_cX_valueXnameX((Iterator<String>)traversal);
    }

    @UseEngine(value=TraversalEngine.Type.STANDARD)
    public static class Traversals
    extends SideEffectTest {
        @Override
        public Traversal<Vertex, String> get_g_VX1X_sideEffectXstore_aX_name(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).withSideEffect("a", ArrayList::new).sideEffect(traverser -> {
                ((List)traverser.sideEffects("a")).clear();
                ((List)traverser.sideEffects("a")).add(traverser.get());
            }).values(new String[]{"name"});
        }

        @Override
        public Traversal<Vertex, String> get_g_VX1X_out_sideEffectXincr_cX_name(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).withSideEffect("c", () -> {
                ArrayList<Integer> list = new ArrayList<Integer>();
                list.add(0);
                return list;
            }).out(new String[0]).sideEffect(traverser -> {
                Integer temp = (Integer)((List)traverser.sideEffects("c")).get(0);
                ((List)traverser.sideEffects("c")).clear();
                ((List)traverser.sideEffects("c")).add(temp + 1);
            }).values(new String[]{"name"});
        }

        @Override
        public Traversal<Vertex, String> get_g_VX1X_out_sideEffectXX_name(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).out(new String[0]).sideEffect(traverser -> {}).values(new String[]{"name"});
        }
    }
}

