/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.UseEngine;
import org.apache.tinkerpop.gremlin.process.UseEngines;
import org.apache.tinkerpop.gremlin.process.traversal.Scope;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalEngine;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.junit.Assert;
import org.junit.Test;

public abstract class MinTest
extends AbstractGremlinProcessTest {
    public abstract Traversal<Vertex, Integer> get_g_V_age_min();

    public abstract Traversal<Vertex, Integer> get_g_V_repeatXbothX_timesX5X_age_min();

    public abstract Traversal<Vertex, Map<String, Number>> get_g_V_hasLabelXsoftwareX_group_byXnameX_byXbothE_valuesXweightX_foldX_byXminXlocalXX();

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_age_min() {
        List<Traversal> traversals = Arrays.asList(this.get_g_V_age_min(), this.get_g_V_repeatXbothX_timesX5X_age_min());
        traversals.forEach(traversal -> {
            this.printTraversalForm((Traversal)traversal);
            this.checkResults(Arrays.asList(27), traversal);
        });
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasLabelXsoftwareX_group_byXnameX_byXin_valuesXageX_foldX_byXminXlocalXX() {
        Traversal<Vertex, Map<String, Number>> traversal = this.get_g_V_hasLabelXsoftwareX_group_byXnameX_byXbothE_valuesXweightX_foldX_byXminXlocalXX();
        this.printTraversalForm(traversal);
        Assert.assertTrue((boolean)traversal.hasNext());
        Map map = (Map)traversal.next();
        Assert.assertFalse((boolean)traversal.hasNext());
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((Object)1.0, map.get("ripple"));
        Assert.assertEquals((Object)0.2, map.get("lop"));
    }

    @UseEngines(value={@UseEngine(value=TraversalEngine.Type.STANDARD), @UseEngine(value=TraversalEngine.Type.COMPUTER)})
    public static class Traversals
    extends MinTest {
        @Override
        public Traversal<Vertex, Integer> get_g_V_age_min() {
            return this.g.V(new Object[0]).values(new String[]{"age"}).min();
        }

        @Override
        public Traversal<Vertex, Integer> get_g_V_repeatXbothX_timesX5X_age_min() {
            return this.g.V(new Object[0]).repeat((Traversal)__.both((String[])new String[0])).times(5).values(new String[]{"age"}).min();
        }

        @Override
        public Traversal<Vertex, Map<String, Number>> get_g_V_hasLabelXsoftwareX_group_byXnameX_byXbothE_valuesXweightX_foldX_byXminXlocalXX() {
            return this.g.V(new Object[0]).hasLabel(new String[]{"software"}).group().by("name").by((Traversal)__.bothE((String[])new String[0]).values(new String[]{"weight"}).fold()).by((Traversal)__.min((Scope)Scope.local));
        }
    }
}

