/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.algorithm.generator;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.FeatureRequirementSet;
import org.apache.tinkerpop.gremlin.algorithm.generator.AbstractGeneratorTest;
import org.apache.tinkerpop.gremlin.algorithm.generator.CommunityGenerator;
import org.apache.tinkerpop.gremlin.algorithm.generator.Distribution;
import org.apache.tinkerpop.gremlin.algorithm.generator.NormalDistribution;
import org.apache.tinkerpop.gremlin.algorithm.generator.PowerLawDistribution;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.util.StreamFactory;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Enclosed.class)
public class CommunityGeneratorTest {

    public static class ProcessorTest
    extends AbstractGremlinTest {
        private static final int numberOfVertices = 100;

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
        public void shouldProcessVerticesEdges() {
            NormalDistribution dist = new NormalDistribution(2.0);
            CommunityGenerator generator = ((CommunityGenerator.Builder)((CommunityGenerator.Builder)((CommunityGenerator.Builder)CommunityGenerator.build(this.graph).label("knows")).edgeProcessor(e -> e.property("data", (Object)"test"))).vertexProcessor((v, m) -> {
                m.forEach((arg_0, arg_1) -> ((Vertex)v).property(arg_0, arg_1));
                v.property("test", (Object)"data");
            })).communityDistribution(dist).degreeDistribution(dist).crossCommunityPercentage(0.0).expectedNumCommunities(2).expectedNumEdges(1000).create();
            long edgesGenerated = generator.generate();
            Assert.assertTrue((edgesGenerated > 0L ? 1 : 0) != 0);
            this.tryCommit(this.graph, graph -> {
                Assert.assertEquals((Object)new Long(edgesGenerated), (Object)new Long(IteratorUtils.count((Iterator)graph.edges(new Object[0]))));
                Assert.assertTrue((IteratorUtils.count((Iterator)graph.vertices(new Object[0])) > 0L ? 1 : 0) != 0);
                Assert.assertTrue((boolean)StreamFactory.stream((Iterator)graph.edges(new Object[0])).allMatch(e -> e.value("data").equals("test")));
                Assert.assertTrue((boolean)StreamFactory.stream((Iterator)graph.vertices(new Object[0])).allMatch(v -> v.value("test").equals("data") && v.property("communityIndex").isPresent()));
            });
        }

        @Override
        protected void afterLoadGraphWith(Graph graph) throws Exception {
            int numNodes = 100;
            for (int i = 0; i < 100; ++i) {
                graph.addVertex(new Object[]{"oid", i});
            }
            this.tryCommit(graph);
        }
    }

    @RunWith(value=Parameterized.class)
    public static class DifferentDistributionsTest
    extends AbstractGeneratorTest {
        @Parameterized.Parameter(value=0)
        public Distribution communityDistribution;
        @Parameterized.Parameter(value=1)
        public Distribution degreeDistribution;
        @Parameterized.Parameter(value=2)
        public double crossPcent;
        private static final int numberOfVertices = 100;
        private final AtomicInteger failures = new AtomicInteger();
        private static final int ultimateFailureThreshold = 3;

        @Parameterized.Parameters(name="test({0},{1},{2})")
        public static Iterable<Object[]> data() {
            return Arrays.asList({new NormalDistribution(2.0), new PowerLawDistribution(2.4), 0.1}, {new NormalDistribution(2.0), new PowerLawDistribution(2.4), 0.5}, {new NormalDistribution(2.0), new NormalDistribution(4.0), 0.5}, {new NormalDistribution(2.0), new NormalDistribution(4.0), 0.1}, {new PowerLawDistribution(2.3), new PowerLawDistribution(2.4), 0.25}, {new PowerLawDistribution(2.3), new NormalDistribution(4.0), 0.25});
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
        public void shouldGenerateDifferentGraph() throws Exception {
            Configuration configuration = this.graphProvider.newGraphConfiguration("g1", this.getClass(), this.name.getMethodName());
            Graph graph1 = this.graphProvider.openTestGraph(configuration);
            try {
                this.communityGeneratorTest(this.graph, () -> 123456789L);
                this.afterLoadGraphWith(graph1);
                this.communityGeneratorTest(graph1, () -> 987654321L);
                Assert.assertTrue((IteratorUtils.count((Iterator)this.graph.edges(new Object[0])) > 0L ? 1 : 0) != 0);
                Assert.assertTrue((IteratorUtils.count((Iterator)this.graph.vertices(new Object[0])) > 0L ? 1 : 0) != 0);
                Assert.assertTrue((IteratorUtils.count((Iterator)graph1.edges(new Object[0])) > 0L ? 1 : 0) != 0);
                Assert.assertTrue((IteratorUtils.count((Iterator)graph1.vertices(new Object[0])) > 0L ? 1 : 0) != 0);
                Assert.assertFalse((boolean)this.same(this.graph, graph1));
            }
            catch (Exception ex) {
                throw ex;
            }
            finally {
                this.graphProvider.clear(graph1, configuration);
            }
            Assert.assertFalse((this.failures.get() >= 3 ? 1 : 0) != 0);
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
        public void shouldGenerateSameGraph() throws Exception {
            Configuration configuration = this.graphProvider.newGraphConfiguration("g1", this.getClass(), this.name.getMethodName());
            Graph graph1 = this.graphProvider.openTestGraph(configuration);
            try {
                this.communityGeneratorTest(this.graph, () -> 123456789L);
                this.afterLoadGraphWith(graph1);
                this.communityGeneratorTest(graph1, () -> 123456789L);
                Assert.assertTrue((IteratorUtils.count((Iterator)this.graph.edges(new Object[0])) > 0L ? 1 : 0) != 0);
                Assert.assertTrue((IteratorUtils.count((Iterator)this.graph.vertices(new Object[0])) > 0L ? 1 : 0) != 0);
                Assert.assertTrue((IteratorUtils.count((Iterator)graph1.edges(new Object[0])) > 0L ? 1 : 0) != 0);
                Assert.assertTrue((IteratorUtils.count((Iterator)graph1.vertices(new Object[0])) > 0L ? 1 : 0) != 0);
                Assert.assertEquals((long)IteratorUtils.count((Iterator)this.graph.edges(new Object[0])), (long)IteratorUtils.count((Iterator)graph1.edges(new Object[0])));
                Assert.assertTrue((boolean)this.same(this.graph, graph1));
            }
            catch (Exception ex) {
                throw ex;
            }
            finally {
                this.graphProvider.clear(graph1, configuration);
            }
            Assert.assertFalse((this.failures.get() >= 3 ? 1 : 0) != 0);
        }

        @Override
        protected void afterLoadGraphWith(Graph graph) throws Exception {
            int numNodes = 100;
            for (int i = 0; i < 100; ++i) {
                graph.addVertex(new Object[]{"oid", i});
            }
            this.tryCommit(graph);
        }

        protected Iterable<Vertex> verticesByOid(Graph graph) {
            List vertices = IteratorUtils.list((Iterator)graph.vertices(new Object[0]));
            Collections.sort(vertices, (v1, v2) -> ((Integer)v1.value("oid")).compareTo((Integer)v2.value("oid")));
            return vertices;
        }

        private void communityGeneratorTest(Graph graph, Supplier<Long> seedGenerator) throws Exception {
            boolean generated = false;
            double localCrossPcent = this.crossPcent;
            while (!generated) {
                try {
                    CommunityGenerator generator = ((CommunityGenerator.Builder)((CommunityGenerator.Builder)CommunityGenerator.build(graph).label("knows")).communityDistribution(this.communityDistribution).degreeDistribution(this.degreeDistribution).crossCommunityPercentage(localCrossPcent).expectedNumCommunities(10).expectedNumEdges(1000).seedGenerator(seedGenerator)).verticesToGenerateEdgesFor(this.verticesByOid(graph)).create();
                    int numEdges = generator.generate();
                    Assert.assertTrue((numEdges > 0 ? 1 : 0) != 0);
                    this.tryCommit(graph, g -> Assert.assertEquals((Object)new Long(numEdges), (Object)new Long(IteratorUtils.count((Iterator)g.edges(new Object[0])))));
                    generated = true;
                }
                catch (IllegalArgumentException iae) {
                    generated = (localCrossPcent -= 0.005) < 0.0;
                    graph.vertices(new Object[0]).forEachRemaining(Element::remove);
                    this.tryCommit(graph);
                    this.afterLoadGraphWith(graph);
                    System.out.println(String.format("Ran CommunityGeneratorTest with different CrossCommunityPercentage, expected %s but used %s", this.crossPcent, localCrossPcent));
                    if (!generated) continue;
                    this.failures.incrementAndGet();
                }
            }
        }
    }
}

