/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.socket.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.socket.server.SocketServerSettings;
import org.apache.tinkerpop.gremlin.socket.server.TestChannelizers;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerFactory;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;
import org.apache.tinkerpop.gremlin.util.message.RequestMessage;
import org.apache.tinkerpop.gremlin.util.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.util.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.util.ser.AbstractMessageSerializer;
import org.apache.tinkerpop.gremlin.util.ser.GraphBinaryMessageSerializerV1;
import org.apache.tinkerpop.gremlin.util.ser.GraphSONMessageSerializerV2;
import org.apache.tinkerpop.gremlin.util.ser.GraphSONMessageSerializerV3;
import org.apache.tinkerpop.gremlin.util.ser.SerializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestWSGremlinInitializer
extends TestChannelizers.TestWebSocketServerInitializer {
    private static final Logger logger = LoggerFactory.getLogger(TestWSGremlinInitializer.class);
    private static final String USER_AGENT_HEADER = "User-Agent";
    private final SocketServerSettings settings;
    private static AbstractMessageSerializer SERIALIZER;
    private static final ByteBufAllocator allocator;

    public TestWSGremlinInitializer(SocketServerSettings settings) {
        this.settings = settings;
        switch (settings.SERIALIZER) {
            case "GraphSONV2": {
                SERIALIZER = new GraphSONMessageSerializerV2();
                break;
            }
            case "GraphSONV3": {
                SERIALIZER = new GraphSONMessageSerializerV3();
                break;
            }
            case "GraphBinaryV1": {
                SERIALIZER = new GraphBinaryMessageSerializerV1();
                break;
            }
            default: {
                logger.warn("Could not recognize serializer [%s], defaulting to GraphBinaryV1", (Object)settings.SERIALIZER);
                SERIALIZER = new GraphBinaryMessageSerializerV1();
            }
        }
    }

    @Override
    public void postInit(ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{new ClientTestConfigurableHandler(this.settings)});
    }

    static {
        allocator = UnpooledByteBufAllocator.DEFAULT;
    }

    static class ClientTestConfigurableHandler
    extends MessageToMessageDecoder<BinaryWebSocketFrame> {
        private SocketServerSettings settings;
        private String userAgent = "";
        private String secWebsocketExtensions = "";

        public ClientTestConfigurableHandler(SocketServerSettings settings) {
            this.settings = settings;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void decode(ChannelHandlerContext ctx, BinaryWebSocketFrame frame, List<Object> objects) throws Exception {
            ByteBuf messageBytes = frame.content();
            byte len = messageBytes.readByte();
            if (len <= 0) {
                objects.add(RequestMessage.INVALID);
                return;
            }
            ByteBuf contentTypeBytes = ctx.alloc().buffer((int)len);
            try {
                messageBytes.readBytes(contentTypeBytes);
            }
            finally {
                contentTypeBytes.release();
            }
            RequestMessage msg = SERIALIZER.deserializeRequest(messageBytes.discardReadBytes());
            if (msg.getRequestId().equals(this.settings.SINGLE_VERTEX_DELAYED_CLOSE_CONNECTION_REQUEST_ID)) {
                logger.info("sending vertex result frame");
                ctx.channel().writeAndFlush((Object)new BinaryWebSocketFrame(this.returnSingleVertexResponse(this.settings.SINGLE_VERTEX_DELAYED_CLOSE_CONNECTION_REQUEST_ID)));
                logger.info("waiting for 2 sec");
                Thread.sleep(2000L);
                logger.info("sending close frame");
                ctx.channel().writeAndFlush((Object)new CloseWebSocketFrame());
            } else if (msg.getRequestId().equals(this.settings.SINGLE_VERTEX_REQUEST_ID)) {
                logger.info("sending vertex result frame");
                ctx.channel().writeAndFlush((Object)new BinaryWebSocketFrame(this.returnSingleVertexResponse(this.settings.SINGLE_VERTEX_REQUEST_ID)));
            } else if (msg.getRequestId().equals(this.settings.FAILED_AFTER_DELAY_REQUEST_ID)) {
                logger.info("waiting for 1 sec");
                Thread.sleep(1000L);
                ResponseMessage responseMessage = ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR).statusAttributeException((Throwable)new RuntimeException()).create();
                ctx.channel().writeAndFlush((Object)new BinaryWebSocketFrame(SERIALIZER.serializeResponseAsBinary(responseMessage, allocator)));
            } else if (msg.getRequestId().equals(this.settings.CLOSE_CONNECTION_REQUEST_ID) || msg.getRequestId().equals(this.settings.CLOSE_CONNECTION_REQUEST_ID_2)) {
                Thread.sleep(1000L);
                ctx.channel().writeAndFlush((Object)new CloseWebSocketFrame());
            } else if (msg.getRequestId().equals(this.settings.USER_AGENT_REQUEST_ID)) {
                ctx.channel().writeAndFlush((Object)new BinaryWebSocketFrame(this.returnSimpleBinaryResponse(this.settings.USER_AGENT_REQUEST_ID, this.userAgent)));
            } else if (msg.getRequestId().equals(this.settings.SEC_WEBSOCKET_EXTENSIONS)) {
                ctx.channel().writeAndFlush((Object)new BinaryWebSocketFrame(this.returnSimpleBinaryResponse(this.settings.SEC_WEBSOCKET_EXTENSIONS, this.secWebsocketExtensions)));
            } else if (msg.getRequestId().equals(this.settings.PER_REQUEST_SETTINGS_REQUEST_ID)) {
                String response = String.format("requestId=%s evaluationTimeout=%d, batchSize=%d, userAgent=%s, materializeProperties=%s", msg.getRequestId(), msg.getArgs().get("evaluationTimeout"), msg.getArgs().get("batchSize"), msg.getArgs().get("userAgent"), msg.getArgs().get("materializeProperties"));
                ctx.channel().writeAndFlush((Object)new BinaryWebSocketFrame(this.returnSimpleBinaryResponse(this.settings.PER_REQUEST_SETTINGS_REQUEST_ID, response)));
            } else {
                try {
                    Thread.sleep(Long.parseLong((String)msg.getArgs().get("gremlin")));
                    ctx.channel().writeAndFlush((Object)new BinaryWebSocketFrame(this.returnSingleVertexResponse(msg.getRequestId())));
                }
                catch (NumberFormatException nfe) {
                    logger.warn("Request unknown request with RequestId: %s", (Object)msg.getRequestId());
                }
            }
        }

        private ByteBuf returnSingleVertexResponse(UUID requestID) throws SerializationException {
            TinkerGraph graph = TinkerFactory.createClassic();
            GraphTraversalSource g = graph.traversal();
            ArrayList<Vertex> t = new ArrayList<Vertex>(1);
            t.add((Vertex)g.V(new Object[0]).limit(1L).next());
            return SERIALIZER.serializeResponseAsBinary(ResponseMessage.build((UUID)requestID).result(t).create(), allocator);
        }

        private ByteBuf returnSimpleBinaryResponse(UUID requestID, String message) throws SerializationException {
            ArrayList<String> messageList = new ArrayList<String>(1);
            messageList.add(message);
            return SERIALIZER.serializeResponseAsBinary(ResponseMessage.build((UUID)requestID).result(messageList).create(), allocator);
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            if (evt instanceof WebSocketServerProtocolHandler.HandshakeComplete) {
                WebSocketServerProtocolHandler.HandshakeComplete handshake = (WebSocketServerProtocolHandler.HandshakeComplete)evt;
                HttpHeaders requestHeaders = handshake.requestHeaders();
                if (requestHeaders.contains(TestWSGremlinInitializer.USER_AGENT_HEADER)) {
                    this.userAgent = requestHeaders.get(TestWSGremlinInitializer.USER_AGENT_HEADER);
                }
                if (requestHeaders.contains("sec-websocket-extensions")) {
                    this.secWebsocketExtensions = requestHeaders.get("sec-websocket-extensions");
                } else {
                    ctx.fireUserEventTriggered(evt);
                }
            }
        }
    }
}

