/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.socket.server;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.UUID;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class SocketServerSettings {
    public int PORT = 0;
    public String SERIALIZER = "GraphBinaryV1";
    public UUID SINGLE_VERTEX_REQUEST_ID = null;
    public UUID SINGLE_VERTEX_DELAYED_CLOSE_CONNECTION_REQUEST_ID = null;
    public UUID FAILED_AFTER_DELAY_REQUEST_ID = null;
    public UUID CLOSE_CONNECTION_REQUEST_ID = null;
    public UUID CLOSE_CONNECTION_REQUEST_ID_2 = null;
    public UUID USER_AGENT_REQUEST_ID = null;
    public UUID SEC_WEBSOCKET_EXTENSIONS = null;
    public UUID PER_REQUEST_SETTINGS_REQUEST_ID = null;

    public static SocketServerSettings read(Path confFilePath) throws IOException {
        return SocketServerSettings.read(Files.newInputStream(confFilePath, new OpenOption[0]));
    }

    public static SocketServerSettings read(InputStream confInputStream) {
        Objects.requireNonNull(confInputStream);
        LoaderOptions options = new LoaderOptions();
        Yaml yaml = new Yaml((BaseConstructor)new Constructor(SocketServerSettings.class, options));
        return (SocketServerSettings)yaml.load(confInputStream);
    }
}

