/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.handler;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpMessage;
import org.apache.tinkerpop.gremlin.server.Channelizer;
import org.apache.tinkerpop.gremlin.server.channel.WebSocketChannelizer;
import org.apache.tinkerpop.gremlin.server.handler.HttpGremlinEndpointHandler;
import org.apache.tinkerpop.gremlin.server.handler.HttpUserAgentHandler;
import org.apache.tinkerpop.gremlin.server.handler.WebSocketHandlerUtil;
import org.apache.tinkerpop.gremlin.server.util.ServerGremlinExecutor;

@ChannelHandler.Sharable
public class WsAndHttpChannelizerHandler
extends ChannelInboundHandlerAdapter {
    private final WebSocketChannelizer wsChannelizer = new WebSocketChannelizer();
    private HttpGremlinEndpointHandler httpGremlinEndpointHandler;

    public void init(ServerGremlinExecutor serverGremlinExecutor, HttpGremlinEndpointHandler httpGremlinEndpointHandler) {
        this.wsChannelizer.init(serverGremlinExecutor);
        this.httpGremlinEndpointHandler = httpGremlinEndpointHandler;
    }

    public Channelizer getWsChannelizer() {
        return this.wsChannelizer;
    }

    public void configure(ChannelPipeline pipeline) {
        this.wsChannelizer.configure(pipeline);
    }

    public void channelRead(ChannelHandlerContext ctx, Object obj) {
        ChannelPipeline pipeline = ctx.pipeline();
        if (obj instanceof HttpMessage && !WebSocketHandlerUtil.isWebSocket((HttpMessage)obj)) {
            pipeline.remove("request-handler");
            if (null != pipeline.get("http-user-agent-handler")) {
                pipeline.remove("http-user-agent-handler");
            }
            if (null != pipeline.get("authenticator")) {
                ChannelHandler authenticator = pipeline.get("authenticator");
                pipeline.remove("authenticator");
                pipeline.addAfter("http-aggregator", "authenticator", authenticator);
                pipeline.addAfter("authenticator", "http-user-agent-handler", (ChannelHandler)new HttpUserAgentHandler());
                pipeline.addAfter("http-user-agent-handler", "request-handler", (ChannelHandler)this.httpGremlinEndpointHandler);
            } else {
                pipeline.addAfter("http-aggregator", "http-user-agent-handler", (ChannelHandler)new HttpUserAgentHandler());
                pipeline.addAfter("http-user-agent-handler", "request-handler", (ChannelHandler)this.httpGremlinEndpointHandler);
            }
        }
        ctx.fireChannelRead(obj);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        ctx.close();
    }
}

