/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.handler;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.ReferenceCountUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.script.Bindings;
import javax.script.SimpleBindings;
import org.apache.tinkerpop.gremlin.groovy.engine.GremlinExecutor;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptChecker;
import org.apache.tinkerpop.gremlin.process.remote.traversal.DefaultRemoteTraverser;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.AbstractTraverser;
import org.apache.tinkerpop.gremlin.server.GraphManager;
import org.apache.tinkerpop.gremlin.server.GremlinServer;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.auth.AuthenticatedUser;
import org.apache.tinkerpop.gremlin.server.handler.HttpHandlerUtil;
import org.apache.tinkerpop.gremlin.server.handler.StateKey;
import org.apache.tinkerpop.gremlin.server.util.MetricManager;
import org.apache.tinkerpop.gremlin.server.util.TextPlainMessageSerializer;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceFactory;
import org.apache.tinkerpop.gremlin.util.ExceptionHelper;
import org.apache.tinkerpop.gremlin.util.MessageSerializer;
import org.apache.tinkerpop.gremlin.util.function.FunctionUtils;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.apache.tinkerpop.gremlin.util.message.RequestMessage;
import org.apache.tinkerpop.gremlin.util.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.util.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.util.ser.MessageTextSerializer;
import org.apache.tinkerpop.gremlin.util.ser.SerializationException;
import org.javatuples.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class HttpGremlinEndpointHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(HttpGremlinEndpointHandler.class);
    private static final Logger auditLogger = LoggerFactory.getLogger((String)"audit.org.apache.tinkerpop.gremlin.server");
    private static final Timer evalOpTimer = MetricManager.INSTANCE.getTimer(MetricRegistry.name(GremlinServer.class, (String[])new String[]{"op", "eval"}));
    private final Map<String, MessageSerializer<?>> serializers;
    private static final TextPlainMessageSerializer textPlainSerializer = new TextPlainMessageSerializer();
    private final GremlinExecutor gremlinExecutor;
    private final GraphManager graphManager;
    private final Settings settings;
    private static final Pattern pattern = Pattern.compile("(.*);q=(.*)");

    public HttpGremlinEndpointHandler(Map<String, MessageSerializer<?>> serializers, GremlinExecutor gremlinExecutor, GraphManager graphManager, Settings settings) {
        this.serializers = serializers;
        this.gremlinExecutor = gremlinExecutor;
        this.graphManager = graphManager;
        this.settings = settings;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof FullHttpRequest) {
            RequestMessage requestMessage;
            FullHttpRequest req = (FullHttpRequest)msg;
            boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)req);
            if ("/favicon.ico".equals(req.uri())) {
                HttpHandlerUtil.sendError(ctx, HttpResponseStatus.NOT_FOUND, "Gremlin Server doesn't have a favicon.ico", keepAlive);
                ReferenceCountUtil.release((Object)msg);
                return;
            }
            if (HttpUtil.is100ContinueExpected((HttpMessage)req)) {
                ctx.write((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
            }
            if (req.method() != HttpMethod.GET && req.method() != HttpMethod.POST) {
                HttpHandlerUtil.sendError(ctx, HttpResponseStatus.METHOD_NOT_ALLOWED, HttpResponseStatus.METHOD_NOT_ALLOWED.toString(), keepAlive);
                ReferenceCountUtil.release((Object)msg);
                return;
            }
            try {
                requestMessage = HttpHandlerUtil.getRequestMessageFromHttpRequest(req, this.serializers);
            }
            catch (IllegalArgumentException | SerializationException ex) {
                HttpHandlerUtil.sendError(ctx, HttpResponseStatus.BAD_REQUEST, ex.getMessage(), keepAlive);
                ReferenceCountUtil.release((Object)msg);
                return;
            }
            String acceptMime = Optional.ofNullable(req.headers().get((CharSequence)HttpHeaderNames.ACCEPT)).orElse("application/json");
            Pair<String, MessageTextSerializer<?>> serializer = this.chooseSerializer(acceptMime);
            if (null == serializer) {
                HttpHandlerUtil.sendError(ctx, HttpResponseStatus.BAD_REQUEST, String.format("no serializer for requested Accept header: %s", acceptMime), keepAlive);
                ReferenceCountUtil.release((Object)msg);
                return;
            }
            String origin = req.headers().get((CharSequence)HttpHeaderNames.ORIGIN);
            ReferenceCountUtil.release((Object)msg);
            try {
                Bindings bindings;
                logger.debug("Processing request containing script [{}] and bindings of [{}] on {}", new Object[]{requestMessage.getArgOrDefault("gremlin", (Object)""), requestMessage.getArgOrDefault("bindings", Collections.emptyMap()), Thread.currentThread().getName()});
                if (this.settings.enableAuditLog.booleanValue()) {
                    String address;
                    AuthenticatedUser user = (AuthenticatedUser)ctx.channel().attr(StateKey.AUTHENTICATED_USER).get();
                    if (null == user) {
                        user = AuthenticatedUser.ANONYMOUS_USER;
                    }
                    if ((address = ctx.channel().remoteAddress().toString()).startsWith("/") && address.length() > 1) {
                        address = address.substring(1);
                    }
                    auditLogger.info("User {} with address {} requested: {}", new Object[]{user.getName(), address, requestMessage.getArgOrDefault("gremlin", (Object)"")});
                }
                ChannelPromise promise = ctx.channel().newPromise();
                AtomicReference resultHolder = new AtomicReference();
                promise.addListener(future -> {
                    if (future.isSuccess()) {
                        logger.debug("Preparing HTTP response for request with script [{}] and bindings of [{}] with result of [{}] on [{}]", new Object[]{requestMessage.getArgOrDefault("gremlin", (Object)""), requestMessage.getArgOrDefault("bindings", Collections.emptyMap()), resultHolder.get(), Thread.currentThread().getName()});
                        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, (ByteBuf)resultHolder.get());
                        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, serializer.getValue0());
                        if (origin != null) {
                            response.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, (Object)origin);
                        }
                        HttpHandlerUtil.sendAndCleanupConnection(ctx, keepAlive, (FullHttpResponse)response);
                    }
                });
                Timer.Context timerContext = evalOpTimer.time();
                try {
                    bindings = this.createBindings((Map)requestMessage.getArgOrDefault("bindings", Collections.emptyMap()), (Map)requestMessage.getArgOrDefault("aliases", Collections.emptyMap()));
                }
                catch (IllegalStateException iae) {
                    HttpHandlerUtil.sendError(ctx, HttpResponseStatus.BAD_REQUEST, iae.getMessage(), keepAlive);
                    ReferenceCountUtil.release((Object)msg);
                    return;
                }
                CompletableFuture evalFuture = this.gremlinExecutor.eval(requestMessage.getArg("gremlin"), (String)requestMessage.getArg("language"), (Map)bindings, (Long)requestMessage.getArgOrDefault("evaluationTimeout", null), FunctionUtils.wrapFunction(o -> {
                    List results;
                    timerContext.stop();
                    logger.debug("Transforming result of request with script [{}] and bindings of [{}] with result of [{}] on [{}]", new Object[]{requestMessage.getArg("gremlin"), requestMessage.getArg("bindings"), o, Thread.currentThread().getName()});
                    Optional mp = requestMessage.getArg("gremlin") instanceof String ? GremlinScriptChecker.parse((String)((String)requestMessage.getArg("gremlin"))).getMaterializeProperties() : Optional.empty();
                    List list = results = requestMessage.getOp().equals("bytecode") ? IteratorUtils.asList((Object)o).stream().map(r -> new DefaultRemoteTraverser(r, 1L)).collect(Collectors.toList()) : IteratorUtils.asList((Object)o);
                    if (mp.isPresent() && ((String)mp.get()).equals("tokens")) {
                        Object firstElement = results.get(0);
                        if (firstElement instanceof Element) {
                            for (int i = 0; i < results.size(); ++i) {
                                results.set(i, ReferenceFactory.detach((Element)((Element)results.get(i))));
                            }
                        } else if (firstElement instanceof AbstractTraverser) {
                            for (Object item : results) {
                                ((AbstractTraverser)item).detach();
                            }
                        }
                    }
                    ResponseMessage responseMessage = ResponseMessage.build((UUID)requestMessage.getRequestId()).code(ResponseStatusCode.SUCCESS).result(results).create();
                    HttpGremlinEndpointHandler.attemptCommit((Map)requestMessage.getArg("aliases"), this.graphManager, this.settings.strictTransactionManagement);
                    try {
                        return Unpooled.wrappedBuffer((ByteBuf)((MessageTextSerializer)serializer.getValue1()).serializeResponseAsBinary(responseMessage, ctx.alloc()));
                    }
                    catch (Exception ex) {
                        logger.warn(String.format("Error during serialization for %s", responseMessage), (Throwable)ex);
                        if (ex instanceof SerializationException) {
                            throw new SerializationException(String.format("Could not serialize the result with %s - %s", serializer.getValue0(), ex.getMessage()));
                        }
                        throw ex;
                    }
                }));
                evalFuture.exceptionally(t -> {
                    if (t.getMessage() != null) {
                        HttpHandlerUtil.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR, t.getMessage(), Optional.of(t), keepAlive);
                    } else {
                        HttpHandlerUtil.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR, String.format("Error encountered evaluating script: %s", (Object[])requestMessage.getArg("gremlin")), Optional.of(t), keepAlive);
                    }
                    promise.setFailure(t);
                    return null;
                });
                evalFuture.thenAcceptAsync(r -> {
                    resultHolder.set(r);
                    promise.setSuccess();
                }, (Executor)this.gremlinExecutor.getExecutorService());
            }
            catch (Exception ex) {
                Throwable t2 = ExceptionHelper.getRootCause((Throwable)ex);
                if (t2 instanceof TooLongFrameException) {
                    HttpHandlerUtil.sendError(ctx, HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, t2.getMessage() + " - increase the maxContentLength", keepAlive);
                }
                if (t2 != null) {
                    HttpHandlerUtil.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR, t2.getMessage(), keepAlive);
                }
                HttpHandlerUtil.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR, ex.getMessage(), keepAlive);
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        logger.error("Error processing HTTP Request", cause);
        if (ctx.channel().isActive()) {
            HttpHandlerUtil.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR, cause.getMessage(), false);
        }
    }

    private Bindings createBindings(Map<String, Object> bindingMap, Map<String, String> rebindingMap) {
        SimpleBindings bindings = new SimpleBindings();
        if (!rebindingMap.isEmpty()) {
            for (Map.Entry<String, String> kv : rebindingMap.entrySet()) {
                TraversalSource ts;
                boolean found = false;
                Graph g = this.graphManager.getGraph(kv.getValue());
                if (null != g) {
                    bindings.put(kv.getKey(), (Object)g);
                    found = true;
                }
                if (!found && null != (ts = this.graphManager.getTraversalSource(kv.getValue()))) {
                    bindings.put(kv.getKey(), (Object)ts);
                    found = true;
                }
                if (found) continue;
                String error = String.format("Could not rebind [%s] to [%s] as [%s] not in the Graph or TraversalSource global bindings", kv.getKey(), kv.getValue(), kv.getValue());
                throw new IllegalStateException(error);
            }
        }
        bindings.putAll((Map<? extends String, ? extends Object>)bindingMap);
        return bindings;
    }

    private Pair<String, MessageTextSerializer<?>> chooseSerializer(String mimeType) {
        List ordered = Stream.of(mimeType.split(",")).map(mediaType -> {
            Matcher matcher = pattern.matcher((CharSequence)mediaType);
            return matcher.matches() ? Pair.with((Object)matcher.group(1), (Object)Double.parseDouble(matcher.group(2))) : Pair.with((Object)mediaType, (Object)1.0);
        }).sorted((o1, o2) -> ((String)o2.getValue0()).compareTo((String)o1.getValue0())).collect(Collectors.toList());
        for (Pair p : ordered) {
            String accept;
            String string = accept = ((String)p.getValue0()).equals("*/*") ? "application/json" : (String)p.getValue0();
            if (this.serializers.containsKey(accept)) {
                return Pair.with((Object)accept, (Object)((MessageTextSerializer)this.serializers.get(accept)));
            }
            if (!accept.equals("text/plain")) continue;
            return Pair.with((Object)accept, (Object)textPlainSerializer);
        }
        return null;
    }

    private static void attemptCommit(Map<String, String> aliases, GraphManager graphManager, boolean strict) {
        if (strict) {
            graphManager.commit(new HashSet<String>(aliases.values()));
        } else {
            graphManager.commitAll();
        }
    }
}

