/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.util;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.Counter;
import com.codahale.metrics.CsvReporter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Slf4jReporter;
import com.codahale.metrics.Timer;
import com.codahale.metrics.ganglia.GangliaReporter;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import info.ganglia.gmetric4j.gmetric.GMetric;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.tinkerpop.gremlin.groovy.jsr223.GremlinGroovyScriptEngine;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngine;
import org.apache.tinkerpop.gremlin.server.GremlinServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum MetricManager {
    INSTANCE;

    private static final Logger log;
    private final MetricRegistry registry = new MetricRegistry();
    private ConsoleReporter consoleReporter = null;
    private CsvReporter csvReporter = null;
    private JmxReporter jmxReporter = null;
    private Slf4jReporter slf4jReporter = null;
    private GangliaReporter gangliaReporter = null;
    private GraphiteReporter graphiteReporter = null;

    public MetricRegistry getRegistry() {
        return this.registry;
    }

    public synchronized void addConsoleReporter(long reportIntervalInMS) {
        if (null != this.consoleReporter) {
            log.debug("Metrics ConsoleReporter already active; not creating another");
            return;
        }
        this.consoleReporter = ConsoleReporter.forRegistry((MetricRegistry)this.getRegistry()).build();
        this.consoleReporter.start(reportIntervalInMS, TimeUnit.MILLISECONDS);
        log.info("Configured Metrics ConsoleReporter configured with report interval={}ms", (Object)reportIntervalInMS);
    }

    public synchronized void removeConsoleReporter() {
        if (null != this.consoleReporter) {
            this.consoleReporter.stop();
        }
        this.consoleReporter = null;
    }

    public synchronized void addCsvReporter(long reportIntervalInMS, String output) {
        File outputDir = new File(output);
        if (null != this.csvReporter) {
            log.debug("Metrics CsvReporter already active; not creating another");
            return;
        }
        if (!outputDir.exists() && !outputDir.mkdirs()) {
            log.warn("Failed to create CSV metrics dir {}", (Object)outputDir);
        }
        this.csvReporter = CsvReporter.forRegistry((MetricRegistry)this.getRegistry()).build(outputDir);
        this.csvReporter.start(reportIntervalInMS, TimeUnit.MILLISECONDS);
        log.info("Configured Metrics CsvReporter configured with report interval={}ms to fileName={}", (Object)reportIntervalInMS, (Object)output);
    }

    public synchronized void removeCsvReporter() {
        if (null != this.csvReporter) {
            this.csvReporter.stop();
        }
        this.csvReporter = null;
    }

    public synchronized void addJmxReporter(String domain, String agentId) {
        if (null != this.jmxReporter) {
            log.debug("Metrics JmxReporter already active; not creating another");
            return;
        }
        JmxReporter.Builder b = JmxReporter.forRegistry((MetricRegistry)this.getRegistry());
        if (null != domain) {
            b.inDomain(domain);
        }
        if (null != agentId) {
            ArrayList<MBeanServer> servs = MBeanServerFactory.findMBeanServer(agentId);
            if (null != servs && 1 == servs.size()) {
                b.registerWith((MBeanServer)servs.get(0));
            } else {
                log.error("Metrics Slf4jReporter agentId {} does not resolve to a single MBeanServer", (Object)agentId);
            }
        }
        this.jmxReporter = b.build();
        this.jmxReporter.start();
        log.info("Configured Metrics JmxReporter configured with domain={} and agentId={}", (Object)Optional.ofNullable(domain).orElse(""), (Object)Optional.ofNullable(agentId).orElse(""));
    }

    public synchronized void removeJmxReporter() {
        if (null != this.jmxReporter) {
            this.jmxReporter.stop();
        }
        this.jmxReporter = null;
    }

    public synchronized void addSlf4jReporter(long reportIntervalInMS, String loggerName) {
        if (null != this.slf4jReporter) {
            log.debug("Metrics Slf4jReporter already active; not creating another");
            return;
        }
        Slf4jReporter.Builder b = Slf4jReporter.forRegistry((MetricRegistry)this.getRegistry());
        if (null != loggerName) {
            Logger l = LoggerFactory.getLogger((String)loggerName);
            if (null != l) {
                b.outputTo(l);
            } else {
                log.error("Logger with name {} could not be obtained", (Object)loggerName);
            }
        }
        this.slf4jReporter = b.build();
        this.slf4jReporter.start(reportIntervalInMS, TimeUnit.MILLISECONDS);
        log.info("Configured Metrics Slf4jReporter configured with interval={}ms and loggerName={}", (Object)reportIntervalInMS, (Object)loggerName);
    }

    public synchronized void removeSlf4jReporter() {
        if (null != this.slf4jReporter) {
            this.slf4jReporter.stop();
        }
        this.slf4jReporter = null;
    }

    public synchronized void addGangliaReporter(String groupOrHost, int port, String addressingMode, int ttl, Boolean protocol31, UUID hostUUID, String spoof, long reportIntervalInMS) throws IOException {
        GMetric.UDPAddressingMode gmetricAddressingMode;
        if (null == groupOrHost || groupOrHost.isEmpty()) {
            throw new IllegalArgumentException("groupOrHost cannot be null or empty");
        }
        if (null == addressingMode) {
            throw new IllegalArgumentException("addressing mode cannot be null");
        }
        try {
            gmetricAddressingMode = GMetric.UDPAddressingMode.valueOf((String)addressingMode);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("addressing mode must be MULTICAST or UNICAST");
        }
        if (null != this.gangliaReporter) {
            log.debug("Metrics GangliaReporter already active; not creating another");
            return;
        }
        boolean protocol = null == protocol31 ? true : protocol31;
        GMetric ganglia = new GMetric(groupOrHost, port, gmetricAddressingMode, ttl, protocol, hostUUID, spoof);
        GangliaReporter.Builder b = GangliaReporter.forRegistry((MetricRegistry)this.getRegistry());
        this.gangliaReporter = b.build(ganglia);
        this.gangliaReporter.start(reportIntervalInMS, TimeUnit.MILLISECONDS);
        log.info("Configured Ganglia Metrics reporter host={} interval={}ms port={} addrmode={} ttl={} proto31={} uuid={} spoof={}", new Object[]{groupOrHost, reportIntervalInMS, port, addressingMode, ttl, protocol31, hostUUID, spoof});
    }

    public synchronized void removeGangliaReporter() {
        if (null != this.gangliaReporter) {
            this.gangliaReporter.stop();
        }
        this.gangliaReporter = null;
    }

    public synchronized void addGraphiteReporter(String host, int port, String prefix, long reportIntervalInMS) {
        if (host == null || host.isEmpty()) {
            throw new IllegalArgumentException("Host cannot be null or empty");
        }
        Graphite graphite = new Graphite(new InetSocketAddress(host, port));
        GraphiteReporter.Builder b = GraphiteReporter.forRegistry((MetricRegistry)this.getRegistry());
        if (null != prefix) {
            b.prefixedWith(prefix);
        }
        b.filter(MetricFilter.ALL);
        this.graphiteReporter = b.build(graphite);
        this.graphiteReporter.start(reportIntervalInMS, TimeUnit.MILLISECONDS);
        log.info("Configured Graphite reporter host={} interval={}ms port={} prefix={}", new Object[]{host, reportIntervalInMS, port, prefix});
    }

    public synchronized void removeGraphiteReporter() {
        if (null != this.graphiteReporter) {
            this.graphiteReporter.stop();
        }
        this.graphiteReporter = null;
    }

    public synchronized void removeAllReporters() {
        this.removeConsoleReporter();
        this.removeCsvReporter();
        this.removeJmxReporter();
        this.removeSlf4jReporter();
        this.removeGangliaReporter();
        this.removeGraphiteReporter();
    }

    public synchronized void removeAllMetrics() {
        this.getRegistry().removeMatching((s, metric) -> true);
    }

    public int getCounterSize() {
        return INSTANCE.getRegistry().getCounters().size();
    }

    public boolean contains(String name) {
        return INSTANCE.getRegistry().getNames().contains(name);
    }

    public Counter getCounter(String name) {
        return this.getRegistry().counter(name);
    }

    public Counter getCounter(String prefix, String ... names) {
        return this.getRegistry().counter(MetricRegistry.name((String)prefix, (String[])names));
    }

    public <T> Gauge<T> getGuage(Gauge<T> gauge, String name) {
        return (Gauge)this.getRegistry().register(name, gauge);
    }

    public <T> Gauge<T> getGuage(Gauge<T> gauge, String prefix, String ... names) {
        return (Gauge)this.getRegistry().register(MetricRegistry.name((String)prefix, (String[])names), gauge);
    }

    public Meter getMeter(String name) {
        return this.getRegistry().meter(name);
    }

    public Meter getMeter(String prefix, String ... names) {
        return this.getRegistry().meter(MetricRegistry.name((String)prefix, (String[])names));
    }

    public Timer getTimer(String name) {
        return this.getRegistry().timer(name);
    }

    public Timer getTimer(String prefix, String ... names) {
        return this.getRegistry().timer(MetricRegistry.name((String)prefix, (String[])names));
    }

    public Histogram getHistogram(String name) {
        return this.getRegistry().histogram(name);
    }

    public Histogram getHistogram(String prefix, String ... names) {
        return this.getRegistry().histogram(MetricRegistry.name((String)prefix, (String[])names));
    }

    public void registerGremlinScriptEngineMetrics(GremlinScriptEngine engine, String ... prefix) {
        if (engine instanceof GremlinGroovyScriptEngine && this.getRegistry().getNames().stream().noneMatch(n -> n.endsWith("long-run-compilation-count"))) {
            GremlinGroovyScriptEngine gremlinGroovyScriptEngine = (GremlinGroovyScriptEngine)engine;
            this.getRegistry().register(MetricRegistry.name(GremlinServer.class, (String[])((String[])ArrayUtils.add((Object[])prefix, (Object)"long-run-compilation-count"))), (Metric)((Gauge)() -> ((GremlinGroovyScriptEngine)gremlinGroovyScriptEngine).getClassCacheLongRunCompilationCount()));
            this.getRegistry().register(MetricRegistry.name(GremlinServer.class, (String[])((String[])ArrayUtils.add((Object[])prefix, (Object)"estimated-size"))), (Metric)((Gauge)() -> ((GremlinGroovyScriptEngine)gremlinGroovyScriptEngine).getClassCacheEstimatedSize()));
            this.getRegistry().register(MetricRegistry.name(GremlinServer.class, (String[])((String[])ArrayUtils.add((Object[])prefix, (Object)"average-load-penalty"))), (Metric)((Gauge)() -> ((GremlinGroovyScriptEngine)gremlinGroovyScriptEngine).getClassCacheAverageLoadPenalty()));
            this.getRegistry().register(MetricRegistry.name(GremlinServer.class, (String[])((String[])ArrayUtils.add((Object[])prefix, (Object)"eviction-count"))), (Metric)((Gauge)() -> ((GremlinGroovyScriptEngine)gremlinGroovyScriptEngine).getClassCacheEvictionCount()));
            this.getRegistry().register(MetricRegistry.name(GremlinServer.class, (String[])((String[])ArrayUtils.add((Object[])prefix, (Object)"eviction-weight"))), (Metric)((Gauge)() -> ((GremlinGroovyScriptEngine)gremlinGroovyScriptEngine).getClassCacheEvictionWeight()));
            this.getRegistry().register(MetricRegistry.name(GremlinServer.class, (String[])((String[])ArrayUtils.add((Object[])prefix, (Object)"hit-count"))), (Metric)((Gauge)() -> ((GremlinGroovyScriptEngine)gremlinGroovyScriptEngine).getClassCacheHitCount()));
            this.getRegistry().register(MetricRegistry.name(GremlinServer.class, (String[])((String[])ArrayUtils.add((Object[])prefix, (Object)"hit-rate"))), (Metric)((Gauge)() -> ((GremlinGroovyScriptEngine)gremlinGroovyScriptEngine).getClassCacheHitRate()));
            this.getRegistry().register(MetricRegistry.name(GremlinServer.class, (String[])((String[])ArrayUtils.add((Object[])prefix, (Object)"load-count"))), (Metric)((Gauge)() -> ((GremlinGroovyScriptEngine)gremlinGroovyScriptEngine).getClassCacheLoadCount()));
            this.getRegistry().register(MetricRegistry.name(GremlinServer.class, (String[])((String[])ArrayUtils.add((Object[])prefix, (Object)"load-failure-count"))), (Metric)((Gauge)() -> ((GremlinGroovyScriptEngine)gremlinGroovyScriptEngine).getClassCacheLoadFailureCount()));
            this.getRegistry().register(MetricRegistry.name(GremlinServer.class, (String[])((String[])ArrayUtils.add((Object[])prefix, (Object)"load-failure-rate"))), (Metric)((Gauge)() -> ((GremlinGroovyScriptEngine)gremlinGroovyScriptEngine).getClassCacheLoadFailureRate()));
            this.getRegistry().register(MetricRegistry.name(GremlinServer.class, (String[])((String[])ArrayUtils.add((Object[])prefix, (Object)"load-success-count"))), (Metric)((Gauge)() -> ((GremlinGroovyScriptEngine)gremlinGroovyScriptEngine).getClassCacheLoadSuccessCount()));
            this.getRegistry().register(MetricRegistry.name(GremlinServer.class, (String[])((String[])ArrayUtils.add((Object[])prefix, (Object)"miss-count"))), (Metric)((Gauge)() -> ((GremlinGroovyScriptEngine)gremlinGroovyScriptEngine).getClassCacheMissCount()));
            this.getRegistry().register(MetricRegistry.name(GremlinServer.class, (String[])((String[])ArrayUtils.add((Object[])prefix, (Object)"miss-rate"))), (Metric)((Gauge)() -> ((GremlinGroovyScriptEngine)gremlinGroovyScriptEngine).getClassCacheMissRate()));
            this.getRegistry().register(MetricRegistry.name(GremlinServer.class, (String[])((String[])ArrayUtils.add((Object[])prefix, (Object)"request-count"))), (Metric)((Gauge)() -> ((GremlinGroovyScriptEngine)gremlinGroovyScriptEngine).getClassCacheRequestCount()));
            this.getRegistry().register(MetricRegistry.name(GremlinServer.class, (String[])((String[])ArrayUtils.add((Object[])prefix, (Object)"total-load-time"))), (Metric)((Gauge)() -> ((GremlinGroovyScriptEngine)gremlinGroovyScriptEngine).getClassCacheTotalLoadTime()));
        }
    }

    static {
        log = LoggerFactory.getLogger(MetricManager.class);
    }
}

