/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.util.CharsetUtil;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.driver.MessageSerializer;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.server.handler.ServerSerializers;
import org.apache.tinkerpop.gremlin.server.handler.StateKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NioGremlinBinaryRequestDecoder
extends ReplayingDecoder<DecoderState> {
    private static final Logger logger = LoggerFactory.getLogger(NioGremlinBinaryRequestDecoder.class);
    private final Map<String, MessageSerializer> serializers;
    private int messageLength;

    public NioGremlinBinaryRequestDecoder(Map<String, MessageSerializer> serializers) {
        super((Object)DecoderState.MESSAGE_LENGTH);
        this.serializers = serializers;
    }

    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> objects) throws Exception {
        switch ((DecoderState)((Object)this.state())) {
            case MESSAGE_LENGTH: {
                this.messageLength = byteBuf.readInt();
                this.checkpoint((Object)DecoderState.MESSAGE);
            }
            case MESSAGE: {
                try {
                    ByteBuf messageFrame = byteBuf.readBytes(this.messageLength);
                    byte contentTypeLength = messageFrame.readByte();
                    ByteBuf contentTypeFrame = messageFrame.readBytes((int)contentTypeLength);
                    String contentType = contentTypeFrame.toString(CharsetUtil.UTF_8);
                    MessageSerializer serializer = this.select(contentType, ServerSerializers.DEFAULT_SERIALIZER);
                    channelHandlerContext.channel().attr(StateKey.SESSION).set(null);
                    channelHandlerContext.channel().attr(StateKey.SERIALIZER).set((Object)serializer);
                    channelHandlerContext.channel().attr(StateKey.USE_BINARY).set((Object)true);
                    int payloadLength = this.messageLength - 1 - contentTypeLength;
                    objects.add(serializer.deserializeRequest(messageFrame.readBytes(payloadLength)));
                }
                catch (SerializationException se) {
                    objects.add(RequestMessage.INVALID);
                }
                this.checkpoint((Object)DecoderState.MESSAGE_LENGTH);
                break;
            }
            default: {
                throw new Error("Invalid message sent to Gremlin Server");
            }
        }
    }

    public MessageSerializer select(String mimeType, MessageSerializer defaultSerializer) {
        if (logger.isWarnEnabled() && !this.serializers.containsKey(mimeType)) {
            logger.warn("Gremlin Server is not configured with a serializer for the requested mime type [{}] - using {} by default", (Object)mimeType, (Object)defaultSerializer.getClass().getName());
        }
        return this.serializers.getOrDefault(mimeType, defaultSerializer);
    }

    public static enum DecoderState {
        MESSAGE_LENGTH,
        MESSAGE;

    }
}

