/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.op.traversal;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.netty.channel.ChannelHandlerContext;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.script.Bindings;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.tinkerpop.gremlin.driver.MessageSerializer;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.jsr223.JavaTranslator;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSideEffects;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.util.BytecodeHelper;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalInterruptedException;
import org.apache.tinkerpop.gremlin.server.Context;
import org.apache.tinkerpop.gremlin.server.GraphManager;
import org.apache.tinkerpop.gremlin.server.GremlinServer;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.handler.Frame;
import org.apache.tinkerpop.gremlin.server.handler.StateKey;
import org.apache.tinkerpop.gremlin.server.op.AbstractOpProcessor;
import org.apache.tinkerpop.gremlin.server.op.OpProcessorException;
import org.apache.tinkerpop.gremlin.server.util.MetricManager;
import org.apache.tinkerpop.gremlin.server.util.SideEffectIterator;
import org.apache.tinkerpop.gremlin.server.util.TraverserIterator;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONMapper;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONVersion;
import org.apache.tinkerpop.gremlin.util.function.ThrowingConsumer;
import org.apache.tinkerpop.shaded.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraversalOpProcessor
extends AbstractOpProcessor {
    private static final Logger logger = LoggerFactory.getLogger(TraversalOpProcessor.class);
    private static final ObjectMapper mapper = GraphSONMapper.build().version(GraphSONVersion.V2_0).create().createMapper();
    public static final String OP_PROCESSOR_NAME = "traversal";
    public static final Timer traversalOpTimer = MetricManager.INSTANCE.getTimer(MetricRegistry.name(GremlinServer.class, (String[])new String[]{"op", "traversal"}));
    public static final Settings.ProcessorSettings DEFAULT_SETTINGS = new Settings.ProcessorSettings();
    @Deprecated
    public static final String CONFIG_CACHE_EXPIRATION_TIME = "cacheExpirationTime";
    @Deprecated
    public static final long DEFAULT_CACHE_EXPIRATION_TIME = 600000L;
    @Deprecated
    public static final String CONFIG_CACHE_MAX_SIZE = "cacheMaxSize";
    @Deprecated
    public static final long DEFAULT_CACHE_MAX_SIZE = 1000L;
    protected static Cache<UUID, TraversalSideEffects> cache;
    private static final Bindings EMPTY_BINDINGS;

    public TraversalOpProcessor() {
        super(false);
    }

    @Override
    public String getName() {
        return OP_PROCESSOR_NAME;
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public void init(Settings settings) {
        Settings.ProcessorSettings processorSettings = settings.processors.stream().filter(p -> p.className.equals(TraversalOpProcessor.class.getCanonicalName())).findAny().orElse(DEFAULT_SETTINGS);
        long maxSize = Long.parseLong(processorSettings.config.get(CONFIG_CACHE_MAX_SIZE).toString());
        long expirationTime = Long.parseLong(processorSettings.config.get(CONFIG_CACHE_EXPIRATION_TIME).toString());
        cache = Caffeine.newBuilder().expireAfterWrite(expirationTime, TimeUnit.MILLISECONDS).maximumSize(maxSize).build();
        logger.info("Initialized cache for {} with size {} and expiration time of {} ms", new Object[]{TraversalOpProcessor.class.getSimpleName(), maxSize, expirationTime});
    }

    @Override
    public ThrowingConsumer<Context> select(Context context) throws OpProcessorException {
        ThrowingConsumer op;
        RequestMessage message = context.getRequestMessage();
        logger.debug("Selecting processor for RequestMessage {}", (Object)message);
        switch (message.getOp()) {
            case "bytecode": {
                TraversalOpProcessor.validateTraversalSourceAlias(context, message, TraversalOpProcessor.validateTraversalRequest(message));
                op = this::iterateBytecodeTraversal;
                break;
            }
            case "gather": {
                Optional sideEffectForGather = message.optionalArgs("sideEffect");
                if (!sideEffectForGather.isPresent()) {
                    String msg = String.format("A message with an [%s] op code requires a [%s] argument.", "gather", "sideEffect");
                    throw new OpProcessorException(msg, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(msg).create());
                }
                Optional sideEffectKey = message.optionalArgs("sideEffectKey");
                if (!sideEffectKey.isPresent()) {
                    String msg = String.format("A message with an [%s] op code requires a [%s] argument.", "gather", "sideEffectKey");
                    throw new OpProcessorException(msg, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(msg).create());
                }
                TraversalOpProcessor.validateTraversalSourceAlias(context, message, TraversalOpProcessor.validatedAliases(message).get());
                op = this::gatherSideEffect;
                break;
            }
            case "keys": {
                Optional sideEffectForKeys = message.optionalArgs("sideEffect");
                if (!sideEffectForKeys.isPresent()) {
                    String msg = String.format("A message with an [%s] op code requires a [%s] argument.", "gather", "sideEffect");
                    throw new OpProcessorException(msg, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(msg).create());
                }
                op = varRhc -> {
                    RequestMessage msg = context.getRequestMessage();
                    Optional sideEffect = msg.optionalArgs("sideEffect");
                    TraversalSideEffects sideEffects = (TraversalSideEffects)cache.getIfPresent(sideEffect.get());
                    if (null == sideEffects) {
                        logger.warn("Request for side-effect keys on {} returned no side-effects in the cache", sideEffect.get());
                    }
                    this.handleIterator((Context)varRhc, (Iterator)(null == sideEffects ? Collections.emptyIterator() : sideEffects.keys().iterator()));
                };
                break;
            }
            case "close": {
                Optional sideEffectForClose = message.optionalArgs("sideEffect");
                if (!sideEffectForClose.isPresent()) {
                    String msg = String.format("A message with an [%s] op code requires a [%s] argument.", "close", "sideEffect");
                    throw new OpProcessorException(msg, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(msg).create());
                }
                op = varRhc -> {
                    RequestMessage msg = context.getRequestMessage();
                    logger.debug("Close request {} for in thread {}", (Object)msg.getRequestId(), (Object)Thread.currentThread().getName());
                    Optional sideEffect = msg.optionalArgs("sideEffect");
                    cache.invalidate(sideEffect.get());
                    String successMessage = String.format("Successfully cleared side effect cache for [%s].", "sideEffect");
                    varRhc.writeAndFlush(ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.NO_CONTENT).statusMessage(successMessage).create());
                };
                break;
            }
            case "invalid": {
                String msgInvalid = String.format("Message could not be parsed.  Check the format of the request. [%s]", message);
                throw new OpProcessorException(msgInvalid, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_MALFORMED_REQUEST).statusMessage(msgInvalid).create());
            }
            default: {
                String msgDefault = String.format("Message with op code [%s] is not recognized.", message.getOp());
                throw new OpProcessorException(msgDefault, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_MALFORMED_REQUEST).statusMessage(msgDefault).create());
            }
        }
        return op;
    }

    private static void validateTraversalSourceAlias(Context ctx, RequestMessage message, Map<String, String> aliases) throws OpProcessorException {
        String traversalSourceBindingForAlias = aliases.values().iterator().next();
        if (!ctx.getGraphManager().getTraversalSourceNames().contains(traversalSourceBindingForAlias)) {
            String msg = String.format("The traversal source [%s] for alias [%s] is not configured on the server.", traversalSourceBindingForAlias, "g");
            throw new OpProcessorException(msg, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(msg).create());
        }
    }

    private static Map<String, String> validateTraversalRequest(RequestMessage message) throws OpProcessorException {
        if (!message.optionalArgs("gremlin").isPresent()) {
            String msg = String.format("A message with [%s] op code requires a [%s] argument.", "bytecode", "gremlin");
            throw new OpProcessorException(msg, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(msg).create());
        }
        return TraversalOpProcessor.validatedAliases(message).get();
    }

    private static Optional<Map<String, String>> validatedAliases(RequestMessage message) throws OpProcessorException {
        Optional aliases = message.optionalArgs("aliases");
        if (!aliases.isPresent()) {
            String msg = String.format("A message with [%s] op code requires a [%s] argument.", "bytecode", "aliases");
            throw new OpProcessorException(msg, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(msg).create());
        }
        if (((Map)aliases.get()).size() != 1 || !((Map)aliases.get()).containsKey("g")) {
            String msg = String.format("A message with [%s] op code requires the [%s] argument to be a Map containing one alias assignment named '%s'.", "bytecode", "aliases", "g");
            throw new OpProcessorException(msg, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(msg).create());
        }
        return aliases;
    }

    private void gatherSideEffect(Context context) throws OpProcessorException {
        RequestMessage msg = context.getRequestMessage();
        logger.debug("Side-effect request {} for in thread {}", (Object)msg.getRequestId(), (Object)Thread.currentThread().getName());
        Optional sideEffect = msg.optionalArgs("sideEffect");
        Optional sideEffectKey = msg.optionalArgs("sideEffectKey");
        Map aliases = (Map)msg.optionalArgs("aliases").get();
        GraphManager graphManager = context.getGraphManager();
        String traversalSourceName = (String)aliases.entrySet().iterator().next().getValue();
        TraversalSource g = graphManager.getTraversalSource(traversalSourceName);
        Timer.Context timerContext = traversalOpTimer.time();
        try {
            ChannelHandlerContext ctx = context.getChannelHandlerContext();
            Graph graph = g.getGraph();
            context.getGremlinExecutor().getExecutorService().submit(() -> {
                try {
                    TraversalSideEffects sideEffects;
                    block14: {
                        this.beforeProcessing(graph, context);
                        sideEffects = (TraversalSideEffects)cache.getIfPresent(sideEffect.get());
                        if (null != sideEffects) break block14;
                        String errorMessage = String.format("Could not find side-effects for %s.", sideEffect.get());
                        logger.warn(errorMessage);
                        context.writeAndFlush(ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR).statusMessage(errorMessage).create());
                        this.onError(graph, context);
                        return;
                    }
                    if (!sideEffects.exists((String)sideEffectKey.get())) {
                        String errorMessage = String.format("Could not find side-effect key for %s in %s.", sideEffectKey.get(), sideEffect.get());
                        logger.warn(errorMessage);
                        context.writeAndFlush(ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR).statusMessage(errorMessage).create());
                        this.onError(graph, context);
                        return;
                    }
                    try {
                        this.handleIterator(context, (Iterator)new SideEffectIterator(sideEffects.get((String)sideEffectKey.get()), (String)sideEffectKey.get()));
                    }
                    catch (TimeoutException ex) {
                        String errorMessage = String.format("Response iteration exceeded the configured threshold for request [%s] - %s", msg.getRequestId(), ex.getMessage());
                        logger.warn(errorMessage);
                        context.writeAndFlush(ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR_TIMEOUT).statusMessage(errorMessage).statusAttributeException((Throwable)ex).create());
                        this.onError(graph, context);
                        return;
                    }
                    catch (Exception ex) {
                        logger.warn(String.format("Exception processing a side-effect on iteration for request [%s].", msg.getRequestId()), (Throwable)ex);
                        context.writeAndFlush(ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR).statusMessage(ex.getMessage()).statusAttributeException((Throwable)ex).create());
                        this.onError(graph, context);
                        return;
                    }
                    this.onSideEffectSuccess(graph, context);
                }
                catch (Exception ex) {
                    logger.warn(String.format("Exception processing a side-effect on request [%s].", msg.getRequestId()), (Throwable)ex);
                    context.writeAndFlush(ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR).statusMessage(ex.getMessage()).statusAttributeException((Throwable)ex).create());
                    this.onError(graph, context);
                }
                finally {
                    timerContext.stop();
                }
            });
        }
        catch (Exception ex) {
            timerContext.stop();
            throw new OpProcessorException("Could not iterate the side-effect instance", ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR).statusMessage(ex.getMessage()).statusAttributeException((Throwable)ex).create());
        }
    }

    private void iterateBytecodeTraversal(Context context) throws Exception {
        Traversal.Admin traversal;
        RequestMessage msg = context.getRequestMessage();
        logger.debug("Traversal request {} for in thread {}", (Object)msg.getRequestId(), (Object)Thread.currentThread().getName());
        Object bytecodeObj = msg.getArgs().get("gremlin");
        Bytecode bytecode = bytecodeObj instanceof Bytecode ? (Bytecode)bytecodeObj : (Bytecode)mapper.readValue(bytecodeObj.toString(), Bytecode.class);
        Map aliases = (Map)msg.optionalArgs("aliases").get();
        Map args = msg.getArgs();
        long seto = args.containsKey("scriptEvaluationTimeout") || args.containsKey("evaluationTimeout") ? (args.containsKey("scriptEvaluationTimeout") ? ((Number)args.get("scriptEvaluationTimeout")).longValue() : ((Number)args.get("evaluationTimeout")).longValue()) : context.getSettings().getEvaluationTimeout();
        GraphManager graphManager = context.getGraphManager();
        String traversalSourceName = (String)aliases.entrySet().iterator().next().getValue();
        TraversalSource g = graphManager.getTraversalSource(traversalSourceName);
        try {
            Optional lambdaLanguage = BytecodeHelper.getLambdaLanguage((Bytecode)bytecode);
            traversal = !lambdaLanguage.isPresent() ? JavaTranslator.of((TraversalSource)g).translate(bytecode) : context.getGremlinExecutor().eval(bytecode, EMPTY_BINDINGS, (String)lambdaLanguage.get(), traversalSourceName);
        }
        catch (ScriptException ex) {
            logger.error("Traversal contains a lambda that cannot be compiled", (Throwable)ex);
            throw new OpProcessorException("Traversal contains a lambda that cannot be compiled", ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR_SCRIPT_EVALUATION).statusMessage(ex.getMessage()).statusAttributeException((Throwable)ex).create());
        }
        catch (Exception ex) {
            logger.error("Could not deserialize the Traversal instance", (Throwable)ex);
            throw new OpProcessorException("Could not deserialize the Traversal instance", ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR_SERIALIZATION).statusMessage(ex.getMessage()).statusAttributeException((Throwable)ex).create());
        }
        Timer.Context timerContext = traversalOpTimer.time();
        FutureTask<Void> evalFuture = new FutureTask<Void>(() -> {
            block9: {
                Graph graph = g.getGraph();
                try {
                    this.beforeProcessing(graph, context);
                    try {
                        traversal.applyStrategies();
                        this.handleIterator(context, new TraverserIterator(traversal), graph);
                    }
                    catch (Exception ex) {
                        Throwable t = ex;
                        if (ex instanceof UndeclaredThrowableException) {
                            t = t.getCause();
                        }
                        if (t instanceof InterruptedException || t instanceof TraversalInterruptedException) {
                            String errorMessage = String.format("A timeout occurred during traversal evaluation of [%s] - consider increasing the limit given to evaluationTimeout", msg);
                            logger.warn(errorMessage);
                            context.writeAndFlush(ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR_TIMEOUT).statusMessage(errorMessage).statusAttributeException((Throwable)ex).create());
                            this.onError(graph, context);
                            break block9;
                        }
                        logger.warn(String.format("Exception processing a Traversal on iteration for request [%s].", msg.getRequestId()), (Throwable)ex);
                        context.writeAndFlush(ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR).statusMessage(ex.getMessage()).statusAttributeException((Throwable)ex).create());
                        this.onError(graph, context);
                    }
                }
                catch (Exception ex) {
                    logger.warn(String.format("Exception processing a Traversal on request [%s].", msg.getRequestId()), (Throwable)ex);
                    context.writeAndFlush(ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR).statusMessage(ex.getMessage()).statusAttributeException((Throwable)ex).create());
                    this.onError(graph, context);
                }
                finally {
                    timerContext.stop();
                }
            }
            return null;
        });
        Future<?> executionFuture = context.getGremlinExecutor().getExecutorService().submit(evalFuture);
        if (seto > 0L) {
            context.getScheduledExecutorService().schedule(() -> executionFuture.cancel(true), seto, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    protected void iterateComplete(ChannelHandlerContext ctx, RequestMessage msg, Iterator itty) {
        Traversal.Admin traversal;
        if (itty instanceof TraverserIterator && !(traversal = ((TraverserIterator)itty).getTraversal()).getSideEffects().isEmpty()) {
            cache.put((Object)msg.getRequestId(), (Object)traversal.getSideEffects());
        }
    }

    protected void beforeProcessing(Graph graph, Context ctx) {
        if (graph.features().graph().supportsTransactions() && graph.tx().isOpen()) {
            graph.tx().rollback();
        }
    }

    protected void onError(Graph graph, Context ctx) {
        if (graph.features().graph().supportsTransactions() && graph.tx().isOpen()) {
            graph.tx().rollback();
        }
    }

    protected void onTraversalSuccess(Graph graph, Context ctx) {
        if (graph.features().graph().supportsTransactions() && graph.tx().isOpen()) {
            graph.tx().commit();
        }
    }

    protected void onSideEffectSuccess(Graph graph, Context ctx) {
        if (graph.features().graph().supportsTransactions() && graph.tx().isOpen()) {
            graph.tx().rollback();
        }
    }

    @Override
    protected Map<String, Object> generateMetaData(ChannelHandlerContext ctx, RequestMessage msg, ResponseStatusCode code, Iterator itty) {
        SideEffectIterator traversalIterator;
        String key;
        Map<String, Object> metaData = Collections.emptyMap();
        if (itty instanceof SideEffectIterator && (key = (traversalIterator = (SideEffectIterator)itty).getSideEffectKey()) != null) {
            metaData = new HashMap<String, Object>();
            metaData.put("sideEffectKey", key);
            metaData.put("aggregateTo", traversalIterator.getSideEffectAggregator());
        }
        return metaData;
    }

    protected void handleIterator(Context context, Iterator itty, Graph graph) throws InterruptedException {
        ChannelHandlerContext nettyContext = context.getChannelHandlerContext();
        RequestMessage msg = context.getRequestMessage();
        Settings settings = context.getSettings();
        MessageSerializer serializer = (MessageSerializer)nettyContext.channel().attr(StateKey.SERIALIZER).get();
        boolean useBinary = (Boolean)nettyContext.channel().attr(StateKey.USE_BINARY).get();
        boolean warnOnce = false;
        if (!itty.hasNext()) {
            this.onTraversalSuccess(graph, context);
            if (itty instanceof TraverserIterator && !((TraverserIterator)itty).getTraversal().getSideEffects().isEmpty()) {
                cache.put((Object)msg.getRequestId(), (Object)((TraverserIterator)itty).getTraversal().getSideEffects());
            }
            context.writeAndFlush(ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.NO_CONTENT).create());
            return;
        }
        int resultIterationBatchSize = msg.optionalArgs("batchSize").orElse(settings.resultIterationBatchSize);
        ArrayList<Object> aggregate = new ArrayList<Object>(resultIterationBatchSize);
        boolean hasMore = itty.hasNext();
        while (hasMore) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            boolean forceFlush = this.isForceFlushed(nettyContext, msg, itty);
            if (aggregate.size() < resultIterationBatchSize && itty.hasNext() && !forceFlush) {
                aggregate.add(itty.next());
            }
            if (nettyContext.channel().isActive() && nettyContext.channel().isWritable()) {
                if (!forceFlush && aggregate.size() != resultIterationBatchSize && itty.hasNext()) continue;
                ResponseStatusCode code = itty.hasNext() ? ResponseStatusCode.PARTIAL_CONTENT : ResponseStatusCode.SUCCESS;
                Map<String, Object> metadata = this.generateMetaData(nettyContext, msg, code, itty);
                Frame frame = null;
                try {
                    frame = TraversalOpProcessor.makeFrame(context, msg, serializer, useBinary, aggregate, code, metadata);
                }
                catch (Exception ex) {
                    if (frame != null) {
                        frame.tryRelease();
                    }
                    this.onError(graph, context);
                    break;
                }
                try {
                    if (itty.hasNext()) {
                        aggregate = new ArrayList(resultIterationBatchSize);
                    } else {
                        this.onTraversalSuccess(graph, context);
                        hasMore = false;
                    }
                }
                catch (Exception ex) {
                    if (frame != null) {
                        frame.tryRelease();
                    }
                    throw ex;
                }
                if (!itty.hasNext()) {
                    this.iterateComplete(nettyContext, msg, itty);
                }
                context.writeAndFlush(code, frame);
                continue;
            }
            if (!warnOnce) {
                logger.warn("Pausing response writing as writeBufferHighWaterMark exceeded on {} - writing will continue once client has caught up", (Object)msg);
                warnOnce = true;
            }
            TimeUnit.MILLISECONDS.sleep(10L);
        }
    }

    static {
        TraversalOpProcessor.DEFAULT_SETTINGS.className = TraversalOpProcessor.class.getCanonicalName();
        TraversalOpProcessor.DEFAULT_SETTINGS.config = new HashMap<String, Object>(){
            {
                this.put(TraversalOpProcessor.CONFIG_CACHE_EXPIRATION_TIME, 600000L);
                this.put(TraversalOpProcessor.CONFIG_CACHE_MAX_SIZE, 1000L);
            }
        };
        cache = null;
        EMPTY_BINDINGS = new SimpleBindings();
    }
}

