/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.op.traversal;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import io.netty.channel.ChannelHandlerContext;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.HaltedTraverserStrategy;
import org.apache.tinkerpop.gremlin.server.Context;
import org.apache.tinkerpop.gremlin.server.GraphManager;
import org.apache.tinkerpop.gremlin.server.GremlinServer;
import org.apache.tinkerpop.gremlin.server.op.AbstractOpProcessor;
import org.apache.tinkerpop.gremlin.server.op.OpProcessorException;
import org.apache.tinkerpop.gremlin.server.util.MetricManager;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.util.Serializer;
import org.apache.tinkerpop.gremlin.util.function.ThrowingConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraversalOpProcessor
extends AbstractOpProcessor {
    private static final Logger logger = LoggerFactory.getLogger(TraversalOpProcessor.class);
    public static final String OP_PROCESSOR_NAME = "traversal";
    public static final Timer traversalOpTimer = MetricManager.INSTANCE.getTimer(MetricRegistry.name(GremlinServer.class, (String[])new String[]{"op", "traversal"}));

    public TraversalOpProcessor() {
        super(true);
    }

    @Override
    public String getName() {
        return OP_PROCESSOR_NAME;
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public ThrowingConsumer<Context> select(Context ctx) throws OpProcessorException {
        ThrowingConsumer op;
        RequestMessage message = ctx.getRequestMessage();
        logger.debug("Selecting processor for RequestMessage {}", (Object)message);
        switch (message.getOp()) {
            case "traverse": {
                if (!message.optionalArgs("gremlin").isPresent()) {
                    String msg = String.format("A message with an [%s] op code requires a [%s] argument.", "traverse", "gremlin");
                    throw new OpProcessorException(msg, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(msg).create());
                }
                Optional aliases = message.optionalArgs("aliases");
                if (!aliases.isPresent()) {
                    String msg = String.format("A message with an [%s] op code requires a [%s] argument.", "traverse", "aliases");
                    throw new OpProcessorException(msg, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(msg).create());
                }
                if (((Map)aliases.get()).size() != 1) {
                    String msg = String.format("A message with an [%s] op code requires the [%s] argument to be a Map containing one alias assignment.", "traverse", "aliases");
                    throw new OpProcessorException(msg, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(msg).create());
                }
                Map.Entry kv = ((Map)aliases.get()).entrySet().iterator().next();
                if (!ctx.getGraphManager().getGraphs().containsKey(kv.getValue())) {
                    String msg = String.format("The graph [%s] for alias [%s] is not configured on the server.", kv.getValue(), kv.getKey());
                    throw new OpProcessorException(msg, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(msg).create());
                }
                op = this::iterateOp;
                break;
            }
            case "invalid": {
                String msgInvalid = String.format("Message could not be parsed.  Check the format of the request. [%s]", message);
                throw new OpProcessorException(msgInvalid, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_MALFORMED_REQUEST).statusMessage(msgInvalid).create());
            }
            default: {
                String msgDefault = String.format("Message with op code [%s] is not recognized.", message.getOp());
                throw new OpProcessorException(msgDefault, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_MALFORMED_REQUEST).statusMessage(msgDefault).create());
            }
        }
        return op;
    }

    private void iterateOp(Context context) throws OpProcessorException {
        Traversal.Admin traversal;
        RequestMessage msg = context.getRequestMessage();
        if (logger.isDebugEnabled()) {
            logger.debug("Traversal request {} for in thread {}", (Object)msg.getRequestId(), (Object)Thread.currentThread().getName());
        }
        byte[] serializedTraversal = (byte[])msg.getArgs().get("gremlin");
        Map aliases = (Map)msg.optionalArgs("aliases").get();
        try {
            traversal = (Traversal.Admin)Serializer.deserializeObject((byte[])serializedTraversal);
        }
        catch (Exception ex) {
            throw new OpProcessorException("Could not deserialize the Traversal instance", ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR_SERIALIZATION).statusMessage(ex.getMessage()).create());
        }
        if (traversal.isLocked()) {
            throw new OpProcessorException("Locked Traversals cannot be processed by the server", ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR_SERIALIZATION).statusMessage("Locked Traversals cannot be processed by the server").create());
        }
        Timer.Context timerContext = traversalOpTimer.time();
        try {
            ChannelHandlerContext ctx = context.getChannelHandlerContext();
            GraphManager graphManager = context.getGraphManager();
            String graphName = (String)aliases.entrySet().iterator().next().getValue();
            Graph graph = graphManager.getGraphs().get(graphName);
            boolean supportsTransactions = graph.features().graph().supportsTransactions();
            TraversalOpProcessor.configureTraversal(traversal, graph);
            context.getGremlinExecutor().getExecutorService().submit(() -> {
                block15: {
                    try {
                        if (supportsTransactions && graph.tx().isOpen()) {
                            graph.tx().rollback();
                        }
                        try {
                            traversal.applyStrategies();
                            this.handleIterator(context, new DetachingIterator(traversal));
                        }
                        catch (TimeoutException ex) {
                            String errorMessage = String.format("Response iteration exceeded the configured threshold for request [%s] - %s", msg.getRequestId(), ex.getMessage());
                            logger.warn(errorMessage);
                            ctx.writeAndFlush((Object)ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR_TIMEOUT).statusMessage(errorMessage).create());
                            if (supportsTransactions && graph.tx().isOpen()) {
                                graph.tx().rollback();
                            }
                            timerContext.stop();
                            return;
                        }
                        catch (Exception ex) {
                            block14: {
                                logger.warn(String.format("Exception processing a Traversal on iteration for request [%s].", msg.getRequestId()), (Throwable)ex);
                                ctx.writeAndFlush((Object)ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR).statusMessage(ex.getMessage()).create());
                                if (!supportsTransactions || !graph.tx().isOpen()) break block14;
                                graph.tx().rollback();
                            }
                            timerContext.stop();
                            return;
                        }
                        if (graph.features().graph().supportsTransactions()) {
                            graph.tx().commit();
                        }
                        break block15;
                        {
                            catch (Exception ex) {
                                logger.warn(String.format("Exception processing a Traversal on request [%s].", msg.getRequestId()), (Throwable)ex);
                                ctx.writeAndFlush((Object)ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR).statusMessage(ex.getMessage()).create());
                                if (graph.features().graph().supportsTransactions() && graph.tx().isOpen()) {
                                    graph.tx().rollback();
                                }
                                break block15;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        timerContext.stop();
                    }
                }
            });
        }
        catch (Exception ex) {
            timerContext.stop();
            throw new OpProcessorException("Could not iterate the Traversal instance", ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR).statusMessage(ex.getMessage()).create());
        }
    }

    private static void configureTraversal(Traversal.Admin<?, ?> traversal, Graph graph) {
        traversal.setGraph(graph);
        List strategies = TraversalStrategies.GlobalCache.getStrategies(graph.getClass()).toList();
        TraversalStrategy[] arrayOfStrategies = new TraversalStrategy[strategies.size()];
        strategies.toArray(arrayOfStrategies);
        traversal.getStrategies().addStrategies(arrayOfStrategies);
    }

    static class DetachingIterator<E>
    implements Iterator<Traverser.Admin<E>> {
        private Iterator<Traverser.Admin<E>> inner;
        private HaltedTraverserStrategy haltedTraverserStrategy;

        public DetachingIterator(Traversal.Admin<?, E> traversal) {
            this.inner = traversal.getEndStep();
            this.haltedTraverserStrategy = (HaltedTraverserStrategy)traversal.getStrategies().toList().stream().filter(s -> s instanceof HaltedTraverserStrategy).findAny().orElse((TraversalStrategy)(Boolean.valueOf(System.getProperty("is.testing", "false")) != false ? HaltedTraverserStrategy.detached() : HaltedTraverserStrategy.reference()));
        }

        @Override
        public boolean hasNext() {
            return this.inner.hasNext();
        }

        @Override
        public Traverser.Admin<E> next() {
            return this.haltedTraverserStrategy.halt(this.inner.next());
        }
    }
}

