/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.handler;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.groovy.engine.GremlinExecutor;
import org.apache.tinkerpop.gremlin.server.Context;
import org.apache.tinkerpop.gremlin.server.GraphManager;
import org.apache.tinkerpop.gremlin.server.GremlinServer;
import org.apache.tinkerpop.gremlin.server.OpProcessor;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.op.OpLoader;
import org.apache.tinkerpop.gremlin.server.op.OpProcessorException;
import org.apache.tinkerpop.gremlin.server.util.MetricManager;
import org.javatuples.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class OpSelectorHandler
extends MessageToMessageDecoder<RequestMessage> {
    private static final Logger logger = LoggerFactory.getLogger(OpSelectorHandler.class);
    @Deprecated
    static final Meter errorMeter = MetricManager.INSTANCE.getMeter(MetricRegistry.name(GremlinServer.class, (String[])new String[]{"errors"}));
    private final Settings settings;
    private final GraphManager graphManager;
    private final GremlinExecutor gremlinExecutor;
    private final ScheduledExecutorService scheduledExecutorService;

    public OpSelectorHandler(Settings settings, GraphManager graphManager, GremlinExecutor gremlinExecutor, ScheduledExecutorService scheduledExecutorService) {
        this.settings = settings;
        this.graphManager = graphManager;
        this.gremlinExecutor = gremlinExecutor;
        this.scheduledExecutorService = scheduledExecutorService;
    }

    protected void decode(ChannelHandlerContext ctx, RequestMessage msg, List<Object> objects) throws Exception {
        Context gremlinServerContext = new Context(msg, ctx, this.settings, this.graphManager, this.gremlinExecutor, this.scheduledExecutorService);
        try {
            Optional<OpProcessor> processor = OpLoader.getProcessor(msg.getProcessor());
            if (!processor.isPresent()) {
                String errorMessage = String.format("Invalid OpProcessor requested [%s]", msg.getProcessor());
                throw new OpProcessorException(errorMessage, ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(errorMessage).create());
            }
            objects.add(Pair.with((Object)msg, processor.get().select(gremlinServerContext)));
        }
        catch (OpProcessorException ope) {
            logger.warn(ope.getMessage(), (Throwable)ope);
            ctx.writeAndFlush((Object)ope.getResponseMessage());
        }
    }
}

