/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.script.Bindings;
import javax.script.SimpleBindings;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.server.GremlinServer;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.util.GraphFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GraphManager {
    private static final Logger logger = LoggerFactory.getLogger(GremlinServer.class);
    private final Map<String, Graph> graphs = new ConcurrentHashMap<String, Graph>();
    private final Map<String, TraversalSource> traversalSources = new ConcurrentHashMap<String, TraversalSource>();

    public GraphManager(Settings settings) {
        settings.graphs.entrySet().forEach(e -> {
            block2: {
                try {
                    Graph newGraph = GraphFactory.open((String)((String)e.getValue()));
                    this.graphs.put((String)e.getKey(), newGraph);
                    logger.info("Graph [{}] was successfully configured via [{}].", e.getKey(), e.getValue());
                }
                catch (RuntimeException re) {
                    logger.warn(String.format("Graph [%s] configured at [%s] could not be instantiated and will not be available in Gremlin Server.  GraphFactory message: %s", e.getKey(), e.getValue(), re.getMessage()), (Throwable)re);
                    if (re.getCause() == null) break block2;
                    logger.debug("GraphFactory exception", re.getCause());
                }
            }
        });
    }

    public Map<String, Graph> getGraphs() {
        return this.graphs;
    }

    public Map<String, TraversalSource> getTraversalSources() {
        return this.traversalSources;
    }

    public Bindings getAsBindings() {
        SimpleBindings bindings = new SimpleBindings();
        this.graphs.forEach(bindings::put);
        this.traversalSources.forEach(bindings::put);
        return bindings;
    }

    public void rollbackAll() {
        this.graphs.entrySet().forEach(e -> {
            Graph graph = (Graph)e.getValue();
            if (graph.features().graph().supportsTransactions() && graph.tx().isOpen()) {
                graph.tx().rollback();
            }
        });
    }

    public void rollback(Set<String> graphSourceNamesToCloseTxOn) {
        this.closeTx(graphSourceNamesToCloseTxOn, Transaction.Status.ROLLBACK);
    }

    public void commitAll() {
        this.graphs.entrySet().forEach(e -> {
            Graph graph = (Graph)e.getValue();
            if (graph.features().graph().supportsTransactions() && graph.tx().isOpen()) {
                graph.tx().commit();
            }
        });
    }

    public void commit(Set<String> graphSourceNamesToCloseTxOn) {
        this.closeTx(graphSourceNamesToCloseTxOn, Transaction.Status.COMMIT);
    }

    private void closeTx(Set<String> graphSourceNamesToCloseTxOn, Transaction.Status tx) {
        HashSet graphsToCloseTxOn = new HashSet();
        graphSourceNamesToCloseTxOn.forEach(r -> {
            if (this.graphs.containsKey(r)) {
                graphsToCloseTxOn.add(this.graphs.get(r));
            } else {
                graphsToCloseTxOn.add(this.traversalSources.get(r).getGraph().get());
            }
        });
        graphsToCloseTxOn.forEach(graph -> {
            if (graph.features().graph().supportsTransactions() && graph.tx().isOpen()) {
                if (tx == Transaction.Status.COMMIT) {
                    graph.tx().commit();
                } else {
                    graph.tx().rollback();
                }
            }
        });
    }
}

