/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.op.standard;

import java.util.Map;
import java.util.Optional;
import javax.script.SimpleBindings;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.server.Context;
import org.apache.tinkerpop.gremlin.server.op.AbstractEvalOpProcessor;
import org.apache.tinkerpop.gremlin.server.op.OpProcessorException;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.util.function.ThrowingConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardOpProcessor
extends AbstractEvalOpProcessor {
    private static final Logger logger = LoggerFactory.getLogger(StandardOpProcessor.class);
    public static final String OP_PROCESSOR_NAME = "";

    public StandardOpProcessor() {
        super(true);
    }

    @Override
    public String getName() {
        return OP_PROCESSOR_NAME;
    }

    @Override
    public ThrowingConsumer<Context> getEvalOp() {
        return this::evalOp;
    }

    @Override
    public Optional<ThrowingConsumer<Context>> selectOther(RequestMessage requestMessage) throws OpProcessorException {
        return Optional.empty();
    }

    @Override
    public void close() throws Exception {
    }

    private void evalOp(Context context) throws OpProcessorException {
        RequestMessage msg = context.getRequestMessage();
        logger.debug("Sessionless request {} for eval in thread {}", (Object)msg.getRequestId(), (Object)Thread.currentThread().getName());
        super.evalOpInternal(context, context::getGremlinExecutor, () -> {
            SimpleBindings bindings = new SimpleBindings();
            if (msg.getArgs().containsKey("rebindings")) {
                Map rebinds = (Map)msg.getArgs().get("rebindings");
                for (Map.Entry kv : rebinds.entrySet()) {
                    Map<String, TraversalSource> traversalSources;
                    boolean found = false;
                    Map<String, Graph> graphs = context.getGraphManager().getGraphs();
                    if (graphs.containsKey(kv.getValue())) {
                        bindings.put((String)kv.getKey(), (Object)graphs.get(kv.getValue()));
                        found = true;
                    }
                    if (!found && (traversalSources = context.getGraphManager().getTraversalSources()).containsKey(kv.getValue())) {
                        bindings.put((String)kv.getKey(), (Object)traversalSources.get(kv.getValue()));
                        found = true;
                    }
                    if (found) continue;
                    String error = String.format("Could not rebind [%s] to [%s] as [%s] not in the Graph or TraversalSource global bindings", kv.getKey(), kv.getValue(), kv.getValue());
                    throw new OpProcessorException(error, ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).result((Object)error).create());
                }
            }
            Optional.ofNullable((Map)msg.getArgs().get("bindings")).ifPresent(bindings::putAll);
            return bindings;
        });
    }
}

