/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.channel;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import org.apache.tinkerpop.gremlin.server.AbstractChannelizer;
import org.apache.tinkerpop.gremlin.server.auth.AllowAllAuthenticator;
import org.apache.tinkerpop.gremlin.server.handler.SaslAuthenticationHandler;
import org.apache.tinkerpop.gremlin.server.handler.WsGremlinBinaryRequestDecoder;
import org.apache.tinkerpop.gremlin.server.handler.WsGremlinCloseRequestDecoder;
import org.apache.tinkerpop.gremlin.server.handler.WsGremlinResponseEncoder;
import org.apache.tinkerpop.gremlin.server.handler.WsGremlinTextRequestDecoder;
import org.apache.tinkerpop.gremlin.server.util.ServerGremlinExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketChannelizer
extends AbstractChannelizer {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketChannelizer.class);
    private WsGremlinResponseEncoder wsGremlinResponseEncoder;
    private WsGremlinTextRequestDecoder wsGremlinTextRequestDecoder;
    private WsGremlinBinaryRequestDecoder wsGremlinBinaryRequestDecoder;
    private WsGremlinCloseRequestDecoder wsGremlinCloseRequestDecoder;
    private SaslAuthenticationHandler authenticationHandler;

    @Override
    public void init(ServerGremlinExecutor<EventLoopGroup> serverGremlinExecutor) {
        super.init(serverGremlinExecutor);
        this.wsGremlinResponseEncoder = new WsGremlinResponseEncoder();
        this.wsGremlinTextRequestDecoder = new WsGremlinTextRequestDecoder(this.serializers);
        this.wsGremlinBinaryRequestDecoder = new WsGremlinBinaryRequestDecoder(this.serializers);
        this.wsGremlinCloseRequestDecoder = new WsGremlinCloseRequestDecoder(this.serializers);
        if (this.authenticator != null) {
            this.authenticationHandler = this.authenticator.getClass() == AllowAllAuthenticator.class ? null : new SaslAuthenticationHandler(this.authenticator);
        }
    }

    @Override
    public void configure(ChannelPipeline pipeline) {
        if (logger.isDebugEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler("log-io", LogLevel.DEBUG)});
        }
        logger.debug("HttpRequestDecoder settings - maxInitialLineLength={}, maxHeaderSize={}, maxChunkSize={}", new Object[]{this.settings.maxInitialLineLength, this.settings.maxHeaderSize, this.settings.maxChunkSize});
        pipeline.addLast("http-request-decoder", (ChannelHandler)new HttpRequestDecoder(this.settings.maxInitialLineLength, this.settings.maxHeaderSize, this.settings.maxChunkSize));
        if (logger.isDebugEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler("log-decoder-aggregator", LogLevel.DEBUG)});
        }
        logger.debug("HttpObjectAggregator settings - maxContentLength={}, maxAccumulationBufferComponents={}", (Object)this.settings.maxContentLength, (Object)this.settings.maxAccumulationBufferComponents);
        HttpObjectAggregator aggregator = new HttpObjectAggregator(this.settings.maxContentLength);
        aggregator.setMaxCumulationBufferComponents(this.settings.maxAccumulationBufferComponents);
        pipeline.addLast("aggregator", (ChannelHandler)aggregator);
        if (logger.isDebugEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler("log-aggregator-encoder", LogLevel.DEBUG)});
        }
        pipeline.addLast("http-response-encoder", (ChannelHandler)new HttpResponseEncoder());
        pipeline.addLast("request-handler", (ChannelHandler)new WebSocketServerProtocolHandler("/gremlin", null, false, this.settings.maxContentLength));
        if (logger.isDebugEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler("log-aggregator-encoder", LogLevel.DEBUG)});
        }
        pipeline.addLast("response-encoder", (ChannelHandler)this.wsGremlinResponseEncoder);
        pipeline.addLast("request-text-decoder", (ChannelHandler)this.wsGremlinTextRequestDecoder);
        pipeline.addLast("request-binary-decoder", (ChannelHandler)this.wsGremlinBinaryRequestDecoder);
        pipeline.addLast("request-close-decoder", (ChannelHandler)this.wsGremlinCloseRequestDecoder);
        if (logger.isDebugEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler("log-aggregator-encoder", LogLevel.DEBUG)});
        }
        if (this.authenticationHandler != null) {
            pipeline.addLast("authenticator", (ChannelHandler)this.authenticationHandler);
        }
    }
}

