/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.op.session;

import com.codahale.metrics.MetricRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.script.Bindings;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.server.Context;
import org.apache.tinkerpop.gremlin.server.GremlinServer;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.handler.StateKey;
import org.apache.tinkerpop.gremlin.server.op.AbstractEvalOpProcessor;
import org.apache.tinkerpop.gremlin.server.op.OpProcessorException;
import org.apache.tinkerpop.gremlin.server.op.session.Session;
import org.apache.tinkerpop.gremlin.server.util.MetricManager;
import org.apache.tinkerpop.gremlin.util.function.ThrowingConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionOpProcessor
extends AbstractEvalOpProcessor {
    private static final Logger logger = LoggerFactory.getLogger(SessionOpProcessor.class);
    public static final String OP_PROCESSOR_NAME = "session";
    private static ConcurrentHashMap<String, Session> sessions = new ConcurrentHashMap();
    public static final String CONFIG_SESSION_TIMEOUT = "sessionTimeout";
    public static final long DEFAULT_SESSION_TIMEOUT = 28800000L;
    static final Settings.ProcessorSettings DEFAULT_SETTINGS;

    @Override
    public String getName() {
        return OP_PROCESSOR_NAME;
    }

    @Override
    public ThrowingConsumer<Context> getEvalOp() {
        return this::evalOp;
    }

    @Override
    protected Optional<ThrowingConsumer<Context>> validateEvalMessage(RequestMessage message) throws OpProcessorException {
        super.validateEvalMessage(message);
        if (!message.optionalArgs(OP_PROCESSOR_NAME).isPresent()) {
            String msg = String.format("A message with an [%s] op code requires a [%s] argument.", "eval", OP_PROCESSOR_NAME);
            throw new OpProcessorException(msg, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).result((Object)msg).create());
        }
        return Optional.empty();
    }

    protected void evalOp(Context context) throws OpProcessorException {
        RequestMessage msg = context.getRequestMessage();
        Session session = SessionOpProcessor.getSession(context, msg);
        context.getChannelHandlerContext().channel().attr(StateKey.SESSION).set((Object)session);
        this.evalOpInternal(context, session::getGremlinExecutor, () -> {
            Bindings bindings = session.getBindings();
            Optional.ofNullable((Map)msg.getArgs().get("bindings")).ifPresent(bindings::putAll);
            return bindings;
        });
    }

    private static Session getSession(Context context, RequestMessage msg) {
        String sessionId = (String)msg.getArgs().get(OP_PROCESSOR_NAME);
        logger.debug("In-session request {} for eval for session {} in thread {}", new Object[]{msg.getRequestId(), sessionId, Thread.currentThread().getName()});
        Session session = sessions.computeIfAbsent(sessionId, k -> new Session((String)k, context, sessions));
        session.touch();
        return session;
    }

    static {
        MetricManager.INSTANCE.getGuage(sessions::size, MetricRegistry.name(GremlinServer.class, (String[])new String[]{"sessions"}));
        DEFAULT_SETTINGS = new Settings.ProcessorSettings();
        SessionOpProcessor.DEFAULT_SETTINGS.className = SessionOpProcessor.class.getCanonicalName();
        SessionOpProcessor.DEFAULT_SETTINGS.config = new HashMap<String, Object>(){
            {
                this.put(SessionOpProcessor.CONFIG_SESSION_TIMEOUT, 28800000L);
            }
        };
    }
}

