/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.handler;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.tinkerpop.gremlin.driver.MessageSerializer;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.driver.ser.MessageTextSerializer;
import org.apache.tinkerpop.gremlin.groovy.engine.GremlinExecutor;
import org.apache.tinkerpop.gremlin.server.GremlinServer;
import org.apache.tinkerpop.gremlin.server.util.MetricManager;
import org.apache.tinkerpop.gremlin.util.function.FunctionUtils;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.javatuples.Triplet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class HttpGremlinEndpointHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(HttpGremlinEndpointHandler.class);
    private static final Charset UTF8 = Charset.forName("UTF-8");
    static final Meter errorMeter = MetricManager.INSTANCE.getMeter(MetricRegistry.name(GremlinServer.class, (String[])new String[]{"errors"}));
    private static final Timer evalOpTimer = MetricManager.INSTANCE.getTimer(MetricRegistry.name(GremlinServer.class, (String[])new String[]{"op", "eval"}));
    private final Map<String, MessageSerializer> serializers;
    private static final ObjectMapper mapper = new ObjectMapper();
    private final GremlinExecutor gremlinExecutor;

    public HttpGremlinEndpointHandler(Map<String, MessageSerializer> serializers, GremlinExecutor gremlinExecutor) {
        this.serializers = serializers;
        this.gremlinExecutor = gremlinExecutor;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof FullHttpRequest) {
            Triplet<String, Map<String, Object>, String> requestArguments;
            FullHttpRequest req = (FullHttpRequest)msg;
            if (HttpHeaders.is100ContinueExpected((HttpMessage)req)) {
                ctx.write((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
            }
            if (req.getMethod() != HttpMethod.GET && req.getMethod() != HttpMethod.POST) {
                HttpGremlinEndpointHandler.sendError(ctx, HttpResponseStatus.METHOD_NOT_ALLOWED, HttpResponseStatus.METHOD_NOT_ALLOWED.toString());
                ReferenceCountUtil.release((Object)msg);
                return;
            }
            try {
                requestArguments = HttpGremlinEndpointHandler.getGremlinScript(req);
            }
            catch (IllegalArgumentException iae) {
                HttpGremlinEndpointHandler.sendError(ctx, HttpResponseStatus.BAD_REQUEST, iae.getMessage());
                ReferenceCountUtil.release((Object)msg);
                return;
            }
            String acceptString = Optional.ofNullable(req.headers().get("Accept")).orElse("application/json");
            String accept = acceptString.equals("*/*") ? "application/json" : acceptString;
            MessageTextSerializer serializer = (MessageTextSerializer)this.serializers.get(accept);
            if (null == serializer) {
                HttpGremlinEndpointHandler.sendError(ctx, HttpResponseStatus.BAD_REQUEST, String.format("no serializer for requested Accept header: %s", accept));
                ReferenceCountUtil.release((Object)msg);
                return;
            }
            String origin = req.headers().get("Origin");
            boolean keepAlive = !HttpHeaders.isKeepAlive((HttpMessage)req);
            ReferenceCountUtil.release((Object)msg);
            try {
                logger.debug("Processing request containing script [{}] and bindings of [{}] on {}", new Object[]{requestArguments.getValue0(), requestArguments.getValue1(), Thread.currentThread().getName()});
                ChannelPromise promise = ctx.channel().newPromise();
                AtomicReference resultHolder = new AtomicReference();
                promise.addListener(future -> {
                    if (future.isSuccess()) {
                        logger.debug("Preparing HTTP response for request with script [{}] and bindings of [{}] with result of [{}] on [{}]", new Object[]{requestArguments.getValue0(), requestArguments.getValue1(), resultHolder.get(), Thread.currentThread().getName()});
                        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, (ByteBuf)resultHolder.get());
                        response.headers().set("Content-Type", (Object)accept);
                        response.headers().set("Content-Length", (Object)response.content().readableBytes());
                        if (origin != null) {
                            response.headers().set("Access-Control-Allow-Origin", (Object)origin);
                        }
                        if (!keepAlive) {
                            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                        } else {
                            response.headers().set("Connection", (Object)"keep-alive");
                            ctx.writeAndFlush((Object)response);
                        }
                    }
                });
                Timer.Context timerContext = evalOpTimer.time();
                CompletableFuture evalFuture = this.gremlinExecutor.eval((String)requestArguments.getValue0(), (String)requestArguments.getValue2(), (Map)requestArguments.getValue1(), FunctionUtils.wrapFunction(o -> {
                    timerContext.stop();
                    logger.debug("Transforming result of request with script [{}] and bindings of [{}] with result of [{}] on [{}]", new Object[]{requestArguments.getValue0(), requestArguments.getValue1(), o, Thread.currentThread().getName()});
                    ResponseMessage responseMessage = ResponseMessage.build((UUID)UUID.randomUUID()).code(ResponseStatusCode.SUCCESS).result((Object)IteratorUtils.asList((Object)o)).create();
                    try {
                        return Unpooled.wrappedBuffer((byte[])serializer.serializeResponseAsString(responseMessage).getBytes(UTF8));
                    }
                    catch (Exception ex) {
                        logger.warn(String.format("Error during serialization for %s", responseMessage), (Throwable)ex);
                        throw ex;
                    }
                }));
                evalFuture.exceptionally(t -> {
                    HttpGremlinEndpointHandler.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR, String.format("Error encountered evaluating script: %s", requestArguments.getValue0()));
                    promise.setFailure(t);
                    return null;
                });
                evalFuture.thenAcceptAsync(r -> {
                    resultHolder.set(r);
                    promise.setSuccess();
                }, (Executor)this.gremlinExecutor.getExecutorService());
            }
            catch (Exception ex) {
                Throwable t2 = ExceptionUtils.getRootCause((Throwable)ex);
                throw new RuntimeException(null == t2 ? ex : t2);
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        logger.error("Error processing HTTP Request", cause);
        HttpGremlinEndpointHandler.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR, cause.getCause().getMessage());
        ctx.close();
    }

    private static Triplet<String, Map<String, Object>, String> getGremlinScript(FullHttpRequest request) {
        JsonNode languageNode;
        JsonNode body;
        if (request.getMethod() == HttpMethod.GET) {
            QueryStringDecoder decoder = new QueryStringDecoder(request.getUri());
            List gremlinParms = (List)decoder.parameters().get("gremlin");
            if (null == gremlinParms || gremlinParms.size() == 0) {
                throw new IllegalArgumentException("no gremlin script supplied");
            }
            String script = (String)gremlinParms.get(0);
            if (script.isEmpty()) {
                throw new IllegalArgumentException("no gremlin script supplied");
            }
            HashMap bindings = new HashMap();
            decoder.parameters().entrySet().stream().filter(kv -> !((String)kv.getKey()).equals("gremlin")).forEach(kv -> bindings.put(kv.getKey(), ((List)kv.getValue()).get(0)));
            List languageParms = (List)decoder.parameters().get("language");
            String language = null == languageParms || languageParms.size() == 0 ? null : (String)languageParms.get(0);
            return Triplet.with((Object)script, bindings, (Object)language);
        }
        try {
            body = mapper.readTree(request.content().toString(CharsetUtil.UTF_8));
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("body could not be parsed", ioe);
        }
        JsonNode scriptNode = body.get("gremlin");
        if (null == scriptNode) {
            throw new IllegalArgumentException("no gremlin script supplied");
        }
        JsonNode bindingsNode = body.get("bindings");
        if (bindingsNode != null && !bindingsNode.isObject()) {
            throw new IllegalArgumentException("bindings must be a Map");
        }
        HashMap bindings = new HashMap();
        if (bindingsNode != null) {
            bindingsNode.fields().forEachRemaining(kv -> bindings.put(kv.getKey(), HttpGremlinEndpointHandler.fromJsonNode((JsonNode)kv.getValue())));
        }
        String language = null == (languageNode = body.get("language")) ? null : languageNode.asText();
        return Triplet.with((Object)scriptNode.asText(), bindings, (Object)language);
    }

    public static Object fromJsonNode(JsonNode node) {
        if (node.isNull()) {
            return null;
        }
        if (node.isObject()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            ObjectNode objectNode = (ObjectNode)node;
            Iterator iterator = objectNode.fieldNames();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                map.put(key, HttpGremlinEndpointHandler.fromJsonNode(objectNode.get(key)));
            }
            return map;
        }
        if (node.isArray()) {
            ArrayNode arrayNode = (ArrayNode)node;
            ArrayList<Object> array = new ArrayList<Object>();
            for (int i = 0; i < arrayNode.size(); ++i) {
                array.add(HttpGremlinEndpointHandler.fromJsonNode(arrayNode.get(i)));
            }
            return array;
        }
        if (node.isFloatingPointNumber()) {
            return node.asDouble();
        }
        if (node.isIntegralNumber()) {
            return node.asLong();
        }
        if (node.isBoolean()) {
            return node.asBoolean();
        }
        return node.asText();
    }

    private static void sendError(ChannelHandlerContext ctx, HttpResponseStatus status, String message) {
        logger.warn("Invalid request - responding with {} and {}", (Object)status, (Object)message);
        errorMeter.mark();
        ObjectNode node = mapper.createObjectNode();
        node.put("message", message);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.copiedBuffer((CharSequence)node.toString(), (Charset)CharsetUtil.UTF_8));
        response.headers().set("Content-Type", (Object)"application/json");
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }
}

