/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.channel;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.tinkerpop.gremlin.groovy.engine.GremlinExecutor;
import org.apache.tinkerpop.gremlin.server.AbstractChannelizer;
import org.apache.tinkerpop.gremlin.server.Graphs;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.handler.HttpGremlinEndpointHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpChannelizer
extends AbstractChannelizer {
    private static final Logger logger = LoggerFactory.getLogger(HttpChannelizer.class);
    private HttpGremlinEndpointHandler httpGremlinEndpointHandler;

    @Override
    public void init(Settings settings, GremlinExecutor gremlinExecutor, ExecutorService gremlinExecutorService, Graphs graphs, ScheduledExecutorService scheduledExecutorService) {
        super.init(settings, gremlinExecutor, gremlinExecutorService, graphs, scheduledExecutorService);
        this.httpGremlinEndpointHandler = new HttpGremlinEndpointHandler(this.serializers, gremlinExecutor);
    }

    @Override
    public void configure(ChannelPipeline pipeline) {
        if (logger.isDebugEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler("log-io", LogLevel.DEBUG)});
        }
        pipeline.addLast("http-server", (ChannelHandler)new HttpServerCodec());
        if (logger.isDebugEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler("http-io", LogLevel.DEBUG)});
        }
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(this.settings.maxContentLength)});
        pipeline.addLast("http-gremlin-handler", (ChannelHandler)this.httpGremlinEndpointHandler);
    }

    @Override
    public void finalize(ChannelPipeline pipeline) {
        pipeline.remove("op-selector");
        pipeline.remove("result-iterator-handler");
        pipeline.remove("op-executor");
    }
}

