/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.op.control;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.groovy.engine.GremlinExecutor;
import org.apache.tinkerpop.gremlin.groovy.engine.ScriptEngines;
import org.apache.tinkerpop.gremlin.server.Context;
import org.apache.tinkerpop.gremlin.util.Gremlin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ControlOps {
    private static final Logger logger = LoggerFactory.getLogger(ControlOps.class);

    ControlOps() {
    }

    public static void versionOp(Context context) {
        RequestMessage msg = context.getRequestMessage();
        context.getChannelHandlerContext().writeAndFlush((Object)ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SUCCESS).result((Object)Gremlin.version()));
    }

    public static void importOp(Context context) {
        RequestMessage msg = context.getRequestMessage();
        List l = (List)msg.getArgs().get("imports");
        context.getGremlinExecutor().getScriptEngines().addImports(new HashSet(l));
    }

    public static void showOp(Context context) {
        Map infoToShow;
        RequestMessage msg = context.getRequestMessage();
        String infoType = (String)msg.optionalArgs("infoType").get();
        GremlinExecutor executor = context.getGremlinExecutor();
        ScriptEngines scriptEngines = executor.getScriptEngines();
        if (infoType.equals("dependencies")) {
            infoToShow = scriptEngines.dependencies();
        } else if (infoType.equals("imports")) {
            infoToShow = scriptEngines.imports();
        } else {
            throw new RuntimeException(String.format("Validation for the show operation is not properly checking the %s", "infoType"));
        }
        try {
            context.getChannelHandlerContext().writeAndFlush((Object)ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SUCCESS).result((Object)infoToShow).create());
        }
        catch (Exception ex) {
            logger.warn("The result [{}] in the request {} could not be serialized and returned.", new Object[]{infoToShow, context.getRequestMessage(), ex});
        }
    }

    public static void resetOp(Context context) {
        RequestMessage msg = context.getRequestMessage();
        context.getGremlinExecutor().getScriptEngines().reset();
        context.getChannelHandlerContext().writeAndFlush((Object)ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SUCCESS).create());
    }

    public static void useOp(Context context) {
        RequestMessage msg = context.getRequestMessage();
        List usings = (List)msg.getArgs().get("coordinates");
        usings.forEach(c -> {
            final String group = (String)c.get("group");
            final String artifact = (String)c.get("artifact");
            final String version = (String)c.get("version");
            logger.info("Loading plugin [group={},artifact={},version={}]", new Object[]{group, artifact, version});
            context.getGremlinExecutor().getScriptEngines().use(group, artifact, version);
            HashMap<String, String> coords = new HashMap<String, String>(){
                {
                    this.put("group", group);
                    this.put("artifact", artifact);
                    this.put("version", version);
                }
            };
            context.getChannelHandlerContext().write((Object)ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SUCCESS).result((Object)coords).create());
        });
    }
}

