/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.handler;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.ReferenceCountUtil;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.groovy.engine.GremlinExecutor;
import org.apache.tinkerpop.gremlin.server.Context;
import org.apache.tinkerpop.gremlin.server.Graphs;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.op.OpProcessorException;
import org.apache.tinkerpop.gremlin.util.function.ThrowingConsumer;
import org.javatuples.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class OpExecutorHandler
extends SimpleChannelInboundHandler<Pair<RequestMessage, ThrowingConsumer<Context>>> {
    private static final Logger logger = LoggerFactory.getLogger(OpExecutorHandler.class);
    private final Settings settings;
    private final Graphs graphs;
    private final ScheduledExecutorService scheduledExecutorService;
    private final GremlinExecutor gremlinExecutor;

    public OpExecutorHandler(Settings settings, Graphs graphs, GremlinExecutor gremlinExecutor, ScheduledExecutorService scheduledExecutorService) {
        this.settings = settings;
        this.graphs = graphs;
        this.gremlinExecutor = gremlinExecutor;
        this.scheduledExecutorService = scheduledExecutorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(ChannelHandlerContext channelHandlerContext, Pair<RequestMessage, ThrowingConsumer<Context>> objects) throws Exception {
        RequestMessage msg = (RequestMessage)objects.getValue0();
        ThrowingConsumer op = (ThrowingConsumer)objects.getValue1();
        Context gremlinServerContext = new Context(msg, channelHandlerContext, this.settings, this.graphs, this.gremlinExecutor, this.scheduledExecutorService);
        try {
            op.accept((Object)gremlinServerContext);
        }
        catch (OpProcessorException ope) {
            logger.warn(ope.getMessage(), (Throwable)ope);
            channelHandlerContext.writeAndFlush((Object)ope.getResponseMessage());
        }
        finally {
            ReferenceCountUtil.release(objects);
        }
    }
}

