/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.channel;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.tinkerpop.gremlin.groovy.engine.GremlinExecutor;
import org.apache.tinkerpop.gremlin.server.AbstractChannelizer;
import org.apache.tinkerpop.gremlin.server.Graphs;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.handler.NioGremlinBinaryRequestDecoder;
import org.apache.tinkerpop.gremlin.server.handler.NioGremlinResponseEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NioChannelizer
extends AbstractChannelizer {
    private static final Logger logger = LoggerFactory.getLogger(NioChannelizer.class);
    private NioGremlinBinaryRequestDecoder nioGremlinBinaryRequestDecoder;

    @Override
    public void init(Settings settings, GremlinExecutor gremlinExecutor, ExecutorService gremlinExecutorService, Graphs graphs, ScheduledExecutorService scheduledExecutorService) {
        super.init(settings, gremlinExecutor, gremlinExecutorService, graphs, scheduledExecutorService);
        this.nioGremlinBinaryRequestDecoder = new NioGremlinBinaryRequestDecoder(this.serializers);
    }

    @Override
    public void configure(ChannelPipeline pipeline) {
        if (logger.isDebugEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler("log-io", LogLevel.DEBUG)});
        }
        pipeline.addLast("response-encoder", (ChannelHandler)new NioGremlinResponseEncoder());
        pipeline.addLast("request-binary-decoder", (ChannelHandler)this.nioGremlinBinaryRequestDecoder);
        if (logger.isDebugEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler("log-codec", LogLevel.DEBUG)});
        }
    }
}

