/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.logging.Slf4JLoggerFactory;
import java.io.IOException;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.tinkerpop.gremlin.groovy.engine.GremlinExecutor;
import org.apache.tinkerpop.gremlin.server.Channelizer;
import org.apache.tinkerpop.gremlin.server.Graphs;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.util.MetricManager;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GremlinServer {
    private static final String SERVER_THREAD_PREFIX = "gremlin-server-";
    private static final Logger logger;
    private final Settings settings;
    private Optional<Graphs> graphs = Optional.empty();
    private Channel ch;
    private CompletableFuture<Void> serverStopped = null;
    private CompletableFuture<Void> serverStarted = null;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    private final ExecutorService gremlinExecutorService;

    public GremlinServer(Settings settings) {
        this.settings = settings;
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.stop().join(), "gremlin-server-shutdown"));
        BasicThreadFactory threadFactoryBoss = new BasicThreadFactory.Builder().namingPattern("gremlin-server-boss-%d").build();
        this.bossGroup = new NioEventLoopGroup(settings.threadPoolBoss, (ThreadFactory)threadFactoryBoss);
        BasicThreadFactory threadFactoryWorker = new BasicThreadFactory.Builder().namingPattern("gremlin-server-worker-%d").build();
        this.workerGroup = new NioEventLoopGroup(settings.threadPoolWorker, (ThreadFactory)threadFactoryWorker);
        BasicThreadFactory threadFactoryGremlin = new BasicThreadFactory.Builder().namingPattern("gremlin-server-exec-%d").build();
        this.gremlinExecutorService = Executors.newFixedThreadPool(settings.gremlinPool, (ThreadFactory)threadFactoryGremlin);
    }

    public synchronized CompletableFuture<Void> start() throws Exception {
        if (this.serverStarted != null) {
            return this.serverStarted;
        }
        this.serverStarted = new CompletableFuture();
        this.serverStarted = new CompletableFuture();
        final CompletableFuture serverReadyFuture = this.serverStarted;
        try {
            ServerBootstrap b = new ServerBootstrap();
            b.childOption(ChannelOption.WRITE_BUFFER_LOW_WATER_MARK, (Object)this.settings.writeBufferLowWaterMark);
            b.childOption(ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, (Object)this.settings.writeBufferHighWaterMark);
            b.childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
            GremlinExecutor gremlinExecutor = this.initializeGremlinExecutor(this.gremlinExecutorService, (ScheduledExecutorService)this.workerGroup);
            Channelizer channelizer = GremlinServer.createChannelizer(this.settings);
            channelizer.init(this.settings, gremlinExecutor, this.gremlinExecutorService, this.graphs.get(), (ScheduledExecutorService)this.workerGroup);
            ((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)channelizer);
            b.bind(this.settings.host, this.settings.port).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture channelFuture) throws Exception {
                    if (channelFuture.isSuccess()) {
                        GremlinServer.this.ch = channelFuture.channel();
                        logger.info("Gremlin Server configured with worker thread pool of {}, gremlin pool of {} and boss thread pool of {}.", new Object[]{((GremlinServer)GremlinServer.this).settings.threadPoolWorker, ((GremlinServer)GremlinServer.this).settings.gremlinPool, ((GremlinServer)GremlinServer.this).settings.threadPoolBoss});
                        logger.info("Channel started at port {}.", (Object)((GremlinServer)GremlinServer.this).settings.port);
                        serverReadyFuture.complete(null);
                    } else {
                        serverReadyFuture.completeExceptionally(new IOException(String.format("Could not bind to %s and %s - perhaps something else is bound to that address.", ((GremlinServer)GremlinServer.this).settings.host, ((GremlinServer)GremlinServer.this).settings.port)));
                    }
                }
            });
        }
        catch (Exception ex) {
            logger.error("Gremlin Server Error", (Throwable)ex);
            serverReadyFuture.completeExceptionally(ex);
        }
        return this.serverStarted;
    }

    private static Channelizer createChannelizer(Settings settings) throws Exception {
        try {
            Class<?> clazz = Class.forName(settings.channelizer);
            Object o = clazz.newInstance();
            return (Channelizer)o;
        }
        catch (ClassNotFoundException fnfe) {
            logger.error("Could not find {} implementation defined by the 'channelizer' setting as: {}", (Object)Channelizer.class.getName(), (Object)settings.channelizer);
            throw new RuntimeException(fnfe);
        }
        catch (Exception ex) {
            logger.error("Class defined by the 'channelizer' setting as: {} could not be properly instantiated as a {}", (Object)settings.channelizer, (Object)Channelizer.class.getName());
            throw new RuntimeException(ex);
        }
    }

    private GremlinExecutor initializeGremlinExecutor(ExecutorService gremlinExecutorService, ScheduledExecutorService scheduledExecutorService) {
        if (!this.graphs.isPresent()) {
            this.graphs = Optional.of(new Graphs(this.settings));
        }
        logger.info("Initialized Gremlin thread pool.  Threads in pool named with pattern gremlin-*");
        GremlinExecutor.Builder gremlinExecutorBuilder = GremlinExecutor.build().scriptEvaluationTimeout(this.settings.scriptEvaluationTimeout).afterFailure((b, e) -> this.graphs.get().rollbackAll()).afterSuccess(b -> this.graphs.get().commitAll()).beforeEval(b -> this.graphs.get().rollbackAll()).afterTimeout(b -> this.graphs.get().rollbackAll()).enabledPlugins(new HashSet<String>(this.settings.plugins)).globalBindings(this.graphs.get().getGraphsAsBindings()).executorService(gremlinExecutorService).scheduledExecutorService(scheduledExecutorService);
        this.settings.scriptEngines.forEach((k, v) -> gremlinExecutorBuilder.addEngineSettings(k, v.imports, v.staticImports, v.scripts, v.config));
        GremlinExecutor gremlinExecutor = gremlinExecutorBuilder.create();
        logger.info("Initialized GremlinExecutor and configured ScriptEngines.");
        gremlinExecutor.getGlobalBindings().entrySet().stream().filter(kv -> kv.getValue() instanceof Graph).forEach(kv -> this.graphs.get().getGraphs().put((String)kv.getKey(), (Graph)kv.getValue()));
        return gremlinExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CompletableFuture<Void> stop() {
        if (this.serverStopped != null) {
            return this.serverStopped;
        }
        this.serverStopped = new CompletableFuture();
        CountDownLatch servicesLeftToShutdown = new CountDownLatch(3);
        this.ch.close().addListener(f -> servicesLeftToShutdown.countDown());
        logger.info("Shutting down thread pools.");
        try {
            this.gremlinExecutorService.shutdown();
        }
        finally {
            logger.debug("Shutdown Gremlin thread pool.");
        }
        try {
            this.workerGroup.shutdownGracefully().addListener(f -> servicesLeftToShutdown.countDown());
        }
        finally {
            logger.debug("Shutdown Worker thread pool.");
        }
        try {
            this.bossGroup.shutdownGracefully().addListener(f -> servicesLeftToShutdown.countDown());
        }
        finally {
            logger.debug("Shutdown Boss thread pool.");
        }
        new Thread(() -> {
            try {
                this.gremlinExecutorService.awaitTermination(30000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ie) {
                logger.warn("Timeout waiting for Gremlin thread pool to shutdown - continuing with shutdown process.");
            }
            try {
                servicesLeftToShutdown.await(30000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ie) {
                logger.warn("Timeout waiting for bossy/worker thread pools to shutdown - continuing with shutdown process.");
            }
            this.graphs.ifPresent(gs -> gs.getGraphs().forEach((k, v) -> {
                logger.debug("Closing Graph instance [{}]", k);
                try {
                    v.close();
                }
                catch (Exception ex) {
                    logger.warn(String.format("Exception while closing Graph instance [%s]", k), (Throwable)ex);
                }
                finally {
                    logger.info("Closed Graph instance [{}]", k);
                }
            }));
            logger.info("Gremlin Server - shutdown complete");
            this.serverStopped.complete(null);
        }, "gremlin-server-stop").start();
        return this.serverStopped;
    }

    public static void main(String[] args) throws Exception {
        Settings settings;
        GremlinServer.printHeader();
        String file = args.length > 0 ? args[0] : "conf/gremlin-server.yaml";
        try {
            settings = Settings.read(file);
        }
        catch (Exception ex) {
            logger.error("Configuration file at {} could not be found or parsed properly. [{}]", (Object)file, (Object)ex.getMessage());
            return;
        }
        logger.info("Configuring Gremlin Server from {}", (Object)file);
        settings.optionalMetrics().ifPresent(GremlinServer::configureMetrics);
        new GremlinServer(settings).start();
    }

    public static String getHeader() {
        StringBuilder builder = new StringBuilder();
        builder.append("\r\n");
        builder.append("         \\,,,/\r\n");
        builder.append("         (o o)\r\n");
        builder.append("-----oOOo-(3)-oOOo-----\r\n");
        return builder.toString();
    }

    private static void configureMetrics(Settings.ServerMetrics settings) {
        MetricManager metrics = MetricManager.INSTANCE;
        settings.optionalConsoleReporter().ifPresent(config -> {
            if (config.enabled) {
                metrics.addConsoleReporter(config.interval);
            }
        });
        settings.optionalCsvReporter().ifPresent(config -> {
            if (config.enabled) {
                metrics.addCsvReporter(config.interval, config.fileName);
            }
        });
        settings.optionalJmxReporter().ifPresent(config -> {
            if (config.enabled) {
                metrics.addJmxReporter(config.domain, config.agentId);
            }
        });
        settings.optionalSlf4jReporter().ifPresent(config -> {
            if (config.enabled) {
                metrics.addSlf4jReporter(config.interval, config.loggerName);
            }
        });
        settings.optionalGangliaReporter().ifPresent(config -> {
            if (config.enabled) {
                try {
                    metrics.addGangliaReporter(config.host, config.port, config.optionalAddressingMode(), config.ttl, config.protocol31, config.hostUUID, config.spoof, config.interval);
                }
                catch (IOException ioe) {
                    logger.warn("Error configuring the Ganglia Reporter.", (Throwable)ioe);
                }
            }
        });
        settings.optionalGraphiteReporter().ifPresent(config -> {
            if (config.enabled) {
                metrics.addGraphiteReporter(config.host, config.port, config.prefix, config.interval);
            }
        });
    }

    private static void printHeader() {
        logger.info(GremlinServer.getHeader());
    }

    static {
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new Slf4JLoggerFactory());
        logger = LoggerFactory.getLogger(GremlinServer.class);
    }
}

