/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server;

import java.util.HashMap;
import java.util.Map;
import javax.script.Bindings;
import javax.script.SimpleBindings;
import org.apache.tinkerpop.gremlin.server.GremlinServer;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.util.GraphFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Graphs {
    private static final Logger logger = LoggerFactory.getLogger(GremlinServer.class);
    private final Map<String, Graph> graphs = new HashMap<String, Graph>();

    public Graphs(Settings settings) {
        settings.graphs.entrySet().forEach(e -> {
            block2: {
                try {
                    Graph newGraph = GraphFactory.open((String)((String)e.getValue()));
                    this.graphs.put((String)e.getKey(), newGraph);
                    logger.info("Graph [{}] was successfully configured via [{}].", e.getKey(), e.getValue());
                }
                catch (RuntimeException re) {
                    logger.warn(String.format("Graph [%s] configured at [%s] could not be instantiated and will not be available in Gremlin Server.  GraphFactory message: %s", e.getKey(), e.getValue(), re.getMessage()), (Throwable)re);
                    if (re.getCause() == null) break block2;
                    logger.debug("GraphFactory exception", re.getCause());
                }
            }
        });
    }

    public Map<String, Graph> getGraphs() {
        return this.graphs;
    }

    public Bindings getGraphsAsBindings() {
        SimpleBindings bindings = new SimpleBindings();
        this.graphs.forEach(bindings::put);
        return bindings;
    }

    public void rollbackAll() {
        this.graphs.entrySet().forEach(e -> {
            Graph g = (Graph)e.getValue();
            if (g.features().graph().supportsTransactions()) {
                g.tx().rollback();
            }
        });
    }

    public void commitAll() {
        this.graphs.entrySet().forEach(e -> {
            Graph g = (Graph)e.getValue();
            if (g.features().graph().supportsTransactions()) {
                g.tx().commit();
            }
        });
    }
}

