/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.op.session;

import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.script.Bindings;
import javax.script.SimpleBindings;
import org.apache.tinkerpop.gremlin.groovy.engine.GremlinExecutor;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.server.Context;
import org.apache.tinkerpop.gremlin.server.GraphManager;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.op.session.SessionOpProcessor;
import org.apache.tinkerpop.gremlin.server.util.LifeCycleHook;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Session {
    private static final Logger logger = LoggerFactory.getLogger(Session.class);
    private final Bindings bindings;
    private final Settings settings;
    private final GraphManager graphManager;
    private final String session;
    private final ScheduledExecutorService scheduledExecutorService;
    private final long configuredSessionTimeout;
    private AtomicReference<ScheduledFuture> kill = new AtomicReference();
    private final GremlinExecutor gremlinExecutor;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final ConcurrentHashMap<String, Session> sessions;

    public Session(String session, Context context, ConcurrentHashMap<String, Session> sessions) {
        logger.info("New session established for {}", (Object)session);
        this.session = session;
        this.bindings = new SimpleBindings();
        this.settings = context.getSettings();
        this.graphManager = context.getGraphManager();
        this.scheduledExecutorService = context.getScheduledExecutorService();
        this.sessions = sessions;
        Settings.ProcessorSettings processorSettings = this.settings.processors.stream().filter(p -> p.className.equals(SessionOpProcessor.class.getCanonicalName())).findAny().orElse(SessionOpProcessor.DEFAULT_SETTINGS);
        this.configuredSessionTimeout = Long.parseLong(processorSettings.config.get("sessionTimeout").toString());
        this.gremlinExecutor = this.initializeGremlinExecutor().create();
    }

    public GremlinExecutor getGremlinExecutor() {
        return this.gremlinExecutor;
    }

    public Bindings getBindings() {
        return this.bindings;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public void touch() {
        ScheduledFuture killFuture = this.kill.get();
        if (null == killFuture || !killFuture.isDone()) {
            if (killFuture != null) {
                killFuture.cancel(false);
            }
            this.kill.set(this.scheduledExecutorService.schedule(() -> {
                this.graphManager.getGraphs().values().forEach(g -> {
                    if (g.features().graph().supportsTransactions()) {
                        this.executor.execute(() -> {
                            logger.info("Rolling back any open transactions before killing idle session: {}", (Object)this.session);
                            if (g.tx().isOpen()) {
                                g.tx().rollback();
                            }
                        });
                    }
                });
                this.sessions.remove(this.session);
                logger.info("Kill idle session named {} after {} milliseconds", (Object)this.session, (Object)this.configuredSessionTimeout);
            }, this.configuredSessionTimeout, TimeUnit.MILLISECONDS));
        }
    }

    private GremlinExecutor.Builder initializeGremlinExecutor() {
        GremlinExecutor.Builder gremlinExecutorBuilder = GremlinExecutor.build().scriptEvaluationTimeout(this.settings.scriptEvaluationTimeout).afterTimeout(b -> {
            this.graphManager.rollbackAll();
            this.bindings.clear();
            this.bindings.putAll((Map<? extends String, ? extends Object>)b);
        }).afterSuccess(b -> {
            this.bindings.clear();
            this.bindings.putAll((Map<? extends String, ? extends Object>)b);
        }).enabledPlugins(new HashSet<String>(this.settings.plugins)).globalBindings(this.graphManager.getAsBindings()).promoteBindings(kv -> kv.getValue() instanceof Graph || kv.getValue() instanceof TraversalSource).executorService(this.executor).scheduledExecutorService(this.scheduledExecutorService);
        this.settings.scriptEngines.forEach((k, v) -> {
            v.imports.add(LifeCycleHook.class.getCanonicalName());
            gremlinExecutorBuilder.addEngineSettings(k, v.imports, v.staticImports, v.scripts, v.config);
        });
        return gremlinExecutorBuilder;
    }
}

