/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.groovy.jsr223;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GremlinScriptChecker {
    public static final Result EMPTY_RESULT = new Result(0L);
    private static final List<String> tokens = Arrays.asList("evaluationTimeout", "scriptEvaluationTimeout", "ARGS_EVAL_TIMEOUT", "ARGS_SCRIPT_EVAL_TIMEOUT");
    private static final Pattern patternClean = Pattern.compile("//.*$|/\\*(.|[\\r\\n])*?\\*/|\\s", 8);
    private static final String timeoutTokens = "[\"']evaluationTimeout[\"']|[\"']scriptEvaluationTimeout[\"']|(?:Tokens\\.)?ARGS_EVAL_TIMEOUT|(?:Tokens\\.)?ARGS_SCRIPT_EVAL_TIMEOUT";
    private static final Pattern patternTimeout = Pattern.compile("\\.with\\((?:[\"']evaluationTimeout[\"']|[\"']scriptEvaluationTimeout[\"']|(?:Tokens\\.)?ARGS_EVAL_TIMEOUT|(?:Tokens\\.)?ARGS_SCRIPT_EVAL_TIMEOUT),(\\d*)(:?L|l)?\\)");

    public static Result parse(String gremlin) {
        if (gremlin.isEmpty()) {
            return EMPTY_RESULT;
        }
        if (tokens.stream().noneMatch(gremlin::contains)) {
            return EMPTY_RESULT;
        }
        String cleanGremlin = patternClean.matcher(gremlin).replaceAll("");
        Matcher m = patternTimeout.matcher(cleanGremlin);
        if (!m.find()) {
            return EMPTY_RESULT;
        }
        long l = Long.parseLong(m.group(1));
        while (m.find()) {
            l += Long.parseLong(m.group(1));
        }
        return new Result(l);
    }

    public static class Result {
        private final long timeout;

        private Result(long timeout) {
            this.timeout = timeout;
        }

        public final Optional<Long> getTimeout() {
            return this.timeout == 0L ? Optional.empty() : Optional.of(this.timeout);
        }
    }
}

