/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.groovy.engine;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.script.Bindings;
import javax.script.CompiledScript;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.tinkerpop.gremlin.groovy.engine.ScriptEngines;
import org.apache.tinkerpop.gremlin.groovy.plugin.GremlinPlugin;
import org.apache.tinkerpop.gremlin.jsr223.CachedGremlinScriptEngineManager;
import org.apache.tinkerpop.gremlin.jsr223.ConcurrentBindings;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngineManager;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.javatuples.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GremlinExecutor
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(GremlinExecutor.class);
    private ScriptEngines scriptEngines;
    private GremlinScriptEngineManager gremlinScriptEngineManager;
    private final Map<String, EngineSettings> settings;
    private final Map<String, Map<String, Map<String, Object>>> plugins;
    private final long scriptEvaluationTimeout;
    private final Bindings globalBindings;
    private final List<List<String>> use;
    private final ExecutorService executorService;
    private final ScheduledExecutorService scheduledExecutorService;
    private final Consumer<Bindings> beforeEval;
    private final Consumer<Bindings> afterSuccess;
    private final Consumer<Bindings> afterTimeout;
    private final BiConsumer<Bindings, Throwable> afterFailure;
    private final Set<String> enabledPlugins;
    private final boolean suppliedExecutor;
    private final boolean suppliedScheduledExecutor;
    private boolean useGremlinScriptEngineManager;

    private GremlinExecutor(Builder builder, boolean suppliedExecutor, boolean suppliedScheduledExecutor) {
        this.executorService = builder.executorService;
        this.scheduledExecutorService = builder.scheduledExecutorService;
        this.beforeEval = builder.beforeEval;
        this.afterSuccess = builder.afterSuccess;
        this.afterTimeout = builder.afterTimeout;
        this.afterFailure = builder.afterFailure;
        this.use = builder.use;
        this.settings = builder.settings;
        this.plugins = builder.plugins;
        this.scriptEvaluationTimeout = builder.scriptEvaluationTimeout;
        this.globalBindings = builder.globalBindings;
        this.enabledPlugins = builder.enabledPlugins;
        this.gremlinScriptEngineManager = new CachedGremlinScriptEngineManager();
        this.initializeGremlinScriptEngineManager();
        if (!this.useGremlinScriptEngineManager) {
            this.scriptEngines = this.createScriptEngines();
        } else {
            this.scriptEngines = null;
            this.gremlinScriptEngineManager.getEngineByName("gremlin-groovy");
        }
        this.suppliedExecutor = suppliedExecutor;
        this.suppliedScheduledExecutor = suppliedScheduledExecutor;
    }

    public Optional<CompiledScript> compile(String script) throws ScriptException {
        return this.compile(script, Optional.empty());
    }

    public Optional<CompiledScript> compile(String script, Optional<String> language) throws ScriptException {
        String lang = language.orElse("gremlin-groovy");
        try {
            return Optional.of(this.scriptEngines.compile(script, lang));
        }
        catch (UnsupportedOperationException uoe) {
            return Optional.empty();
        }
    }

    public CompletableFuture<Object> eval(String script) {
        return this.eval(script, (String)null, new SimpleBindings());
    }

    public CompletableFuture<Object> eval(String script, Bindings boundVars) {
        return this.eval(script, (String)null, boundVars);
    }

    public CompletableFuture<Object> eval(String script, Map<String, Object> boundVars) {
        return this.eval(script, (String)null, new SimpleBindings(boundVars));
    }

    public CompletableFuture<Object> eval(String script, String language, Map<String, Object> boundVars) {
        return this.eval(script, language, new SimpleBindings(boundVars));
    }

    public CompletableFuture<Object> eval(String script, String language, Bindings boundVars) {
        return this.eval(script, language, boundVars, null, null);
    }

    public CompletableFuture<Object> eval(String script, String language, Map<String, Object> boundVars, Function<Object, Object> transformResult) {
        return this.eval(script, language, new SimpleBindings(boundVars), transformResult, null);
    }

    public CompletableFuture<Object> eval(String script, String language, Map<String, Object> boundVars, Consumer<Object> withResult) {
        return this.eval(script, language, new SimpleBindings(boundVars), null, withResult);
    }

    public CompletableFuture<Object> eval(String script, String language, Bindings boundVars, Function<Object, Object> transformResult, Consumer<Object> withResult) {
        LifeCycle lifeCycle = LifeCycle.build().transformResult(transformResult).withResult(withResult).create();
        return this.eval(script, language, boundVars, lifeCycle);
    }

    public CompletableFuture<Object> eval(String script, String language, Bindings boundVars, LifeCycle lifeCycle) {
        String lang = Optional.ofNullable(language).orElse("gremlin-groovy");
        logger.debug("Preparing to evaluate script - {} - in thread [{}]", (Object)script, (Object)Thread.currentThread().getName());
        SimpleBindings bindings = new SimpleBindings();
        bindings.putAll(this.globalBindings);
        bindings.putAll(boundVars);
        long scriptEvalTimeOut = lifeCycle.getScriptEvaluationTimeoutOverride().orElse(this.scriptEvaluationTimeout);
        CompletableFuture<Object> evaluationFuture = new CompletableFuture<Object>();
        FutureTask<Void> evalFuture = new FutureTask<Void>(() -> {
            try {
                Object result;
                lifeCycle.getBeforeEval().orElse(this.beforeEval).accept(bindings);
                logger.debug("Evaluating script - {} - in thread [{}]", (Object)script, (Object)Thread.currentThread().getName());
                Object o = this.useGremlinScriptEngineManager ? this.gremlinScriptEngineManager.getEngineByName(lang).eval(script, bindings) : this.scriptEngines.eval(script, bindings, lang);
                Object object = result = lifeCycle.getTransformResult().isPresent() ? lifeCycle.getTransformResult().get().apply(o) : o;
                if (lifeCycle.getWithResult().isPresent()) {
                    lifeCycle.getWithResult().get().accept(result);
                }
                lifeCycle.getAfterSuccess().orElse(this.afterSuccess).accept(bindings);
                evaluationFuture.complete(result);
            }
            catch (Throwable ex) {
                Throwable root;
                Throwable throwable = root = null == ex.getCause() ? ex : ExceptionUtils.getRootCause((Throwable)ex);
                if (root instanceof InterruptedException) {
                    lifeCycle.getAfterTimeout().orElse(this.afterTimeout).accept(bindings);
                    evaluationFuture.completeExceptionally(new TimeoutException(String.format("Script evaluation exceeded the configured 'scriptEvaluationTimeout' threshold of %s ms or evaluation was otherwise cancelled directly for request [%s]: %s", scriptEvalTimeOut, script, root.getMessage())));
                }
                lifeCycle.getAfterFailure().orElse(this.afterFailure).accept(bindings, root);
                evaluationFuture.completeExceptionally(root);
            }
            return null;
        });
        WeakReference evaluationFutureRef = new WeakReference(evaluationFuture);
        Future<?> executionFuture = this.executorService.submit(evalFuture);
        if (scriptEvalTimeOut > 0L) {
            ScheduledFuture<?> sf = this.scheduledExecutorService.schedule(() -> {
                CompletableFuture ef;
                if (executionFuture.cancel(true) && (ef = (CompletableFuture)evaluationFutureRef.get()) != null) {
                    ef.completeExceptionally(new TimeoutException(String.format("Script evaluation exceeded the configured 'scriptEvaluationTimeout' threshold of %s ms or evaluation was otherwise cancelled directly for request [%s]", scriptEvalTimeOut, script)));
                }
            }, scriptEvalTimeOut, TimeUnit.MILLISECONDS);
            evaluationFuture.handleAsync((v, t) -> {
                if (!sf.isDone()) {
                    logger.debug("Killing scheduled timeout on script evaluation - {} - as the eval completed (possibly with exception).", (Object)script);
                    sf.cancel(true);
                }
                return null;
            }, (Executor)this.scheduledExecutorService);
        }
        return evaluationFuture;
    }

    @Deprecated
    public Traversal.Admin eval(Bytecode bytecode, Bindings boundVars, String language) throws ScriptException {
        String lang = Optional.ofNullable(language).orElse("gremlin-groovy");
        SimpleBindings bindings = new SimpleBindings();
        bindings.putAll(this.globalBindings);
        bindings.putAll(boundVars);
        return this.useGremlinScriptEngineManager ? this.gremlinScriptEngineManager.getEngineByName(lang).eval(bytecode, (Bindings)bindings) : this.scriptEngines.eval(bytecode, (Bindings)bindings, lang);
    }

    public Traversal.Admin eval(Bytecode bytecode, Bindings boundVars, String language, String traversalSource) throws ScriptException {
        String lang = Optional.ofNullable(language).orElse("gremlin-groovy");
        SimpleBindings bindings = new SimpleBindings();
        bindings.putAll(this.globalBindings);
        bindings.putAll(boundVars);
        return this.useGremlinScriptEngineManager ? this.gremlinScriptEngineManager.getEngineByName(lang).eval(bytecode, (Bindings)bindings, traversalSource) : this.scriptEngines.eval(bytecode, bindings, lang, traversalSource);
    }

    @Deprecated
    public ScriptEngines getScriptEngines() {
        return this.scriptEngines;
    }

    public GremlinScriptEngineManager getScriptEngineManager() {
        return this.gremlinScriptEngineManager;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    @Deprecated
    public Bindings getGlobalBindings() {
        return this.globalBindings;
    }

    @Override
    public void close() throws Exception {
        this.closeAsync().join();
    }

    public CompletableFuture<Void> closeAsync() throws Exception {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        new Thread(() -> {
            if (!this.suppliedExecutor) {
                this.executorService.shutdown();
                try {
                    if (!this.executorService.awaitTermination(180000L, TimeUnit.MILLISECONDS)) {
                        logger.warn("Timeout while waiting for ExecutorService of GremlinExecutor to shutdown.");
                    }
                }
                catch (InterruptedException ie) {
                    logger.warn("ExecutorService on GremlinExecutor may not have shutdown properly as shutdown thread terminated early.");
                }
            }
            if (!this.suppliedScheduledExecutor) {
                this.scheduledExecutorService.shutdown();
                try {
                    if (!this.scheduledExecutorService.awaitTermination(180000L, TimeUnit.MILLISECONDS)) {
                        logger.warn("Timeout while waiting for ScheduledExecutorService of GremlinExecutor to shutdown.");
                    }
                }
                catch (InterruptedException ie) {
                    logger.warn("ScheduledExecutorService on GremlinExecutor may not have shutdown properly as shutdown thread terminated early.");
                }
            }
            try {
                this.scriptEngines.close();
            }
            catch (Exception ex) {
                logger.warn("Error while shutting down the ScriptEngines in the GremlinExecutor", (Throwable)ex);
            }
            future.complete(null);
        }, "gremlin-executor-close").start();
        return future;
    }

    private void initializeGremlinScriptEngineManager() {
        this.useGremlinScriptEngineManager = !this.plugins.entrySet().isEmpty();
        for (Map.Entry<String, Map<String, Map<String, Object>>> config : this.plugins.entrySet()) {
            String language = config.getKey();
            Map<String, Map<String, Object>> pluginConfigs = config.getValue();
            for (Map.Entry<String, Map<String, Object>> pluginConfig : pluginConfigs.entrySet()) {
                try {
                    Class<?> clazz = Class.forName(pluginConfig.getKey());
                    try {
                        Method instanceMethod = clazz.getMethod("instance", new Class[0]);
                        this.gremlinScriptEngineManager.addPlugin((org.apache.tinkerpop.gremlin.jsr223.GremlinPlugin)instanceMethod.invoke(null, new Object[0]));
                    }
                    catch (Exception ex) {
                        Method builderMethod = clazz.getMethod("build", new Class[0]);
                        Object pluginBuilder = builderMethod.invoke(null, new Object[0]);
                        Class<?> builderClazz = pluginBuilder.getClass();
                        Map<String, Object> customizerConfigs = pluginConfig.getValue();
                        Method[] methods = builderClazz.getMethods();
                        for (Map.Entry<String, Object> customizerConfig : customizerConfigs.entrySet()) {
                            Method configMethod = Stream.of(methods).filter(m -> {
                                Class<?> type = customizerConfig.getValue().getClass();
                                return m.getName().equals(customizerConfig.getKey()) && m.getParameters().length <= 1 && ClassUtils.isAssignable(type, m.getParameters()[0].getType(), (boolean)true);
                            }).findFirst().orElseThrow(() -> new IllegalStateException("Could not find builder method '" + (String)customizerConfig.getKey() + "' on " + builderClazz.getCanonicalName()));
                            if (null == customizerConfig.getValue()) {
                                pluginBuilder = configMethod.invoke(pluginBuilder, new Object[0]);
                                continue;
                            }
                            pluginBuilder = configMethod.invoke(pluginBuilder, customizerConfig.getValue());
                        }
                        try {
                            Method appliesTo = builderClazz.getMethod("appliesTo", Collection.class);
                            pluginBuilder = appliesTo.invoke(pluginBuilder, Collections.singletonList(language));
                        }
                        catch (NoSuchMethodException appliesTo) {
                            // empty catch block
                        }
                        Method create = builderClazz.getMethod("create", new Class[0]);
                        this.gremlinScriptEngineManager.addPlugin((org.apache.tinkerpop.gremlin.jsr223.GremlinPlugin)create.invoke(pluginBuilder, new Object[0]));
                    }
                }
                catch (Exception ex) {
                    throw new IllegalStateException(ex);
                }
            }
        }
        if (this.useGremlinScriptEngineManager) {
            this.gremlinScriptEngineManager.setBindings(this.globalBindings);
        }
    }

    private ScriptEngines createScriptEngines() {
        ArrayList globalPlugins = new ArrayList();
        ServiceLoader.load(GremlinPlugin.class).forEach(globalPlugins::add);
        return new ScriptEngines(se -> {
            for (Map.Entry<String, EngineSettings> config : this.settings.entrySet()) {
                String language = config.getKey();
                se.reload(language, new HashSet<String>(config.getValue().getImports()), new HashSet<String>(config.getValue().getStaticImports()), config.getValue().getConfig());
            }
            ArrayList pluginsToLoad = new ArrayList(globalPlugins);
            this.use.forEach(u -> {
                if (u.size() != 3) {
                    logger.warn("Could not resolve dependencies for [{}].  Each entry for the 'use' configuration must include [groupId, artifactId, version]", u);
                } else {
                    logger.info("Getting dependencies for [{}]", u);
                    pluginsToLoad.addAll(se.use((String)u.get(0), (String)u.get(1), (String)u.get(2)));
                }
            });
            se.loadPlugins(pluginsToLoad.stream().filter(plugin -> this.enabledPlugins.contains(plugin.getName())).collect(Collectors.toList()));
            for (Map.Entry<String, EngineSettings> config : this.settings.entrySet()) {
                String language = config.getKey();
                AtomicBoolean hasErrors = new AtomicBoolean(false);
                config.getValue().getScripts().stream().map(File::new).filter(f -> {
                    if (!f.exists()) {
                        logger.warn("Could not initialize {} ScriptEngine with {} as file does not exist", (Object)language, f);
                        hasErrors.set(true);
                    }
                    return f.exists();
                }).map(f -> {
                    try {
                        return Pair.with((Object)f, Optional.of(new FileReader((File)f)));
                    }
                    catch (IOException ioe) {
                        logger.warn("Could not initialize {} ScriptEngine with {} as file could not be read - {}", new Object[]{language, f, ioe.getMessage()});
                        hasErrors.set(true);
                        return Pair.with((Object)f, Optional.empty());
                    }
                }).filter(p -> ((Optional)p.getValue1()).isPresent()).map(p -> Pair.with((Object)p.getValue0(), ((Optional)p.getValue1()).get())).forEachOrdered(p -> {
                    try {
                        SimpleBindings bindings = new SimpleBindings();
                        bindings.putAll(this.globalBindings);
                        bindings.put("#jsr223.groovy.engine.keep.globals", (Object)"hard");
                        Object initializedBindings = se.eval((Reader)p.getValue1(), (Bindings)bindings, language);
                        if (initializedBindings != null && initializedBindings instanceof Map) {
                            this.globalBindings.putAll((Map)initializedBindings);
                        } else {
                            logger.warn("Initialization script {} did not return a Map - no global bindings specified", p.getValue0());
                        }
                        logger.info("Initialized {} ScriptEngine with {}", (Object)language, p.getValue0());
                    }
                    catch (ScriptException sx) {
                        hasErrors.set(true);
                        logger.warn("Could not initialize {} ScriptEngine with {} as script could not be evaluated - {}", new Object[]{language, p.getValue0(), sx.getMessage()});
                    }
                });
            }
        });
    }

    public static Builder build() {
        return new Builder().addEngineSettings("gremlin-groovy", new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>(), new HashMap<String, Object>());
    }

    public static Builder build(String engineName, List<String> imports, List<String> staticImports, List<String> scripts, Map<String, Object> config) {
        return new Builder().addEngineSettings(engineName, imports, staticImports, scripts, config);
    }

    public static class LifeCycle {
        private final Optional<Consumer<Bindings>> beforeEval;
        private final Optional<Function<Object, Object>> transformResult;
        private final Optional<Consumer<Object>> withResult;
        private final Optional<Consumer<Bindings>> afterSuccess;
        private final Optional<Consumer<Bindings>> afterTimeout;
        private final Optional<BiConsumer<Bindings, Throwable>> afterFailure;
        private final Optional<Long> scriptEvaluationTimeoutOverride;

        private LifeCycle(Builder builder) {
            this.beforeEval = Optional.ofNullable(builder.beforeEval);
            this.transformResult = Optional.ofNullable(builder.transformResult);
            this.withResult = Optional.ofNullable(builder.withResult);
            this.afterSuccess = Optional.ofNullable(builder.afterSuccess);
            this.afterTimeout = Optional.ofNullable(builder.afterTimeout);
            this.afterFailure = Optional.ofNullable(builder.afterFailure);
            this.scriptEvaluationTimeoutOverride = Optional.ofNullable(builder.scriptEvaluationTimeoutOverride);
        }

        public Optional<Long> getScriptEvaluationTimeoutOverride() {
            return this.scriptEvaluationTimeoutOverride;
        }

        public Optional<Consumer<Bindings>> getBeforeEval() {
            return this.beforeEval;
        }

        public Optional<Function<Object, Object>> getTransformResult() {
            return this.transformResult;
        }

        public Optional<Consumer<Object>> getWithResult() {
            return this.withResult;
        }

        public Optional<Consumer<Bindings>> getAfterSuccess() {
            return this.afterSuccess;
        }

        public Optional<Consumer<Bindings>> getAfterTimeout() {
            return this.afterTimeout;
        }

        public Optional<BiConsumer<Bindings, Throwable>> getAfterFailure() {
            return this.afterFailure;
        }

        public static Builder build() {
            return new Builder();
        }

        public static class Builder {
            private Consumer<Bindings> beforeEval = null;
            private Function<Object, Object> transformResult = null;
            private Consumer<Object> withResult = null;
            private Consumer<Bindings> afterSuccess = null;
            private Consumer<Bindings> afterTimeout = null;
            private BiConsumer<Bindings, Throwable> afterFailure = null;
            private Long scriptEvaluationTimeoutOverride = null;

            public Builder beforeEval(Consumer<Bindings> beforeEval) {
                this.beforeEval = beforeEval;
                return this;
            }

            public Builder transformResult(Function<Object, Object> transformResult) {
                this.transformResult = transformResult;
                return this;
            }

            public Builder withResult(Consumer<Object> withResult) {
                this.withResult = withResult;
                return this;
            }

            public Builder afterSuccess(Consumer<Bindings> afterSuccess) {
                this.afterSuccess = afterSuccess;
                return this;
            }

            public Builder afterTimeout(Consumer<Bindings> afterTimeout) {
                this.afterTimeout = afterTimeout;
                return this;
            }

            public Builder afterFailure(BiConsumer<Bindings, Throwable> afterFailure) {
                this.afterFailure = afterFailure;
                return this;
            }

            public Builder scriptEvaluationTimeoutOverride(Long scriptEvaluationTimeoutOverride) {
                this.scriptEvaluationTimeoutOverride = scriptEvaluationTimeoutOverride;
                return this;
            }

            public LifeCycle create() {
                return new LifeCycle(this);
            }
        }
    }

    private static class EngineSettings {
        private List<String> imports;
        private List<String> staticImports;
        private List<String> scripts;
        private Map<String, Object> config;

        public EngineSettings(List<String> imports, List<String> staticImports, List<String> scripts, Map<String, Object> config) {
            this.imports = imports;
            this.staticImports = staticImports;
            this.scripts = scripts;
            this.config = config;
        }

        private List<String> getImports() {
            return this.imports;
        }

        private List<String> getStaticImports() {
            return this.staticImports;
        }

        private List<String> getScripts() {
            return this.scripts;
        }

        public Map<String, Object> getConfig() {
            return this.config;
        }
    }

    public static final class Builder {
        private long scriptEvaluationTimeout = 8000L;
        private Map<String, EngineSettings> settings = new HashMap<String, EngineSettings>();
        private Map<String, Map<String, Map<String, Object>>> plugins = new HashMap<String, Map<String, Map<String, Object>>>();
        private ExecutorService executorService = null;
        private ScheduledExecutorService scheduledExecutorService = null;
        private Set<String> enabledPlugins = new HashSet<String>();
        private Consumer<Bindings> beforeEval = b -> {};
        private Consumer<Bindings> afterSuccess = b -> {};
        private Consumer<Bindings> afterTimeout = b -> {};
        private BiConsumer<Bindings, Throwable> afterFailure = (b, e) -> {};
        private List<List<String>> use = new ArrayList<List<String>>();
        private Bindings globalBindings = new ConcurrentBindings();

        private Builder() {
        }

        @Deprecated
        public Builder addEngineSettings(String engineName, List<String> imports, List<String> staticImports, List<String> scripts, Map<String, Object> config) {
            if (null == imports) {
                throw new IllegalArgumentException("imports cannot be null");
            }
            if (null == staticImports) {
                throw new IllegalArgumentException("staticImports cannot be null");
            }
            if (null == scripts) {
                throw new IllegalArgumentException("scripts cannot be null");
            }
            Map<String, Object> m = null == config ? Collections.emptyMap() : config;
            this.settings.put(engineName, new EngineSettings(imports, staticImports, scripts, m));
            return this;
        }

        public Builder addPlugins(String engineName, Map<String, Map<String, Object>> plugins) {
            this.plugins.put(engineName, plugins);
            return this;
        }

        public Builder globalBindings(Bindings bindings) {
            this.globalBindings = new ConcurrentBindings((Map)bindings);
            return this;
        }

        public Builder scriptEvaluationTimeout(long scriptEvaluationTimeout) {
            this.scriptEvaluationTimeout = scriptEvaluationTimeout;
            return this;
        }

        @Deprecated
        public Builder engineSettings(Map<String, EngineSettings> settings) {
            this.settings = settings;
            return this;
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Builder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
            this.scheduledExecutorService = scheduledExecutorService;
            return this;
        }

        public Builder beforeEval(Consumer<Bindings> beforeEval) {
            this.beforeEval = beforeEval;
            return this;
        }

        public Builder afterSuccess(Consumer<Bindings> afterSuccess) {
            this.afterSuccess = afterSuccess;
            return this;
        }

        public Builder afterTimeout(Consumer<Bindings> afterTimeout) {
            this.afterTimeout = afterTimeout;
            return this;
        }

        public Builder afterFailure(BiConsumer<Bindings, Throwable> afterFailure) {
            this.afterFailure = afterFailure;
            return this;
        }

        @Deprecated
        public Builder use(List<List<String>> use) {
            this.use = use;
            return this;
        }

        @Deprecated
        public Builder enabledPlugins(Set<String> enabledPlugins) {
            this.enabledPlugins = enabledPlugins;
            return this;
        }

        public GremlinExecutor create() {
            ScheduledExecutorService ses;
            ExecutorService es;
            BasicThreadFactory threadFactory = new BasicThreadFactory.Builder().namingPattern("gremlin-executor-default-%d").build();
            AtomicBoolean poolCreatedByBuilder = new AtomicBoolean();
            AtomicBoolean suppliedExecutor = new AtomicBoolean(true);
            AtomicBoolean suppliedScheduledExecutor = new AtomicBoolean(true);
            this.executorService = es = Optional.ofNullable(this.executorService).orElseGet(() -> {
                poolCreatedByBuilder.set(true);
                suppliedExecutor.set(false);
                return Executors.newScheduledThreadPool(4, (ThreadFactory)threadFactory);
            });
            this.scheduledExecutorService = ses = Optional.ofNullable(this.scheduledExecutorService).orElseGet(() -> {
                suppliedScheduledExecutor.set(false);
                return poolCreatedByBuilder.get() ? (ScheduledExecutorService)es : Executors.newScheduledThreadPool(4, (ThreadFactory)threadFactory);
            });
            return new GremlinExecutor(this, suppliedExecutor.get(), suppliedScheduledExecutor.get());
        }
    }
}

