/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.groovy.jsr223;

import java.util.ArrayList;
import java.util.List;
import org.apache.tinkerpop.gremlin.process.computer.Computer;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.SackFunctions;
import org.apache.tinkerpop.gremlin.process.traversal.Translator;
import org.apache.tinkerpop.gremlin.process.traversal.util.ConnectiveP;
import org.apache.tinkerpop.gremlin.process.traversal.util.OrP;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.function.Lambda;

public final class GroovyTranslator
implements Translator.ScriptTranslator {
    private final String traversalSource;

    private GroovyTranslator(String traversalSource) {
        this.traversalSource = traversalSource;
    }

    public static final GroovyTranslator of(String traversalSource) {
        return new GroovyTranslator(traversalSource);
    }

    public String translate(Bytecode bytecode) {
        return this.internalTranslate(this.traversalSource, bytecode);
    }

    public String getTargetLanguage() {
        return "gremlin-groovy";
    }

    public String toString() {
        return StringFactory.translatorString((Translator)this);
    }

    public String getTraversalSource() {
        return this.traversalSource;
    }

    private String internalTranslate(String start, Bytecode bytecode) {
        StringBuilder traversalScript = new StringBuilder(start);
        for (Bytecode.Instruction instruction : bytecode.getInstructions()) {
            String methodName = instruction.getOperator();
            if (methodName.equals("withStrategies")) continue;
            Object[] arguments = instruction.getArguments();
            if (0 == arguments.length) {
                traversalScript.append(".").append(methodName).append("()");
                continue;
            }
            traversalScript.append(".");
            String temp = methodName + "(";
            for (Object object : arguments) {
                temp = temp + this.convertToString(object) + ",";
            }
            traversalScript.append(temp.substring(0, temp.length() - 1)).append(")");
        }
        return traversalScript.toString();
    }

    private String convertToString(Object object) {
        if (object instanceof Bytecode.Binding) {
            return ((Bytecode.Binding)object).variable();
        }
        if (object instanceof String) {
            return "\"" + object + "\"";
        }
        if (object instanceof List) {
            ArrayList<String> list = new ArrayList<String>(((List)object).size());
            for (Object item : (List)object) {
                list.add(this.convertToString(item));
            }
            return ((Object)list).toString();
        }
        if (object instanceof Long) {
            return object + "L";
        }
        if (object instanceof Double) {
            return object + "d";
        }
        if (object instanceof Float) {
            return object + "f";
        }
        if (object instanceof Integer) {
            return "(int) " + object;
        }
        if (object instanceof Class) {
            return ((Class)object).getCanonicalName();
        }
        if (object instanceof P) {
            return this.convertPToString((P)object, new StringBuilder()).toString();
        }
        if (object instanceof SackFunctions.Barrier) {
            return "SackFunctions.Barrier." + object.toString();
        }
        if (object instanceof VertexProperty.Cardinality) {
            return "VertexProperty.Cardinality." + object.toString();
        }
        if (object instanceof Enum) {
            return ((Enum)object).getDeclaringClass().getSimpleName() + "." + object.toString();
        }
        if (object instanceof Element) {
            return this.convertToString(((Element)object).id());
        }
        if (object instanceof Computer) {
            return "";
        }
        if (object instanceof Lambda) {
            String lambdaString = ((Lambda)object).getLambdaScript().trim();
            return lambdaString.startsWith("{") ? lambdaString : "{" + lambdaString + "}";
        }
        if (object instanceof Bytecode) {
            return this.internalTranslate("__", (Bytecode)object);
        }
        return null == object ? "null" : object.toString();
    }

    private StringBuilder convertPToString(P p, StringBuilder current) {
        if (p instanceof ConnectiveP) {
            List list = ((ConnectiveP)p).getPredicates();
            for (int i = 0; i < list.size(); ++i) {
                this.convertPToString((P)list.get(i), current);
                if (i >= list.size() - 1) continue;
                current.append(p instanceof OrP ? ".or(" : ".and(");
            }
            current.append(")");
        } else {
            current.append("P.").append(p.getBiPredicate().toString()).append("(").append(this.convertToString(p.getValue())).append(")");
        }
        return current;
    }
}

