/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.groovy.plugin;

import java.util.Map;
import org.apache.tinkerpop.gremlin.groovy.plugin.GremlinPlugin;
import org.apache.tinkerpop.gremlin.groovy.plugin.IllegalEnvironmentException;
import org.apache.tinkerpop.gremlin.groovy.plugin.PluginAcceptor;
import org.apache.tinkerpop.gremlin.groovy.plugin.PluginInitializationException;
import org.codehaus.groovy.tools.shell.Groovysh;
import org.codehaus.groovy.tools.shell.IO;

public abstract class AbstractGremlinPlugin
implements GremlinPlugin {
    public static final String ENV_CONSOLE_IO = "ConsolePluginAcceptor.io";
    public static final String ENV_CONSOLE_SHELL = "ConsolePluginAcceptor.shell";
    protected static final String IMPORT_SPACE = "import ";
    protected static final String IMPORT_STATIC_SPACE = "import static ";
    protected static final String DOT_STAR = ".*";
    protected IO io;
    protected Groovysh shell;
    protected final boolean requireConsoleEnvironment;

    public AbstractGremlinPlugin() {
        this(false);
    }

    public AbstractGremlinPlugin(boolean requireConsoleEnvironment) {
        this.requireConsoleEnvironment = requireConsoleEnvironment;
    }

    @Override
    public void pluginTo(PluginAcceptor pluginAcceptor) throws IllegalEnvironmentException, PluginInitializationException {
        Map<String, Object> environment = pluginAcceptor.environment();
        this.io = (IO)environment.get(ENV_CONSOLE_IO);
        this.shell = (Groovysh)environment.get(ENV_CONSOLE_SHELL);
        if (this.requireConsoleEnvironment && (null == this.io || null == this.shell)) {
            throw new IllegalEnvironmentException(this, ENV_CONSOLE_SHELL, ENV_CONSOLE_IO);
        }
        try {
            this.afterPluginTo(pluginAcceptor);
        }
        catch (PluginInitializationException pie) {
            throw pie;
        }
        catch (Exception ex) {
            throw new PluginInitializationException(ex);
        }
    }

    public abstract void afterPluginTo(PluginAcceptor var1) throws IllegalEnvironmentException, PluginInitializationException;
}

