/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultHttpObject;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.CharsetUtil;
import java.util.List;
import org.apache.tinkerpop.gremlin.driver.Channelizer;
import org.apache.tinkerpop.gremlin.util.MessageSerializer;
import org.apache.tinkerpop.gremlin.util.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.util.ser.SerializationException;
import org.apache.tinkerpop.shaded.jackson.databind.JsonNode;
import org.apache.tinkerpop.shaded.jackson.databind.ObjectMapper;

public class HttpGremlinResponseStreamDecoder
extends MessageToMessageDecoder<DefaultHttpObject> {
    public static final AttributeKey<Boolean> IS_BULKED = AttributeKey.valueOf((String)"isBulked");
    private static final AttributeKey<Boolean> IS_FIRST_CHUNK = AttributeKey.valueOf((String)"isFirstChunk");
    private static final AttributeKey<HttpResponseStatus> RESPONSE_STATUS = AttributeKey.valueOf((String)"responseStatus");
    private static final AttributeKey<String> RESPONSE_ENCODING = AttributeKey.valueOf((String)"responseSerializer");
    private static final AttributeKey<Long> BYTES_READ = AttributeKey.valueOf((String)"bytesRead");
    private final MessageSerializer<?> serializer;
    private final long maxResponseContentLength;
    private final ObjectMapper mapper = new ObjectMapper();

    public HttpGremlinResponseStreamDecoder(MessageSerializer<?> serializer, long maxResponseContentLength) {
        this.serializer = serializer;
        this.maxResponseContentLength = maxResponseContentLength;
    }

    protected void decode(ChannelHandlerContext ctx, DefaultHttpObject msg, List<Object> out) throws Exception {
        Attribute isFirstChunk = ctx.attr(IS_FIRST_CHUNK);
        Attribute isBulked = ctx.attr(IS_BULKED);
        Attribute responseStatus = ctx.attr(RESPONSE_STATUS);
        Attribute responseEncoding = ctx.attr(RESPONSE_ENCODING);
        if (msg instanceof HttpResponse) {
            ctx.channel().attr(BYTES_READ).set((Object)0L);
            HttpResponse resp = (HttpResponse)msg;
            responseStatus.set((Object)resp.status());
            responseEncoding.set((Object)resp.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE));
            isFirstChunk.set((Object)true);
        }
        if (msg instanceof HttpContent) {
            ByteBuf content = ((HttpContent)msg).content();
            Attribute bytesRead = ctx.channel().attr(BYTES_READ);
            bytesRead.set((Object)((Long)bytesRead.get() + (long)content.readableBytes()));
            if (this.maxResponseContentLength > 0L && (Long)bytesRead.get() > this.maxResponseContentLength) {
                throw new TooLongFrameException("Response exceeded " + this.maxResponseContentLength + " bytes.");
            }
            try {
                if (HttpGremlinResponseStreamDecoder.isError((HttpResponseStatus)responseStatus.get()) && !"application/vnd.graphbinary-v4.0".equals(responseEncoding.get())) {
                    JsonNode node = this.mapper.readTree(content.toString(CharsetUtil.UTF_8));
                    String message = node.get("message").asText();
                    ResponseMessage response = ResponseMessage.build().code((HttpResponseStatus)responseStatus.get()).statusMessage(message).create();
                    out.add(response);
                } else {
                    ResponseMessage chunk = this.serializer.readChunk(content, ((Boolean)isFirstChunk.get()).booleanValue());
                    if (((Boolean)isFirstChunk.get()).booleanValue()) {
                        isBulked.set((Object)chunk.getResult().isBulked());
                    }
                    isFirstChunk.set((Object)false);
                    out.add(chunk);
                }
                if (msg instanceof LastHttpContent) {
                    out.add(Channelizer.HttpChannelizer.LAST_CONTENT_READ_RESPONSE);
                }
            }
            catch (SerializationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static boolean isError(HttpResponseStatus status) {
        return status != HttpResponseStatus.OK;
    }
}

