/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.handler;

import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.InputStream;
import java.util.List;
import java.util.UUID;
import org.apache.tinkerpop.gremlin.driver.MessageSerializer;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.shaded.jackson.databind.JsonNode;
import org.apache.tinkerpop.shaded.jackson.databind.ObjectMapper;

@ChannelHandler.Sharable
public final class HttpGremlinResponseDecoder
extends MessageToMessageDecoder<FullHttpResponse> {
    private final MessageSerializer<?> serializer;
    private final ObjectMapper mapper = new ObjectMapper();

    public HttpGremlinResponseDecoder(MessageSerializer<?> serializer) {
        this.serializer = serializer;
    }

    protected void decode(ChannelHandlerContext channelHandlerContext, FullHttpResponse httpResponse, List<Object> objects) throws Exception {
        if (httpResponse.status() == HttpResponseStatus.OK) {
            objects.add(this.serializer.deserializeResponse(httpResponse.content()));
        } else {
            JsonNode root = this.mapper.readTree((InputStream)new ByteBufInputStream(httpResponse.content()));
            objects.add(ResponseMessage.build(UUID.fromString(root.get("requestId").asText())).code(ResponseStatusCode.SERVER_ERROR).statusMessage(root.get("message").asText()).create());
        }
    }
}

